/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.xlcommons.util.http;

import com.xunlei.xlcommons.util.Map.KeyValueUtil;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientUtil.class);

    public static String doPost(String url, Map<String, String> postParams, Map<String, String> headerParams, Map<String, String> requestHeaderParams) throws Exception {
        int statusCode;
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        if (requestHeaderParams != null && !requestHeaderParams.isEmpty()) {
            for (String key : requestHeaderParams.keySet()) {
                String value = requestHeaderParams.get(key);
                postMethod.addRequestHeader(key, value);
            }
        }
        if (headerParams != null && !headerParams.isEmpty()) {
            ArrayList<Header> headers = new ArrayList<Header>();
            for (String key : headerParams.keySet()) {
                String value = headerParams.get(key);
                headers.add(new Header(key, value));
            }
            httpClient.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
        }
        if (postParams != null && !postParams.isEmpty()) {
            NameValuePair[] paramArray = new NameValuePair[postParams.size()];
            int i = 0;
            for (String key : postParams.keySet()) {
                String value = postParams.get(key);
                paramArray[i++] = new NameValuePair(key, value);
            }
            postMethod.setRequestBody(paramArray);
        }
        if (200 != (statusCode = httpClient.executeMethod((HttpMethod)postMethod))) {
            LOG.error("executeMethod fail!,statusCode:{}", (Object)statusCode);
            throw new Exception("executeMethod fail!");
        }
        String responseBody = new String(postMethod.getResponseBody());
        if (responseBody == null || "".equals(responseBody)) {
            throw new Exception("responseBody is empty!");
        }
        return responseBody;
    }

    public static String doGet(String url, Map<String, Object> getParams, Map<String, String> headerParams) throws Exception {
        int statusCode;
        HttpClient httpClient = new HttpClient();
        String reqParam = KeyValueUtil.getKeyValueStrTrim(getParams);
        url = url.contains("?") ? String.valueOf(url) + "&" + reqParam : String.valueOf(url) + "?" + reqParam;
        GetMethod getMethod = new GetMethod(url);
        getMethod.setRequestHeader("Content-Type", "text/html;charset=UTF-8");
        if (headerParams != null && !headerParams.isEmpty()) {
            ArrayList<Header> headers = new ArrayList<Header>();
            for (String key : headerParams.keySet()) {
                String value = headerParams.get(key);
                headers.add(new Header(key, value));
            }
            httpClient.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
        }
        if (200 != (statusCode = httpClient.executeMethod((HttpMethod)getMethod))) {
            throw new Exception("executeMethod fail!");
        }
        String responseBody = new String(getMethod.getResponseBody(), "UTF-8");
        if (responseBody == null || "".equals(responseBody)) {
            throw new Exception("responseBody is empty!");
        }
        return responseBody;
    }

    public static String doPostXML(String url, String postData, Map<String, String> headerParams) throws Exception {
        int statusCode;
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Content-Type", "text/html;charset=UTF-8");
        if (headerParams != null && !headerParams.isEmpty()) {
            ArrayList<Header> headers = new ArrayList<Header>();
            for (String key : headerParams.keySet()) {
                String value = headerParams.get(key);
                headers.add(new Header(key, value));
            }
            httpClient.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
        }
        if (postData != null && !"".equals(postData)) {
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(postData, "text/xml", "UTF-8"));
        }
        if (200 != (statusCode = httpClient.executeMethod((HttpMethod)postMethod))) {
            throw new Exception("executeMethod fail!");
        }
        String responseBody = new String(postMethod.getResponseBody());
        if (responseBody == null || "".equals(responseBody)) {
            throw new Exception("responseBody is empty!");
        }
        return responseBody;
    }

    public static byte[] doPostWithByteResp(String url, Map<String, String> postParams, Map<String, String> headerParams, Map<String, String> requestHeaderParams) throws Exception {
        int statusCode;
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        if (requestHeaderParams != null && !requestHeaderParams.isEmpty()) {
            for (String key : requestHeaderParams.keySet()) {
                String value = requestHeaderParams.get(key);
                postMethod.addRequestHeader(key, value);
            }
        }
        if (headerParams != null && !headerParams.isEmpty()) {
            ArrayList<Header> headers = new ArrayList<Header>();
            for (String key : headerParams.keySet()) {
                String value = headerParams.get(key);
                headers.add(new Header(key, value));
            }
            httpClient.getHostConfiguration().getParams().setParameter("http.default-headers", headers);
        }
        if (postParams != null && !postParams.isEmpty()) {
            NameValuePair[] paramArray = new NameValuePair[postParams.size()];
            int i = 0;
            for (String key : postParams.keySet()) {
                String value = postParams.get(key);
                paramArray[i++] = new NameValuePair(key, value);
            }
            postMethod.setRequestBody(paramArray);
        }
        if (200 != (statusCode = httpClient.executeMethod((HttpMethod)postMethod))) {
            LOG.error("executeMethod fail!,statusCode:{}", (Object)statusCode);
            throw new Exception("executeMethod fail!");
        }
        byte[] responseBody = postMethod.getResponseBody();
        if (responseBody == null) {
            throw new Exception("responseBody is empty!");
        }
        return responseBody;
    }
}

