/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.xlcommons.util.Map;

import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class KeyValueUtil {
    public static String getKeyValueStr(Map<String, Object> map) throws Exception {
        if (map == null) {
            throw new Exception("map is empty!");
        }
        Iterator<String> it = map.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            if (isFirst) {
                sb.append(key).append("=").append(value);
                isFirst = false;
                continue;
            }
            sb.append("&").append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static String getKeyValueStrTrim(Map<String, Object> map) throws Exception {
        if (map == null) {
            throw new Exception("map is empty!");
        }
        Iterator<String> it = map.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            if (key == null || "".equals(key) || value == null || "".equals(value)) continue;
            if (isFirst) {
                sb.append(key).append("=").append(value);
                isFirst = false;
                continue;
            }
            sb.append("&").append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static String getKeyValueStrTrimWithMark(Map<String, Object> map) throws Exception {
        if (map == null) {
            throw new Exception("map is empty!");
        }
        Iterator<String> it = map.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (it.hasNext()) {
            String key = it.next();
            Object value = map.get(key);
            if (key == null || "".equals(key) || value == null || "".equals(value)) continue;
            if (isFirst) {
                sb.append(key).append("=").append("\"").append(value).append("\"");
                isFirst = false;
                continue;
            }
            sb.append("&").append(key).append("=").append("\"").append(value).append("\"");
        }
        return sb.toString();
    }

    public static String getKeyValueStrEnc(Map<String, String> map, String encoding) throws Exception {
        if (map == null) {
            throw new Exception("map is empty!");
        }
        if (encoding == null || "".equals(encoding)) {
            throw new Exception("encoding is illegal!");
        }
        Iterator<String> it = map.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (it.hasNext()) {
            String key = it.next();
            String value = map.get(key);
            if (key == null || "".equals(key) || value == null || "".equals(value)) continue;
            String enValue = URLEncoder.encode(value, encoding);
            enValue.replace("+", "%20");
            if (isFirst) {
                sb.append(key).append("=").append(enValue);
                isFirst = false;
                continue;
            }
            sb.append("&").append(key).append("=").append(enValue);
        }
        return sb.toString();
    }

    public static String getKeyValueStrTrim(Object obj) throws Exception {
        Field[] fields = obj.getClass().getDeclaredFields();
        TreeMap<String, Object> paramMap = new TreeMap<String, Object>();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            field.setAccessible(true);
            String key = field.getName();
            Object value = field.get(obj);
            if (key != null && !"".equals(key) && value != null && !"".equals(value)) {
                paramMap.put(key, value);
            }
            ++i;
        }
        return KeyValueUtil.getKeyValueStrTrim(paramMap);
    }

    public static String getKeyValueStrTrimWithMark(Object obj) throws Exception {
        Field[] fields = obj.getClass().getDeclaredFields();
        TreeMap<String, Object> paramMap = new TreeMap<String, Object>();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            field.setAccessible(true);
            String key = field.getName();
            Object value = field.get(obj);
            if (key != null && !"".equals(key) && value != null && !"".equals(value)) {
                paramMap.put(key, value);
            }
            ++i;
        }
        return KeyValueUtil.getKeyValueStrTrimWithMark(paramMap);
    }
}

