/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.xlcommons.util.Mail;

import com.xunlei.xlcommons.util.Mail.MailAuthenticator;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailSender {
    private final transient Properties props = System.getProperties();
    private transient MailAuthenticator authenticator;
    private transient Session session;

    public static MailSender getDefaultSender() {
        return MailSenderHolder.XL_MAIL_SENDER;
    }

    public MailSender(String smtpHostName, String username, String password) {
        this.init(username, password, smtpHostName);
    }

    public MailSender(String username, String password) {
        String smtpHostName = "smtp." + username.split("@")[1];
        this.init(username, password, smtpHostName);
    }

    private void init(String username, String password, String smtpHostName) {
        this.props.put("mail.smtp.auth", "true");
        this.props.put("mail.smtp.host", smtpHostName);
        this.authenticator = new MailAuthenticator(username, password);
        this.session = Session.getInstance((Properties)this.props, (Authenticator)this.authenticator);
    }

    public void send(String recipient, String subject, Object content) throws AddressException, MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(this.authenticator.getUsername()));
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        message.setSubject(subject);
        message.setContent((Object)content.toString(), "text/html;charset=utf-8");
        Transport.send((Message)message);
    }

    public void send(List<String> recipients, String subject, Object content) throws AddressException, MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(this.authenticator.getUsername()));
        int num = recipients.size();
        InternetAddress[] addresses = new InternetAddress[num];
        int i = 0;
        while (i < num) {
            addresses[i] = new InternetAddress(recipients.get(i));
            ++i;
        }
        message.setRecipients(Message.RecipientType.TO, (Address[])addresses);
        message.setSubject(subject);
        message.setContent((Object)content.toString(), "text/html;charset=utf-8");
        Transport.send((Message)message);
    }

    private static class MailSenderHolder {
        public static final MailSender XL_MAIL_SENDER = new MailSender("mail.xunlei.com", "xlpay@xunlei.com", "xlpayabc");

        private MailSenderHolder() {
        }
    }
}

