/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.xlcommons.util.Ftp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClient {
    private static final Logger LOG = LoggerFactory.getLogger(FtpClient.class);
    private FTPClient client;
    private boolean isLogin = false;

    public boolean isLogin() {
        return this.isLogin;
    }

    public FtpClient(String url, int port, String username, String password) {
        try {
            this.init(url, port, username, password);
        }
        catch (Exception e) {
            LOG.error("url:{},login fail!throws Exception:", new Object[]{url, e});
        }
    }

    private void init(String url, int port, String username, String password) throws Exception {
        LOG.info("connecting ftp,url:{},port:{},username:{},password:{}", new Object[]{url, port, username, password});
        this.client = new FTPClient();
        this.client.connect(url, port);
        this.client.login(username, password);
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            this.client.disconnect();
            LOG.error("FTPClient connect fail!,replyCode:{}", (Object)this.client.getReplyCode());
            throw new Exception("FTPClient connect fail!,replyCode:" + this.client.getReplyCode());
        }
        this.client.enterLocalPassiveMode();
        this.isLogin = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("FTPClient connect success!");
        }
    }

    private boolean ftpDownload(String remotePath, String fileName, String localPath) throws Exception {
        boolean downloadRes = false;
        LOG.info("downloading file from remotePath:{},fileName:{},localPath:{}", new Object[]{remotePath, fileName, localPath});
        try {
            this.client.changeWorkingDirectory(remotePath);
            FTPFile[] fileList = this.client.listFiles();
            if (fileList.length <= 0) {
                LOG.error("remotePath:{},does not contains any file!");
                return false;
            }
            FTPFile[] fTPFileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile file = fTPFileArray[n2];
                if (file.getName().equals(fileName)) {
                    File localFile = new File(String.valueOf(localPath) + "/" + file.getName());
                    FileOutputStream is = new FileOutputStream(localFile);
                    this.client.retrieveFile(file.getName(), (OutputStream)is);
                    ((OutputStream)is).close();
                }
                ++n2;
            }
            downloadRes = true;
            this.client.logout();
        }
        finally {
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
        }
        return downloadRes;
    }

    public boolean downLoadFile(final String remotePath, final String fileName, final String localPath, int timeout) {
        boolean downLoadRes = false;
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return FtpClient.this.ftpDownload(remotePath, fileName, localPath);
            }
        };
        ExecutorService pool = Executors.newSingleThreadExecutor();
        Future<Boolean> future = pool.submit(task);
        try {
            downLoadRes = future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("FTPClient download fail!,throws Exception:", (Throwable)e);
        }
        pool.shutdownNow();
        return downLoadRes;
    }
}

