/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.utils;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

public class Properties {
    private ResourceBundle bundle;

    public Properties(String propFileName) {
        this.bundle = ResourceBundle.getBundle(propFileName);
    }

    public String getPropertie(String key) {
        return this.bundle.getString(key);
    }

    public List<String> getListPropertie(String key, String split) {
        ArrayList<String> list = new ArrayList<String>();
        String content = this.bundle.getString(key);
        if (StringUtils.isNotEmpty((String)content)) {
            if (content.indexOf(split) > 0) {
                String[] cons = content.split(split);
                for (int i = 0; i < cons.length; ++i) {
                    list.add(cons[i]);
                }
            } else {
                list.add(content);
            }
        }
        return list;
    }

    public String getCHPropertie(String key) {
        String chValue = "";
        try {
            chValue = new String(this.getPropertie(key).getBytes("ISO8859-1"), "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chValue;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public static Map<String, String> getPayTypeConfigMap(String propertiesName) {
        HashMap<String, String> map = new HashMap<String, String>();
        ResourceBundle bundle = ResourceBundle.getBundle(propertiesName);
        Enumeration<String> allName = bundle.getKeys();
        while (allName.hasMoreElements()) {
            String key = allName.nextElement();
            map.put(key, bundle.getString(key));
        }
        return map;
    }

    public static void main(String[] args) {
        Map<String, String> map = Properties.getPayTypeConfigMap("jdpaycode");
        System.out.println(map.size());
    }
}

