/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.payproxy.util.PayCenterUtil;
import com.xunlei.payproxy.util.SmsSender;
import com.xunlei.payproxy.vo.UploadRequest;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyUploadRequest")
public class UploadRequestManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(UploadRequestManagedBean.class);

    public String add() {
        this.authenticateAdd();
        try {
            logger.info("enter add method!");
            UploadRequest uploadRequest = (UploadRequest)this.findBean(UploadRequest.class, "payproxy_uploadrequest");
            String paycenterargs = uploadRequest.getPaycenterArgs();
            String sendsmsargs = uploadRequest.getSendsmsArgs();
            String sendTime = uploadRequest.getSendTime();
            String smsContent = uploadRequest.getSmsContent();
            UploadedFile uploadedFile = uploadRequest.getUploadedFile();
            if (uploadedFile == null) {
                logger.error("uploadedFile cannot be empty!");
                this.alertJS("\u4e0a\u4f20\u7528\u6237\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return "";
            }
            if (smsContent == null || "".equals(smsContent.trim())) {
                logger.error("smsContent cannot be empty!");
                this.alertJS("\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return "";
            }
            if (paycenterargs == null || "".equals(paycenterargs.trim())) {
                logger.error("paycenterargs cannot be empty!");
                this.alertJS("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u63a5\u53e3\u6240\u9700\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return "";
            }
            if (sendsmsargs == null || "".equals(sendsmsargs.trim())) {
                logger.error("sendsmsargs cannot be empty!");
                this.alertJS("\u77ed\u4fe1\u53d1\u9001\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return "";
            }
            if (sendTime == null || "".equals(sendTime.trim())) {
                logger.error("sendTime cannot be empty!");
                this.alertJS("\u53d1\u9001\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return "";
            }
            logger.info("paycenterargs: " + paycenterargs + ",sendsmsargs: " + sendsmsargs + ",sendTime: " + sendTime + ",smsContent: " + smsContent + ", uploadedFileName: " + uploadedFile.getName());
            String filename = uploadedFile.getName();
            if (!filename.endsWith(".txt")) {
                logger.error("filename not endwith .txt!");
                this.alertJS("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5\uff0c\u4ec5\u652f\u6301.txt\u6587\u672c\u6587\u4ef6\uff01");
                return "";
            }
            List<String> txtList = this.handleUploadedFile(uploadedFile);
            if (txtList == null || txtList.size() <= 0) {
                logger.error("upload txt file occurred some error or file is empty!");
                this.alertJS("\u4e0a\u4f20txt\u6587\u4ef6\u51fa\u9519\u6216\u6587\u4ef6\u4e3a\u7a7a");
                return "";
            }
            String[] paycenterarg = paycenterargs.split("\\|");
            String bizNo = paycenterarg[0];
            String bizKey = paycenterarg[1];
            String mref = paycenterarg[2];
            String[] sendsmsarg = sendsmsargs.split("\\|");
            int totalCounter = txtList.size();
            int successCounter = 0;
            int counter = 0;
            long start = System.currentTimeMillis();
            logger.info("==========start===========\n");
            for (int i = 0; i < txtList.size(); ++i) {
                ++counter;
                String[] words = txtList.get(i).split(",");
                String xunleiId = words[0];
                String mobile = words[1];
                if (this.isEmpty(xunleiId) || this.isEmpty(mobile)) {
                    logger.error("xunleiId: " + xunleiId + ", mobile: " + mobile + " , there is one empty!");
                    continue;
                }
                logger.info("------------args: " + Arrays.toString(new Object[]{xunleiId, mobile, bizNo, mref}));
                String shortMapUrl = PayCenterUtil.getMapUrl((String)xunleiId, (String)bizNo, (String)bizKey, (String)mref);
                logger.info("-------------------shortMapUrl: " + shortMapUrl);
                String sendContent = smsContent.replace("shortMapUrl", shortMapUrl);
                if (counter % 100 == 0) {
                    logger.info("too many textmessage, sleep 3s...");
                    Thread.sleep(3000L);
                    logger.info("sleep over, go to work...");
                }
                boolean isSendSuccess = SmsSender.send((String)mobile, (String)sendContent, (String)sendsmsarg[0], (String)sendsmsarg[1]);
                String logRecord = "\u53d1\u9001\u7ed3\u679c\uff1a    " + isSendSuccess + ", \u8be6\u60c5\uff1a" + Arrays.toString(new Object[]{xunleiId, mobile, shortMapUrl, sendContent});
                logger.info(logRecord + "\n");
                if (!isSendSuccess) continue;
                ++successCounter;
            }
            long end = System.currentTimeMillis();
            logger.info("==========end===========\n");
            logger.info("====================\u603b\u8bb0\u5f55\u6570: " + counter + "==================\u6210\u529f\u53d1\u9001\u77ed\u4fe1\u6761\u6570: " + successCounter);
            logger.info("=========\u8017\u65f6: " + (end - start) + "milliseconds");
            this.alertJS("\u603b\u6761\u6570: " + totalCounter + " \u6761, \u6210\u529f\u53d1\u9001: " + successCounter + " \u6761\u3002");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alertJS("error: " + e);
        }
        return "";
    }

    private List<String> handleUploadedFile(UploadedFile uploadedFile) {
        try {
            ArrayList<String> dataList = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(uploadedFile.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                dataList.add(line);
                line = reader.readLine();
            }
            return dataList;
        }
        catch (Exception e) {
            logger.error("error: " + e);
            return null;
        }
    }
}

