/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.util.HttpGetAndPostSender;
import com.xunlei.payproxy.util.SignatureHelper2;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxySendMessage")
public class SendMessageManagerBean
extends BaseManagedBean {
    private static final Logger LOG = LoggerFactory.getLogger(SendMessageManagerBean.class);
    private UploadedFile upFile;
    private String mobiles;

    public UploadedFile getUpFile() {
        return this.upFile;
    }

    public void setUpFile(UploadedFile upFile) {
        this.upFile = upFile;
    }

    public String sendMessage() {
        LOG.info("===invoking SendMessageManagerBean sendMessage===");
        this.authenticateRun();
        String mobiles = this.findParameter("mobileshidden");
        String content = this.findParameter("messagecontent");
        LOG.info("===mobiles:" + mobiles + "===");
        ArrayList<String> failList = new ArrayList<String>();
        if (StringTools.isEmpty((String)mobiles)) {
            LOG.error("mobiles:" + mobiles + ",is null!");
            this.alertJS("\u8bf7\u8f93\u5165\u624b\u673a\u53f7!");
            return "";
        }
        if (StringTools.isEmpty((String)content)) {
            LOG.error("content:" + content + ", is null!");
            this.alertJS("\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
            return "";
        }
        String[] mobilesArr = (mobiles = mobiles.replaceAll("\uff1b", ";")).split("\\;");
        if (null != mobilesArr && mobilesArr.length > 0) {
            for (int i = 0; i < mobilesArr.length; ++i) {
                String mobile = mobilesArr[i];
                if (!this.isMobile(mobile)) {
                    LOG.error("mobile:" + mobile + ",is not a mobilenumber");
                    failList.add(mobile);
                    continue;
                }
                try {
                    boolean senRes = this.singleSend(mobile, content);
                    if (!senRes) {
                        failList.add(mobile);
                    }
                }
                catch (Exception e) {
                    failList.add(mobile);
                    LOG.error("mobile:" + mobile + ",singleSend fail!", (Throwable)e);
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Thread sleep throws Exception:", (Throwable)e);
                }
            }
        } else {
            LOG.error("mobiles:" + mobiles + ",after convert can not get array!");
            this.alertJS("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e!");
            return "";
        }
        LOG.info("failList:" + Arrays.toString(failList.toArray()));
        if (failList.size() > 0) {
            this.alertJS("\u5b58\u5728\u90e8\u5206\u53f7\u7801\u53d1\u9001\u5931\u8d25\uff0c\u53d1\u9001\u5931\u8d25\u53f7\u7801:" + Arrays.toString(failList.toArray()));
        } else {
            this.alertJS("\u53d1\u9001\u6210\u529f!");
        }
        return "";
    }

    public boolean isMobile(String number) {
        String CNUMBER_PATTERN = "^[0-9]*$";
        Pattern p = Pattern.compile("^[0-9]*$");
        Matcher m = p.matcher(number);
        return m.find() && number.length() == 11;
    }

    private boolean singleSend(String mobile, String content) throws Exception {
        String version = "v1.0";
        String pagecharset = "UTF-8";
        String bizno = "000001";
        String signMsg = this.sign("v1.0", "UTF-8", "000001", mobile, content);
        LOG.info("signMsg:" + signMsg);
        String url = "http://sms.pay.xunlei.com/sendsms?version=" + URLEncoder.encode("v1.0", "UTF-8") + "&pageCharset=" + URLEncoder.encode("UTF-8", "UTF-8") + "&bizNo=" + URLEncoder.encode("000001", "UTF-8") + "&mobile=" + mobile + "&content=" + URLEncoder.encode(content, "UTF-8") + "&signMsg=" + signMsg;
        String resp = "";
        resp = HttpGetAndPostSender.sendGet((String)url);
        LOG.info("mobile:" + mobile + ",content:" + content + ",sendRes:" + resp);
        return resp.contains("00");
    }

    private String sign(String version, String pageCharset, String bizno, String mobile, String content) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", version);
        params.put("pageCharset", pageCharset);
        params.put("bizNo", bizno);
        params.put("mobile", mobile);
        params.put("content", content);
        String sign = SignatureHelper2.sign(params, (String)"qawsedrftgyhplok");
        return sign;
    }

    public String doUploadFile() {
        this.authenticateRun();
        String activeType = this.findParameter("activeType");
        try {
            LOG.info("CleanDataJobManagedBean begin task!");
            if (null == activeType || "".equals(activeType)) {
                LOG.error("activeType is empty!");
                this.alertJS("\u7cfb\u7edf\u9519\u8bef");
                return "";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("activeType:{" + activeType + "}");
            }
            if (!activeType.equals("message")) {
                LOG.error(activeType + "does supported!");
                this.alertJS("\u6682\u4e0d\u652f\u6301\u7684\u7c7b\u578b!");
                return "";
            }
            this.uploadFileJob();
        }
        catch (Exception e) {
            LOG.error("doCleanJob throws Exception\uff1a" + e);
            this.alertJS("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return "";
    }

    private void uploadFileJob() throws IOException {
        LOG.info("\u8fdb\u5165\u65b9\u6cd5\uff01");
        if (this.upFile == null) {
            LOG.info("\u6ca1\u6709\u4e0a\u4f20\u6587\u4ef6");
            this.alertJS("\u8bf7\u9009\u62e9\u4e0a\u4f20\u7684\u6587\u4ef6");
            return;
        }
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.upFile.getInputStream()));
        LOG.info("reader \u521d\u59cb\u5316\u6b63\u5e38\uff01");
        String mobile = "";
        ArrayList<String> failNum = new ArrayList<String>();
        LOG.info("upFile \u8def\u5f84" + this.upFile.getName());
        while (mobile != null) {
            mobile = reader.readLine();
            LOG.info("mobile\u7684\u503c\u4e3a" + mobile);
            if (mobile == null) continue;
            if (mobile.contains(";")) {
                mobile.replace(";", "");
            }
            if (mobile.contains("\uff1b")) {
                mobile.replace("\uff1b", "");
            }
            if (this.isMobile(mobile)) {
                buf.append(mobile + ";");
                continue;
            }
            failNum.add(mobile);
        }
        LOG.info("\u83b7\u5f97\u4e86\u7684\u624b\u673a\u53f7\u7801\u662f" + buf.toString());
        if (failNum.size() > 0) {
            LOG.error(failNum + "\u8fd9\u4e9b\u53f7\u7801\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5c06\u88ab\u8fc7\u6ee4");
            this.alertJS(failNum + "\u8fd9\u4e9b\u53f7\u7801\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5c06\u88ab\u8fc7\u6ee4");
        }
        if (buf.length() > 0) {
            LOG.info("\u63d0\u53d6\u7684\u53f7\u7801\u4e3a:" + buf.toString());
            this.setMobiles(buf.toString());
        }
    }

    public String getMobiles() {
        return this.mobiles;
    }

    public void setMobiles(String mobiles) {
        this.mobiles = mobiles;
    }
}

