/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.alipay.util.SignProtocolUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.ProxyHelper;
import com.xunlei.payproxy.vo.Copartners;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="QuerySignProtocol")
public class QuerySignProtocolManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(QuerySignProtocolManagedBean.class);
    protected static final IFacade facade = IFacade.INSTANCE;
    private String pay_is_success = "";
    private String income_is_success = "";
    private String pay_charge_agent = "";
    private String pay_refund_charge = "";
    private String income_charge_agent = "";
    private String income_refund_charge = "";
    private String pay_errcode = "";
    private String income_errcode = "";
    private String email = "";
    private String bizNo = "";
    private static Map<String, String> biznoMap;
    private static SelectItem[] biznoItem;

    public String getQuery() {
        this.authenticateRun();
        this.pay_is_success = "";
        this.income_is_success = "";
        this.pay_charge_agent = "";
        this.pay_refund_charge = "";
        this.income_charge_agent = "";
        this.income_refund_charge = "";
        this.pay_errcode = "";
        this.income_errcode = "";
        this.email = "";
        this.bizNo = "";
        try {
            this.email = this.findParameter("email");
            this.bizNo = this.findParameter("bizNo");
            String copartnerNo = ProxyHelper.getCopartnerNoFromBizNo((String)this.bizNo);
            Copartners copartnersForQuery = new Copartners();
            copartnersForQuery.setCopartnerno(copartnerNo);
            Copartners copartners = facade.findCopartners(copartnersForQuery);
            logger.debug("\u9a8c\u8bc1\u4e1a\u52a1\u5408\u6cd5\u6027");
            Copbizinfo copbizinfoForQuery = new Copbizinfo();
            copbizinfoForQuery.setBizno(this.bizNo);
            Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
            String bizKey = copbizinfo.getBizkey();
            String[] partner_email = new String[]{"pay@xunlei.com", "incomexl@xunlei.com"};
            HashMap<String, String> pay_paramsMap = new HashMap<String, String>();
            pay_paramsMap.put("bizNo", this.bizNo);
            pay_paramsMap.put("partner", partner_email[0]);
            pay_paramsMap.put("email", this.email);
            HashMap<String, String> incomexl_paramsMap = new HashMap<String, String>();
            incomexl_paramsMap.put("bizNo", this.bizNo);
            incomexl_paramsMap.put("partner", partner_email[1]);
            incomexl_paramsMap.put("email", this.email);
            String pay_reqUrl = SignProtocolUtil.getQuerySignProtocolUrl(pay_paramsMap, (String)bizKey);
            logger.info("pay_AlipayReqUrl=" + pay_reqUrl);
            URL pay_url = new URL(pay_reqUrl);
            String incomexl_reqUrl = SignProtocolUtil.getQuerySignProtocolUrl(incomexl_paramsMap, (String)bizKey);
            logger.info("incomexl_AlipayReqUrl=" + incomexl_reqUrl);
            URL incomexl_url = new URL(incomexl_reqUrl);
            SAXReader reader = new SAXReader();
            Document pay_document = reader.read(pay_url);
            Element root = pay_document.getRootElement();
            this.pay_is_success = root.element("is_success").getText();
            logger.info("pay_is_success = " + this.pay_is_success);
            if (this.pay_is_success.equals("Y")) {
                this.pay_charge_agent = root.element("charge_agent").getText();
                this.pay_refund_charge = root.element("refund_charge").getText();
            }
            if (this.pay_is_success.equals("N")) {
                this.pay_errcode = root.element("errcode").getText();
            }
            SAXReader reader2 = new SAXReader();
            Document incom_Document = reader2.read(incomexl_url);
            Element incom_Root = incom_Document.getRootElement();
            this.income_is_success = incom_Root.element("is_success").getText();
            logger.info("income_is_success = " + this.income_is_success);
            if (this.income_is_success.equals("Y")) {
                this.income_charge_agent = incom_Root.element("charge_agent").getText();
                this.income_refund_charge = incom_Root.element("refund_charge").getText();
            }
            if (this.income_is_success.equals("N")) {
                this.income_errcode = incom_Root.element("errcode").getText();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return "";
    }

    public SelectItem[] getBiznoItem() {
        if (biznoItem == null) {
            List list = (List)IFacade.INSTANCE.queryCopbizinfo(new Copbizinfo(), null).getDatas();
            if (list != null) {
                biznoItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    QuerySignProtocolManagedBean.biznoItem[i] = new SelectItem((Object)((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
                }
            }
            return biznoItem;
        }
        return biznoItem;
    }

    public Map getBiznoMap() {
        if (biznoMap == null) {
            biznoMap = new HashMap<String, String>();
            List list = (List)IFacade.INSTANCE.queryCopbizinfo(new Copbizinfo(), null).getDatas();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    biznoMap.put(((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
                }
            }
        }
        return biznoMap;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public String getBizNo() {
        return this.bizNo;
    }

    public void setPay_charge_agent(String pay_charge_agent) {
        this.pay_charge_agent = pay_charge_agent;
    }

    public String getPay_charge_agent() {
        return this.pay_charge_agent;
    }

    public void setPay_refund_charge(String pay_refund_charge) {
        this.pay_refund_charge = pay_refund_charge;
    }

    public String getPay_refund_charge() {
        return this.pay_refund_charge;
    }

    public void setIncome_charge_agent(String income_charge_agent) {
        this.income_charge_agent = income_charge_agent;
    }

    public String getIncome_charge_agent() {
        return this.income_charge_agent;
    }

    public void setIncome_refund_charge(String income_refund_charge) {
        this.income_refund_charge = income_refund_charge;
    }

    public String getIncome_refund_charge() {
        return this.income_refund_charge;
    }

    public String getPay_is_success() {
        return this.pay_is_success;
    }

    public void setPay_is_success(String pay_is_success) {
        this.pay_is_success = pay_is_success;
    }

    public String getIncome_is_success() {
        return this.income_is_success;
    }

    public void setIncome_is_success(String income_is_success) {
        this.income_is_success = income_is_success;
    }

    public void setPay_errcode(String pay_errcode) {
        this.pay_errcode = pay_errcode;
    }

    public String getPay_errcode() {
        return this.pay_errcode;
    }

    public void setIncome_errcode(String income_errcode) {
        this.income_errcode = income_errcode;
    }

    public String getIncome_errcode() {
        return this.income_errcode;
    }
}

