/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.PayProxyFunctionConstant;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.Copartners;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.vo.Paynoticefail;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;

@FunRef(value="PayProxyPaynoticefail")
public class PaynoticefailManagedBean
extends BaseManagedBean {
    private static Map<String, String> paytypeMap;
    private static SelectItem[] paytypeItem;

    public String getQueryPaynoticefailList() {
        this.authenticateRun();
        Paynoticefail paynoticefail = (Paynoticefail)this.findBean(Paynoticefail.class, "payproxy_paynoticefail");
        if (Utility.isEmpty((String)paynoticefail.getFromdate())) {
            paynoticefail.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
        }
        if (Utility.isEmpty((String)paynoticefail.getTodate())) {
            paynoticefail.setTodate(DatetimeUtil.today());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("noticetime desc");
        Sheet sheet = facade.queryPaynoticefail(paynoticefail, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        facade.deletePaynoticefailById(this.findParamSeqids());
        this.getQueryPaynoticefailList();
        return "";
    }

    public String informSome() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticeinformBtn");
        logger.info((Object)("moveids:" + moveids));
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                logger.info((Object)("informSome-----seqid\u4e3a\uff1a" + seqid));
                Paynoticefail queryPaynoticefail = new Paynoticefail();
                queryPaynoticefail.setSeqid(Long.parseLong(seqid));
                Paynoticefail paynoticefail = facade.findPaynoticefail(queryPaynoticefail);
                logger.info((Object)("informSome-----seqid=" + seqid + ",xunleipayid=" + paynoticefail.getXunleipayid()));
                this.perNotice(paynoticefail.getXunleipayid());
            }
        }
        return "";
    }

    public String perNotice(String xunleipayid) {
        Bizorderok bizorderokQry = new Bizorderok();
        bizorderokQry.setXunleipayid(xunleipayid);
        Bizorderok bizorderok = IFacade.INSTANCE.findBizorderok(bizorderokQry);
        String type = bizorderok.getType();
        if (type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_TRADE)) {
            PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)xunleipayid);
        } else if (type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_REFUND_PLATFORM) || type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_REFUND_USER)) {
            PayProxyJmsMessageSender.sendRefundBizorderokByXunleiPayId((String)xunleipayid);
        }
        logger.info((Object)("xunleipayid=" + xunleipayid + ",\u901a\u77e5\u53d1\u9001\u5b8c\u6210"));
        this.alertJS("\u53d1\u9001\u901a\u77e5\u5b8c\u6210");
        return "";
    }

    public String informSomeLast() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticeinformLastBtn");
        logger.info((Object)("moveids:" + moveids));
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                logger.info((Object)("\u6279\u91cf\u901a\u77e5\u5386\u53f2\u8ba2\u5355-----seqid\u4e3a\uff1a" + seqid));
                Paynoticefail queryPaynoticefail = new Paynoticefail();
                queryPaynoticefail.setSeqid(Long.parseLong(seqid));
                Paynoticefail paynoticefail = facade.findPaynoticefail(queryPaynoticefail);
                logger.info((Object)("\u6279\u91cf\u901a\u77e5\u5386\u53f2\u8ba2\u5355-----seqid=" + seqid + ",xunleipayid=" + paynoticefail.getXunleipayid()));
                this.perLastNotice(paynoticefail.getXunleipayid());
            }
        }
        return "";
    }

    public String perLastNotice(String xunleipayid) {
        Bizorderok bizorderokQry = new Bizorderok();
        bizorderokQry.setXunleipayid(xunleipayid);
        String table = this.getBizroderokQuartTable(xunleipayid);
        Bizorderok bizorderok = IFacade.INSTANCE.findBizorderokByTable(bizorderokQry, table);
        String type = bizorderok.getType();
        if (type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_TRADE)) {
            PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)xunleipayid);
        } else if (type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_REFUND_PLATFORM) || type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_REFUND_USER)) {
            PayProxyJmsMessageSender.sendRefundBizorderokByXunleiPayId((String)xunleipayid);
        }
        logger.info((Object)("xunleipayid=" + xunleipayid + ",\u901a\u77e5\u53d1\u9001\u5b8c\u6210"));
        this.alertJS("\u53d1\u9001\u901a\u77e5\u5b8c\u6210");
        return "";
    }

    public String getBizroderokQuartTable(String date) {
        SimpleDateFormat sdfYYMMDD = new SimpleDateFormat("yyMMdd");
        logger.info((Object)("getBizroderokQuartTable-----\u67e5\u8be2\u7684\u65e5\u671f\u4e3a\uff1a" + date));
        int frommonth = 0;
        try {
            Date time = sdfYYMMDD.parse(date.substring(0, 6));
            frommonth = PaynoticefailManagedBean.getSeason(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String table = "bizorderok_20" + date.substring(0, 2) + "Q" + frommonth;
        return table;
    }

    public static int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public String ignoreSome() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticeignoreBtn");
        logger.info((Object)("moveids:" + moveids));
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                this.doPerIgnore(seqid);
            }
        }
        return "";
    }

    public SelectItem[] getCopartnersItem() {
        Copartners queryCopartners = new Copartners();
        Sheet sheet = facade.queryCopartners(queryCopartners, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getChooseflag() + "-" + ((Copartners)list.get(i)).getCopartnername());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getCopartnersMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Sheet sheet = facade.queryCopartners(new Copartners(), null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getCopartnername());
            }
        }
        return copMap;
    }

    public Map<String, String> getPaytypeMap() {
        if (paytypeMap == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            paytypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paytypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paytypeMap;
    }

    public SelectItem[] getPaytypeItem() {
        if (paytypeItem == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            if (list == null) {
                paytypeItem = new SelectItem[0];
            } else {
                paytypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    PaynoticefailManagedBean.paytypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return paytypeItem;
    }

    public SelectItem[] getBiznoItem() {
        Copbizinfo queryCopbizinfo = new Copbizinfo();
        Sheet sheet = facade.queryCopbizinfo(queryCopbizinfo, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getBiznameMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Sheet sheet = facade.queryCopbizinfo(new Copbizinfo(), null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
        }
        return copMap;
    }

    public String doPerIgnore(String seqid) {
        logger.info((Object)("doPerIgnore\u7684\u64cd\u4f5c\uff0cseqid\u4e3a\uff1a" + seqid));
        Paynoticefail data = new Paynoticefail();
        data.setSeqid(Long.parseLong(seqid));
        Paynoticefail paynoticefail = facade.findPaynoticefail(data);
        if (paynoticefail.getFailtimes() >= 0) {
            paynoticefail.setFailtimes(-1);
            facade.updatePaynoticefail(paynoticefail);
        } else {
            this.alertJS("\u5931\u8d25\u6b21\u6570\u5c0f\u4e8e0");
        }
        return "";
    }

    public String doIgnore() {
        this.authenticateEdit();
        return this.doPerIgnore(this.findParameter("sseqid"));
    }
}

