/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Copartners;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.vo.Paydayend;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.ExcelBaseBean;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyPaydayend")
public class PaydayendSumManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(PaydayendSumManagedBean.class);
    private static Map<String, String> paytypeMap;
    private static SelectItem[] paytypeItem;
    private static Map<String, String> bizNameMap;

    public String getQueryPaydayendList() {
        this.authenticateRun();
        Paydayend paydayend = (Paydayend)this.findBean(Paydayend.class, "payproxy_paydayend");
        if (Utility.isEmpty((String)paydayend.getFromdate())) {
            paydayend.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-30));
        }
        if (Utility.isEmpty((String)paydayend.getTodate())) {
            paydayend.setTodate(DatetimeUtil.today());
        }
        if (Utility.isEmpty((String)paydayend.getBizno())) {
            paydayend.setBiznos(this.biznosByRecRoleForPaydayend());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("balancedate desc");
        Sheet sheet = facade.queryPaydayendSum(paydayend, fliper);
        if (sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            int failNum = 0;
            int successNum = 0;
            double successRate = 0.0;
            int failUserNum = 0;
            int successUserNum = 0;
            double userPercent = 0.0;
            double successAmt = 0.0;
            double factSuccessAmt = 0.0;
            for (Paydayend vo : list) {
                failNum += vo.getFailnum();
                successNum += vo.getSuccessnum();
                failUserNum += vo.getFailusernum();
                successUserNum += vo.getSuccessusernum();
                successAmt += vo.getSuccessamt();
                factSuccessAmt += vo.getFactsuccessamt().doubleValue();
            }
            Paydayend sum = new Paydayend();
            sum.setFailnum(failNum);
            sum.setSuccessnum(successNum);
            sum.setFailusernum(failUserNum);
            sum.setSuccessusernum(successUserNum);
            sum.setSuccessamt(successAmt);
            sum.setFactsuccessamt(Double.valueOf(factSuccessAmt));
            sheet.getDatas().add(sum);
        }
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public boolean checkBizNoisNull(String bizNo) {
        return bizNo != null && !bizNo.equals("");
    }

    public SelectItem[] getCopartnersItem() {
        Copartners queryCopartners = new Copartners();
        Sheet sheet = facade.queryCopartners(queryCopartners, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getChooseflag() + "-" + ((Copartners)list.get(i)).getCopartnername());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getCopartnersMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Sheet sheet = facade.queryCopartners(new Copartners(), null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getCopartnername());
            }
        }
        return copMap;
    }

    public SelectItem[] getBiznoItem() {
        Copbizinfo queryCopbizinfo = new Copbizinfo();
        queryCopbizinfo.setBizstatus("N");
        Sheet sheet = facade.queryCopbizinfo(queryCopbizinfo, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getBizNameMap() {
        if (bizNameMap == null) {
            Copbizinfo queryCopbizinfo = new Copbizinfo();
            queryCopbizinfo.setBizstatus("N");
            Sheet sheet = facade.queryCopbizinfo(queryCopbizinfo, null);
            bizNameMap = new Hashtable<String, String>();
            if (sheet != null && sheet.getRowcount() > 0) {
                List list = (List)sheet.getDatas();
                for (int i = 0; i < list.size(); ++i) {
                    bizNameMap.put(((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
                }
            }
        }
        return bizNameMap;
    }

    public Map<String, String> getPaytypeMap() {
        if (paytypeMap == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            paytypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paytypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paytypeMap;
    }

    public SelectItem[] getPaytypeItem() {
        if (paytypeItem == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            if (list == null) {
                paytypeItem = new SelectItem[0];
            } else {
                paytypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    PaydayendSumManagedBean.paytypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return paytypeItem;
    }

    public void getExcel() {
        HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
        ExcelBaseBean te = new ExcelBaseBean();
        Paydayend paydayend = (Paydayend)this.findBean(Paydayend.class, "payproxy_paydayend");
        if (Utility.isEmpty((String)paydayend.getFromdate())) {
            paydayend.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-30));
        }
        if (Utility.isEmpty((String)paydayend.getTodate())) {
            paydayend.setTodate(DatetimeUtil.today());
        }
        if (Utility.isEmpty((String)paydayend.getBizno())) {
            paydayend.setBiznos(this.biznosByRecRoleForPaydayend());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("balancedate desc");
        List list = facade.queryPaydayendSumList(paydayend, fliper);
        int failNum = 0;
        int successNum = 0;
        double successRate = 0.0;
        int failUserNum = 0;
        int successUserNum = 0;
        double userPercent = 0.0;
        double successAmt = 0.0;
        double factSuccessAmt = 0.0;
        for (Paydayend vo : list) {
            vo.setBizname(bizNameMap.get(vo.getBizno()));
            vo.setPaytype(paytypeMap.get(vo.getPaytype()));
            failNum += vo.getFailnum();
            successNum += vo.getSuccessnum();
            failUserNum += vo.getFailusernum();
            successUserNum += vo.getSuccessusernum();
            successAmt += vo.getSuccessamt();
            factSuccessAmt += vo.getFactsuccessamt().doubleValue();
        }
        Paydayend sum = new Paydayend();
        sum.setBizname("\u603b\u8ba1");
        sum.setFailnum(failNum);
        sum.setSuccessnum(successNum);
        sum.setFailusernum(failUserNum);
        sum.setSuccessusernum(successUserNum);
        sum.setSuccessamt(successAmt);
        sum.setFactsuccessamt(Double.valueOf(factSuccessAmt));
        list.add(sum);
        response.reset();
        response.setContentType("application/ms-excel");
        try {
            HSSFWorkbook wb = te.makeExcel(list);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String fileName = "\u652f\u4ed8\u65b9\u5f0f\u65e5\u6c47\u603b" + sdf.format(new Date());
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("gb2312"), "ISO8859-1") + ".xls");
            wb.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            logger.error("excel err:" + e.toString());
            e.printStackTrace();
        }
        FacesContext.getCurrentInstance().responseComplete();
    }
}

