/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.util.FlashAnalyse;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Copartners;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.vo.Paydayend;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;

@FunRef(value="PayProxyPaydayend")
public class PaydayendManagedBean
extends BaseManagedBean {
    private static Map<String, String> paytypeMap;
    private static SelectItem[] paytypeItem;

    public String getQueryPaydayendList() {
        this.authenticateRun();
        Paydayend paydayend = (Paydayend)this.findBean(Paydayend.class, "payproxy_paydayend");
        if (Utility.isEmpty((String)paydayend.getFromdate())) {
            paydayend.setFromdate(DatetimeUtil.yesterday());
        }
        if (Utility.isEmpty((String)paydayend.getTodate())) {
            paydayend.setTodate(DatetimeUtil.yesterday());
        }
        if (Utility.isEmpty((String)paydayend.getBizno())) {
            paydayend.setBiznos(this.biznosByRecRoleForPaydayend());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("balancedate desc,copartnerno asc,bizno");
        Sheet sheet = facade.queryPaydayend(paydayend, fliper);
        if (sheet.getRowcount() > 0) {
            Paydayend sum = facade.queryPaydayendSum(paydayend);
            sheet.getDatas().add(sum);
        }
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public String getQueryTrend() {
        this.authenticate("PPPaydayendtrend", "run");
        Paydayend paydayend = (Paydayend)this.findBean(Paydayend.class, "payproxy_paydayend");
        if (Utility.isEmpty((String)paydayend.getFromdate())) {
            paydayend.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.yesterday(), (String)"D", (int)-30));
        }
        if (Utility.isEmpty((String)paydayend.getTodate())) {
            paydayend.setTodate(DatetimeUtil.yesterday());
        }
        if (Utility.isEmpty((String)paydayend.getBizno())) {
            paydayend.setBiznos(this.biznosByRecRoleForPaydayend());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("balancedate asc,bizno");
        fliper.setPageSize(40000);
        String[] flashDatas = new String[]{};
        Sheet sheet = facade.queryPaydayend(paydayend, fliper);
        if (sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            ArrayList<String> xTimeDatas = new ArrayList<String>();
            String prevTime = null;
            for (Paydayend item : list) {
                if (prevTime != null && prevTime.equals(item.getBalancedate())) continue;
                xTimeDatas.add(item.getBalancedate().substring(2));
                prevTime = item.getBalancedate();
            }
            String bizName = "";
            String YName = "";
            switch (paydayend.getDimension()) {
                case 1: {
                    bizName = "\u6210\u529f\u91d1\u989d\u6c47\u603b";
                    YName = "\u91d1\u989d";
                    break;
                }
                case 2: {
                    bizName = "\u652f\u4ed8\u6210\u529f\u8ba2\u5355\u6570\u91cf\u6c47\u603b";
                    YName = "\u6210\u529f\u6570\u91cf";
                    break;
                }
                case 3: {
                    bizName = "\u652f\u4ed8\u6210\u529f\u7387\u6c47\u603b";
                    YName = "\u6210\u529f\u7387";
                    break;
                }
                case 4: {
                    bizName = "ARPU(\u91d1\u989d/\u652f\u4ed8\u6210\u529f\u8ba2\u5355\u6570\u91cf)\u6c47\u603b";
                    YName = "ARPU";
                    break;
                }
                default: {
                    bizName = "\u6210\u529f\u91d1\u989d\u6c47\u603b";
                    YName = "\u91d1\u989d";
                }
            }
            Map<String, String> biznameMap = this.getBiznameMap();
            biznameMap.put("-1", bizName);
            HashMap<String, Integer> bizNoIndex = new HashMap<String, Integer>();
            String[] biznames = new String[biznameMap.size()];
            int index = 1;
            biznames[0] = biznameMap.get("-1");
            bizNoIndex.put("-1", 0);
            for (Map.Entry<String, String> entry : biznameMap.entrySet()) {
                if (entry.getKey().equals("-1")) continue;
                bizNoIndex.put(entry.getKey(), index);
                biznames[index] = entry.getValue();
                ++index;
            }
            flashDatas = new String[biznameMap.size()];
            double[][][] flashLineDatas = new double[biznameMap.size()][1][xTimeDatas.size()];
            double dayTotal = 0.0;
            double bizTotal = 0.0;
            double factsuccess = 0.0;
            double factsum = 0.0;
            double bizfactsuccess = 0.0;
            double bizfactsum = 0.0;
            double tmpfactsuccess = 0.0;
            double tmpfactsum = 0.0;
            int dayLineIndex = 0;
            for (int i = 0; i < list.size(); ++i) {
                double df;
                BigDecimal b;
                Paydayend item = (Paydayend)list.get(i);
                switch (paydayend.getDimension()) {
                    case 1: {
                        bizTotal += item.getFactsuccessamt().doubleValue();
                        dayTotal += item.getFactsuccessamt().doubleValue();
                        break;
                    }
                    case 2: {
                        bizTotal += (double)(item.getSuccessnum() - item.getRrefundsuccessnum());
                        dayTotal += (double)(item.getSuccessnum() - item.getRrefundsuccessnum());
                        break;
                    }
                    case 3: {
                        tmpfactsuccess = item.getSuccessnum() - item.getRrefundsuccessnum();
                        tmpfactsum = item.getSuccessnum() + item.getFailnum() - item.getRrefundsuccessnum();
                        bizfactsuccess += tmpfactsuccess;
                        bizfactsum += tmpfactsum;
                        factsuccess += tmpfactsuccess;
                        factsum += tmpfactsum;
                        break;
                    }
                    case 4: {
                        tmpfactsuccess = item.getFactsuccessamt();
                        tmpfactsum = item.getSuccessnum() - item.getRrefundsuccessnum();
                        bizfactsuccess += tmpfactsuccess;
                        bizfactsum += tmpfactsum;
                        factsuccess += tmpfactsuccess;
                        factsum += tmpfactsum;
                        break;
                    }
                    default: {
                        bizTotal += item.getFactsuccessamt().doubleValue();
                        dayTotal += item.getFactsuccessamt().doubleValue();
                    }
                }
                if (i == list.size() - 1 || !item.getBizno().equals(((Paydayend)list.get(i + 1)).getBizno())) {
                    if (paydayend.getDimension() == 3 || paydayend.getDimension() == 4) {
                        if (bizfactsum == 0.0) {
                            flashLineDatas[((Integer)bizNoIndex.get((Object)item.getBizno())).intValue()][0][dayLineIndex] = 0.0;
                        } else {
                            b = null;
                            b = paydayend.getDimension() == 3 ? new BigDecimal(bizfactsuccess / bizfactsum * 100.0) : new BigDecimal(bizfactsuccess / bizfactsum);
                            flashLineDatas[((Integer)bizNoIndex.get((Object)item.getBizno())).intValue()][0][dayLineIndex] = df = b.setScale(2, 4).doubleValue();
                        }
                        logger.debug((Object)("item.getBizno() = '" + item.getBizno() + "' bizfactsuccess = '" + bizfactsuccess + "' bizfactsum = '" + bizfactsum + "'"));
                        bizfactsuccess = 0.0;
                        bizfactsum = 0.0;
                    } else {
                        flashLineDatas[((Integer)bizNoIndex.get((Object)item.getBizno())).intValue()][0][dayLineIndex] = bizTotal;
                        bizTotal = 0.0;
                    }
                }
                if (i != list.size() - 1 && item.getBalancedate().equals(((Paydayend)list.get(i + 1)).getBalancedate())) continue;
                if (paydayend.getDimension() == 3 || paydayend.getDimension() == 4) {
                    if (factsum > 0.0) {
                        b = null;
                        b = paydayend.getDimension() == 3 ? new BigDecimal(factsuccess / factsum * 100.0) : new BigDecimal(factsuccess / factsum);
                        flashLineDatas[((Integer)bizNoIndex.get((Object)"-1")).intValue()][0][dayLineIndex] = df = b.setScale(2, 4).doubleValue();
                    } else {
                        flashLineDatas[((Integer)bizNoIndex.get((Object)"-1")).intValue()][0][dayLineIndex] = 0.0;
                    }
                    logger.debug((Object)("item.getBalancedate() = '" + item.getBalancedate() + "' factsuccess = '" + factsuccess + "' factsum = '" + factsum + "'"));
                    factsuccess = 0.0;
                    factsum = 0.0;
                } else {
                    flashLineDatas[((Integer)bizNoIndex.get((Object)"-1")).intValue()][0][dayLineIndex] = dayTotal;
                    dayTotal = 0.0;
                }
                ++dayLineIndex;
            }
            String[] xTimeDatasStr = new String[xTimeDatas.size()];
            xTimeDatas.toArray(xTimeDatasStr);
            for (int k = 0; k < biznameMap.size(); ++k) {
                flashDatas[k] = FlashAnalyse.createChar((String[])xTimeDatasStr, (double[][])flashLineDatas[k], (String[])new String[]{biznames[k]}, (String[])new String[]{biznames[k], YName});
            }
        }
        this.mergeBean(flashDatas, "list");
        return "";
    }

    public SelectItem[] getCopartnersItem() {
        Copartners queryCopartners = new Copartners();
        Sheet sheet = facade.queryCopartners(queryCopartners, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getChooseflag() + "-" + ((Copartners)list.get(i)).getCopartnername());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getCopartnersMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Sheet sheet = facade.queryCopartners(new Copartners(), null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getCopartnername());
            }
        }
        return copMap;
    }

    public SelectItem[] getBiznoItem() {
        Copbizinfo queryCopbizinfo = new Copbizinfo();
        queryCopbizinfo.setBizstatus("N");
        Sheet sheet = facade.queryCopbizinfo(queryCopbizinfo, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getBiznameMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Copbizinfo queryCopbizinfo = new Copbizinfo();
        queryCopbizinfo.setBizstatus("N");
        Sheet sheet = facade.queryCopbizinfo(queryCopbizinfo, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
        }
        return copMap;
    }

    public Map<String, String> getPaytypeMap() {
        if (paytypeMap == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            paytypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paytypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paytypeMap;
    }

    public SelectItem[] getPaytypeItem() {
        if (paytypeItem == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            if (list == null) {
                paytypeItem = new SelectItem[0];
            } else {
                paytypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    PaydayendManagedBean.paytypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return paytypeItem;
    }
}

