/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.util.FlashAnalyse;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.vo.Paydayend;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaydayendDatailManageBean
extends BaseManagedBean {
    private static Logger log = LoggerFactory.getLogger(PaydayendDatailManageBean.class);
    private static Map<String, String> paytypeMap;

    public String getQueryPaydayendDetailList() {
        this.authenticateRun();
        log.debug("\u5f00\u59cb\u67e5\u8be2...");
        String bizno = this.findParameter("bizno");
        String fromdate = this.findParameter("fromdate");
        String todate = this.findParameter("todate");
        Paydayend paydayend = (Paydayend)this.findBean(Paydayend.class, "payproxy_paydayend");
        if (this.isNotEmpty(bizno)) {
            paydayend.setBizno(bizno);
        }
        if (this.isNotEmpty(fromdate)) {
            paydayend.setFromdate(fromdate);
        }
        if (this.isNotEmpty(todate)) {
            paydayend.setTodate(todate);
        }
        if (this.isNotEmpty(paydayend.getBizno())) {
            String[] biznos = new String[]{paydayend.getBizno()};
            paydayend.setBiznos(biznos);
        }
        if (Utility.isEmpty((String)paydayend.getFromdate())) {
            paydayend.setFromdate(DatetimeUtil.yesterday());
        }
        if (Utility.isEmpty((String)paydayend.getTodate())) {
            paydayend.setTodate(DatetimeUtil.yesterday());
        }
        if (Utility.isEmpty((String)paydayend.getBizno())) {
            paydayend.setBiznos(this.biznosByRecRoleForPaydayend());
        }
        List list = facade.queryPaytypedayendByBizno(paydayend);
        this.getFlashVarAmt(list);
        this.getFlashVarOrder(list);
        this.mergeBean(list, "datas");
        return "";
    }

    private String getFlashVarAmt(List<Paydayend> list) {
        String flashVar;
        String title = "\u6210\u529f\u91d1\u989d";
        if (list != null && list.size() > 0) {
            String yName = "\u6210\u529f\u91d1\u989d";
            int size = list.size() - 1;
            String[] rowKyes = new String[size];
            String[] columnKeys = new String[size];
            double[][] bizAndQtyNum = new double[size][size];
            for (int i = 0; i < size; ++i) {
                Paydayend data = list.get(i);
                rowKyes[i] = this.getPaytypeMap().get(data.getPaytype());
                columnKeys[i] = "";
                bizAndQtyNum[i][size - 1 - i] = data.getFactsuccessamt();
            }
            flashVar = FlashAnalyse.createChar((String[])columnKeys, (double[][])bizAndQtyNum, (String[])rowKyes, (String[])new String[]{title, yName});
        } else {
            flashVar = FlashAnalyse.createChar(null, (double[][])null, null, (String[])new String[]{title, null});
        }
        log.debug("\u6210\u529f\u91d1\u989dflash\uff1a" + flashVar);
        this.mergeBean(flashVar, "channelchartfile1");
        return "";
    }

    public Map<String, String> getBiznameMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Copbizinfo queryCopbizinfo = new Copbizinfo();
        queryCopbizinfo.setBizstatus("N");
        Sheet sheet = facade.queryCopbizinfo(queryCopbizinfo, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
            copMap.put("", "(\u6c47\u603b)");
        }
        return copMap;
    }

    private String getFlashVarOrder(List<Paydayend> list) {
        String flashVar;
        String title = "\u6210\u529f\u8ba2\u5355";
        if (list != null && list.size() > 0) {
            String yName = "\u6210\u529f\u8ba2\u5355";
            int size = list.size() - 1;
            String[] rowKyes = new String[size];
            String[] columnKeys = new String[size];
            double[][] bizAndQtyNum = new double[size][size];
            for (int i = 0; i < size; ++i) {
                Paydayend data = list.get(i);
                rowKyes[i] = this.getPaytypeMap().get(data.getPaytype());
                columnKeys[i] = "";
                bizAndQtyNum[i][size - 1 - i] = data.getSuccessnum();
            }
            flashVar = FlashAnalyse.createChar((String[])columnKeys, (double[][])bizAndQtyNum, (String[])rowKyes, (String[])new String[]{title, yName});
        } else {
            flashVar = FlashAnalyse.createChar(null, (double[][])null, null, (String[])new String[]{title, null});
        }
        log.debug("\u6210\u529f\u8ba2\u5355flash\uff1a" + flashVar);
        this.mergeBean(flashVar, "channelchartfile2");
        return "";
    }

    public Map<String, String> getPaytypeMap() {
        if (paytypeMap == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            paytypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paytypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paytypeMap;
    }
}

