/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FileUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.util.PayProxyFunctionConstant;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.vo.Mobilevipbill;
import com.xunlei.payproxy.vo.Mobilevipmonthend;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="Mobilevipbill")
public class MobilevipbillManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(MobilevipbillManagedBean.class);
    private static Map<String, String> carrierMap;
    private static SelectItem[] carrierItem;
    private static Map<String, String> usertypeMap;
    private static SelectItem[] usertypeItem;
    private static Map<String, String> chargestateMap;
    private static SelectItem[] chargestateItem;
    private static Map<String, String> datastateMap;
    private static SelectItem[] datastateItem;
    private static Map<String, String> dealtypeMap;
    private static SelectItem[] dealtypeItem;
    private static Map<String, String> exceptiondatatypeMap;
    private static SelectItem[] exceptiondatatypeItem;
    private static SelectItem[] provinceItem;
    private static Map<String, String> provinceMap;
    private UploadedFile chargebillfile;
    private UploadedFile quitbillfile;
    private final DateFormat monthYm = new SimpleDateFormat("yyyy-MM");

    public String getQueryMobilevipbillList() {
        this.authenticateRun();
        Mobilevipbill mobilevipbill = (Mobilevipbill)this.findBean(Mobilevipbill.class, "payproxy_mobilevipbill");
        Map hrefMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        logger.info("\u8bf7\u6c42\u9875\u9762\u65f6\u7684\u53c2\u6570\u4e3a\uff1a" + hrefMap);
        String quitMobile = (String)hrefMap.get("quitmobile");
        if (this.isNotEmpty(quitMobile)) {
            mobilevipbill.setMobile(quitMobile);
            mobilevipbill.setFrommonth(DatetimeUtil.today().substring(0, 4) + "-01");
            mobilevipbill.setFrommonth(DatetimeUtil.today().substring(0, 4) + "-12");
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid desc");
            Sheet sheet = facade.queryMobilevipbill(mobilevipbill, fliper);
            if (sheet.getRowcount() <= 0) {
                this.alertJS("\u624b\u673a\u53f7[" + quitMobile + "]\u4e0d\u5b58\u5728" + DatetimeUtil.today().substring(0, 4) + "\u5e74\u5ea6\u7684\u6263\u8d39\u8bb0\u5f55");
            }
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
            return "";
        }
        if (Utility.isEmpty((String)mobilevipbill.getFromyear())) {
            mobilevipbill.setFromyear("");
        }
        if (Utility.isEmpty((String)mobilevipbill.getFrommonth())) {
            mobilevipbill.setFrommonth("");
        }
        if (Utility.isEmpty((String)mobilevipbill.getToyear())) {
            mobilevipbill.setFrommonth("");
        }
        if (Utility.isEmpty((String)mobilevipbill.getTomonth())) {
            mobilevipbill.setFrommonth("");
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("seqid desc");
        Sheet sheet = facade.queryMobilevipbill(mobilevipbill, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public UploadedFile getChargebillfile() {
        return this.chargebillfile;
    }

    public void setChargebillfile(UploadedFile chargebillfile) {
        this.chargebillfile = chargebillfile;
    }

    public UploadedFile getQuitbillfile() {
        return this.quitbillfile;
    }

    public void setQuitbillfile(UploadedFile quitbillfile) {
        this.quitbillfile = quitbillfile;
    }

    public String importChargeBill() {
        this.authenticateAdd();
        try {
            String filename = this.chargebillfile.getName();
            logger.debug("filename=" + filename);
            String realfilename = filename.substring(filename.lastIndexOf("\\") + 1, filename.length());
            logger.info("realfilename=" + realfilename);
            BufferedInputStream in = new BufferedInputStream(this.chargebillfile.getInputStream());
            String path = ApplicationConfigUtil.getRootFilePath() + "payproxy" + File.separator + "mobile" + File.separator + "data" + File.separator;
            if (!new File(path).isDirectory()) {
                new File(path).mkdirs();
            }
            File file = new File(path + realfilename);
            logger.debug("\u670d\u52a1\u5668\u6587\u4ef6\u8def\u5f84:" + path + realfilename);
            FileOutputStream out = new FileOutputStream(file);
            long fSize = this.chargebillfile.getSize();
            byte[] buffer = new byte[(int)fSize];
            ((InputStream)in).read(buffer, 0, (int)fSize);
            out.write(buffer, 0, (int)fSize);
            out.close();
            ((InputStream)in).close();
            if (filename.indexOf(".txt") > 0) {
                List list = FileUtil.readFile((String)(path + realfilename));
                String billmonth = "";
                billmonth = realfilename.substring(0, 7);
                String carrier = "";
                String serivetype = "";
                Double orderamt = 0.0;
                logger.debug("subfilename=" + realfilename.substring(0, realfilename.length() - 4));
                serivetype = realfilename.substring(7, 8);
                orderamt = (double)new Double(realfilename.substring(8, 10));
                if (realfilename.substring(0, realfilename.length() - 4).endsWith("cmcc")) {
                    carrier = "M";
                } else if (realfilename.substring(0, realfilename.length() - 4).endsWith("unicom")) {
                    carrier = "U";
                } else if (realfilename.substring(0, realfilename.length() - 4).endsWith("telecom")) {
                    carrier = "T";
                } else {
                    this.alertJS("\u6587\u4ef6\u540d\u5fc5\u987b\u4ee5cmcc\u3001unicom\u6216\u8005telecom\u7ed3\u5c3e");
                    return "";
                }
                int count = facade.deleteMonthChargebill(billmonth, PayProxyFunctionConstant.SP_KONGZHONG, carrier, serivetype, orderamt);
                logger.debug("\u4e00\u5171\u5220\u9664\u4e86" + count + "\u6761\u8bb0\u5f55");
                for (int i = 0; i < list.size(); ++i) {
                    String note = (String)list.get(i);
                    facade.importOneChargeBill(billmonth, carrier, note, serivetype, orderamt);
                }
                this.alertJS("\u5bfc\u5165Txt\u6210\u529f");
            } else {
                this.alertJS("\u6587\u6863\u683c\u5f0f\u5fc5\u987b\u4e3atxt");
            }
        }
        catch (NumberFormatException e) {
            logger.error(e.getMessage());
            this.alertJS("\u5bfc\u5165Txt\u5931\u8d25\uff0c\u8bf7\u6309\u7167\u8981\u6c42\u7684\u683c\u5f0f\u5bfc\u5165\u8ba1\u8d39\u8bdd\u8d39");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.alertJS("\u5bfc\u5165Txt\u5931\u8d25");
        }
        return "";
    }

    public String importQuitBill() {
        this.authenticateAdd();
        try {
            String filename = this.quitbillfile.getName();
            logger.info("filename=" + filename);
            String realfilename = filename.substring(filename.lastIndexOf("\\") + 1, filename.length());
            logger.info("realfilename=" + realfilename);
            BufferedInputStream in = new BufferedInputStream(this.quitbillfile.getInputStream());
            String path = ApplicationConfigUtil.getRootFilePath() + "payproxy" + File.separator + "mobile" + File.separator + "data" + File.separator;
            if (!new File(path).isDirectory()) {
                new File(path).mkdirs();
            }
            File file = new File(path + realfilename);
            logger.debug("\u670d\u52a1\u5668\u6587\u4ef6\u8def\u5f84:" + path + realfilename);
            FileOutputStream out = new FileOutputStream(file);
            long fSize = this.quitbillfile.getSize();
            byte[] buffer = new byte[(int)fSize];
            ((InputStream)in).read(buffer, 0, (int)fSize);
            out.write(buffer, 0, (int)fSize);
            out.close();
            ((InputStream)in).close();
            if (filename.indexOf(".txt") > 0) {
                List list = FileUtil.readFile((String)(path + realfilename));
                logger.debug("quitcount=" + list.size());
                String billmonth = "";
                String serivetype = "";
                Double orderamt = 0.0;
                billmonth = realfilename.substring(0, 7);
                serivetype = realfilename.substring(7, 8);
                orderamt = (double)new Double(realfilename.substring(8, 10));
                logger.debug("subrealfilename=" + realfilename.substring(0, realfilename.length() - 4));
                if (!realfilename.substring(0, realfilename.length() - 4).endsWith("quit")) {
                    this.alertJS("\u6587\u4ef6\u540d\u5fc5\u987b\u4ee5quit\u7ed3\u5c3e");
                }
                int count = facade.deleteMonthQuitbill(billmonth, PayProxyFunctionConstant.SP_KONGZHONG, serivetype, orderamt);
                logger.debug("\u4e00\u5171\u5220\u9664\u4e86" + count + "\u6761\u8bb0\u5f55");
                for (int i = 0; i < list.size(); ++i) {
                    String note = (String)list.get(i);
                    if (note.equals("")) continue;
                    facade.importOneQuitBill(billmonth, note, serivetype, orderamt);
                }
                this.alertJS("\u5bfc\u5165Txt\u6210\u529f");
            } else {
                this.alertJS("\u6587\u6863\u683c\u5f0f\u5fc5\u987b\u4e3atxt");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.alertJS("\u5bfc\u5165Txt\u5931\u8d25");
        }
        return "";
    }

    public String doMonthend() {
        this.authenticateAdd();
        try {
            Mobilevipbill mobilevipbill = (Mobilevipbill)this.findBean(Mobilevipbill.class, "payproxy_mobilevipbill");
            String balancemonth = mobilevipbill.getFromyear() + "-" + mobilevipbill.getFrommonth();
            logger.debug("balancemonth=" + balancemonth);
            int count = facade.deleteMobilevipmonthend(balancemonth);
            logger.debug("\u4e00\u5171\u5220\u9664\u4e86" + count + "\u6761\u8bb0\u5f55");
            facade.insertMobilevipmonthend(balancemonth);
            this.alertJS("\u7ed3\u7b97\u6210\u529f");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.alertJS("\u7ed3\u7b97\u5931\u8d25");
        }
        return "";
    }

    public String doBatchExceptionData() {
        this.authenticateAdd();
        Calendar cal = Calendar.getInstance();
        String currentMonth = this.monthYm.format(cal.getTime());
        try {
            Mobilevipbill mobilevipbill = (Mobilevipbill)this.findBean(Mobilevipbill.class, "payproxy_mobilevipbill");
            String billmonth = mobilevipbill.getToyear() + "-" + mobilevipbill.getTomonth();
            String sp = mobilevipbill.getSp();
            logger.debug("sp=" + sp);
            String quitstartTime = DatetimeUtil.now();
            logger.debug("billmonth=" + billmonth);
            List list = IFacade.INSTANCE.getLibclassdByClassNo("SeriveType");
            for (Libclassd ld : list) {
                String serivetype = ld.getItemno();
                Mobilevipbill qdata = new Mobilevipbill();
                qdata.setBillmonth(billmonth);
                qdata.setDatastate("E");
                qdata.setDealtype("B");
                qdata.setExceptiondatatype("3");
                qdata.setSerivetype(serivetype);
                qdata.setSp(sp);
                Sheet sheet = facade.queryMobilevipbill(qdata, null);
                logger.debug("\u4e00\u5171\u6709" + sheet.getRowcount() + "\u6761\u8bb0\u5f55");
                Mobilevipbill cqdata = new Mobilevipbill();
                for (Mobilevipbill mb : sheet.getDatas()) {
                    cqdata.setBillmonth(currentMonth);
                    cqdata.setSerivetype(serivetype);
                    cqdata.setMobile(mb.getMobile());
                    cqdata.setSp(sp);
                    Mobilevipbill currentData = IFacade.INSTANCE.findMobilevipbill(cqdata);
                    if (null != currentData && "Y".equals(currentData.getChargestate())) {
                        logger.info(mb.getMobile() + "\tis ok in " + currentMonth);
                        continue;
                    }
                    logger.debug("mobile=" + mb.getMobile());
                    facade.callMobilevipquit(mb.getMobile(), serivetype, "B", sp);
                    mb.setDealtype("C");
                    mb.setEditby(this.currentUserLogo());
                    mb.setEdittime(this.now());
                    facade.updateMobilevipbill(mb);
                }
            }
            String quitEndTime = DatetimeUtil.now();
            Mobilevipmonthend mobilevipmonthendQry = new Mobilevipmonthend();
            mobilevipmonthendQry.setBalancemonth(billmonth);
            mobilevipmonthendQry.setSerivetype("A");
            List mobilevipmonthends = (List)facade.queryMobilevipmonthend(mobilevipmonthendQry, null).getDatas();
            logger.info("mobilevipmonthends size = " + mobilevipmonthends.size());
            logger.info("quitstartTime and quitEndTime : " + quitstartTime + " " + quitEndTime);
            if (mobilevipmonthends != null && mobilevipmonthends.size() > 0) {
                Mobilevipmonthend mobilevipmonthend = (Mobilevipmonthend)mobilevipmonthends.get(0);
                mobilevipmonthend.setRemark(quitstartTime + " " + quitEndTime);
                facade.updateMobilevipmonthend(mobilevipmonthend);
            }
            this.alertJS("\u6279\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.alertJS("\u6279\u5904\u7406\u5931\u8d25");
        }
        return "";
    }

    @Override
    public Map<String, String> getCarrierMap() {
        if (carrierMap == null) {
            List list = facade.getLibclassdByClassNo("Carrier");
            carrierMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                carrierMap.put(data.getItemno(), data.getItemname());
            }
        }
        return carrierMap;
    }

    @Override
    public SelectItem[] getCarrierItem() {
        if (carrierItem == null) {
            List list = facade.getLibclassdByClassNo("Carrier");
            if (list == null) {
                carrierItem = new SelectItem[0];
            } else {
                carrierItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MobilevipbillManagedBean.carrierItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return carrierItem;
    }

    public Map<String, String> getUsertypeMap() {
        if (usertypeMap == null) {
            List list = facade.getLibclassdByClassNo("UserType");
            usertypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                usertypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return usertypeMap;
    }

    public SelectItem[] getUsertypeItem() {
        if (usertypeItem == null) {
            List list = facade.getLibclassdByClassNo("UserType");
            if (list == null) {
                usertypeItem = new SelectItem[0];
            } else {
                usertypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MobilevipbillManagedBean.usertypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return usertypeItem;
    }

    public Map<String, String> getChargestateMap() {
        if (chargestateMap == null) {
            List list = facade.getLibclassdByClassNo("ChargeState");
            chargestateMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                chargestateMap.put(data.getItemno(), data.getItemname());
            }
        }
        return chargestateMap;
    }

    public SelectItem[] getChargestateItem() {
        if (chargestateItem == null) {
            List list = facade.getLibclassdByClassNo("ChargeState");
            if (list == null) {
                chargestateItem = new SelectItem[0];
            } else {
                chargestateItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MobilevipbillManagedBean.chargestateItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return chargestateItem;
    }

    public Map<String, String> getDatastateMap() {
        if (datastateMap == null) {
            List list = facade.getLibclassdByClassNo("DataState");
            datastateMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                datastateMap.put(data.getItemno(), data.getItemname());
            }
        }
        return datastateMap;
    }

    public SelectItem[] getDatastateItem() {
        if (datastateItem == null) {
            List list = facade.getLibclassdByClassNo("DataState");
            if (list == null) {
                datastateItem = new SelectItem[0];
            } else {
                datastateItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MobilevipbillManagedBean.datastateItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return datastateItem;
    }

    public Map<String, String> getDealtypeMap() {
        if (dealtypeMap == null) {
            List list = facade.getLibclassdByClassNo("DealType");
            dealtypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                dealtypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return dealtypeMap;
    }

    public SelectItem[] getDealtypeItem() {
        if (dealtypeItem == null) {
            List list = facade.getLibclassdByClassNo("DealType");
            if (list == null) {
                dealtypeItem = new SelectItem[0];
            } else {
                dealtypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MobilevipbillManagedBean.dealtypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return dealtypeItem;
    }

    public SelectItem[] getProvinceItem() {
        if (provinceItem == null) {
            List list = facade.getLibclassdByClassNo("MobileProvince");
            if (list == null) {
                provinceItem = new SelectItem[0];
            } else {
                provinceItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MobilevipbillManagedBean.provinceItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return provinceItem;
    }

    public Map<String, String> getProvinceMap() {
        if (provinceMap == null) {
            List list = facade.getLibclassdByClassNo("MobileProvince");
            provinceMap = new HashMap<String, String>();
            for (Libclassd data : list) {
                provinceMap.put(data.getItemno(), data.getItemname());
            }
        }
        return provinceMap;
    }

    public Map<String, String> getExceptiondatatypeMap() {
        if (exceptiondatatypeMap == null) {
            List list = facade.getLibclassdByClassNo("ExceptionDataType");
            exceptiondatatypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                exceptiondatatypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return exceptiondatatypeMap;
    }

    public SelectItem[] getExceptiondatatypeItem() {
        if (exceptiondatatypeItem == null) {
            List list = facade.getLibclassdByClassNo("ExceptionDataType");
            if (list == null) {
                exceptiondatatypeItem = new SelectItem[0];
            } else {
                exceptiondatatypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    MobilevipbillManagedBean.exceptiondatatypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return exceptiondatatypeItem;
    }

    public String doManual() throws Exception {
        this.authenticateEdit();
        long seqid = Long.valueOf(this.findParameter("sseqid"));
        Mobilevipbill qdata = new Mobilevipbill();
        qdata.setSeqid(seqid);
        Mobilevipbill mobilevipbill = facade.findMobilevipbill(qdata);
        if (mobilevipbill.getDealtype().equals("B")) {
            mobilevipbill.setDealtype("D");
            mobilevipbill.setEditby(this.currentUserLogo());
            mobilevipbill.setEdittime(this.now());
            facade.updateMobilevipbill(mobilevipbill);
        } else {
            this.alertJS("\u72b6\u6001\u4e0d\u7b26");
        }
        return "";
    }

    public String doIgnore() throws Exception {
        this.authenticateEdit();
        long seqid = Long.valueOf(this.findParameter("sseqid"));
        Mobilevipbill qdata = new Mobilevipbill();
        qdata.setSeqid(seqid);
        Mobilevipbill mobilevipbill = facade.findMobilevipbill(qdata);
        if (mobilevipbill.getDealtype().equals("B")) {
            mobilevipbill.setDealtype("E");
            mobilevipbill.setEditby(this.currentUserLogo());
            mobilevipbill.setEdittime(this.now());
            facade.updateMobilevipbill(mobilevipbill);
        } else {
            this.alertJS("\u72b6\u6001\u4e0d\u7b26");
        }
        return "";
    }

    private String getLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(date);
    }
}

