/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.vo.Mobilevipok;
import com.xunlei.payproxy.vo.Mobilevipquit;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="MobileCleandata")
public class MobileCleanDataManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(MobileCleanDataManagedBean.class);
    private static final IFacade facade = IFacade.INSTANCE;
    List<String> checkFileContent = new ArrayList<String>();
    List<String> result_ok = null;
    List<String> result_quit = null;
    List<String> result_nohave = null;
    private UploadedFile upFile;
    private UploadedFile uploadFile;

    public UploadedFile getUpFile() {
        return this.upFile;
    }

    public void setUpFile(UploadedFile upFile) {
        this.upFile = upFile;
    }

    public UploadedFile getUploadFile() {
        return this.uploadFile;
    }

    public void setUploadFile(UploadedFile uploadFile) {
        this.uploadFile = uploadFile;
    }

    public String createOkResult() {
        if (this.result_ok == null) {
            this.getQueryResult();
        }
        this.writeFile("kong_result_ok.txt", this.result_ok);
        return "";
    }

    public String createQuitResult() {
        if (this.result_quit == null) {
            this.getQueryResult();
        }
        this.writeFile("kong_result_quit.txt", this.result_quit);
        return "";
    }

    public String createNoHaveResult() {
        if (this.result_nohave == null) {
            this.getQueryResult();
        }
        this.writeFile("kong_result_nohave.txt", this.result_nohave);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String filename, List<String> result_list) {
        try {
            logger.info("writeFile-----filename: " + filename + ", result_list: " + result_list);
            String txtPath = this.getHttpServletRequest().getSession().getServletContext().getRealPath("") + File.separator + "WEB-INF" + File.separator + "download" + File.separator + filename;
            logger.info("\u5b58\u653e\u7684txtpath\u4e3a\uff1a" + txtPath);
            File txtFile = new File(txtPath);
            File folder = new File(txtPath.substring(0, txtPath.lastIndexOf(File.separator)));
            if (!folder.exists()) {
                txtFile.mkdirs();
            }
            if (txtFile.exists()) {
                txtFile.delete();
                txtFile.createNewFile();
            } else {
                txtFile.createNewFile();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(txtPath));
            for (String result : result_list) {
                bufferedWriter.write(result + "\n");
            }
            bufferedWriter.flush();
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            logger.info("\u5199\u5165\u6587\u4ef6\u5b8c\u6210");
        }
        catch (Exception e) {
            logger.error("\u7ed3\u679c\u5199\u5165\u6587\u4ef6\u5f02\u5e38\uff1a" + e);
            this.alertJS("\u5bfc\u51fa\u5f02\u5e38");
        }
    }

    public static String upImage(MobileCleanDataManagedBean mobileCleanDataManagedBean) {
        try {
            if (mobileCleanDataManagedBean.upFile == null) {
                logger.info("\u6ca1\u6709\u4e0a\u4f20\u6587\u4ef6");
                mobileCleanDataManagedBean.alertJS("\u8bf7\u9009\u62e9\u4e0a\u4f20\u7684\u6587\u4ef6");
                return "";
            }
            String fileName = mobileCleanDataManagedBean.upFile.getName();
            logger.info("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a\uff1a" + fileName);
            if (!fileName.toLowerCase().endsWith("txt")) {
                logger.info("\u6587\u4ef6\u683c\u5f0f\u5fc5\u987b\u662ftxt\u683c\u5f0f");
                mobileCleanDataManagedBean.alertJS("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u662ftxt\u683c\u5f0f");
                return "";
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(mobileCleanDataManagedBean.upFile.getInputStream()));
            String line = "";
            mobileCleanDataManagedBean.checkFileContent = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                mobileCleanDataManagedBean.checkFileContent.add(line);
            }
            bufferedReader.close();
            logger.info("\u4e0a\u4f20\u7684\u6587\u4ef6\u5171\u6709[" + mobileCleanDataManagedBean.checkFileContent.size() + "]\u884c");
            mobileCleanDataManagedBean.result_ok = null;
            mobileCleanDataManagedBean.result_nohave = null;
            mobileCleanDataManagedBean.result_quit = null;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a" + e);
            mobileCleanDataManagedBean.alertJS("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return "";
    }

    public String uploadOkFile() {
        try {
            if (this.uploadFile == null) {
                logger.info("\u6ca1\u6709\u4e0a\u4f20\u6587\u4ef6");
                this.alertJS("\u8bf7\u9009\u62e9\u4e0a\u4f20\u7684\u6587\u4ef6");
                return "";
            }
            String filePath = "/usr/local/zeus/htdocsnew/XLPayProxyMobileTask/data/mobilebill";
            String fileName = this.uploadFile.getName();
            logger.info("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a\uff1a" + fileName);
            if (!fileName.toLowerCase().endsWith("txt")) {
                logger.info("\u6587\u4ef6\u683c\u5f0f\u5fc5\u987b\u662ftxt\u683c\u5f0f");
                this.alertJS("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u662ftxt\u683c\u5f0f");
                return "";
            }
            File file = new File(filePath + File.separator + fileName);
            if (file.exists()) {
                file.delete();
            } else {
                file = new File(filePath + File.separator + fileName);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.uploadFile.getInputStream()));
            String line = "";
            this.checkFileContent = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                this.checkFileContent.add(line);
            }
            bufferedReader.close();
            MobileCleanDataManagedBean.writeToTxt(file, this.checkFileContent);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a" + e);
            this.alertJS("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToTxt(File txtFile, List<String> list) {
        RandomAccessFile randomFile = null;
        StringBuffer writer = new StringBuffer();
        try {
            randomFile = new RandomAccessFile(txtFile, "rw");
            if (!writer.toString().equals("")) {
                long fileLength = randomFile.length();
                MappedByteBuffer out = randomFile.getChannel().map(FileChannel.MapMode.READ_WRITE, fileLength, writer.toString().getBytes().length);
                out.put(writer.toString().getBytes());
                out.clear();
            }
            for (int i = 0; i < list.size(); ++i) {
                long fileLength = randomFile.length();
                String content = list.get(i) + "\r\n";
                MappedByteBuffer out = randomFile.getChannel().map(FileChannel.MapMode.READ_WRITE, fileLength, content.toString().getBytes().length);
                out.put(content.getBytes());
                out.clear();
            }
            randomFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (randomFile != null) {
                    randomFile.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized String getQueryResult() {
        if (this.checkFileContent.size() > 0) {
            String separator_def = this.findParameter("separatordef");
            if (StringTools.isEmpty((String)separator_def)) {
                separator_def = " ";
            }
            logger.info("\u5b9a\u4e49\u7684\u5206\u9694\u7b26\u4e3a\uff1a" + separator_def);
            String selected_opt = this.findParameter("optselectedids");
            logger.info("\u9700\u8981\u7684\u53c2\u6570\u4e3a\uff1a" + selected_opt);
            this.result_ok = new ArrayList<String>();
            this.result_nohave = new ArrayList<String>();
            this.result_quit = new ArrayList<String>();
            for (String mobile : this.checkFileContent) {
                String result = "";
                Mobilevipok mobilevipok = new Mobilevipok();
                mobilevipok.setMobile(mobile);
                PagedFliper fliper = new PagedFliper();
                fliper.setSortColumnIfEmpty("gettime desc");
                Sheet sheet = facade.queryMobilevipok(mobilevipok, fliper);
                List mobilevipokList = null;
                if (sheet.getRowcount() > 0) {
                    logger.info("[" + mobile + "]\u5b58\u5728\u4e8eok\u8868\u4e2d");
                    mobilevipokList = (List)sheet.getDatas();
                    mobilevipok = (Mobilevipok)mobilevipokList.get(0);
                    if (selected_opt.contains("mobile")) {
                        result = result + mobile + separator_def;
                    }
                    if (selected_opt.contains("xunleiid")) {
                        result = result + mobilevipok.getXunleiid() + separator_def;
                    }
                    if (selected_opt.contains("usershow")) {
                        result = result + mobilevipok.getUsershow() + separator_def;
                    }
                    if (selected_opt.contains("orderid")) {
                        result = result + mobilevipok.getOrderid() + separator_def;
                    }
                    if (selected_opt.contains("time")) {
                        result = result + mobilevipok.getGettime() + separator_def;
                    }
                    if (result.endsWith(separator_def)) {
                        result = result.substring(0, result.lastIndexOf(separator_def));
                    }
                    this.result_ok.add(result);
                    continue;
                }
                Mobilevipquit mobilevipquit = new Mobilevipquit();
                fliper = new PagedFliper();
                fliper.setSortColumn("quittime desc");
                Sheet sheetQuit = facade.queryMobilevipQuitByMobile(mobile, fliper);
                List mobilevipquitList = null;
                logger.info("sheetQuit\u7684\u5927\u5c0f\u4e3a\uff1a" + sheetQuit.getRowcount());
                if (sheetQuit.getRowcount() > 0) {
                    logger.info("[" + mobile + "]\u5b58\u5728\u4e8equit\u8868\u4e2d");
                    mobilevipquitList = (List)sheetQuit.getDatas();
                    mobilevipquit = (Mobilevipquit)mobilevipquitList.get(0);
                    if (selected_opt.contains("mobile")) {
                        result = result + mobile + separator_def;
                    }
                    if (selected_opt.contains("xunleiid")) {
                        result = result + mobilevipquit.getXunleiid() + separator_def;
                    }
                    if (selected_opt.contains("usershow")) {
                        result = result + mobilevipquit.getUsershow() + separator_def;
                    }
                    if (selected_opt.contains("orderid")) {
                        result = result + mobilevipquit.getOrderid() + separator_def;
                    }
                    if (selected_opt.contains("time")) {
                        result = result + mobilevipquit.getGettime() + separator_def;
                    }
                    if (result.endsWith(separator_def)) {
                        result = result.substring(0, result.lastIndexOf(separator_def));
                    }
                    this.result_quit.add(result);
                    continue;
                }
                logger.info("[" + mobile + "]\u67e5\u8be2\u4e0d\u5230");
                result = mobile;
                this.result_nohave.add(result);
            }
        }
        return "";
    }
}

