/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.alipay.util.SignProtocolUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="GenSignProtocol")
public class GenSignProtocolManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(GenSignProtocolManagedBean.class);
    protected static final IFacade facade = IFacade.INSTANCE;
    private String pay_signurl = "";
    private String incomexl_signurl = "";
    private String bizNo = "";
    private static Map<String, String> biznoMap;
    private static SelectItem[] biznoItem;

    public String getQuery() {
        this.authenticateRun();
        this.setPay_signurl("");
        this.setIncomexl_signurl("");
        this.bizNo = "";
        try {
            this.bizNo = this.findParameter("bizNo");
            logger.debug("\u9a8c\u8bc1\u4e1a\u52a1\u5408\u6cd5\u6027");
            Copbizinfo copbizinfoForQuery = new Copbizinfo();
            copbizinfoForQuery.setBizno(this.bizNo);
            Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
            String bizKey = copbizinfo.getBizkey();
            String[] partner_email = new String[]{"pay@xunlei.com", "incomexl@xunlei.com"};
            HashMap<String, String> pay_paramsMap = new HashMap<String, String>();
            pay_paramsMap.put("bizNo", this.bizNo);
            pay_paramsMap.put("partner", partner_email[0]);
            HashMap<String, String> incomexl_paramsMap = new HashMap<String, String>();
            incomexl_paramsMap.put("bizNo", this.bizNo);
            incomexl_paramsMap.put("partner", partner_email[1]);
            String pay_reqUrl = SignProtocolUtil.getSignProtocolUrl(pay_paramsMap, (String)bizKey);
            logger.info("pay_reqUrl=" + pay_reqUrl);
            this.pay_signurl = this.parseUrl(pay_reqUrl);
            String incomexl_reqUrl = SignProtocolUtil.getSignProtocolUrl(incomexl_paramsMap, (String)bizKey);
            logger.info("incomexl_AlipayReqUrl=" + incomexl_reqUrl);
            this.incomexl_signurl = this.parseUrl(incomexl_reqUrl);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return "";
    }

    private String parseUrl(String url) {
        String ret = "";
        try {
            URL reqUrl = new URL(url);
            URLConnection pay_connection = reqUrl.openConnection();
            pay_connection.connect();
            InputStream in = pay_connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            StringBuffer buffer = new StringBuffer();
            while (line != null) {
                buffer.append(line);
                line = reader.readLine();
            }
            System.out.println(buffer.toString());
            ret = buffer.toString();
            int start = ret.indexOf("https://");
            int end = ret.indexOf("></form>");
            ret = ret.substring(start, end - 1);
            System.out.println(ret);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return ret;
    }

    public SelectItem[] getBiznoItem() {
        if (biznoItem == null) {
            List list = (List)IFacade.INSTANCE.queryCopbizinfo(new Copbizinfo(), null).getDatas();
            if (list != null) {
                biznoItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    GenSignProtocolManagedBean.biznoItem[i] = new SelectItem((Object)((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
                }
            }
            return biznoItem;
        }
        return biznoItem;
    }

    public Map getBiznoMap() {
        if (biznoMap == null) {
            biznoMap = new HashMap<String, String>();
            List list = (List)IFacade.INSTANCE.queryCopbizinfo(new Copbizinfo(), null).getDatas();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    biznoMap.put(((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
                }
            }
        }
        return biznoMap;
    }

    public void setPay_signurl(String pay_signurl) {
        this.pay_signurl = pay_signurl;
    }

    public String getPay_signurl() {
        return this.pay_signurl;
    }

    public void setIncomexl_signurl(String incomexl_signurl) {
        this.incomexl_signurl = incomexl_signurl;
    }

    public String getIncomexl_signurl() {
        return this.incomexl_signurl;
    }

    public String getBizNo() {
        return this.bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }
}

