/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.thirdparty.utils.UnitArith;
import com.xunlei.common.util.Arith;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.vo.Extxiaomipay;
import com.xunlei.payproxy.vo.Extxiaomipayok;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.xiaomipay.query.query.XiaomipayQuery;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtxiaomipay")
public class ExtxiaomipayManagerBean
extends BaseManagedBean {
    private static final Logger LOG = LoggerFactory.getLogger(ExtxiaomipayManagerBean.class);
    private static Map<String, String> orderStatusMap;
    private static SelectItem[] orderStatusItem;
    private static Map<String, String> typeMap;
    private static SelectItem[] typeItem;

    public String getQuery() {
        this.authenticateRun();
        Extxiaomipay data = (Extxiaomipay)this.findBean(Extxiaomipay.class, "payproxy_Extxiaomipay");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getFromdate())) {
                data.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)data.getTodate())) {
                data.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid desc");
            Sheet sheet = facade.queryExtxiaomipay(data, fliper);
            if (sheet.getRowcount() > 0) {
                Extxiaomipay sum = facade.queryExtxiaomipaySum(data);
                sheet.getDatas().add(sum);
            }
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String moveExtxiaomipayToSuccess() {
        this.authenticateEdit();
        String moveids = this.findParameter("noticeBtn");
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            LOG.info("ExtxiaomipayManagerBean,moveids:" + moveids);
            for (String seqid : seqids = moveids.split("\\|")) {
                Extxiaomipay queryData = new Extxiaomipay();
                queryData.setSeqid(Long.valueOf(seqid).longValue());
                queryData = facade.findExtxiaomipay(queryData);
                if (queryData != null) {
                    String orderId = queryData.getOrderid();
                    String type = queryData.getType();
                    String xiaomiId = queryData.getXiaomiid();
                    Map payResMap = new HashMap();
                    if (!"0".equals(type)) {
                        this.alertJS("\u6682\u4e0d\u652f\u6301\u7684\u652f\u4ed8\u7c7b\u578b!");
                        return "";
                    }
                    payResMap = XiaomipayQuery.orderQuery((String)xiaomiId, (String)orderId);
                    if (null == payResMap || payResMap.size() < 2) {
                        this.alertJS("\u8ba2\u5355:" + orderId + "\u67e5\u8be2\u5931\u8d25!");
                        return "";
                    }
                    boolean payRes = (Boolean)payResMap.get("payRes");
                    if (payRes) {
                        double orderAmtRemote;
                        String payAmt = (String)payResMap.get("payAmt");
                        double orderAmtLocal = queryData.getOrderamt();
                        double sub = Arith.sub((double)orderAmtLocal, (double)(orderAmtRemote = Double.parseDouble(UnitArith.fenToyuan((String)payAmt))));
                        if (Math.abs(sub) > 0.01) {
                            LOG.error("orderId:{},orderAmtLocal:{},orderAmtRemote:{},does not equal!", new Object[]{orderId, orderAmtLocal, orderAmtRemote});
                            this.alertJS("\u91d1\u989d\u4e0d\u4e00\u81f4!\u4e0d\u5141\u8bb8\u4eba\u5de5\u5b9a\u5236");
                            return "";
                        }
                        queryData.setRemark(this.noticeok_remark(queryData.getRemark()));
                        queryData.setExt2("custom");
                        facade.updateExtxiaomipay(queryData);
                        Extxiaomipayok dataok = new Extxiaomipayok();
                        dataok.setOrderid(queryData.getOrderid());
                        dataok.setSuccesstime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                        dataok.setExt1(queryData.getExt1());
                        dataok.setXiaomiid(queryData.getXiaomiid());
                        facade.moveExtxiaomipayToSuccess(dataok);
                        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)orderId);
                        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
                        continue;
                    }
                    LOG.info("orderId:" + orderId + ",pay fail!");
                    String payInfo = (String)payResMap.get("payMsg");
                    this.alertJS("\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f\u65f6\u4e0d\u5141\u8bb8\u5b9a\u5236,\u539f\u4ea4\u6613\u8fd4\u56de:" + payInfo);
                    return "";
                }
                LOG.info("ExtxiaomipayManagerBean,according to seqid = " + seqid + " can not find request record!");
                this.alertJS("\u627e\u4e0d\u5230\u8ba2\u5355");
            }
        } else {
            LOG.info("ExtxiaomipayManagerBean moveids is null");
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
        }
        return "";
    }

    public String checkOrderStatus() {
        this.authenticateRun();
        String orderId = this.findParameter("xiaomipay_orderid");
        LOG.info("ExtxiaomipayManagerBean checkOrderStatus orderid is :" + orderId);
        Extxiaomipay queryData = new Extxiaomipay();
        queryData.setOrderid(orderId);
        queryData = facade.findExtxiaomipay(queryData);
        if (null == queryData) {
            this.alertJS("\u6839\u636e\u8ba2\u5355\u53f7:" + orderId + "\u627e\u4e0d\u5230\u539f\u4ea4\u6613!");
            return "";
        }
        Map payResMap = new HashMap();
        String type = queryData.getType();
        String xiaomiId = queryData.getXiaomiid();
        if (!type.equals("0")) {
            this.alertJS("\u6682\u4e0d\u652f\u6301\u7684\u652f\u4ed8\u7c7b\u578b!");
            return "";
        }
        payResMap = XiaomipayQuery.orderQuery((String)xiaomiId, (String)orderId);
        if (null == payResMap || payResMap.size() < 2) {
            this.alertJS("\u8ba2\u5355:" + orderId + "\u67e5\u8be2\u5931\u8d25!");
            return "";
        }
        boolean payRes = (Boolean)payResMap.get("payRes");
        if (payRes) {
            this.alertJS("\u652f\u4ed8\u6210\u529f!");
        } else {
            String message = (String)payResMap.get("payMsg");
            this.alertJS("\u652f\u4ed8\u5931\u8d25,\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f:" + message);
        }
        return "";
    }

    public Map<String, String> getOrderStatusMap() {
        if (orderStatusMap == null) {
            orderStatusMap = new HashMap<String, String>();
            orderStatusMap.put("W", "\u7b49\u5f85");
            orderStatusMap.put("N", "\u5931\u8d25");
            orderStatusMap.put("U", "\u53ef\u7591");
            orderStatusMap.put("Y", "\u6210\u529f");
        }
        return orderStatusMap;
    }

    public SelectItem[] getOrderStatusItem() {
        if (orderStatusItem == null) {
            orderStatusItem = new SelectItem[4];
            ExtxiaomipayManagerBean.orderStatusItem[0] = new SelectItem((Object)"Y", "\u6210\u529f");
            ExtxiaomipayManagerBean.orderStatusItem[1] = new SelectItem((Object)"U", "\u53ef\u7591");
            ExtxiaomipayManagerBean.orderStatusItem[2] = new SelectItem((Object)"N", "\u5931\u8d25");
            ExtxiaomipayManagerBean.orderStatusItem[3] = new SelectItem((Object)"W", "\u7b49\u5f85");
        }
        return orderStatusItem;
    }

    public Map<String, String> getTypeMap() {
        if (typeMap == null) {
            typeMap = new HashMap<String, String>();
            typeMap.put("0", "\u7c73\u5e01\u652f\u4ed8");
        }
        return typeMap;
    }

    public SelectItem[] getTypeItem() {
        if (typeItem == null) {
            typeItem = new SelectItem[1];
            ExtxiaomipayManagerBean.typeItem[0] = new SelectItem((Object)"0", "\u7c73\u5e01\u652f\u4ed8");
        }
        return typeItem;
    }
}

