/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extwechatpay;
import com.xunlei.payproxy.vo.Extwechatpayok;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.wechatpay.client.WeChatAppPayClient;
import com.xunlei.wechatpay.client.WeChatPubPayClient;
import com.xunlei.wechatpay.client.WeChatWebPayClient;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtwechatpay")
public class ExtwechatpayManagerBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtwechatpayManagerBean.class);
    private static Map<String, String> orderStatusMap;
    private static SelectItem[] orderStatusItem;
    private static Map<String, String> typeMap;
    private static SelectItem[] typeItem;

    public String getQuery() {
        this.authenticateRun();
        Extwechatpay extwechatpay = (Extwechatpay)this.findBean(Extwechatpay.class, "payproxy_Extwechatpay");
        if (extwechatpay != null) {
            if (StringTools.isEmpty((String)extwechatpay.getFromdate())) {
                extwechatpay.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)extwechatpay.getTodate())) {
                extwechatpay.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid desc");
            Sheet sheet = facade.queryExtwechatpay(extwechatpay, fliper);
            if (sheet.getRowcount() > 0) {
                Extwechatpay sum = facade.queryExtwechatpaySum(extwechatpay);
                sheet.getDatas().add(sum);
            }
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String moveExtwechatpayToSuccess() {
        this.authenticateEdit();
        String moveids = this.findParameter("noticeBtn");
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            logger.info("ExtwechatpayManagerBean,moveids:{}", (Object)moveids);
            for (String seqid : seqids = moveids.split("\\|")) {
                Extwechatpay extwechatpayQuery = new Extwechatpay();
                extwechatpayQuery.setSeqid(Long.valueOf(seqid).longValue());
                extwechatpayQuery = facade.findExtwechatpay(extwechatpayQuery);
                if (extwechatpayQuery != null) {
                    String appId;
                    Map payResMap = new HashMap();
                    String orderId = extwechatpayQuery.getOrderId();
                    String type = extwechatpayQuery.getType();
                    if (type.equals("2")) {
                        appId = extwechatpayQuery.getExt2();
                        payResMap = "V3.0".equals(extwechatpayQuery.getRemark()) ? WeChatWebPayClient.executeOrderQuery1((String)orderId, (String)appId) : WeChatWebPayClient.executeOrderQuery((String)orderId);
                    } else if (type.equals("3")) {
                        appId = extwechatpayQuery.getExt2();
                        if ("V3.0".equals(extwechatpayQuery.getRemark())) {
                            logger.info("\u5fae\u4fe1\u516c\u4f17\u8d26\u53f7V3.0\uff0c\u72b6\u6001\u67e5\u8be2\uff01");
                            payResMap = WeChatWebPayClient.executeOrderQuery1((String)orderId, (String)appId);
                        } else {
                            logger.info("\u5fae\u4fe1\u516c\u4f17\u8d26\u53f7V1.0\uff0c\u72b6\u6001\u67e5\u8be2\uff01");
                            payResMap = WeChatPubPayClient.executeOrderQuery2((String)orderId, (String)appId);
                        }
                    } else if (type.equals("1")) {
                        appId = extwechatpayQuery.getExt2();
                        if ("V3.0".equals(extwechatpayQuery.getRemark())) {
                            logger.info("\u5fae\u4fe1APP V3.0\uff0c\u72b6\u6001\u67e5\u8be2\uff01");
                            payResMap = WeChatWebPayClient.executeOrderQuery1((String)orderId, (String)appId);
                        } else {
                            logger.info("\u5fae\u4fe1APP V1.0\uff0c\u72b6\u6001\u67e5\u8be2\uff01");
                            payResMap = WeChatPubPayClient.executeOrderQuery2((String)orderId, (String)appId);
                        }
                    } else if (type.equals("4")) {
                        appId = extwechatpayQuery.getExt2();
                        payResMap = WeChatWebPayClient.executeOrderQuery1((String)orderId, (String)appId);
                    } else {
                        this.alertJS("\u6682\u4e0d\u652f\u6301\u7684\u652f\u4ed8\u7c7b\u578b!");
                        return "";
                    }
                    if (null == payResMap || payResMap.size() < 2) {
                        this.alertJS("\u8ba2\u5355:" + orderId + "\u67e5\u8be2\u5931\u8d25!");
                        return "";
                    }
                    boolean payRes = (Boolean)payResMap.get("result");
                    String message = (String)payResMap.get("message");
                    if (payRes) {
                        logger.info("orderId:" + orderId + ",pay success!");
                        extwechatpayQuery.setRemark(this.noticeok_remark(extwechatpayQuery.getRemark()));
                        String remark = extwechatpayQuery.getRemark();
                        remark = remark + "|custom";
                        extwechatpayQuery.setRemark(remark);
                        logger.debug(Utility.toStringCommon((Object)extwechatpayQuery));
                        facade.updateExtwechatpay(extwechatpayQuery);
                        logger.debug("seqid = " + seqid + ", orderid=" + extwechatpayQuery.getOrderId() + ", usershow=" + extwechatpayQuery.getUserShow());
                        Extwechatpayok extwechatpayok = new Extwechatpayok();
                        extwechatpayok.setOrderId(extwechatpayQuery.getOrderId());
                        extwechatpayok.setSuccessTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                        String transactionId = (String)payResMap.get("transaction_id");
                        String timeEnd = (String)payResMap.get("time_end");
                        extwechatpayok.setTransactionId(transactionId);
                        extwechatpayok.setTimeEnd(timeEnd);
                        facade.moveExtwechatpayToSuccess(extwechatpayok);
                        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)orderId);
                        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
                        continue;
                    }
                    logger.info("orderId:" + orderId + ",pay fail!");
                    this.alertJS("\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f\u65f6\u4e0d\u5141\u8bb8\u5b9a\u5236,\u539f\u4ea4\u6613\u8fd4\u56de:" + message);
                    return "";
                }
                logger.info("ExtwechatpayManagerBean,according to seqid = " + seqid + " can not find request record!");
            }
        } else {
            logger.info("ExtwechatpayManagerBean moveids is null");
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
        }
        return "";
    }

    public String checkOrderStatus() {
        String appId;
        this.authenticateRun();
        String orderId = this.findParameter("wechatpay_orderid");
        logger.info("ExtwechatpayManagerBean checkOrderStatus orderid is :" + orderId);
        Extwechatpay extwechatpayQuery = new Extwechatpay();
        extwechatpayQuery.setOrderId(orderId);
        extwechatpayQuery = facade.findExtwechatpay(extwechatpayQuery);
        if (null == extwechatpayQuery) {
            this.alertJS("\u6839\u636e\u8ba2\u5355\u53f7:" + orderId + "\u627e\u4e0d\u5230\u539f\u4ea4\u6613!");
        }
        Map payResMap = new HashMap();
        String type = extwechatpayQuery.getType();
        logger.info("type=" + type);
        if (type.equals("2")) {
            appId = extwechatpayQuery.getExt2();
            payResMap = "V3.0".equals(extwechatpayQuery.getRemark()) ? WeChatWebPayClient.executeOrderQuery1((String)orderId, (String)appId) : WeChatWebPayClient.executeOrderQuery((String)orderId);
        } else if (type.equals("3") || type.equals("4")) {
            appId = extwechatpayQuery.getExt2();
            if ("V3.0".equals(extwechatpayQuery.getRemark())) {
                logger.info("\u5fae\u4fe1\u516c\u4f17\u8d26\u53f7V3.0\uff0c\u72b6\u6001\u67e5\u8be2\uff01");
                payResMap = WeChatWebPayClient.executeOrderQuery1((String)orderId, (String)appId);
            } else {
                logger.info("\u5fae\u4fe1\u516c\u4f17\u8d26\u53f7V1.0\uff0c\u72b6\u6001\u67e5\u8be2\uff01");
                payResMap = WeChatPubPayClient.executeOrderQuery2((String)orderId, (String)appId);
            }
        } else if (type.equals("1")) {
            appId = extwechatpayQuery.getExt2();
            WeChatAppPayClient client = new WeChatAppPayClient(appId);
            if ("V3.0".equals(extwechatpayQuery.getRemark())) {
                logger.info("\u5fae\u4fe1appV3.0\uff0c\u72b6\u6001\u67e5\u8be2\uff01");
                payResMap = client.executeNewAppOrderQuery(null, orderId, appId);
            } else {
                logger.info("\u5fae\u4fe1appV1.0\uff0c\u72b6\u6001\u67e5\u8be2\uff01");
                payResMap = client.executeOrderQuery2(orderId);
            }
        } else {
            this.alertJS("\u6682\u4e0d\u652f\u6301\u7684\u652f\u4ed8\u7c7b\u578b!");
            return "";
        }
        if (null == payResMap || payResMap.size() < 2) {
            this.alertJS("\u8ba2\u5355:" + orderId + "\u67e5\u8be2\u5931\u8d25!");
            return "";
        }
        boolean payRes = (Boolean)payResMap.get("result");
        String message = (String)payResMap.get("message");
        if (payRes) {
            this.alertJS("\u652f\u4ed8\u6210\u529f!");
        } else {
            this.alertJS(message);
        }
        return "";
    }

    public Map<String, String> getOrderStatusMap() {
        if (orderStatusMap == null) {
            orderStatusMap = new HashMap<String, String>();
            orderStatusMap.put("W", "\u7b49\u5f85");
            orderStatusMap.put("N", "\u5931\u8d25");
            orderStatusMap.put("U", "\u53ef\u7591");
            orderStatusMap.put("Y", "\u6210\u529f");
        }
        return orderStatusMap;
    }

    public SelectItem[] getOrderStatusItem() {
        if (orderStatusItem == null) {
            orderStatusItem = new SelectItem[4];
            ExtwechatpayManagerBean.orderStatusItem[0] = new SelectItem((Object)"Y", "\u6210\u529f");
            ExtwechatpayManagerBean.orderStatusItem[1] = new SelectItem((Object)"U", "\u53ef\u7591");
            ExtwechatpayManagerBean.orderStatusItem[2] = new SelectItem((Object)"N", "\u5931\u8d25");
            ExtwechatpayManagerBean.orderStatusItem[3] = new SelectItem((Object)"W", "\u7b49\u5f85");
        }
        return orderStatusItem;
    }

    public Map<String, String> getTypeMap() {
        if (typeMap == null) {
            typeMap = new HashMap<String, String>();
            typeMap.put("1", "APP\u652f\u4ed8");
            typeMap.put("2", "\u626b\u7801\u652f\u4ed8");
            typeMap.put("3", "\u516c\u4f17\u5e10\u53f7");
            typeMap.put("4", "WAP\u652f\u4ed8");
        }
        return typeMap;
    }

    public SelectItem[] getTypeItem() {
        if (typeItem == null) {
            typeItem = new SelectItem[4];
            ExtwechatpayManagerBean.typeItem[0] = new SelectItem((Object)"1", "APP\u652f\u4ed8");
            ExtwechatpayManagerBean.typeItem[1] = new SelectItem((Object)"2", "\u626b\u7801\u652f\u4ed8");
            ExtwechatpayManagerBean.typeItem[2] = new SelectItem((Object)"3", "\u516c\u4f17\u5e10\u53f7");
            ExtwechatpayManagerBean.typeItem[3] = new SelectItem((Object)"4", "WAP\u652f\u4ed8");
        }
        return typeItem;
    }
}

