/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.util.ProxyHelper;
import com.xunlei.payproxy.vo.Copartners;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.ExtWechatMonthSignOk;
import com.xunlei.payproxy.vo.ExtWechatMonthSignReq;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyWechatMonthsignreq")
public class ExtwechatmonthsignreqManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtwechatmonthsignreqManagedBean.class);
    private String WECHAT_MONTH_QUERY_SIGN_URL = "http://proxy.pay.xunlei.com/wechatMonthQuerySignServlet?";

    public String getQuery() {
        this.authenticateRun();
        ExtWechatMonthSignReq data = (ExtWechatMonthSignReq)this.findBean(ExtWechatMonthSignReq.class, "payproxy_extwechatmonthsignreq");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getBeginDate())) {
                data.setBeginDate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getEndDate())) {
                data.setEndDate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtWechatMonthSignReq(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String moveExtWechatMonthSignReqToSignOk() {
        String[] seqId;
        this.authenticateEdit();
        String seqIds = this.findParameter("noticeBtn");
        if (this.isEmpty(seqIds)) {
            logger.error("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01seqIds: {}", (Object)seqIds);
            this.alertJS("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        logger.debug("\u67e5\u8be2\u53c2\u6570seqIds: {}", (Object)seqIds);
        for (String id : seqId = seqIds.split("\\|")) {
            ExtWechatMonthSignReq bindInfo = new ExtWechatMonthSignReq();
            bindInfo.setSeqId(Long.valueOf(id).longValue());
            ExtWechatMonthSignReq bindInfoRes = facade.findExtWechatMonthSignReq(bindInfo);
            if (null != bindInfoRes) {
                String xlnumId = bindInfoRes.getXunleiId();
                String bizNo = bindInfoRes.getBizNo();
                String source = "CHANNEL";
                logger.debug("\u9a8c\u8bc1\u5546\u6237\u5408\u6cd5\u6027");
                String copartnerNo = ProxyHelper.getCopartnerNoFromBizNo((String)bizNo);
                Copartners copartnersForQuery = new Copartners();
                copartnersForQuery.setCopartnerno(copartnerNo);
                Copartners copartners = facade.findCopartners(copartnersForQuery);
                if (copartners == null) {
                    logger.error("\u5546\u6237\u4e0d\u5b58\u5728\uff01");
                    this.alertJS("\u5546\u6237\u4e0d\u5b58\u5728\uff01");
                    return null;
                }
                if (copartners.getInuse() == 0) {
                    logger.error("\u5546\u6237\u4e0d\u53ef\u7528\uff01");
                    this.alertJS("\u5546\u6237\u4e0d\u53ef\u7528\uff01");
                    return null;
                }
                logger.debug("\u9a8c\u8bc1\u4e1a\u52a1\u5408\u6cd5\u6027");
                Copbizinfo copbizinfoForQuery = new Copbizinfo();
                copbizinfoForQuery.setBizno(bizNo);
                Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
                if (copbizinfo == null) {
                    logger.error("\u4e1a\u52a1\u4e0d\u5b58\u5728\uff01");
                    this.alertJS("\u4e1a\u52a1\u4e0d\u5b58\u5728\uff01");
                    return null;
                }
                if (copbizinfo.getBizstatus().equals("C")) {
                    logger.error("\u4e1a\u52a1\u4e0d\u53ef\u7528\uff01");
                    this.alertJS("\u4e1a\u52a1\u4e0d\u53ef\u7528\uff01");
                    return null;
                }
                HashMap<String, String> paraMap = new HashMap<String, String>();
                paraMap.put("xlnumId", xlnumId);
                paraMap.put("bizNo", bizNo);
                paraMap.put("source", source);
                String genSign = this.generateSign(paraMap, copbizinfo.getBizkey());
                StringBuffer urlBuffer = new StringBuffer(this.WECHAT_MONTH_QUERY_SIGN_URL);
                urlBuffer.append("xlnumId=").append(xlnumId).append("&bizNo=").append(bizNo).append("&source=").append(source).append("&signMsg=").append(genSign);
                logger.info("--------------------------------the query url: {}", (Object)this.WECHAT_MONTH_QUERY_SIGN_URL.toString());
                DefaultHttpClient httpclient = new DefaultHttpClient();
                httpclient.getParams().setParameter("http.connection.timeout", (Object)6000);
                httpclient.getParams().setParameter("http.socket.timeout", (Object)6000);
                HttpGet httpGet = new HttpGet(urlBuffer.toString());
                HttpResponse res = null;
                try {
                    res = httpclient.execute((HttpUriRequest)httpGet);
                }
                catch (Exception e) {
                    logger.error("\u67e5\u8be2\u5931\u8d25,url: {}, msg: {}", (Object)this.WECHAT_MONTH_QUERY_SIGN_URL.toString(), (Object)e.getMessage());
                    this.alertJS("\u67e5\u8be2\u5931\u8d25,url: " + this.WECHAT_MONTH_QUERY_SIGN_URL.toString() + ", msg: " + e.getMessage());
                    return null;
                }
                if (res == null) {
                    logger.error("\u67e5\u8be2\u5931\u8d25,url: {}", (Object)this.WECHAT_MONTH_QUERY_SIGN_URL.toString());
                    this.alertJS("\u67e5\u8be2\u5931\u8d25,url: " + this.WECHAT_MONTH_QUERY_SIGN_URL.toString());
                    return null;
                }
                if (res.getStatusLine().getStatusCode() != 200) {
                    logger.error("\u67e5\u8be2\u5931\u8d25, status code\uff1a{}", (Object)res.getStatusLine().getStatusCode());
                    this.alertJS("\u67e5\u8be2\u5931\u8d25, status code\uff1a" + res.getStatusLine().getStatusCode());
                    return null;
                }
                String result = "";
                Document doc = null;
                String resultCode = "";
                String resultStatus = "";
                try {
                    result = EntityUtils.toString((HttpEntity)res.getEntity());
                    doc = DocumentHelper.parseText((String)result);
                    Element root = doc.getRootElement();
                    resultCode = root.elementText("payresult");
                    resultStatus = root.elementText("status");
                }
                catch (Exception e) {
                    logger.error("\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! xml: {}", (Object)result);
                    this.alertJS("\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! xml: " + result);
                    return null;
                }
                if ("00".equals(resultCode)) {
                    HashMap<String, String> statusMap = new HashMap<String, String>();
                    String[] statusArray = resultStatus.split("\\|");
                    if (statusArray.length > 0) {
                        for (String s : statusArray) {
                            String[] temp = s.split("=");
                            statusMap.put(temp[0], temp[1]);
                        }
                    }
                    String openid = (String)statusMap.get("openid");
                    String contract_id = (String)statusMap.get("contract_id");
                    String request_serial = (String)statusMap.get("request_serial");
                    String contract_code = (String)statusMap.get("contract_code");
                    String contract_signed_time = (String)statusMap.get("contract_signed_time");
                    String contract_expired_time = (String)statusMap.get("contract_expired_time");
                    ExtWechatMonthSignOk queryCondition = new ExtWechatMonthSignOk();
                    queryCondition.setExternalSignNo(contract_code);
                    ExtWechatMonthSignOk queryResult = facade.findExtWechatMonthSignOk(queryCondition);
                    if (queryResult != null && StringUtils.isNotEmpty((String)queryResult.getExternalSignNo())) {
                        logger.error("move req record to ok table failed, cause already moved!");
                        return null;
                    }
                    ExtWechatMonthSignReq req = new ExtWechatMonthSignReq();
                    req.setExternalSignNo(contract_code);
                    ExtWechatMonthSignReq reqResult = facade.findExtWechatMonthSignReq(req);
                    if (reqResult == null) {
                        logger.error("signreq record doesn't exist!");
                        return null;
                    }
                    ExtWechatMonthSignOk extWechatMonthSignOk = new ExtWechatMonthSignOk();
                    extWechatMonthSignOk.setOpenId(openid);
                    extWechatMonthSignOk.setContractExpiredTime(contract_expired_time);
                    extWechatMonthSignOk.setExternalSignNo(contract_code);
                    extWechatMonthSignOk.setBindId(contract_id);
                    extWechatMonthSignOk.setOperateTime(contract_signed_time);
                    extWechatMonthSignOk.setRequestSerial(request_serial);
                    extWechatMonthSignOk.setSignTime(reqResult.getRequestTime());
                    extWechatMonthSignOk.setUserShow(reqResult.getUserShow());
                    extWechatMonthSignOk.setXunleiId(reqResult.getXunleiId());
                    extWechatMonthSignOk.setStatus("\u7b7e\u7ea6");
                    facade.insertExtWechatMonthSignOk(extWechatMonthSignOk);
                    logger.info("moveExtWechatMonthSignReqToSignOk successfully.");
                    this.alertJS("\u64cd\u4f5c\u6210\u529f\uff01");
                    return "";
                }
                logger.error("\u64cd\u4f5c\u5931\u8d25");
                this.alertJS("\u64cd\u4f5c\u5931\u8d25");
                return "";
            }
            logger.error("\u67e5\u8be2\u5931\u8d25, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684seqId: {} \u7b7e\u7ea6\u8bb0\u5f55", (Object)id);
        }
        return "";
    }

    public void checkOrderStatus() {
        String externalSignNo = this.findParameter("query_externalSignNo");
        logger.debug("check sign NO. is : {}", (Object)externalSignNo);
        if (StringUtils.isEmpty((String)externalSignNo)) {
            this.alertJS("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            return;
        }
        ExtWechatMonthSignReq bindInfo = new ExtWechatMonthSignReq();
        bindInfo.setExternalSignNo(externalSignNo);
        ExtWechatMonthSignReq bindInfoResult = facade.findExtWechatMonthSignReq(bindInfo);
        if (null == bindInfoResult) {
            logger.error("\u6ca1\u6709\u7b7e\u7ea6\uff01 \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u7ea6ID: {} \u8bb0\u5f55", (Object)externalSignNo);
            this.alertJS("\u6ca1\u6709\u7b7e\u7ea6\uff01");
            return;
        }
        String xlnumId = bindInfoResult.getXunleiId();
        String bizNo = bindInfoResult.getBizNo();
        String source = "CHANNEL";
        logger.debug("\u9a8c\u8bc1\u5546\u6237\u5408\u6cd5\u6027");
        String copartnerNo = ProxyHelper.getCopartnerNoFromBizNo((String)bizNo);
        Copartners copartnersForQuery = new Copartners();
        copartnersForQuery.setCopartnerno(copartnerNo);
        Copartners copartners = facade.findCopartners(copartnersForQuery);
        if (copartners == null) {
            logger.error("\u5546\u6237\u4e0d\u5b58\u5728\uff01");
            this.alertJS("\u5546\u6237\u4e0d\u5b58\u5728\uff01");
            return;
        }
        if (copartners.getInuse() == 0) {
            logger.error("\u5546\u6237\u4e0d\u53ef\u7528\uff01");
            this.alertJS("\u5546\u6237\u4e0d\u53ef\u7528\uff01");
            return;
        }
        logger.debug("\u9a8c\u8bc1\u4e1a\u52a1\u5408\u6cd5\u6027");
        Copbizinfo copbizinfoForQuery = new Copbizinfo();
        copbizinfoForQuery.setBizno(bizNo);
        Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
        if (copbizinfo == null) {
            logger.error("\u4e1a\u52a1\u4e0d\u5b58\u5728\uff01");
            this.alertJS("\u4e1a\u52a1\u4e0d\u5b58\u5728\uff01");
            return;
        }
        if (copbizinfo.getBizstatus().equals("C")) {
            logger.error("\u4e1a\u52a1\u4e0d\u53ef\u7528\uff01");
            this.alertJS("\u4e1a\u52a1\u4e0d\u53ef\u7528\uff01");
            return;
        }
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("xlnumId", xlnumId);
        paraMap.put("bizNo", bizNo);
        paraMap.put("source", source);
        String genSign = this.generateSign(paraMap, copbizinfo.getBizkey());
        StringBuffer urlBuffer = new StringBuffer(this.WECHAT_MONTH_QUERY_SIGN_URL);
        urlBuffer.append("xlnumId=").append(xlnumId).append("&bizNo=").append(bizNo).append("&source=").append(source).append("&signMsg=").append(genSign);
        logger.info("--------------------------------the query url: {}", (Object)this.WECHAT_MONTH_QUERY_SIGN_URL.toString());
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getParams().setParameter("http.connection.timeout", (Object)6000);
        httpclient.getParams().setParameter("http.socket.timeout", (Object)6000);
        HttpGet httpGet = new HttpGet(urlBuffer.toString());
        HttpResponse res = null;
        try {
            res = httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5931\u8d25,url: {}, msg: {}", (Object)this.WECHAT_MONTH_QUERY_SIGN_URL.toString(), (Object)e.getMessage());
            this.alertJS("\u67e5\u8be2\u5931\u8d25,url: " + this.WECHAT_MONTH_QUERY_SIGN_URL.toString() + ", msg: " + e.getMessage());
            return;
        }
        if (res == null) {
            logger.error("\u67e5\u8be2\u5931\u8d25,url: {}", (Object)this.WECHAT_MONTH_QUERY_SIGN_URL.toString());
            this.alertJS("\u67e5\u8be2\u5931\u8d25,url: " + this.WECHAT_MONTH_QUERY_SIGN_URL.toString());
            return;
        }
        if (res.getStatusLine().getStatusCode() != 200) {
            logger.error("\u67e5\u8be2\u5931\u8d25, status code\uff1a{}", (Object)res.getStatusLine().getStatusCode());
            this.alertJS("\u67e5\u8be2\u5931\u8d25, status code\uff1a" + res.getStatusLine().getStatusCode());
            return;
        }
        String result = "";
        Document doc = null;
        String resultCode = "";
        String resultStatus = "";
        String errcode = "";
        try {
            result = EntityUtils.toString((HttpEntity)res.getEntity());
            doc = DocumentHelper.parseText((String)result);
            Element root = doc.getRootElement();
            resultCode = root.elementText("payresult");
            resultStatus = root.elementText("status");
            errcode = root.element("errcode").getText();
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! xml: {}", (Object)result);
            this.alertJS("\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! xml: " + result);
            return;
        }
        if ("00".equals(resultCode.trim())) {
            this.alertJS("\u72b6\u6001\u5df2\u7ecf\u6210\u529f\uff01");
            return;
        }
        if (StringUtils.isNotEmpty((String)resultCode) && "10".equals(resultCode.trim()) && StringUtils.isNotEmpty((String)errcode) && "1919".equals(errcode.trim())) {
            this.alertJS("\u7b7e\u7ea6\u4e0d\u5b58\u5728\uff01");
            return;
        }
        this.alertJS("\u72b6\u6001\u672a\u6210\u529f\uff01");
    }

    public String generateSign(Map<String, String> paraMap, String key) {
        StringBuilder builder = new StringBuilder();
        builder.append(ExtwechatmonthsignreqManagedBean.mapToString(paraMap, true)).append(key);
        return Md5Encrypt.md5((String)builder.toString());
    }

    public static String mapToString(Map<String, String> params, boolean isSort) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        if (isSort) {
            Collections.sort(keys);
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (StringUtils.isEmpty((String)value) || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            if (i == keys.size() - 1) {
                builder.append(key).append("=").append(value);
                continue;
            }
            builder.append(key).append("=").append(value).append("&");
        }
        return builder.toString();
    }
}

