/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.ExtWechatMonthSignOk;
import com.xunlei.payproxy.vo.ExtWechatMonthSignReq;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyWechatMonthsignok")
public class ExtwechatmonthsignokManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtwechatmonthsignokManagedBean.class);
    private String wechatMonthUnsignUrl = "http://proxy.pay.xunlei.com/wechatMonthUnsignServlet?";

    public String getQuery() {
        this.authenticateRun();
        ExtWechatMonthSignOk data = (ExtWechatMonthSignOk)this.findBean(ExtWechatMonthSignOk.class, "payproxy_extwechatmonthsignok");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getBeginDate())) {
                data.setBeginDate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getEndDate())) {
                data.setEndDate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtWechatMonthSignOk(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String moveWechatMonthSignOkToUnsign() {
        String[] seqId;
        this.authenticateEdit();
        String seqIds = this.findParameter("noticeBtn");
        if (this.isEmpty(seqIds)) {
            logger.error("\u53c2\u6570noticeBtn\uff1a{}\uff0c\u4e3a\u7a7a\uff01", (Object)seqIds);
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
            return "";
        }
        logger.debug("\u89e3\u7ea6seqIds: {}", (Object)seqIds);
        String[] stringArray = seqId = seqIds.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        if (n2 < n) {
            String id = stringArray[n2];
            ExtWechatMonthSignOk r = new ExtWechatMonthSignOk();
            r.setSeqId(Long.valueOf(id).longValue());
            ExtWechatMonthSignOk signOk = facade.findExtWechatMonthSignOk(r);
            if (null == signOk) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684seqId: {} \u7b7e\u7ea6\u8bb0\u5f55", (Object)id);
                this.alertJS("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u7ea6\u8bb0\u5f55!");
                return "";
            }
            String xlnumId = signOk.getXunleiId();
            ExtWechatMonthSignReq signReq = new ExtWechatMonthSignReq();
            String externalSignNo = signOk.getExternalSignNo();
            signReq.setExternalSignNo(externalSignNo);
            ExtWechatMonthSignReq signReqResult = facade.findExtWechatMonthSignReq(signReq);
            if (signReqResult == null) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684externalSignNo: {} \u7b7e\u7ea6\u8bb0\u5f55", (Object)externalSignNo);
                this.alertJS("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7b7e\u7ea6\u8bb0\u5f55!");
                return "";
            }
            String bizNo = signReqResult.getBizNo();
            Copbizinfo copbizinfoForQuery = new Copbizinfo();
            copbizinfoForQuery.setBizno(bizNo);
            Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
            String bizKey = copbizinfo.getBizkey();
            String url = this.genUnsignedUrl(bizNo, xlnumId, bizKey);
            logger.info("unsign GET-URL: {}", (Object)url);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.connection.timeout", (Object)6000);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)6000);
            HttpGet httpGet = new HttpGet(url);
            HttpResponse res = null;
            try {
                res = httpclient.execute((HttpUriRequest)httpGet);
            }
            catch (Exception e) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u89e3\u7ea6\u8bf7\u6c42URL\uff1a{}", (Object)(url + e.getMessage()));
                this.alertJS("\u89e3\u7ea6\u5931\u8d25!");
                return "";
            }
            if (res == null) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u670d\u52a1\u5668\u8d85\u65f6, \u89e3\u7ea6\u8bf7\u6c42URL\uff1a{}", (Object)url);
                this.alertJS("\u89e3\u7ea6\u5931\u8d25,\u670d\u52a1\u5668\u8d85\u65f6!");
                return "";
            }
            if (res.getStatusLine().getStatusCode() != 200) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u670d\u52a1\u5668\u9519\u8bef, status code\uff1a{}", (Object)res.getStatusLine().getStatusCode());
                this.alertJS("\u89e3\u7ea6\u5931\u8d25,\u670d\u52a1\u5668\u9519\u8bef!");
                return "";
            }
            String result = "";
            String resultCode = "";
            String errorCode = "";
            String errorMsg = "";
            try {
                result = EntityUtils.toString((HttpEntity)res.getEntity());
                Document doc = DocumentHelper.parseText((String)result);
                Element rootElement = doc.getRootElement();
                resultCode = rootElement.elementText("payresult");
                errorCode = rootElement.elementText("errcode");
                errorMsg = rootElement.elementText("errmsg");
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u652f\u4ed8\u5b9d\u5305\u6708\u4ee3\u6263\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! xml: {}", (Object)result);
                this.alertJS("\u89e3\u7ea6\u5931\u8d25,\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519!");
                return "";
            }
            if (StringUtils.isNotEmpty((String)resultCode) && "00".equals(resultCode.trim())) {
                logger.info("\u89e3\u7ea6\u6210\u529f\uff0cid: {}", (Object)id);
                this.alertJS("\u89e3\u7ea6\u6210\u529f!");
                return "";
            }
            logger.error("\u89e3\u7ea6\u5931\u8d25! errorCode: {}, errorMsg: {}", (Object)errorCode, (Object)errorMsg);
            this.alertJS("\u89e3\u7ea6\u5931\u8d25!" + errorMsg);
            return "";
        }
        return "";
    }

    public String genUnsignedUrl(String bizNo, String xlnumId, String bizKey) {
        StringBuffer signMsg = new StringBuffer();
        signMsg.append("bizNo=").append(bizNo).append("&");
        signMsg.append("xlnumId=").append(xlnumId);
        String sign = Md5Encrypt.md5((String)(signMsg.toString() + bizKey));
        StringBuffer queryStr = new StringBuffer(this.wechatMonthUnsignUrl);
        queryStr.append(signMsg.toString()).append("&signMsg=").append(sign);
        return queryStr.toString();
    }
}

