/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.ExtWechatMonthPayOk;
import com.xunlei.payproxy.vo.ExtWechatMonthPayReq;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.model.ExtalipaymonthreqManagedBean;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyWechatMonthpayreq")
public class ExtwechatmonthreqManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtalipaymonthreqManagedBean.class);
    private static Map<String, String> orderStatusMap;
    private static String queryUrl;

    public String getQuery() {
        logger.debug("entering ExtwechatmonthreqManagedBean#getQuery...");
        this.authenticateRun();
        ExtWechatMonthPayReq data = (ExtWechatMonthPayReq)this.findBean(ExtWechatMonthPayReq.class, "payproxy_extwechatmonthpayreq");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getBeginDate())) {
                data.setBeginDate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getEndDate())) {
                data.setEndDate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtWechatMonthReq(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public Map<String, String> getOrderStatusMap() {
        if (orderStatusMap == null) {
            orderStatusMap = new HashMap<String, String>();
            orderStatusMap.put("W", "\u7b49\u5f85");
            orderStatusMap.put("N", "\u5931\u8d25");
            orderStatusMap.put("U", "\u53ef\u7591");
        }
        return orderStatusMap;
    }

    public void checkOrderStatus() {
        String xunleiPayId = this.findParameter("query_orderId");
        logger.debug("check order status xunleiPayId: {}", (Object)xunleiPayId);
        if (StringUtils.isEmpty((String)xunleiPayId)) {
            this.alertJS("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
            return;
        }
        this.authenticateRun();
        ExtWechatMonthPayReq query = new ExtWechatMonthPayReq();
        query.setXunleiPayId(xunleiPayId);
        ExtWechatMonthPayReq result = facade.findExtWechatMonthReq(query);
        if (result == null) {
            this.alertJS("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
            return;
        }
        String bizNo = result.getBizNo();
        String xlnumId = result.getXunleiId();
        Copbizinfo copbizinfoForQuery = new Copbizinfo();
        copbizinfoForQuery.setBizno(bizNo);
        Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
        if (copbizinfo == null || copbizinfo.getBizstatus().equals("C")) {
            this.alertJS("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\uff01");
            return;
        }
        String bizKey = copbizinfo.getBizkey();
        String url = this.gensignedUrl(bizNo, xlnumId, xunleiPayId, bizKey);
        logger.info("\u67e5\u8be2url-->{}", (Object)url);
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.connection.timeout", (Object)6000);
        client.getParams().setParameter("http.socket.timeout", (Object)6000);
        HttpGet get = new HttpGet(url);
        HttpResponse res = null;
        try {
            res = client.execute((HttpUriRequest)get);
        }
        catch (IOException e) {
            logger.error("\u67e5\u8be2\u8d85\u65f6\uff01{}", (Object)e.getMessage());
            this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff01");
            return;
        }
        if (res == null) {
            logger.error("\u67e5\u8be2\u8d85\u65f6\uff01queryUrl: {}", (Object)query.toString());
            this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff01");
            return;
        }
        if (res.getStatusLine().getStatusCode() != 200) {
            logger.error("\u67e5\u8be2\u5931\u8d25\uff01response code: {}", (Object)res.getStatusLine().getStatusCode());
            this.alertJS("\u67e5\u8be2\u5931\u8d25,\u670d\u52a1\u5668\u54cd\u5e94\u7801\u4e0d\u6b63\u786e\uff01code: " + res.getStatusLine().getStatusCode());
            return;
        }
        try {
            String entity = EntityUtils.toString((HttpEntity)res.getEntity());
            logger.debug("response: {}", (Object)entity);
            Document doc = null;
            doc = DocumentHelper.parseText((String)entity);
            Element rootElement = doc.getRootElement();
            String payresult = rootElement.element("payresult").getTextTrim();
            String status = rootElement.element("status").getTextTrim();
            if ("00".equals(payresult)) {
                this.alertJS("\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff01");
                return;
            }
            this.alertJS("\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f\uff01");
            return;
        }
        catch (DocumentException e) {
            logger.error("\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! {}", (Object)e.getMessage());
            this.alertJS("\u67e5\u8be2\u5931\u8d25, \u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519, {}");
            return;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5931\u8d25\uff01{}", (Object)e.getMessage());
            this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage());
            return;
        }
    }

    public String gensignedUrl(String bizNo, String xlnumId, String xunleiPayId, String bizKey) {
        StringBuffer signMsg = new StringBuffer();
        signMsg.append("bizNo=").append(bizNo).append("&");
        signMsg.append("orderId=").append(xunleiPayId).append("&");
        signMsg.append("xlnumId=").append(xlnumId);
        String sign = Md5Encrypt.md5((String)(signMsg.toString() + bizKey));
        StringBuffer queryStr = new StringBuffer(queryUrl);
        queryStr.append(signMsg.toString()).append("&signMsg=").append(sign);
        return queryStr.toString();
    }

    public String moveExtWechatMonthReqToSuccess() {
        String[] seqIds;
        String selectIds = this.findParameter("noticeBtn");
        if (this.isEmpty(selectIds)) {
            logger.debug("selectIds is null \uff01");
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\uff01");
        }
        this.authenticateEdit();
        logger.debug("moveExtWechatMonthReqToSuccess, selectIds : {}", (Object)selectIds);
        String[] stringArray = seqIds = selectIds.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        if (n2 < n) {
            String seqId = stringArray[n2];
            ExtWechatMonthPayReq extWechatMonthPayReq = new ExtWechatMonthPayReq();
            extWechatMonthPayReq.setSeqId(Long.valueOf(seqId).longValue());
            ExtWechatMonthPayReq reqResult = facade.findExtWechatMonthReq(extWechatMonthPayReq);
            if (null == reqResult) {
                logger.error("according to seqId:{}, can not find ExtWechatMonthPayReq", (Object)seqId);
                this.alertJS("\u64cd\u4f5c\u5931\u8d25,\u65e0\u6cd5\u627e\u5230\u8ba2\u5355!");
                return "";
            }
            String xunleiPayId = reqResult.getXunleiPayId();
            String bizNo = reqResult.getBizNo();
            String xlnumId = reqResult.getXunleiId();
            Copbizinfo copbizinfoForQuery = new Copbizinfo();
            copbizinfoForQuery.setBizno(bizNo);
            Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
            if (copbizinfo == null || copbizinfo.getBizstatus().equals("C")) {
                this.alertJS("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\uff01");
                return "";
            }
            String bizKey = copbizinfo.getBizkey();
            String url = this.gensignedUrl(bizNo, xlnumId, xunleiPayId, bizKey);
            logger.info("\u67e5\u8be2url-->{}", (Object)url);
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setParameter("http.connection.timeout", (Object)6000);
            client.getParams().setParameter("http.socket.timeout", (Object)6000);
            HttpGet get = new HttpGet(url);
            HttpResponse res = null;
            try {
                res = client.execute((HttpUriRequest)get);
            }
            catch (IOException e) {
                logger.error("\u67e5\u8be2\u8d85\u65f6\uff01{}", (Object)e.getMessage());
                this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff01");
                return "";
            }
            if (res == null) {
                logger.error("\u67e5\u8be2\u8d85\u65f6\uff01url: {}", (Object)url);
                this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff01");
                return "";
            }
            if (res.getStatusLine().getStatusCode() != 200) {
                logger.error("\u67e5\u8be2\u5931\u8d25\uff01response code: {}", (Object)res.getStatusLine().getStatusCode());
                this.alertJS("\u67e5\u8be2\u5931\u8d25,\u670d\u52a1\u5668\u54cd\u5e94\u7801\u4e0d\u6b63\u786e\uff01code: " + res.getStatusLine().getStatusCode());
                return "";
            }
            String entity = "";
            try {
                entity = EntityUtils.toString((HttpEntity)res.getEntity());
            }
            catch (IOException e) {
                logger.error("\u89e3\u6790entity\u51fa\u9519! {}", (Object)e.getMessage());
                this.alertJS("\u67e5\u8be2\u5931\u8d25, \u89e3\u6790entity\u51fa\u9519, {}");
                return "";
            }
            logger.debug("response: {}", (Object)entity);
            Document doc = null;
            try {
                doc = DocumentHelper.parseText((String)entity);
            }
            catch (DocumentException e) {
                logger.error("\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! {}", (Object)e.getMessage());
                this.alertJS("\u67e5\u8be2\u5931\u8d25, \u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519, {}");
                return "";
            }
            Element rootElement = doc.getRootElement();
            String payresult = rootElement.element("payresult").getTextTrim();
            String status = rootElement.element("status").getTextTrim();
            if ("00".equals(payresult)) {
                HashMap<String, String> statusMap = new HashMap<String, String>();
                String[] statusArray = status.split("\\|");
                if (statusArray.length > 0) {
                    for (String s : statusArray) {
                        String[] temp = s.split("=");
                        statusMap.put(temp[0], temp[1]);
                    }
                }
                ExtWechatMonthPayOk queryCondition = new ExtWechatMonthPayOk();
                queryCondition.setXunleiPayId(reqResult.getXunleiPayId());
                ExtWechatMonthPayOk queryResult = facade.findExtWechatMonthOk(queryCondition);
                if (queryResult != null) {
                    logger.error("move req record to ok table failed, cause already moved!");
                    return null;
                }
                facade.updateWechatMonthSignReqSuccessTimes(reqResult.getXunleiId(), reqResult.getBizNo());
                ExtWechatMonthPayOk extWechatMonthPayOk = new ExtWechatMonthPayOk();
                extWechatMonthPayOk.setOrderId(reqResult.getOrderId());
                extWechatMonthPayOk.setAmount((double)Integer.parseInt((String)statusMap.get("total_fee")) * 0.01);
                extWechatMonthPayOk.setXunleiId(reqResult.getXunleiId());
                extWechatMonthPayOk.setUserShow(reqResult.getUserShow());
                extWechatMonthPayOk.setXunleiPayId((String)statusMap.get("out_trade_no"));
                extWechatMonthPayOk.setOrderTime(reqResult.getOrderTime());
                extWechatMonthPayOk.setSuccessTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                extWechatMonthPayOk.setBalanceDate("");
                extWechatMonthPayOk.setNotifyTime("");
                extWechatMonthPayOk.setTradeNo("");
                extWechatMonthPayOk.setGoodNo(reqResult.getGoodNo());
                extWechatMonthPayOk.setBizNo(reqResult.getBizNo());
                extWechatMonthPayOk.setFareAmount((double)Math.round(extWechatMonthPayOk.getAmount() * 0.02 * 100.0) * 0.01);
                extWechatMonthPayOk.setFactAmount(extWechatMonthPayOk.getAmount() - extWechatMonthPayOk.getFareAmount());
                extWechatMonthPayOk.setExt1("");
                extWechatMonthPayOk.setExt2("");
                extWechatMonthPayOk.setRemark("");
                extWechatMonthPayOk.setBuyerLogonId((String)statusMap.get("transaction_id"));
                extWechatMonthPayOk.setBuyerUserId((String)statusMap.get("openid"));
                extWechatMonthPayOk.setOrderStatus("Y");
                logger.info("\u8ba2\u5355\u53f7: {}, \u652f\u4ed8\u6210\u529f\uff0c\u79fb\u52a8\u6570\u636e\u5230\u6210\u529f\u8868", (Object)reqResult.getOrderId());
                facade.moveExtWechatMonthReqToSuccess(extWechatMonthPayOk);
                PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)((String)statusMap.get("out_trade_no")));
                this.alertJS("\u64cd\u4f5c\u6210\u529f!");
                return "";
            }
            this.alertJS("\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f\uff01");
            return "";
        }
        return "";
    }

    static {
        queryUrl = "http://proxy.pay.xunlei.com/wechatMonthPayOrderQueryServlet?";
    }
}

