/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.MiscUtility;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extunionpay;
import com.xunlei.payproxy.vo.Extunionpayok;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.unionpay.query.MonitorUnionpayHandler;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtunionpay")
public class ExtunionpayManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtunionpayManagedBean.class);
    private static Map<String, String> unionpaystatusMap;

    public String getQuery() {
        logger.info("ExtunionpayManagedBean-----getQuery-----run at : " + new Date());
        this.authenticateRun();
        Extunionpay extunionpay = (Extunionpay)this.findBean(Extunionpay.class, "payproxy_extunionpay");
        if (extunionpay != null) {
            logger.info("ExtunionpayManagedBean-----getQuery-----extunionpay is not null");
            if (StringTools.isEmpty((String)extunionpay.getFromdate())) {
                extunionpay.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)extunionpay.getTodate())) {
                extunionpay.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty(" inputtime desc");
            Sheet sheet = facade.queryExtunionpay(extunionpay, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public Map<String, String> getUnionpaystatusMap() {
        if (unionpaystatusMap == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("F", "\u5931\u8d25");
            map.put("U", "\u53ef\u7591");
            map.put("W", "\u7b49\u5f85");
            map.put("Y", "\u6210\u529f");
            unionpaystatusMap = map;
        }
        return unionpaystatusMap;
    }

    public String moveExtunionpayreqToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticesuccBtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                Extunionpay unionpayQuery = new Extunionpay();
                unionpayQuery.setSeqid(Long.valueOf(seqid).longValue());
                Extunionpay extunionpay = facade.findExtunionpay(unionpayQuery);
                if (extunionpay == null) continue;
                String orderid = extunionpay.getOrderid();
                double orderamt = extunionpay.getOrderamt();
                String orderstatus = extunionpay.getOrderstatus();
                String orderTime = extunionpay.getInputtime();
                try {
                    boolean query = CustomUtil.isQuery((String)"unionpay");
                    logger.info("query : " + query + ", orderid : " + orderid + ", orderamt: " + orderamt + ", orderstatus: " + orderstatus);
                    if (!query) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        this.doMove(extunionpay, map);
                    } else {
                        MonitorUnionpayHandler monitorUnionpayHandler = new MonitorUnionpayHandler();
                        orderstatus = "";
                        HashMap resultMap = monitorUnionpayHandler.query(orderid, String.valueOf(orderamt), orderTime, orderstatus);
                        logger.info("result code map : " + resultMap);
                        String timeout = ((String)resultMap.get("timeOut")).trim();
                        String checkSuccess = ((String)resultMap.get("checkSuccess")).trim();
                        if (timeout.equals("N") && checkSuccess.equals("Y")) {
                            this.doMove(extunionpay, resultMap);
                        } else if (timeout.equals("Y")) {
                            this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff0c\u65e0\u6cd5\u5b9a\u5236\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                        } else {
                            this.alertJS("\u7f6e\u4e3a\u6210\u529f\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba2\u5355\u652f\u4ed8\u5931\u8d25\uff1a" + (String)resultMap.get("msg"));
                        }
                    }
                    logger.debug("\u4eba\u5de5\u4f5c\u5b9a\u5236\u64cd\u4f5c\u7ed3\u675f.....");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return "";
    }

    public void doMove(Extunionpay extunionpay, Map<String, String> resultMap) {
        try {
            logger.info("ExtunionpayManagedBean-----moveExtunionpayreqToSuccess----domove\u64cd\u4f5c");
            extunionpay.setRemark(this.noticeok_remark(extunionpay.getRemark()));
            logger.debug(Utility.toStringCommon((Object)extunionpay));
            facade.updateExtunionpay(extunionpay);
            Extunionpayok extunionpayok = new Extunionpayok();
            extunionpayok.setOrderid(extunionpay.getOrderid());
            extunionpayok.setOrderamt(extunionpay.getOrderamt());
            extunionpayok.setCurrency(this.getValueStrFromMap(resultMap, "setlCurrency"));
            extunionpayok.setRate(this.getValueStrFromMap(resultMap, "converRate"));
            extunionpayok.setCupsqid(this.getValueStrFromMap(resultMap, "cupsQid"));
            extunionpayok.setCupstracenum(this.getValueStrFromMap(resultMap, "cupsTraceNum"));
            extunionpayok.setCupstracetime(this.getValueStrFromMap(resultMap, "cupsTraceTime"));
            extunionpayok.setSettledate(this.getValueStrFromMap(resultMap, "settleDate"));
            String settleDate = resultMap.get("settleDate");
            if (settleDate == null || "".equals(settleDate)) {
                extunionpayok.setBalancedate(MiscUtility.dateofnow());
            } else {
                try {
                    extunionpayok.setBalancedate(new SimpleDateFormat("yyyy-MM-dd").format(new SimpleDateFormat("yyyyMMdd").parse(Calendar.getInstance().get(1) + settleDate)));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    extunionpayok.setBalancedate(MiscUtility.dateofnow());
                }
            }
            extunionpayok.setSettleamt(this.getValueDoubleStrFromMap(resultMap, "setlAmt"));
            extunionpayok.setOrderstatus("Y");
            facade.moveExtunionpayreqToSuccess(extunionpayok);
            PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extunionpay.getOrderid());
            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getValueStrFromMap(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null || value.equals("")) {
            value = "";
        }
        return value;
    }

    public double getValueDoubleStrFromMap(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null || value.equals("")) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public String getUnionpayQuery() {
        logger.info("ExtunionpayManagedBean-----getunionpayQuery-----run at : " + new Date());
        this.authenticateRun();
        String orderid = this.findParameter("unionpay_orderid");
        String orderstatus = "";
        String orderamt = this.findParameter("unionpay_orderamt");
        String orderTime = this.findParameter("unionpay_inputtime");
        logger.info("ExtunionpayManagedBean-----getunionpayQuery----orderid= " + orderid);
        try {
            MonitorUnionpayHandler monitorUnionpayHandler = new MonitorUnionpayHandler();
            HashMap resultMap = monitorUnionpayHandler.query(orderid, orderamt, orderTime, orderstatus);
            logger.info("result code map : " + resultMap);
            String timeout = ((String)resultMap.get("timeOut")).trim();
            String checkSuccess = ((String)resultMap.get("checkSuccess")).trim();
            if (timeout.equals("N") && checkSuccess.equals("Y")) {
                logger.info("\u8ba2\u5355\u67e5\u8be2\u6210\u529f");
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            } else if (timeout.equals("Y")) {
                logger.info("\u8ba2\u5355\u67e5\u8be2\u8d85\u65f6");
                this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5:" + (String)resultMap.get("msg"));
            } else {
                logger.info("\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u5931\u8d25:" + (String)resultMap.get("msg"));
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u94f6\u8054\u624b\u673a\u652f\u4ed8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
            this.alertJS("\u8ba2\u5355[" + orderid + "]\u67e5\u8be2\u8d85\u65f6:" + e.getMessage());
        }
        return "";
    }
}

