/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.thirdparty.utils.HttpClient4Utils;
import com.xunlei.common.util.Arith;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.HttpGetAndPostSender;
import com.xunlei.payproxy.util.PropertiesUtil;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extunionmobilepay;
import com.xunlei.payproxy.vo.Extunionmobilepayok;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtunionmobilepay")
public class ExtunionmobilepayManagerBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExtunionmobilepayManagerBean.class);
    private static Map<String, String> orderstatusMap;
    private static SelectItem[] orderstatusItem;
    private boolean checkFlag = true;

    public String getQuery() {
        logger.info("invoking ExtunionmobilepayManagerBean getQuery method!");
        this.authenticateRun();
        Extunionmobilepay extunionmobilepay = (Extunionmobilepay)this.findBean(Extunionmobilepay.class, "payproxy_Extunionmobilepay");
        this.logextunionpay(extunionmobilepay);
        if (extunionmobilepay != null) {
            if (StringTools.isEmpty((String)extunionmobilepay.getFromdate())) {
                extunionmobilepay.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)extunionmobilepay.getTodate())) {
                extunionmobilepay.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid desc");
            Sheet sheet = facade.queryExtunionmobilepay(extunionmobilepay, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String checkOrderStatus() {
        logger.info("invoking ExtunionmobilepayManagerBean checkOrderStatus method!");
        this.authenticateRun();
        String linkid = this.findParameter("unionpay_linkid");
        String svcid = this.findParameter("unionpay_svcid");
        String uptime = this.findParameter("unionpay_uptime");
        String orderid = this.findParameter("unionpay_orderid");
        logger.info("linkid:" + linkid + " svcid:" + svcid + " uptime:" + uptime);
        try {
            if (orderid != null) {
                String resp = this.queryOrderStatus(orderid);
                resp = resp.replace("\n", "");
                if (null == (resp = resp.replace("\t", "")) || "".equals(resp)) {
                    this.alertJS("\u67e5\u8be2\u8ba2\u5355\u51fa\u9519!\u6ca1\u6709\u5f97\u5230\u7b2c\u4e09\u65b9\u7684\u8fd4\u56de\u7ed3\u679c!");
                } else if ("no_status".equals(resp)) {
                    this.alertJS("\u8be5\u8ba2\u5355\u53f7\u65e0\u72b6\u6001\u62a5\u544a!\u8fd4\u56de\u4fe1\u606f\u4e3a:" + resp);
                } else if ("0".equals(resp)) {
                    this.alertJS("\u8ba2\u5355\u652f\u4ed8\u6210\u529f!");
                } else {
                    this.alertJS("\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f,\u8fd4\u56de\u4fe1\u606f\u4e3a:" + resp);
                }
            } else {
                String resp = this.queryOrderStatus(linkid, svcid, uptime);
                if (null == resp || "".equals(resp)) {
                    this.alertJS("\u67e5\u8be2\u8ba2\u5355\u51fa\u9519!\u6ca1\u6709\u5f97\u5230\u7b2c\u4e09\u65b9\u7684\u8fd4\u56de\u7ed3\u679c!");
                } else if ("no_status".equals(resp)) {
                    this.alertJS("\u8be5\u8ba2\u5355\u53f7\u65e0\u72b6\u6001\u62a5\u544a!\u8fd4\u56de\u4fe1\u606f\u4e3a:" + resp);
                } else if ("DELIVRD".equals(resp)) {
                    this.alertJS("\u8ba2\u5355\u652f\u4ed8\u6210\u529f!");
                } else {
                    this.alertJS("\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f,\u8fd4\u56de\u4fe1\u606f\u4e3a:" + resp);
                }
            }
        }
        catch (Exception e) {
            this.alertJS("\u67e5\u8be2\u8ba2\u5355\u51fa\u9519,\u5f02\u5e38\u4fe1\u606f:" + e.getMessage());
            logger.error("checkOrderStatus fail ,errorMs:", (Throwable)e);
        }
        return "";
    }

    public String queryOrderStatus(String linkid, String svcid, String uptime) throws Exception {
        logger.info("invoking queryOrderStatus  method!");
        String service = PropertiesUtil.getPropertie((String)"unionmobilepayService");
        if (null == service || "".equals(service)) {
            throw new Exception("can not get propertie named unionmobilepayService!");
        }
        logger.info("\u5f97\u5230\u7684unionmobilepayService:" + service);
        StringBuffer param = new StringBuffer();
        if (null == linkid || "".equals(linkid)) {
            throw new Exception("linkid is null!");
        }
        if (null == svcid || "".equals(svcid)) {
            throw new Exception("svcid is null!");
        }
        if (null == uptime || "".equals(uptime)) {
            throw new Exception("uptime is null!");
        }
        uptime = this.parseTime(uptime, "yyyy-MM-dd HH:mm:ss", "yyyyMMddHHmmss");
        param.append("Linkid=" + linkid);
        param.append("&Svcid=" + svcid);
        param.append("&Time=" + uptime);
        logger.info("query param is[" + param.toString() + "]");
        String resp = HttpGetAndPostSender.sendPost((String)service, (String)param.toString());
        logger.info("response  is[" + resp + "]");
        return resp;
    }

    public String queryOrderStatus(String orderid) throws Exception {
        logger.info("invoking queryOrderStatus  method!");
        String resp = null;
        String url = PropertiesUtil.getPropertie((String)"url");
        String svcid = PropertiesUtil.getPropertie((String)"Svcid_1");
        Extunionmobilepay extunionmobilepay = new Extunionmobilepay();
        logger.info("get orderid is " + orderid);
        extunionmobilepay.setOrderid(orderid);
        extunionmobilepay = facade.findExtunionmobilepay(extunionmobilepay);
        if (null == extunionmobilepay) {
            throw new Exception("orderid is null!");
        }
        String outTradeNo = extunionmobilepay.getExt1();
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("outTradeNo", outTradeNo);
        params.put("Svcid", svcid);
        params.put("Time", this.getTime(new Date()));
        logger.info("get params ====>" + params);
        resp = HttpClient4Utils.doPost((String)url, params);
        return resp;
    }

    private String getTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(date);
    }

    private void doMove(Extunionmobilepay extunionmobilepay) {
        logger.info("ExtunionmobilepayManagerBean-----moveExtunionmobilepayToSuccess----domove\u64cd\u4f5c");
        String orderid = extunionmobilepay.getOrderid();
        logger.info("order id is[" + orderid + "]");
        extunionmobilepay.setRemark("custom");
        logger.debug(Utility.toStringCommon((Object)extunionmobilepay));
        facade.updateExtunionmobilepay(extunionmobilepay);
        Extunionmobilepayok extunionmobilepayok = new Extunionmobilepayok();
        extunionmobilepayok.setOrderid(extunionmobilepay.getOrderid());
        String successTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        extunionmobilepayok.setSuccesstime(successTime);
        facade.moveExtunionmobilepayToSuccess(extunionmobilepayok);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)orderid);
    }

    public String customExtunionmobilepay() {
        logger.info("invoking ExtunionmobilepayManagerBean method customExtunionmobilepay");
        this.authenticateEdit();
        String params = this.findParameter("noticeBtn");
        String ext = this.findParameter("noticeBtn_ext");
        logger.info("ext's value is " + ext);
        if (!StringTools.isEmpty((String)ext)) {
            Extunionmobilepay extunionmobilepay = new Extunionmobilepay();
            extunionmobilepay.setExt1(ext);
            extunionmobilepay = facade.findExtunionmobilepay(extunionmobilepay);
            String orderid = extunionmobilepay.getOrderid();
            if (orderid != null) {
                logger.info("orderid value is " + orderid);
                try {
                    String resp = this.queryOrderStatus(orderid);
                    resp = resp.replace("\n", "");
                    resp = resp.replace("\t", "");
                    if (null == resp || "".equals(resp)) {
                        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25:\u67e5\u8be2\u8ba2\u5355\u51fa\u9519!\u6ca1\u6709\u5f97\u5230\u7b2c\u4e09\u65b9\u7684\u8fd4\u56de\u7ed3\u679c!");
                        logger.error("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25:\u67e5\u8be2\u8ba2\u5355\u51fa\u9519!\u6ca1\u6709\u5f97\u5230\u7b2c\u4e09\u65b9\u7684\u8fd4\u56de\u7ed3\u679c!");
                    } else if ("no_status".equals(resp)) {
                        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25:\u8be5\u8ba2\u5355\u53f7\u65e0\u72b6\u6001\u62a5\u544a!\u8fd4\u56de\u4fe1\u606f\u4e3a:" + resp);
                        logger.error("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25:\u8be5\u8ba2\u5355\u53f7\u65e0\u72b6\u6001\u62a5\u544a!\u8fd4\u56de\u4fe1\u606f\u4e3a:" + resp);
                    } else if ("0".equals(resp)) {
                        this.doMove(extunionmobilepay);
                        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f!");
                    } else {
                        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25:\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f");
                        logger.error("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25:\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f,\u8fd4\u56de\u4fe1\u606f\u4e3a:" + resp);
                    }
                }
                catch (Exception e) {
                    logger.error("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25:" + e.getMessage());
                    this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25:\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f,\u8fd4\u56de\u4fe1\u606f\u4e3a:" + e.getMessage());
                }
            }
            return "";
        }
        if (this.isNotEmpty(params)) {
            logger.info("params:" + params);
            String[] paramArray = params.split("\\|");
            if (paramArray.length != 4) {
                this.alertJS("\u4f20\u5165\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e!");
                return "";
            }
            String seqid = paramArray[0];
            String linkid = paramArray[1];
            String uptime = paramArray[2];
            String feetemp = paramArray[3];
            double fee = 0.0;
            String dest = "";
            String cmd = "";
            String svcid = "";
            if (StringTools.isEmpty((String)seqid) || StringTools.isEmpty((String)linkid) || StringTools.isEmpty((String)uptime) || StringTools.isEmpty((String)feetemp)) {
                this.alertJS("\u4f20\u5165\u53c2\u6570\u4e0d\u5b8c\u6574!");
                return "";
            }
            try {
                uptime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new SimpleDateFormat("yyyyMMddHHmmss").parse(uptime));
            }
            catch (Exception e) {
                this.alertJS("\u8f93\u5165\u7684\u4e0a\u4f20\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e,\u5e94\u4e3ayyyyMMddHHmmss");
                return "";
            }
            try {
                fee = new BigDecimal(feetemp).movePointLeft(2).doubleValue();
            }
            catch (Exception e) {
                this.alertJS("\u8f93\u5165\u7684\u8ba1\u8d39\u683c\u5f0f\u4e0d\u6b63\u786e");
                return "";
            }
            try {
                dest = PropertiesUtil.getPropertie((String)"Dest");
                cmd = PropertiesUtil.getPropertie((String)"Cmd");
                svcid = PropertiesUtil.getPropertie((String)"Svcid");
            }
            catch (Exception e) {
                this.alertJS("\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u51fa\u9519");
                logger.error("", (Throwable)e);
                return "";
            }
            try {
                String resp = this.queryOrderStatus(linkid, svcid, uptime);
                if (!"DELIVRD".equals(resp) && this.checkFlag) {
                    this.alertJS(" \u547d\u4ee4\u884c\u8bb0\u5f55\u53f7:" + linkid + "\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u8fd4\u56de\u4e0d\u4e3a\u6210\u529f!\u4e0d\u5141\u8bb8\u8fdb\u884c\u5b9a\u5236");
                    return "";
                }
            }
            catch (Exception e1) {
                logger.error("", (Throwable)e1);
                this.alertJS("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5931\u8d25!");
                return "";
            }
            Extunionmobilepay extaudiopayQuery = new Extunionmobilepay();
            extaudiopayQuery.setSeqid(Long.parseLong(seqid));
            extaudiopayQuery = facade.findExtunionmobilepay(extaudiopayQuery);
            if (null == extaudiopayQuery) {
                this.alertJS("\u6839\u636e\u8ba2\u5355\u5e8f\u5217\u53f7" + seqid + "\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u8ba2\u5355!");
                return "";
            }
            Extunionmobilepayok extaudiopayokQuery = new Extunionmobilepayok();
            extaudiopayokQuery.setLinkid(linkid);
            extaudiopayokQuery = facade.findExtunionmobilepayok(extaudiopayokQuery);
            if (null != extaudiopayokQuery) {
                this.alertJS("\u8be5\u547d\u4ee4\u884c\u8bb0\u5f55\u53f7:" + linkid + "\u5df2\u7ecf\u88ab\u4f7f\u7528");
                return "";
            }
            double orderamt = extaudiopayQuery.getOrderamt();
            logger.info("orderamt :" + orderamt + " feetemp:" + feetemp + " fee:" + fee);
            double sub = Arith.sub((double)orderamt, (double)fee);
            if (Math.abs(sub) >= 0.01) {
                this.alertJS("\u8ba2\u5355\u91d1\u989d\u4e0e\u8ba1\u8d39\u91d1\u989d\u4e0d\u4e00\u81f4!");
                return "";
            }
            extaudiopayQuery.setUptime(uptime);
            extaudiopayQuery.setLinkid(linkid);
            extaudiopayQuery.setDest(dest);
            extaudiopayQuery.setCmd(cmd);
            extaudiopayQuery.setSvcid(svcid);
            extaudiopayQuery.setFee(fee + "");
            this.doMove(extaudiopayQuery);
            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
        } else {
            this.alertJS("\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5217!");
        }
        return "";
    }

    public static String formatOrderAmt(double amount) throws Exception {
        DecimalFormat formatter = new DecimalFormat("0.00");
        return formatter.format(Arith.div((double)amount, (double)100.0)) + "";
    }

    private String parseTime(String time, String before, String after) {
        SimpleDateFormat bfSp = new SimpleDateFormat(before);
        SimpleDateFormat afSp = new SimpleDateFormat(after);
        try {
            return afSp.format(bfSp.parse(time));
        }
        catch (ParseException e) {
            logger.error("can not parse time[" + time + "]", (Throwable)e);
            return "";
        }
    }

    public void logextunionpay(Extunionmobilepay extunionmobilepay) {
        logger.info(extunionmobilepay.toString());
    }

    public Map<String, String> getOrderstatusMap() {
        if (orderstatusMap == null) {
            orderstatusMap = new HashMap<String, String>();
            orderstatusMap.put("W", "\u7b49\u5f85");
            orderstatusMap.put("F", "\u5931\u8d25");
            orderstatusMap.put("U", "\u53ef\u7591");
            orderstatusMap.put("Y", "\u6210\u529f");
            orderstatusMap.put("O", "\u8fc5\u96f7\u4e0b\u5355");
        }
        return orderstatusMap;
    }

    public SelectItem[] getOrderstatusItem() {
        if (orderstatusItem == null) {
            orderstatusItem = new SelectItem[5];
            ExtunionmobilepayManagerBean.orderstatusItem[0] = new SelectItem((Object)"Y", "\u6210\u529f");
            ExtunionmobilepayManagerBean.orderstatusItem[1] = new SelectItem((Object)"U", "\u53ef\u7591");
            ExtunionmobilepayManagerBean.orderstatusItem[2] = new SelectItem((Object)"F", "\u5931\u8d25");
            ExtunionmobilepayManagerBean.orderstatusItem[3] = new SelectItem((Object)"W", "\u7b49\u5f85");
            ExtunionmobilepayManagerBean.orderstatusItem[4] = new SelectItem((Object)"O", "\u8fc5\u96f7\u4e0b\u5355");
        }
        return orderstatusItem;
    }

    public static void main(String[] args) {
        System.out.println();
    }
}

