/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.umpay.SignEnc;
import com.umpay.SignEncException;
import com.xunlei.card.util.Utility;
import com.xunlei.common.util.Arith;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.umpay.ResponseInfo;
import com.xunlei.payproxy.umpay.UmpayUtil;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.XLAlreadyMoveException;
import com.xunlei.payproxy.vo.Extumpay;
import com.xunlei.payproxy.vo.Extumpayok;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxyutil.result.ResultInfo;
import com.xunlei.payproxyutil.umpay.UmpayHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtumpay")
public class ExtumpayManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExtumpayManagedBean.class);
    private Map<String, String> typeMap = null;
    private List<SelectItem> typeItem = null;

    public String getQuery() {
        this.authenticateRun();
        Extumpay extumpay = (Extumpay)this.findBean(Extumpay.class, "payproxy_extumpay");
        if (StringTools.isEmpty((String)extumpay.getFromdate())) {
            extumpay.setFromdate(DatetimeUtil.today());
        }
        if (StringTools.isEmpty((String)extumpay.getTodate())) {
            extumpay.setTodate(DatetimeUtil.today());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Sheet sheet = facade.queryExtumpay(extumpay, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getTypeMap() {
        if (this.typeMap == null) {
            ExtumpayManagedBean extumpayManagedBean = this;
            synchronized (extumpayManagedBean) {
                List list = facade.getLibclassdByClassNo("UmpayType");
                this.typeMap = new Hashtable<String, String>();
                for (Libclassd data : list) {
                    this.typeMap.put(data.getItemno(), data.getItemname());
                }
            }
        }
        return this.typeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SelectItem> getTypeItem() {
        if (this.typeItem == null) {
            ExtumpayManagedBean extumpayManagedBean = this;
            synchronized (extumpayManagedBean) {
                List list = facade.getLibclassdByClassNo("UmpayType");
                this.typeItem = new ArrayList<SelectItem>();
                for (Libclassd data : list) {
                    this.typeItem.add(new SelectItem((Object)data.getItemno(), data.getItemname()));
                }
            }
        }
        return this.typeItem;
    }

    public String noticeUmpayok() {
        this.authenticateAdd();
        String orderids = this.findParameter("noticebtn");
        boolean success = false;
        String umpayBalanceDate = Utility.timeofnow();
        String retCode = "0000";
        int transTypeInt = 0;
        if (this.isNotEmpty(orderids)) {
            String[] ids;
            for (String orderId : ids = orderids.split("\\|")) {
                Extumpay extumpayQry = new Extumpay();
                extumpayQry.setOrderid(orderId);
                Extumpay extumpay = IFacade.INSTANCE.findExtumpay(extumpayQry);
                if (extumpay != null) {
                    logger.info("umpaytype=" + extumpay.getUmpaytype());
                }
                if (extumpay != null && "D".equals(extumpay.getUmpaytype())) {
                    success = this.moveExtumpay2SuccessForSjby(orderId, umpayBalanceDate, transTypeInt, extumpay.getMobileno());
                    continue;
                }
                try {
                    boolean query = CustomUtil.isQuery((String)"umpay_cash");
                    logger.info("query:" + query + "\torderid:" + extumpay.getOrderid());
                    if (!query) {
                        logger.info("\u4e0d\u8fdb\u884c\u652f\u4ed8\u67e5\u8be2\uff0c\u76f4\u63a5\u4eba\u5de5\u5b9a\u5236");
                        success = this.moveExtumpay2Success(orderId, umpayBalanceDate, transTypeInt, retCode, null);
                        continue;
                    }
                    String merDate = this.changeTimeType(extumpay.getInputtime());
                    ResultInfo resultInfo = UmpayHelper.getQueryResult((String)extumpay.getOrderid(), (double)Arith.div((double)extumpay.getAmount(), (double)100.0), (String)merDate, (String)extumpay.getMobileno());
                    logger.info("\u55d6\u4ed8\u67e5\u8be2\u7ed3\u679c\uff1a" + resultInfo + ", code=" + resultInfo.getCode());
                    if (resultInfo.getCode().equals("00")) {
                        success = this.moveExtumpay2Success(orderId, umpayBalanceDate, transTypeInt, retCode, resultInfo);
                        continue;
                    }
                    this.alertJS(resultInfo.getMessage());
                }
                catch (Exception e) {
                    this.alertJS("\u67e5\u8be2\u5931\u8d25 [" + e.getMessage() + " ]");
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (success) {
            this.alertJS("\u64cd\u4f5c\u6210\u529f");
        } else {
            this.alertJS("\u64cd\u4f5c\u5931\u8d25");
        }
        return "";
    }

    public String changeTimeType(String targetTime) {
        logger.info("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\uff0ctarget\u683c\u5f0f\u4e3a\uff1a" + targetTime);
        if (targetTime.length() != 19) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            return targetTime;
        }
        String result = targetTime.substring(0, 10);
        result = result.replace("-", "");
        logger.info("\u8f6c\u5316\u540e\u65e5\u671f\u683c\u5f0f\u4e3a\uff1a" + result);
        if (result.length() != 8) {
            logger.error("\u8f6c\u5316\u540e\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            return targetTime;
        }
        return result;
    }

    private boolean moveExtumpay2Success(String orderId, String umpayBalanceDate, int transTypeInt, String retCode, ResultInfo resultInfo) {
        boolean success = false;
        facade.moveBizorderToSuccess(orderId);
        logger.info("moveExtumpay2Success----\u55d6\u4ed8bizorder\u8868\u8f6c\u79fb\u6210\u529f");
        try {
            facade.moveExtumpayToSuccess(orderId, "Y", umpayBalanceDate, transTypeInt, retCode);
            success = true;
            logger.info("moveExtumpay2Success----\u55d6\u4ed8umpaytosuccess,\u8ba2\u5355\u72b6\u6001\u4e3aY\uff0c\u8f6c\u79fb\u6210\u529f");
        }
        catch (XLAlreadyMoveException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (XLRuntimeException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            try {
                facade.moveExtumpayToSuccess(orderId, "N", umpayBalanceDate, transTypeInt, retCode);
                success = true;
                logger.info("moveExtumpay2Success----\u55d6\u4ed8umpaytosuccess,\u8ba2\u5355\u72b6\u6001\u4e3aN\uff0c\u8f6c\u79fb\u6210\u529f");
            }
            catch (XLAlreadyMoveException ex1) {
                logger.error(ex1.getMessage(), (Throwable)ex1);
                success = true;
            }
        }
        Extumpayok extqishunokForQuery = new Extumpayok();
        extqishunokForQuery.setOrderid(orderId);
        IFacade facade = IFacade.INSTANCE;
        Extumpayok extqishunok = facade.findExtumpayok(extqishunokForQuery);
        if (extqishunok != null) {
            extqishunok.setRemark(this.noticeok_remark(extqishunok.getRemark()));
            facade.updateExtumpayok(extqishunok);
        }
        if (resultInfo != null) {
            this.alertJS(resultInfo.getMessage());
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveExtumpay2SuccessForSjby(String orderId, String umpayBalanceDate, int transTypeInt, String mobileno) {
        HttpEntity httpEntity = this.getConnection(mobileno);
        boolean success = false;
        String htmlRetdata = null;
        try {
            htmlRetdata = EntityUtils.toString((HttpEntity)httpEntity);
        }
        catch (ParseException e) {
            logger.info(e.getMessage());
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
        logger.info("umpay query rgdz service resp: " + htmlRetdata);
        Parser parser = new Parser();
        try {
            parser.setInputHTML(htmlRetdata);
        }
        catch (ParserException e) {
            logger.info(e.getMessage());
        }
        NodeClassFilter nt = new NodeClassFilter(MetaTag.class);
        NodeList nodeList = null;
        try {
            nodeList = parser.parse((NodeFilter)nt);
        }
        catch (ParserException e) {
            logger.info(e.getMessage());
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            String returnCode;
            MetaTag meta = (MetaTag)nodeList.elementAt(i);
            String tagName = meta.getMetaTagName();
            String tagContent = meta.getAttribute("CONTENT");
            logger.info("umpay tag:" + tagName + ",content:" + tagContent);
            String[] datas = tagContent.split("\\|");
            if (datas[3].equals("-1") || !"0000".equals(returnCode = datas[6])) continue;
            String string = orderId.intern();
            synchronized (string) {
                success = this.moveExtumpay2Success(orderId, umpayBalanceDate, transTypeInt, "0000", null);
                continue;
            }
        }
        return success;
    }

    private HttpEntity getConnection(String mobileno) {
        StringBuffer signContent = new StringBuffer();
        signContent.append("merId=").append("3060");
        signContent.append("&").append("goodsId=").append("306002");
        signContent.append("&").append("mobileId=").append(mobileno.trim());
        signContent.append("&").append("version=").append("3.0");
        String sign = "";
        try {
            sign = SignEnc.sign((String)signContent.toString());
        }
        catch (SignEncException e) {
            logger.error(e.getMessage());
            return null;
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("merId", "3060"));
        nvps.add(new BasicNameValuePair("goodsId", "306002"));
        nvps.add(new BasicNameValuePair("mobileId", mobileno));
        nvps.add(new BasicNameValuePair("version", "3.0"));
        nvps.add(new BasicNameValuePair("sign", sign));
        String url = "http://payment.umpay.com/webpay/HfWebMer3QueryUser.do";
        logger.info("mobieNo==" + mobileno);
        logger.info("signContext==" + signContent.toString());
        HttpPost httppost = new HttpPost(url);
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity httpEntity = response.getEntity();
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                return null;
            }
            return httpEntity;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String getUmpayQuery() {
        logger.info("getUmpayQuery----\u67e5\u8be2\u55d6\u4ed8\u652f\u4ed8");
        String orderid = this.findParameter("umpay_orderid");
        String amount = this.findParameter("umpay_amount");
        String inputtime = this.findParameter("umpay_inputtime");
        String mobile = this.findParameter("umpay_mobileno");
        logger.info("\u83b7\u53d6\u7684\u53c2\u6570\u4e3a\uff1aorderid=" + orderid + ", amount=" + amount + ", inputtime=" + inputtime + ", mobile=" + mobile);
        String merdate = inputtime.substring(0, 4) + inputtime.substring(5, 7) + inputtime.substring(8, 10);
        logger.info("merdate=" + merdate);
        String status = facade.checkExtumpay(mobile, merdate);
        if (status.trim().equals("00")) {
            this.alertJS("\u8ba2\u5355[" + orderid + "]\u5b9a\u5236\u6210\u529f");
        } else {
            ResponseInfo responseInfo = UmpayUtil.getInstance().check(orderid, merdate, mobile, Arith.div((double)Double.parseDouble(amount), (double)100.0));
            if (responseInfo == null) {
                logger.error("\u53bb\u8054\u52a8\u4f18\u52bf\u67e5\u8be2\u5931\u8d25");
                this.alertJS("\u67e5\u8be2\u5931\u8d25");
                return "";
            }
            if (responseInfo.getCheckStatus() < 10) {
                logger.info("\u8ba2\u5355[" + orderid + "]\u672a\u652f\u4ed8\u6210\u529f\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + responseInfo.getFailDesp());
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u672a\u652f\u4ed8\u6210\u529f");
            } else if (responseInfo.getCheckStatus() == 10) {
                logger.info("\u8ba2\u5355[" + orderid + "]\u4e3a\u652f\u4ed8\u6210\u529f\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a\u4ea4\u6613\u91d1\u989d\u4e0d\u7b26");
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u672a\u652f\u4ed8\u6210\u529f");
            } else {
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            }
        }
        return "";
    }
}

