/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.ExtumpaySettleInfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;

@FunRef(value="PayProxyExtumpaySettleInfo")
public class ExtumpayDayendManagedBean
extends BaseManagedBean {
    private static Map<String, String> servicetypeMap;
    private static SelectItem[] servicetypeItem;

    public Map<String, String> getServicetypeMap() {
        if (servicetypeMap == null) {
            List list = facade.getLibclassdByClassNo("UmpayServiceType");
            servicetypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                servicetypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return servicetypeMap;
    }

    public SelectItem[] getServicetypeItem() {
        if (servicetypeItem == null) {
            List list = facade.getLibclassdByClassNo("UmpayServiceType");
            if (list == null) {
                servicetypeItem = new SelectItem[0];
            } else {
                servicetypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtumpayDayendManagedBean.servicetypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return servicetypeItem;
    }

    public String getQueryUmpaydayendList() {
        this.authenticateRun();
        ExtumpaySettleInfo extumpaysettleinfo = (ExtumpaySettleInfo)this.findBean(ExtumpaySettleInfo.class, "payproxy_extumpaysettleinfo");
        if (Utility.isEmpty((String)extumpaysettleinfo.getFromdate())) {
            extumpaysettleinfo.setFromdate(DatetimeUtil.yesterday());
        }
        if (Utility.isEmpty((String)extumpaysettleinfo.getTodate())) {
            extumpaysettleinfo.setTodate(DatetimeUtil.yesterday());
        }
        logger.info((Object)("fromdate==" + extumpaysettleinfo.getFromdate()));
        logger.info((Object)("todate==" + extumpaysettleinfo.getTodate()));
        extumpaysettleinfo.setFromdate(this.convertDate(extumpaysettleinfo.getFromdate()));
        extumpaysettleinfo.setTodate(this.convertDate(extumpaysettleinfo.getTodate()));
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("settleDate desc ");
        Sheet sheet = facade.queryExtumpaySettleInfo(extumpaysettleinfo, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public String getQueryExtumpaymonthendList() {
        this.authenticateRun();
        ExtumpaySettleInfo extumpaysettleinfo = (ExtumpaySettleInfo)this.findBean(ExtumpaySettleInfo.class, "payproxy_extumpaysettleinfo");
        String lastYear = this.getLastMonth().substring(0, 4);
        String lastMonth = this.getLastMonth().substring(4, 6);
        if (Utility.isEmpty((String)extumpaysettleinfo.getFromyear())) {
            extumpaysettleinfo.setFromyear(lastYear);
        }
        if (Utility.isEmpty((String)extumpaysettleinfo.getFrommonth())) {
            extumpaysettleinfo.setFrommonth(lastMonth);
        }
        if (Utility.isEmpty((String)extumpaysettleinfo.getToyear())) {
            extumpaysettleinfo.setToyear(lastYear);
        }
        if (Utility.isEmpty((String)extumpaysettleinfo.getTomonth())) {
            extumpaysettleinfo.setTomonth(lastMonth);
        }
        String startMonth = extumpaysettleinfo.getFromyear() + extumpaysettleinfo.getFrommonth();
        String endMonth = extumpaysettleinfo.getToyear() + extumpaysettleinfo.getTomonth();
        ArrayList<ExtumpaySettleInfo> totalResult = new ArrayList<ExtumpaySettleInfo>();
        while (startMonth.compareTo(endMonth) <= 0) {
            String fromDate = startMonth + "01";
            String endDate = startMonth + "31";
            extumpaysettleinfo.setFromdate(fromDate);
            extumpaysettleinfo.setTodate(endDate);
            List result = facade.queryExtumpaySettleInfoByMonth(extumpaysettleinfo);
            logger.info((Object)("goodsid==" + (extumpaysettleinfo.getGoodsid() == null ? null : extumpaysettleinfo.getGoodsid())));
            if (null != result && null != extumpaysettleinfo.getGoodsid() && !"".equals(extumpaysettleinfo.getGoodsid())) {
                for (ExtumpaySettleInfo info : result) {
                    if (!extumpaysettleinfo.getGoodsid().equals(info.getGoodsid().trim())) continue;
                    totalResult.add(info);
                }
            } else {
                totalResult.addAll(result);
            }
            startMonth = this.addMonth(startMonth, 1);
        }
        Sheet sheet = null;
        if (null == totalResult || totalResult.size() == 0) {
            sheet = Sheet.EMPTY;
        } else {
            int rowcount = totalResult.size();
            sheet = new Sheet(rowcount, totalResult);
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("settleDate desc ");
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    private String getLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        return format.format(date);
    }

    private String addMonth(String date, int value) {
        if (date == null || date.length() < 6) {
            return null;
        }
        String oldYear = date.substring(0, 4);
        String oldMonth = date.substring(4, 6);
        int newMonth = Integer.parseInt(oldMonth) + value;
        if (newMonth > 12) {
            int newYear = Integer.parseInt(oldYear) + 1;
            return newYear + "" + ((newMonth -= 12) < 10 ? "0" + newMonth : Integer.valueOf(newMonth));
        }
        return oldYear + (newMonth < 10 ? "0" + newMonth : Integer.valueOf(newMonth));
    }

    private String convertDate(String date) {
        if (date == null || date.length() < 8) {
            return null;
        }
        String newDate = date.replace("-", "");
        return newDate.trim();
    }
}

