/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.umpay.SignEnc;
import com.umpay.SignEncException;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extumpayok;
import com.xunlei.payproxy.vo.Extumpayokinfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtumpayCustomer")
public class ExtumcustomizationManagedBean
extends BaseManagedBean {
    private Map<String, String> typeMap = null;
    private List<SelectItem> typeItem = null;
    private static Logger logger = LoggerFactory.getLogger(ExtumcustomizationManagedBean.class);
    private static DateFormat df_Ymd2 = new SimpleDateFormat("yyyyMMdd");

    public String getCustomization() {
        logger.info("\u5b9a\u5236\u670d\u52a1\u5f00\u59cb=================>");
        this.authenticateRun();
        Extumpayokinfo extumpayokinfo = (Extumpayokinfo)this.findBean(Extumpayokinfo.class, "payproxy_extumpayokinfo");
        if (StringTools.isEmpty((String)extumpayokinfo.getFromdate())) {
            extumpayokinfo.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-30));
        }
        if (StringTools.isEmpty((String)extumpayokinfo.getTodate())) {
            extumpayokinfo.setTodate(DatetimeUtil.today());
        }
        logger.info("fromDate : " + extumpayokinfo.getFromdate() + "\t toDate : " + extumpayokinfo.getTodate());
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("monthlyendedtime desc");
        Sheet sheet = facade.queryCustomization(extumpayokinfo, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public String customizationSome() {
        this.authenticateRun();
        String orderids = this.findParameter("noticepayids");
        UserInfo userinfo = (UserInfo)this.getHttpServletRequest().getSession().getAttribute("userinfo");
        String username = userinfo.getTrueName();
        String now = Utility.timeofnow();
        String orderid = null;
        String mobileno = null;
        String umpaytype = null;
        String remark = username + "|" + now;
        String rtnCode = null;
        String result = null;
        if (this.isNotEmpty(orderids)) {
            String[] ids;
            for (String seqid : ids = orderids.split("\\|")) {
                Extumpayokinfo data = facade.getExtumpayokinfoById(Long.parseLong(seqid));
                orderid = data.getOrderid();
                mobileno = data.getMobileno();
                umpaytype = data.getUmpaytype();
                logger.info("\u5305\u6708\u5b9a\u5236\u7684\u4fe1\u606f\uff1aorderid = " + orderid + " ,mobileno = " + mobileno + " ,umpaytype = " + umpaytype);
                rtnCode = this.customize(orderid, mobileno, umpaytype, remark);
                if (rtnCode.equals("00")) {
                    result = "\u6210\u529f\u901a\u77e5\u5f00\u901a\u4f1a\u5458";
                    continue;
                }
                if (rtnCode.equals("01")) {
                    result = "\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u5b9a\u5236\u5173\u7cfb\u4fe1\u606f";
                    break;
                }
                if (rtnCode.equals("02")) {
                    result = "\u7f51\u7edc\u65e0\u54cd\u5e94";
                    break;
                }
                if (rtnCode.equals("03")) {
                    result = "\u5f00\u901a\u4f1a\u5458\u51fa\u9519";
                    break;
                }
                if (rtnCode.equals("04")) {
                    result = "\u901a\u77e5\u5f00\u901a\u4f1a\u5458\u5931\u8d25";
                    break;
                }
                if (!rtnCode.equals("05")) continue;
                result = "\u6ca1\u6709\u7eed\u8d39";
                break;
            }
        }
        this.alertJS(result);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getTypeMap() {
        if (this.typeMap == null) {
            ExtumcustomizationManagedBean extumcustomizationManagedBean = this;
            synchronized (extumcustomizationManagedBean) {
                List list = facade.getLibclassdByClassNo("UmpayType");
                this.typeMap = new Hashtable<String, String>();
                for (Libclassd data : list) {
                    this.typeMap.put(data.getItemno(), data.getItemname());
                }
            }
        }
        return this.typeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SelectItem> getTypeItem() {
        if (this.typeItem == null) {
            ExtumcustomizationManagedBean extumcustomizationManagedBean = this;
            synchronized (extumcustomizationManagedBean) {
                List list = facade.getLibclassdByClassNo("UmpayType");
                this.typeItem = new ArrayList<SelectItem>();
                for (Libclassd data : list) {
                    this.typeItem.add(new SelectItem((Object)data.getItemno(), data.getItemname()));
                }
            }
        }
        return this.typeItem;
    }

    private String customize(String orderid, String mobileno, String umpaytype, String remark) {
        Extumpayokinfo extumpayokinfo = this.findInfo(orderid, mobileno, umpaytype);
        if (extumpayokinfo == null) {
            return "01";
        }
        HttpEntity httpEntity = this.getConnection(mobileno);
        if (httpEntity == null) {
            return "02";
        }
        return this.openInfo(httpEntity, extumpayokinfo);
    }

    private HttpEntity getConnection(String mobileno) {
        StringBuffer signContent = new StringBuffer();
        signContent.append("merId=").append("3060");
        signContent.append("&").append("goodsId=").append("306002");
        signContent.append("&").append("mobileId=").append(mobileno.trim());
        signContent.append("&").append("version=").append("3.0");
        String sign = "";
        try {
            sign = SignEnc.sign((String)signContent.toString());
        }
        catch (SignEncException e) {
            logger.error(e.getMessage());
            return null;
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("merId", "3060"));
        nvps.add(new BasicNameValuePair("goodsId", "306002"));
        nvps.add(new BasicNameValuePair("mobileId", mobileno));
        nvps.add(new BasicNameValuePair("version", "3.0"));
        nvps.add(new BasicNameValuePair("sign", sign));
        String url = "http://payment.umpay.com/webpay/HfWebMer3QueryUser.do";
        logger.info("mobieNo==" + mobileno);
        logger.info("signContext==" + signContent.toString());
        HttpPost httppost = new HttpPost(url);
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity httpEntity = response.getEntity();
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                return null;
            }
            return httpEntity;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private Extumpayokinfo findInfo(String orderid, String mobileno, String umpaytype) {
        Extumpayokinfo extumpayokinfo;
        block1: {
            Extumpayokinfo data;
            Extumpayokinfo extumpayokQry = new Extumpayokinfo();
            extumpayokQry.setUmpaytype(umpaytype);
            extumpayokQry.setOrderid(orderid);
            extumpayokQry.setMobileno(mobileno);
            Sheet sheet = IFacade.INSTANCE.queryExtumpayokinfoByMonthlyEndedTime(extumpayokQry, null);
            if (sheet == null || sheet.getRowcount() == 0) {
                return null;
            }
            extumpayokinfo = null;
            Iterator iterator = sheet.getDatas().iterator();
            if (!iterator.hasNext()) break block1;
            extumpayokinfo = data = (Extumpayokinfo)iterator.next();
        }
        return extumpayokinfo;
    }

    private String openInfo(HttpEntity httpEntity, Extumpayokinfo data) {
        NodeList nodeList;
        String htmlRetdata;
        try {
            htmlRetdata = EntityUtils.toString((HttpEntity)httpEntity);
        }
        catch (org.apache.http.ParseException e) {
            logger.info(e.getMessage());
            return "03";
        }
        catch (IOException e) {
            logger.info(e.getMessage());
            return "03";
        }
        logger.info("umpay query monthly service resp: " + htmlRetdata);
        Parser parser = new Parser();
        try {
            parser.setInputHTML(htmlRetdata);
        }
        catch (ParserException e) {
            logger.info(e.getMessage());
            return "03";
        }
        NodeClassFilter nt = new NodeClassFilter(MetaTag.class);
        try {
            nodeList = parser.parse((NodeFilter)nt);
        }
        catch (ParserException e) {
            logger.info(e.getMessage());
            return "03";
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            MetaTag meta = (MetaTag)nodeList.elementAt(i);
            String tagName = meta.getMetaTagName();
            String tagContent = meta.getAttribute("CONTENT");
            logger.info("umpay tag:" + tagName + ",content:" + tagContent);
            String[] datas = tagContent.split("\\|");
            if (datas[3].equals("-1")) continue;
            String monthlyEndedTime = datas[5];
            logger.info("monthlyEndedTime: " + monthlyEndedTime);
            if (monthlyEndedTime.compareTo(data.getMonthlyEndedTime()) <= 0 && !"9999".equals(data.getMonthlyEndedTime().trim())) continue;
            Extumpayokinfo endedTimeExtumpayok = new Extumpayokinfo();
            endedTimeExtumpayok.setOrderid(data.getMonthlyOrderId());
            Extumpayokinfo upDateMonthlyEndedTime = IFacade.INSTANCE.findExtumpayokinfo(endedTimeExtumpayok);
            upDateMonthlyEndedTime.setMonthlyEndedTime(monthlyEndedTime);
            String remark = String.valueOf(Integer.valueOf(data.getRemark()) + 1);
            upDateMonthlyEndedTime.setRemark(remark);
            IFacade.INSTANCE.updateExtumpayokinfo(upDateMonthlyEndedTime, new String[]{"monthlyEndedTime", "Remark"});
            Extumpayok newUmpayok = new Extumpayok();
            Utility.copyProperties((Object)newUmpayok, (Object)upDateMonthlyEndedTime);
            newUmpayok.setRemark(DatetimeUtil.today());
            String new_orderid = data.getMonthlyOrderId() + "_" + remark;
            newUmpayok.setOrderid(new_orderid);
            newUmpayok.setInputtime(DatetimeUtil.now());
            newUmpayok.setSuccesstime(DatetimeUtil.now());
            newUmpayok.setBalancedate(DatetimeUtil.today());
            newUmpayok.setRemark(remark);
            IFacade.INSTANCE.insertExtumpayok(newUmpayok);
            String days = String.valueOf(this.getQuot(monthlyEndedTime));
            boolean flag = PayProxyJmsMessageSender.sendUmpayVipByOrderidAndDays((String)data.getMonthlyOrderId(), (String)new_orderid, (String)days);
            if (flag) {
                return "00";
            }
            return "04";
        }
        return "05";
    }

    private long getQuot(String time) {
        long quot = 0L;
        Date date1 = null;
        try {
            date1 = df_Ymd2.parse(time);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        Date date2 = new Date();
        quot = date1.getTime() - date2.getTime();
        quot = quot / 1000L / 60L / 60L / 24L;
        return quot;
    }
}

