/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.MiscUtility;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Extthcardpay;
import com.xunlei.payproxy.vo.Extthcardpayok;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.thcardpay.ThcardpayQuery;
import com.xunlei.thcardpay.vo.ReturnData;
import com.xunlei.thcardpay.vo.ThcardRtn;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtThcardPay")
public class ExtthcardpayManageBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExtthcardpayManageBean.class);
    private static Map<String, String> cardMessage = new HashMap<String, String>();

    public String getQuery() {
        logger.debug("Start query extthcardpay list ...");
        Extthcardpay query = (Extthcardpay)this.findBean(Extthcardpay.class, "payproxy_extthcardpayquery");
        if (this.isEmpty(query.getFromdate())) {
            query.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
        }
        if (this.isEmpty(query.getTodate())) {
            query.setTodate(DatetimeUtil.today());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Sheet sheet = facade.queryExtthcardpay(query, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public void setWaitToFail() {
        this.authenticateEdit();
        String moveIds = this.findParameter("noticefailBtn");
        if (this.isNotEmpty(moveIds)) {
            String[] seqIds;
            for (String seqId : seqIds = moveIds.split("\\|")) {
                Extthcardpay data = facade.findExtthcardpayById(Long.parseLong(seqId));
                if (data == null) continue;
                Bizorder bizorderQry = new Bizorder();
                bizorderQry.setXunleipayid(data.getXunleipayid());
                Bizorder bizorder = facade.findBizorder(bizorderQry);
                if (bizorder != null) {
                    if ("N".equals(data.getExtthcardpaystatus())) {
                        logger.debug("\u8ba2\u5355[" + data.getOrderid() + "]\u5df2\u7ecf\u5904\u4e8e\u5931\u8d25\u72b6\u6001,\u4e0d\u8981\u91cd\u590d\u5b9a\u5236!");
                        this.alertJS("\u8ba2\u5355\u5df2\u7ecf\u5904\u4e8e\u5931\u8d25\u72b6\u6001,\u4e0d\u8981\u91cd\u590d\u5b9a\u5236!");
                        continue;
                    }
                    data.setExtthcardpaystatus("N");
                    data.setRemark(this.noticefail_remark(data.getRemark().trim()) + "|\u7f6e\u4e3a\u5931\u8d25");
                    facade.updateExtthcardpay(data);
                    bizorder.setOrderstatus("N");
                    facade.updateBizorder(bizorder);
                    this.alertJS("\u7f6e\u4e3a\u5931\u8d25\u6210\u529f!");
                    continue;
                }
                this.alertJS("\u4e0d\u5b58\u5728\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a[" + data.getXunleipayid() + "]\u7684\u8bf7\u6c42\u8ba2\u5355");
            }
        }
    }

    public void setToSuccess() {
        this.authenticateEdit();
        String moveIds = this.findParameter("noticebtn");
        logger.debug("moveids:" + moveIds);
        if (this.isNotEmpty(moveIds)) {
            String[] seqids;
            for (String seqid : seqids = moveIds.split("\\|")) {
                Extthcardpay data = facade.findExtthcardpayById(Long.parseLong(seqid));
                if (data == null) continue;
                try {
                    logger.debug("\u5f00\u59cb\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c...");
                    boolean query = CustomUtil.isQuery((String)"thcardpay");
                    logger.info("query:" + query + "\torderid:" + data.getOrderid());
                    if (!query) {
                        this.moveToSuccess(data, null);
                        continue;
                    }
                    ReturnData returnData = ThcardpayQuery.querySingle((String)data.getOrderid(), (String)data.getThcardno(), (double)data.getOrderamt());
                    if (returnData == null) {
                        logger.debug("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38:ReturnData is null");
                        return;
                    }
                    if ("1".equals(returnData.getRtncode())) {
                        if (returnData.getThcardrtn().size() <= 0) continue;
                        ThcardRtn retdata = (ThcardRtn)returnData.getThcardrtn().get(0);
                        this.moveToSuccess(data, retdata);
                        continue;
                    }
                    this.alertJS(returnData.getRtnmsg());
                }
                catch (Exception e) {
                    this.alertJS("\u5b9a\u5236\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38,\u5b9a\u5236\u5931\u8d25!");
                    logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }

    private void moveToSuccess(Extthcardpay extthcardpay, ThcardRtn rtndata) {
        logger.debug("Start move to success...");
        Extthcardpayok extthcardpayok = new Extthcardpayok();
        extthcardpayok.setOrderid(extthcardpay.getOrderid());
        extthcardpayok.setOrderamt(extthcardpay.getOrderamt());
        extthcardpayok.setThcardno(extthcardpay.getThcardno());
        extthcardpayok.setBizorderstatus("Y");
        if (rtndata != null) {
            extthcardpayok.setSuccesstime(rtndata.getPayDate());
            extthcardpayok.setBalancedate(rtndata.getPayDate());
        } else {
            extthcardpayok.setSuccesstime(MiscUtility.timeofnow());
            extthcardpayok.setBalancedate(MiscUtility.dateofnow());
        }
        facade.moveExtthcardpayToSuccess(extthcardpayok);
        Extthcardpayok query = new Extthcardpayok();
        query.setOrderid(extthcardpay.getOrderid());
        Extthcardpayok result = facade.findExtthcardpayok(query);
        if (null != result) {
            result.setRemark(this.noticefail_remark(result.getRemark()));
            facade.updateExtthcardpayok(result);
        }
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extthcardpay.getOrderid());
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }

    public String checkOrderStatus() {
        String orderid = this.findParameter("thcard_orderid");
        String thcardno = this.findParameter("thcard_cardno");
        String buynum = this.findParameter("thcard_buynum");
        double ibuyNum = Double.parseDouble(buynum);
        logger.debug("param:orderid[" + orderid + "],thcard[" + thcardno + "],buynum[" + buynum + "]");
        try {
            ReturnData result = ThcardpayQuery.querySingle((String)orderid, (String)thcardno, (double)ibuyNum);
            if (result == null) {
                logger.debug("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38:ReturnData is null");
                return "";
            }
            logger.debug("Rtncode:" + result.getRtncode() + ",Rtnmsg:" + result.getRtnmsg());
            if ("1".equals(result.getRtncode())) {
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            } else {
                this.alertJS(result.getRtnmsg());
            }
        }
        catch (Exception e) {
            logger.debug("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38:" + e.getMessage());
            this.alertJS("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38");
        }
        return "";
    }

    public Map<String, String> getErrMessage() {
        return cardMessage;
    }

    static {
        cardMessage.put("0", "\u672a\u77e5\u5f02\u5e38");
        cardMessage.put("1", "\u6210\u529f");
        cardMessage.put("-1", "\u53c2\u6570\u9a8c\u8bc1\u5f02\u5e38");
        cardMessage.put("-2", "\u4e00\u5361\u901a\u9a8c\u8bc1\u5f02\u5e38");
        cardMessage.put("-3", "\u8d26\u6237\u9a8c\u8bc1\u5f02\u5e38");
        cardMessage.put("-4", "\u652f\u4ed8\u7c7b\u578b\u9a8c\u8bc1\u5f02\u5e38");
        cardMessage.put("-5", "\u8ba2\u5355\u9a8c\u8bc1\u5f02\u5e38");
        cardMessage.put("-6", "\u652f\u4ed8\u64cd\u4f5c\u5f02\u5e38");
        cardMessage.put("2", "\u89e3\u6790\u8bf7\u6c42\u7ed3\u679c\u5f02\u5e38");
        cardMessage.put("3", "\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f");
        cardMessage.put("4", "\u8fd4\u56de\u7ed3\u679c\u7684\u8ba2\u5355\u53f7\u4e0d\u4e00\u81f4");
        cardMessage.put("5", "\u8fd4\u56de\u7ed3\u679c\u7684\u5361\u53f7\u4e0d\u4e00\u81f4");
        cardMessage.put("6", "\u8fd4\u56de\u7ed3\u679c\u7684\u8ba2\u5355\u91d1\u989d\u4e0d\u4e00\u81f4");
    }
}

