/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.tenpay.OrderQueryResult;
import com.xunlei.payproxy.tenpay.TenpayUtil;
import com.xunlei.payproxy.util.Arith;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Exttenpay;
import com.xunlei.payproxy.vo.Exttenpayok;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExttenpay")
public class ExttenpayManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExttenpayManagedBean.class);
    private static IFacade facade = IFacade.INSTANCE;
    private static Map<String, String> banktypeMap;
    private static SelectItem[] banktypeItem;

    public String getQuery() {
        this.authenticateRun();
        Exttenpay exttenpay = (Exttenpay)this.findBean(Exttenpay.class, "payproxy_exttenpay");
        if (StringTools.isEmpty((String)exttenpay.getFromdate())) {
            exttenpay.setFromdate(DatetimeUtil.today());
        }
        if (StringTools.isEmpty((String)exttenpay.getTodate())) {
            exttenpay.setTodate(DatetimeUtil.today());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputTime desc");
        Sheet sheet = facade.queryExttenpay(exttenpay, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public void moveExttenpayToSuccess() {
        this.authenticateEdit();
        String moveIds = this.findParameter("noticesuccBtn");
        if (this.isNotEmpty(moveIds)) {
            String[] seqIds;
            for (String seqId : seqIds = moveIds.split("\\|")) {
                Exttenpay exttenpayQry = new Exttenpay();
                exttenpayQry.setSeqid(Long.parseLong(seqId));
                Exttenpay exttenpay = facade.findExttenpay(exttenpayQry);
                if (exttenpay == null) continue;
                boolean query = CustomUtil.isQuery((String)"tenpay");
                logger.info("query:" + query + "\torderid:" + exttenpay.getOrderid());
                if (!query) {
                    this.doMove(exttenpay);
                    continue;
                }
                this.doCheckMove(exttenpay);
            }
        }
    }

    public void setWaitToFail() {
        this.authenticateEdit();
        String moveIds = this.findParameter("noticefailBtn");
        if (this.isNotEmpty(moveIds)) {
            String[] seqIds;
            for (String seqId : seqIds = moveIds.split("\\|")) {
                Exttenpay exttenpayQry = new Exttenpay();
                exttenpayQry.setSeqid(Long.parseLong(seqId));
                Exttenpay exttenpay = facade.findExttenpay(exttenpayQry);
                if (exttenpay == null) continue;
                Bizorder bizorderQry = new Bizorder();
                bizorderQry.setXunleipayid(exttenpay.getXunleipayid());
                Bizorder bizorder = facade.findBizorder(bizorderQry);
                if (bizorder != null) {
                    exttenpay.setExttenpaystatus("N");
                    exttenpay.setRemark(this.noticefail_remark(exttenpay.getRemark().trim()));
                    facade.updateExttenpay(exttenpay);
                    bizorder.setOrderstatus("N");
                    facade.updateBizorder(bizorder);
                    continue;
                }
                this.alertJS("\u4e0d\u5b58\u5728\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a" + exttenpay.getXunleipayid() + "\u7684\u8bf7\u6c42\u8ba2\u5355");
            }
        }
    }

    public String getTradeQuery() {
        String queryOrderid = this.findParameter("queryOrderid");
        String queryTransactionid = this.findParameter("queryTransactionid");
        String bizNo = this.findParameter("bizNo");
        try {
            OrderQueryResult result = TenpayUtil.queryOrder((String)queryOrderid, (String)queryTransactionid, (String)bizNo);
            if (result.getRetcode().equals("0")) {
                if (result.getTrade_state().equals("0")) {
                    this.alertJS("\u4ea4\u6613\u6210\u529f");
                } else {
                    this.alertJS("\u67e5\u8be2\u6210\u529f\uff0c\u4ea4\u6613\u5931\u8d25 \uff1a" + result.getRetmsg());
                }
            } else {
                this.alertJS("\u67e5\u8be2\u5931\u8d25\uff1a" + result.getRetmsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public Map<String, String> getBanktypeMap() {
        if (banktypeMap == null) {
            List list = facade.getLibclassdByClassNo("TenpayBankType");
            banktypeMap = new HashMap<String, String>();
            for (Libclassd data : list) {
                banktypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return banktypeMap;
    }

    public SelectItem[] getBanktypeItem() {
        if (banktypeItem == null) {
            List list = facade.getLibclassdByClassNo("TenpayBankType");
            banktypeItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ExttenpayManagedBean.banktypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
            }
        }
        return banktypeItem;
    }

    private void doMove(Exttenpay exttenpay) {
        Exttenpayok exttenpayok = new Exttenpayok();
        exttenpayok.setOrderamt(exttenpay.getOrderamt());
        exttenpayok.setRealbanktype(exttenpay.getBanktype());
        exttenpayok.setTransactionid(exttenpay.getTransactionid());
        exttenpayok.setOrderid(exttenpay.getOrderid());
        exttenpayok.setSuccesstime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        exttenpayok.setBizorderstatus("Y");
        try {
            facade.moveExttenpayToSucc(exttenpay, exttenpayok);
        }
        catch (Exception e) {
            this.alertJS(e.getMessage());
        }
        logger.debug("<============xunleipayid================>" + exttenpay.getXunleipayid());
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)exttenpayok.getXunleipayid());
    }

    private void doCheckMove(Exttenpay exttenpay) {
        block6: {
            String out_trade_no = exttenpay.getOrderid();
            String transaction_id = exttenpay.getTransactionid();
            String bizNo = exttenpay.getExt1();
            try {
                OrderQueryResult result = TenpayUtil.queryOrder((String)out_trade_no, (String)transaction_id, (String)bizNo);
                if (result.getRetcode().equals("0")) {
                    if (result.getTrade_state().equals("0")) {
                        Exttenpayok exttenpayok = new Exttenpayok();
                        double total_fee = Arith.div((double)Integer.parseInt(result.getTotal_fee()), (double)100.0);
                        exttenpayok.setOrderamt(total_fee);
                        exttenpayok.setRealbanktype(result.getBank_type());
                        exttenpayok.setBuyeralias(result.getBuyer_alias());
                        exttenpayok.setBankbillno(result.getBank_billno());
                        exttenpayok.setTransactionid(transaction_id);
                        exttenpayok.setOrderid(out_trade_no);
                        exttenpayok.setSuccesstime(TenpayUtil.parseTenTimeToXl((String)result.getTime_end()));
                        exttenpayok.setBizorderstatus("Y");
                        try {
                            facade.moveExttenpayToSucc(exttenpay, exttenpayok);
                        }
                        catch (Exception e) {
                            this.alertJS(e.getMessage());
                            throw e;
                        }
                        logger.debug("<============xunleipayid================>" + exttenpay.getXunleipayid());
                        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)exttenpayok.getXunleipayid());
                        break block6;
                    }
                    this.alertJS("\u652f\u4ed8\u672a\u6210\u529f\uff1a" + result.getRetmsg());
                    break block6;
                }
                this.alertJS("\u67e5\u8be2\u5931\u8d25\uff1a" + result.getRetmsg());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
            }
        }
    }
}

