/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.xltelemonthlypay.TelemonthlypayQuery;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.vo.Exttelemonthlybind;
import com.xunlei.payproxy.vo.Exttelemonthlypayok;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.DateUtils;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyTelemonthlypayok")
public class ExttelemonthlypayokManagedBean
extends BaseManagedBean {
    private final Logger LOG = LoggerFactory.getLogger(ExttelemonthlypayokManagedBean.class);
    private static Map<String, String> ordertypeMap;
    private static SelectItem[] orderTypeItem;

    public String getQuery() {
        this.LOG.debug("query");
        this.authenticateRun();
        Exttelemonthlypayok data = (Exttelemonthlypayok)this.findBean(Exttelemonthlypayok.class, "payproxy_exttelemonthlypayok");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getFromDate())) {
                data.setFromDate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)data.getToDate())) {
                data.setToDate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid desc");
            Sheet sheet = facade.queryExttelemonthlypayok(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public void checkOrderStatus() {
        String orderid = this.findParameter("query_orderid");
        this.LOG.debug("check order status orderid = " + orderid);
        if (orderid == null || (orderid = orderid.trim()).length() == 0) {
            this.alertJS("\u67e5\u8be2\u7684\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            return;
        }
        Exttelemonthlypayok e = new Exttelemonthlypayok();
        e.setOrderid(orderid);
        e = facade.findExttelemonthlypayok(e);
        if (e == null) {
            this.alertJS("\u6839\u636e\u8ba2\u5355\u53f7: " + orderid + " \u627e\u4e0d\u5230\u4ea4\u6613\u8bb0\u5f55!");
            return;
        }
        String outtradeno = e.getOuttradeno();
        if (outtradeno == null || (outtradeno = outtradeno.trim()).length() == 0) {
            this.alertJS("\u8ba2\u5355 " + orderid + " \u4e0b\u5355\u5931\u8d25,\u6ca1\u6709\u5bf9\u5e94\u7684\u7231\u52a8\u6f2b\u8ba2\u5355\u53f7");
            return;
        }
        Map map = TelemonthlypayQuery.query((String)outtradeno);
        boolean payRes = (Boolean)map.get("payRes");
        if (payRes) {
            this.LOG.debug("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            return;
        }
        String payInfo = (String)map.get("payInfo");
        this.LOG.debug("\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f\uff1a" + payInfo);
        this.alertJS(payInfo);
    }

    public void bindOrder() {
        String orderid = this.findParameter("query_orderid");
        this.LOG.debug("check order status orderid = " + orderid);
        if (orderid == null || (orderid = orderid.trim()).length() == 0) {
            this.alertJS("\u7ed1\u5b9a\u7684\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            return;
        }
        Exttelemonthlypayok e = new Exttelemonthlypayok();
        e.setOrderid(orderid);
        e = facade.findExttelemonthlypayok(e);
        if (e == null) {
            this.alertJS("\u6839\u636e\u8ba2\u5355\u53f7: " + orderid + " \u627e\u4e0d\u5230\u4ea4\u6613\u8bb0\u5f55!");
            return;
        }
        String outtradeno = e.getOuttradeno();
        if (outtradeno == null || (outtradeno = outtradeno.trim()).length() == 0) {
            this.alertJS("\u8ba2\u5355 " + orderid + " \u4e0b\u5355\u5931\u8d25,\u6ca1\u6709\u5bf9\u5e94\u7684\u7231\u52a8\u6f2b\u8ba2\u5355\u53f7");
            return;
        }
        Map map = TelemonthlypayQuery.query((String)outtradeno);
        boolean payRes = (Boolean)map.get("payRes");
        if (payRes) {
            this.LOG.debug("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            Exttelemonthlybind bindQuery = new Exttelemonthlybind();
            bindQuery.setXunleiid(e.getXunleiid());
            bindQuery = IFacade.INSTANCE.findExttelemonthlybind(bindQuery);
            if (bindQuery != null) {
                this.alertJS("xunleiid[" + e.getXunleiid() + "]\u5df2\u7ecf\u7ed1\u5b9a!");
                return;
            }
            bindQuery = new Exttelemonthlybind();
            bindQuery.setMobile(e.getMobile());
            bindQuery = IFacade.INSTANCE.findExttelemonthlybind(bindQuery);
            if (bindQuery != null) {
                this.alertJS("\u624b\u673a\u53f7[" + e.getMobile() + "]\u5df2\u7ecf\u7ed1\u5b9a!");
                return;
            }
            Exttelemonthlybind bindData = this.buildBind(e);
            IFacade.INSTANCE.insertExttelemonthlybind(bindData);
            this.alertJS("\u7ed1\u5b9a\u6210\u529f!");
            return;
        }
        String payInfo = (String)map.get("payInfo");
        this.LOG.debug("\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f\uff1a" + payInfo);
        this.alertJS(payInfo);
    }

    private Exttelemonthlybind buildBind(Exttelemonthlypayok payDataok) {
        this.LOG.info("begin buildBind!");
        Exttelemonthlybind bindData = new Exttelemonthlybind();
        bindData.setOrderid(payDataok.getOrderid());
        bindData.setMobile(payDataok.getMobile());
        bindData.setXunleiid(payDataok.getXunleiid());
        bindData.setUsershow(payDataok.getUsershow());
        bindData.setOrdertime(payDataok.getSuccesstime());
        bindData.setOuttradeno(payDataok.getOuttradeno());
        bindData.setStatus("Y");
        bindData.setSerialno(0);
        String expireDate = "";
        try {
            expireDate = DateUtils.calculateTime(DateUtils.getCurrentTime("yyyy-MM-dd"), "yyyy-MM-dd", "D", 31);
            this.LOG.info("expireDate:{}", (Object)expireDate);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("orderid:{},buildBind expireDate:{}", new Object[]{payDataok.getOrderid(), expireDate});
            }
        }
        catch (ParseException e) {
            this.LOG.error("", (Throwable)e);
        }
        bindData.setExpiredate(expireDate);
        bindData.setAmt(payDataok.getOrderamt());
        bindData.setBizno(payDataok.getBizno());
        bindData.setLastrenewtime(DateUtils.getCurrentTime("yyyy-MM-dd HH:mm:ss"));
        this.LOG.info("bindData:{}", (Object)bindData);
        return bindData;
    }

    public Map<String, String> getOrdertypeMap() {
        if (ordertypeMap == null) {
            ordertypeMap = new HashMap<String, String>();
            ordertypeMap.put("A", "\u652f\u4ed8");
            ordertypeMap.put("D", "\u9000\u6b3e");
        }
        return ordertypeMap;
    }

    public static SelectItem[] getOrderTypeItem() {
        if (orderTypeItem == null) {
            orderTypeItem = new SelectItem[2];
            ExttelemonthlypayokManagedBean.orderTypeItem[0] = new SelectItem((Object)"A", "\u652f\u4ed8");
            ExttelemonthlypayokManagedBean.orderTypeItem[1] = new SelectItem((Object)"D", "\u9000\u6b3e");
        }
        return orderTypeItem;
    }
}

