/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.ExtShengPay;
import com.xunlei.payproxy.vo.ExtShengPayOK;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.shengpay.check.ShengPayCheck;
import com.xunlei.shengpay.check.ShengPayRtn;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtshengpay")
public class ExtshengpayManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtshengpayManagedBean.class);
    private static Map<String, String> paytypeMap;
    private static SelectItem[] paytypeItem;
    private static Map<String, String> bankcodeMap;
    private static SelectItem[] bankcodeItem;
    private static Map<String, String> paystatusMap;
    private static SelectItem[] paystatusItem;
    private static Map<String, String> shengtypeMap;
    private static SelectItem[] shengtypeItem;

    public String getQuery() {
        logger.debug("getQuery...");
        this.authenticateRun();
        ExtShengPay extShengPay = (ExtShengPay)this.findBean(ExtShengPay.class, "payproxy_shengpay");
        if (extShengPay != null) {
            logger.debug("getQuery...extshengpay is not null");
            if (StringTools.isEmpty((String)extShengPay.getStartdate())) {
                extShengPay.setStartdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)extShengPay.getEnddate())) {
                extShengPay.setEnddate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("inputTime desc");
            Sheet sheet = facade.queryExtShengPay(extShengPay, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public void moveExtshengpayToSuccess() throws Exception {
        logger.debug("moveExtshengpayToSuccess...");
        this.authenticateEdit();
        String moveids = this.findParameter("noticesuccBtn");
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            logger.info("moveExtshengpayToSuccess...moveids:{}", (Object)moveids);
            for (String seqid : seqids = moveids.split("\\|")) {
                ExtShengPay extshengpayQuery = new ExtShengPay();
                extshengpayQuery.setSeqid(Long.valueOf(seqid).longValue());
                ExtShengPay extShengPay = facade.findExtShengPay(extshengpayQuery);
                if (extShengPay != null) {
                    logger.debug("seqid = {},orderId={},usershow={}", new Object[]{seqid, extShengPay.getOrderId(), extShengPay.getUsershow()});
                    ShengPayRtn shengPayRtn = ShengPayCheck.queryByOrderId((String)extShengPay.getOrderId());
                    logger.info("moveExtshengpayToSuccess...orderId\uff1a{},success:{}", (Object)extShengPay.getOrderId(), (Object)shengPayRtn.isSuccess());
                    if (shengPayRtn.isSuccess()) {
                        logger.info("moveExtshengpayToSuccess...query success,factamt:{}", (Object)shengPayRtn.getOrderAmt());
                        this.doMove(extShengPay, shengPayRtn);
                        continue;
                    }
                    this.alertJS("\u8ba2\u5355\u53f7\u4e3a\uff1a" + extShengPay.getOrderId() + ",\u67e5\u8be2\u5931\u8d25\uff0c\u65e0\u6cd5\u5b9a\u5236\u6210\u529f");
                    continue;
                }
                logger.info("seqid = {} \u7684\u5217\u4e0d\u5b58\u5728\u4e8e\u8bf7\u6c42\u8868", (Object)seqid);
            }
        } else {
            logger.info("moveExtshengpayToSuccess...\u6ca1\u6709\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5217");
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
        }
    }

    public void setWaitToFail() {
        logger.debug("setWaitToFail...");
        this.authenticateEdit();
        String noticefailIds = this.findParameter("noticefailBtn");
        logger.info("setWaitToFail...noticefailIds\uff1a{}", (Object)noticefailIds);
        if (this.isNotEmpty(noticefailIds)) {
            String[] seqids;
            for (String seqid : seqids = noticefailIds.split("\\|")) {
                ExtShengPay extShengPayQuery = new ExtShengPay();
                extShengPayQuery.setSeqid(Long.valueOf(seqid).longValue());
                extShengPayQuery.setExtpayStatus("W");
                ExtShengPay extShengPay = facade.findExtShengPay(extShengPayQuery);
                if (extShengPay == null) {
                    logger.info("setWaitToFail...seqid:{}, extpaystatus\u4e3aW\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object)seqid);
                    this.alertJS("\u5e8f\u5217\u53f7\u4e3a\uff1a" + seqid + " \u7684\u6570\u636e\u5df2\u7ecf\u4e3a\u5931\u8d25\u72b6\u6001");
                    continue;
                }
                Bizorder bizorderForQuery = new Bizorder();
                bizorderForQuery.setXunleipayid(extShengPay.getOrderId());
                Bizorder bizorder = IFacade.INSTANCE.findBizorder(bizorderForQuery);
                extShengPay.setExtpayStatus("N");
                extShengPay.setRemark(this.noticefail_remark(extShengPay.getRemark().trim()));
                if (bizorder != null) {
                    logger.info("setWaitToFail...seqid:{} \u7684bizorder\u6570\u636e\u5b58\u5728", (Object)seqid);
                    bizorder.setOrderstatus("N");
                    facade.updateExtShengPay(extShengPay);
                    facade.updateBizorder(bizorder);
                    continue;
                }
                this.alertJS("\u4e0d\u5b58\u5728\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a" + extShengPay.getOrderId() + "\u7684\u8bf7\u6c42\u8ba2\u5355");
            }
        } else {
            logger.info("setWaitToFail...\u6ca1\u6709\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5217");
            this.alertJS("\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5217");
        }
    }

    private void doMove(ExtShengPay extShengPay, ShengPayRtn shengPayRtn) {
        logger.debug("domove...");
        ExtShengPayOK extShengPayOK = new ExtShengPayOK();
        extShengPayOK.setOrderId(shengPayRtn.getOrderId());
        extShengPayOK.setOrderAmt(shengPayRtn.getOrderAmt());
        extShengPayOK.setFactAmt(shengPayRtn.getFactAmt());
        extShengPayOK.setSuccessTime(shengPayRtn.getSuccessTime());
        extShengPayOK.setTransNo(shengPayRtn.getTransNo());
        extShengPayOK.setRemark(this.noticeok_remark(extShengPay.getRemark()));
        extShengPayOK.setBizOrderStatus("Y");
        facade.moveExtShengPayToSuccess(extShengPayOK);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extShengPay.getOrderId());
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }

    public String getShengpayQuery() {
        logger.debug("getShengpayQuery...");
        this.authenticateRun();
        String orderid = this.findParameter("shengpay_orderid");
        logger.info("getShengpayQuery...orderid:{}", (Object)orderid);
        try {
            ShengPayRtn shengPayRtn = ShengPayCheck.queryByOrderId((String)orderid);
            logger.info("orderId:{},success:{}", (Object)orderid, (Object)shengPayRtn.isSuccess());
            if (shengPayRtn.isSuccess()) {
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            } else {
                logger.info("orderId\uff1a{} failed,sheng_fu_tong transStatus:{}", (Object)orderid, (Object)shengPayRtn.getTransStatus());
                this.alertJS("\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u76db\u4ed8\u901a\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            this.alertJS("\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u67e5\u8be2\u5f02\u5e38");
        }
        return "";
    }

    public Map<String, String> getPaytypeMap() {
        if (paytypeMap == null) {
            List list = facade.getLibclassdByClassNo("shengpaytype");
            paytypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paytypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paytypeMap;
    }

    public SelectItem[] getPaytypeItem() {
        if (paytypeItem == null) {
            List list = facade.getLibclassdByClassNo("shengpaytype");
            if (list == null) {
                paytypeItem = new SelectItem[0];
            } else {
                paytypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtshengpayManagedBean.paytypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return paytypeItem;
    }

    public Map<String, String> getBankcodeMap() {
        if (bankcodeMap == null) {
            List list = facade.getLibclassdByClassNo("shengbankcode");
            bankcodeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                bankcodeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return bankcodeMap;
    }

    public SelectItem[] getBankcodeItem() {
        if (bankcodeItem == null) {
            List list = facade.getLibclassdByClassNo("shengbankcode");
            if (list == null) {
                bankcodeItem = new SelectItem[0];
            } else {
                bankcodeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtshengpayManagedBean.bankcodeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return bankcodeItem;
    }

    public Map<String, String> getPaystatusMap() {
        if (paystatusMap == null) {
            List list = facade.getLibclassdByClassNo("shengpayorderstatus");
            logger.info("classno:{},size:{}", (Object)"shengpayorderstatus", (Object)list.size());
            paystatusMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paystatusMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paystatusMap;
    }

    public SelectItem[] getPaystatusItem() {
        if (paystatusItem == null) {
            List list = facade.getLibclassdByClassNo("shengpayorderstatus");
            if (list == null) {
                paystatusItem = new SelectItem[0];
            } else {
                paystatusItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtshengpayManagedBean.paystatusItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return paystatusItem;
    }

    public Map<String, String> getShengtypeMap() {
        if (shengtypeMap == null) {
            List list = facade.getLibclassdByClassNo("shengordertype");
            shengtypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                shengtypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return shengtypeMap;
    }

    public SelectItem[] getShengtypeItem() {
        if (shengtypeItem == null) {
            logger.info("getShengtypeItem...shengordertype");
            List list = facade.getLibclassdByClassNo("shengordertype");
            logger.info("getShengtypeItem...list size:{}", (Object)list.size());
            if (list == null || list.isEmpty()) {
                shengtypeItem = new SelectItem[0];
            } else {
                shengtypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtshengpayManagedBean.shengtypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return shengtypeItem;
    }
}

