/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extqishun;
import com.xunlei.payproxy.vo.Extqishunok;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxyutil.qishun.QishunHelper;
import com.xunlei.payproxyutil.result.ResultInfo;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtqishun")
public class ExtqishunManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExtqishunManagedBean.class);
    private static Map<String, String> phonetypeMap;
    private static Map<Integer, String> companytypeMap;
    private static List<SelectItem> companytypeItem;
    private static Hashtable<String, String> producttypeMap;
    private static List<SelectItem> producttypeItem;

    public String getQueryExtqishunList() {
        this.authenticateRun();
        Extqishun extqishun = (Extqishun)this.findBean(Extqishun.class, "payproxy_extqishun");
        if (Utility.isEmpty((String)extqishun.getFromdate())) {
            extqishun.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
        }
        if (Utility.isEmpty((String)extqishun.getTodate())) {
            extqishun.setTodate(DatetimeUtil.today());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Sheet sheet = facade.queryExtqishun(extqishun, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPhonetypeMap() {
        if (phonetypeMap == null) {
            ExtqishunManagedBean extqishunManagedBean = this;
            synchronized (extqishunManagedBean) {
                List list = facade.getLibclassdByClassNo("PhoneType");
                phonetypeMap = new Hashtable<String, String>();
                for (Libclassd data : list) {
                    phonetypeMap.put(data.getItemno(), data.getItemname());
                }
            }
        }
        return phonetypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> getCompanytypeMap() {
        if (companytypeMap == null) {
            ExtqishunManagedBean extqishunManagedBean = this;
            synchronized (extqishunManagedBean) {
                List list = facade.getLibclassdByClassNo("CompanyType");
                companytypeMap = new Hashtable<Integer, String>();
                for (Libclassd data : list) {
                    companytypeMap.put(StringTools.safeToInt((Object)data.getItemno()), data.getItemname());
                }
            }
        }
        return companytypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SelectItem> getCompanytypeItem() {
        if (companytypeItem == null) {
            ExtqishunManagedBean extqishunManagedBean = this;
            synchronized (extqishunManagedBean) {
                List list = facade.getLibclassdByClassNo("CompanyType");
                companytypeItem = new ArrayList<SelectItem>();
                for (Libclassd data : list) {
                    companytypeItem.add(new SelectItem((Object)data.getItemno(), data.getItemname()));
                }
            }
        }
        return companytypeItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getProducttypeMap() {
        if (producttypeMap == null) {
            ExtqishunManagedBean extqishunManagedBean = this;
            synchronized (extqishunManagedBean) {
                List list = facade.getLibclassdByClassNo("QiShunProductType");
                producttypeMap = new Hashtable();
                for (Libclassd data : list) {
                    producttypeMap.put(data.getItemno(), data.getItemname());
                }
            }
        }
        return producttypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SelectItem> getProducttypeItem() {
        if (producttypeItem == null) {
            ExtqishunManagedBean extqishunManagedBean = this;
            synchronized (extqishunManagedBean) {
                List list = facade.getLibclassdByClassNo("QiShunProductType");
                producttypeItem = new ArrayList<SelectItem>();
                for (Libclassd data : list) {
                    producttypeItem.add(new SelectItem((Object)data.getItemno(), data.getItemname()));
                }
            }
        }
        return producttypeItem;
    }

    public void moveExtqishunToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticebtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                Extqishun extqishunForQuery = new Extqishun();
                extqishunForQuery.setSeqid(Long.valueOf(seqid).longValue());
                Extqishun extqishun = facade.findExtqishun(extqishunForQuery);
                if (extqishun.getCompanytype() != 2) {
                    this.alertJS("\u53ea\u80fd\u5bf9\u9f50\u987a\u652f\u4ed8\u4eba\u5de5\u5b9a\u5236");
                    continue;
                }
                if (extqishun == null) continue;
                String orderid = extqishun.getOrderid();
                String balancedate = extqishun.getInputtime();
                int payedamt = extqishun.getPayedamt();
                String productType = extqishun.getProducttype();
                try {
                    logger.debug("\u5f00\u59cb\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c....");
                    boolean query = CustomUtil.isQuery((String)"qishun");
                    if (!query) {
                        logger.info("seqid:" + seqid + "\t\u4e0d\u7528\u67e5\u8ba2\u5355\u7684\u72b6\u6001");
                        this.doMove(extqishun);
                    } else {
                        ResultInfo ri = QishunHelper.getQueryResult((String)productType, (String)orderid, (String)balancedate, (double)payedamt);
                        if (ri.getCode().trim().equals("00")) {
                            this.doMove(extqishun);
                        } else {
                            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + ri.getMessage());
                        }
                    }
                    logger.debug("\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c\u7ed3\u675f....");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void doMove(Extqishun extqishun) {
        extqishun.setRemark(this.noticeok_remark(extqishun.getRemark()));
        facade.updateExtqishun(extqishun);
        Extqishunok extqishunok = new Extqishunok();
        extqishunok.setOrderid(extqishun.getOrderid());
        extqishunok.setPayedamt(extqishun.getPayedamt());
        extqishunok.setBizorderstatus("Y");
        extqishunok.setBalancedate(DatetimeUtil.today());
        extqishunok.setPhonetype(extqishun.getPhonetype());
        extqishunok.setProducttype(extqishunok.getProducttype());
        facade.moveBizorderToSuccess(extqishun.getOrderid());
        facade.moveExtqishunToSuccess(extqishun.getOrderid(), "Y");
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extqishun.getOrderid());
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }

    public void checkOrderStatus() {
        logger.info("ExtqishunManagedBean---checkOrderStatus---run");
        String orderid = this.findParameter("qishun_orderid");
        String producttype = this.findParameter("qishun_producttype");
        String inputtime = this.findParameter("qishun_inputtime");
        String payedamt = this.findParameter("qishun_payedamt");
        logger.info("ExtqishunManagedBean---checkOrderStatus---orderid=" + orderid + ", producttype=" + producttype + ", inputtime=" + inputtime + ", payedamt=" + payedamt);
        try {
            ResultInfo resultInfo = QishunHelper.getQueryResult((String)producttype, (String)orderid, (String)inputtime, (double)Double.parseDouble(payedamt));
            logger.info("result code : " + resultInfo.getCode());
            if (resultInfo.getCode().trim().equals("00")) {
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            } else {
                logger.info("ExtqishunManagedBean---checkOrderStatus-----\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f\uff1a" + resultInfo.getMessage());
                this.alertJS("\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9f50\u987a\u8bf7\u6c42\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

