/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.paypal.query.MonitorPaypalHandler;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extpaypal;
import com.xunlei.payproxy.vo.Extpaypalok;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtpaypal")
public class ExtpaypalManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtpaypalManagedBean.class);
    private static Map<String, String> paypalstatusMap;
    private static SelectItem[] paypalstatusItem;
    private static Map<String, String> errorcodeMap;
    private static SelectItem[] errorcodeItem;

    public String getQuery() {
        logger.info("ExtpaypalManagedBean-----getQuery-----run at : " + new Date());
        this.authenticateRun();
        Extpaypal extpaypal = (Extpaypal)this.findBean(Extpaypal.class, "payproxy_extpaypal");
        if (extpaypal != null) {
            logger.info("ExtpaypalManagedBean-----getQuery-----extpaypal is not null");
            if (StringTools.isEmpty((String)extpaypal.getFromdate())) {
                extpaypal.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)extpaypal.getTodate())) {
                extpaypal.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty(" inputtime desc");
            Sheet sheet = facade.queryExtpaypal(extpaypal, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String moveExtpaypalreqToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticesuccBtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                Extpaypal paypalQuery = new Extpaypal();
                paypalQuery.setSeqid(Long.valueOf(seqid).longValue());
                Extpaypal extpaypal = facade.findExtpaypal(paypalQuery);
                if (extpaypal == null) continue;
                String orderid = extpaypal.getOrderid();
                String transactionid = extpaypal.getTransactionid();
                double orderamt = extpaypal.getOrderamt();
                String orderstatus = extpaypal.getOrderstatus();
                String currencycode = extpaypal.getCurrencycode();
                try {
                    boolean query = CustomUtil.isQuery((String)"paypal");
                    logger.info("query : " + query + ", orderid : " + orderid + ", transactionid : " + transactionid + ", orderamt: " + orderamt + ", orderstatus: " + orderstatus + ", currencycode: " + currencycode);
                    if (!query) {
                        if (transactionid.trim().equals("")) {
                            extpaypal.setTransactionid("-1");
                        }
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("amt", String.valueOf(extpaypal.getOrderamt()));
                        map.put("currencyCode", extpaypal.getCurrencycode());
                        this.doMove(extpaypal, map);
                    } else {
                        MonitorPaypalHandler monitorPaypalHandler = new MonitorPaypalHandler();
                        if (transactionid.trim().equals("")) {
                            this.alertJS("\u6d77\u5916\u652f\u4ed8\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4eba\u5de5\u5b9a\u5236\uff0c\u8bf7\u5173\u95ed\u5b9a\u5236\u67e5\u8be2\u5f00\u5173\uff0c\u7136\u540e\u91cd\u65b0\u5b9a\u5236");
                            return "";
                        }
                        orderstatus = "";
                        HashMap resultMap = monitorPaypalHandler.query(orderid, transactionid, String.valueOf(orderamt), currencycode, orderstatus);
                        logger.info("result code map : " + resultMap);
                        String timeout = ((String)resultMap.get("timeOut")).trim();
                        String checkSuccess = ((String)resultMap.get("checkSuccess")).trim();
                        if (timeout.equals("N") && checkSuccess.equals("Y")) {
                            this.doMove(extpaypal, resultMap);
                        } else if (timeout.equals("Y")) {
                            this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff0c\u65e0\u6cd5\u5b9a\u5236\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                        } else {
                            this.alertJS("\u7f6e\u4e3a\u6210\u529f\u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + (String)resultMap.get("msg"));
                        }
                    }
                    logger.debug("\u4eba\u5de5\u4f5c\u5b9a\u5236\u64cd\u4f5c\u7ed3\u675f.....");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                }
            }
        }
        return "";
    }

    public void doMove(Extpaypal extpaypal, Map<String, String> resultMap) {
        try {
            logger.info("ExtpaypalManagedBean-----moveExtpaypalreqToSuccess----domove\u64cd\u4f5c");
            extpaypal.setRemark(this.noticeok_remark(extpaypal.getRemark()) + "|\u4eba\u5de5\u5b9a\u5236");
            logger.debug(Utility.toStringCommon((Object)extpaypal));
            facade.updateExtpaypal(extpaypal);
            Extpaypalok extpaypalok = new Extpaypalok();
            extpaypalok.setOrderid(extpaypal.getOrderid());
            extpaypalok.setTransactionid(extpaypal.getTransactionid());
            extpaypalok.setOrderamt(this.getValueDoubleStrFromMap(resultMap, "amt"));
            extpaypalok.setCurrencycode(this.getValueStrFromMap(resultMap, "currencyCode"));
            extpaypalok.setPayerstatus(this.getValueStrFromMap(resultMap, "paymentStatus"));
            extpaypalok.setEmail(this.getValueStrFromMap(resultMap, "email"));
            extpaypalok.setPayerid(this.getValueStrFromMap(resultMap, "payerid"));
            extpaypalok.setPayername(this.getValueStrFromMap(resultMap, "payername"));
            extpaypalok.setPayerstatus(this.getValueStrFromMap(resultMap, "payerstatus"));
            extpaypalok.setCountrycode(this.getValueStrFromMap(resultMap, "countrycode"));
            extpaypalok.setPaymenttype(this.getValueStrFromMap(resultMap, "paymenttype"));
            extpaypalok.setChangerate(this.getValueStrFromMap(resultMap, "changerate"));
            extpaypalok.setTranstime(this.getValueStrFromMap(resultMap, "transtime"));
            extpaypalok.setTransdate(this.getValueStrFromMap(resultMap, "transdate"));
            extpaypalok.setFareamt(this.getValueDoubleStrFromMap(resultMap, "feeamt"));
            double factamt = this.getValueDoubleStrFromMap(resultMap, "amt") - this.getValueDoubleStrFromMap(resultMap, "feeamt");
            extpaypalok.setFactamt(factamt);
            logger.info("extpaypalok\u53c2\u6570\u8bbe\u7f6e\u5b8c\u6210");
            extpaypalok.setOrderstatus("Y");
            facade.moveExtpaypalreqToSuccess(extpaypalok);
            PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extpaypal.getOrderid());
            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public String getValueStrFromMap(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null || value.equals("")) {
            value = "";
        }
        return value;
    }

    public double getValueDoubleStrFromMap(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null || value.equals("")) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public String getPaypalQuery() {
        logger.info("ExtpaypalManagedBean-----getPaypalQuery-----run at : " + new Date());
        this.authenticateRun();
        String orderid = this.findParameter("paypal_orderid");
        String transactionid = this.findParameter("paypal_transactionid");
        String currencycode = this.findParameter("paypal_currencycode");
        String orderstatus = "";
        double orderamt = Double.parseDouble(this.findParameter("paypal_orderamt"));
        logger.info("ExtpaypalManagedBean-----getPaypalQuery----orderid= " + orderid);
        try {
            if (transactionid.trim().equals("")) {
                this.alertJS("\u6d77\u5916\u652f\u4ed8\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u67e5\u8be2");
                return "";
            }
            MonitorPaypalHandler monitorPaypalHandler = new MonitorPaypalHandler();
            HashMap resultMap = monitorPaypalHandler.query(orderid, transactionid, String.valueOf(orderamt), currencycode, orderstatus);
            logger.info("result code map : " + resultMap);
            String timeout = ((String)resultMap.get("timeOut")).trim();
            String checkSuccess = ((String)resultMap.get("checkSuccess")).trim();
            String errormsg = ((String)resultMap.get("msg")).trim();
            logger.info("timeout=" + timeout + ", chechsuccess=" + checkSuccess + ", msg=" + errormsg);
            if (timeout.equals("N") && checkSuccess.equals("Y")) {
                logger.info("\u8ba2\u5355\u67e5\u8be2\u6210\u529f");
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            } else if (timeout.equals("N") && checkSuccess.equals("N") && ((String)resultMap.get("isPending")).trim().equals("Y")) {
                logger.info("\u8ba2\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u51bb\u7ed3\u72b6\u6001");
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u5904\u4e8e\u51bb\u7ed3\u4e2d");
            } else if (timeout.equals("Y")) {
                logger.info("\u8ba2\u5355\u67e5\u8be2\u8d85\u65f6");
                this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            } else {
                logger.info("\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6d77\u5916\u652f\u4ed8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return "";
    }

    public Map<String, String> getPaypalstatusMap() {
        List list = facade.getLibclassdByClassNo("paypalstatus");
        paypalstatusMap = new Hashtable<String, String>();
        for (Libclassd data : list) {
            paypalstatusMap.put(data.getItemno(), data.getItemname());
        }
        return paypalstatusMap;
    }

    public SelectItem[] getPaypalstatusItem() {
        List list = facade.getLibclassdByClassNo("paypalstatus");
        if (list == null) {
            paypalstatusItem = new SelectItem[0];
        } else {
            paypalstatusItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ExtpaypalManagedBean.paypalstatusItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
            }
        }
        return paypalstatusItem;
    }

    public Map<String, String> getErrorcodeMap() {
        List list = facade.getLibclassdByClassNo("paypalerrorcode");
        errorcodeMap = new Hashtable<String, String>();
        for (Libclassd data : list) {
            errorcodeMap.put(data.getItemno(), data.getItemname());
        }
        return errorcodeMap;
    }

    public SelectItem[] getErrorcodeItem() {
        List list = facade.getLibclassdByClassNo("paypalerrorcode");
        if (list == null) {
            errorcodeItem = new SelectItem[0];
        } else {
            errorcodeItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ExtpaypalManagedBean.errorcodeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
            }
        }
        return errorcodeItem;
    }
}

