/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.mycard.billing.BillingErrMsgParser;
import com.xunlei.mycard.billing.BillingUtil;
import com.xunlei.mycard.member.MemberReturnMsgsParser;
import com.xunlei.mycard.member.MemberServiceUtil;
import com.xunlei.mycard.member.MemberTradeQuerySingleResult;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Extmycardok;
import com.xunlei.payproxy.vo.Extmycardreq;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="MyCardReq")
public class ExtmycardManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExtmycardManagedBean.class);
    private BillingUtil billingUtil = new BillingUtil();
    private static IFacade facade = IFacade.INSTANCE;
    private static Map<String, String> ordertypeMap;
    private static SelectItem[] ordertypeItem;
    private static Map<String, String> paystatusMap;
    private static SelectItem[] paystatusItem;

    public String getQuery() {
        this.authenticateRun();
        Extmycardreq extmycardreq = (Extmycardreq)this.findBean(Extmycardreq.class, "payproxy_extmycard");
        if (this.isEmpty(extmycardreq.getFromdate())) {
            extmycardreq.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
        }
        if (this.isEmpty(extmycardreq.getTodate())) {
            extmycardreq.setTodate(DatetimeUtil.today());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputTime desc");
        Sheet sheet = facade.queryExtmycardreq(extmycardreq, fliper);
        if (sheet.getRowcount() > 0) {
            Extmycardreq sum = facade.queryExtmycardreqSum(extmycardreq);
            sheet.getDatas().add(sum);
        }
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public void moveExtmycardToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticesuccBtn");
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            logger.info("moveids:" + moveids);
            for (String seqid : seqids = moveids.split("\\|")) {
                Extmycardreq extmycardreqQuery = new Extmycardreq();
                extmycardreqQuery.setSeqid(Long.valueOf(seqid).longValue());
                Extmycardreq extmycardreq = facade.findExtmycardreq(extmycardreqQuery);
                if (extmycardreq == null) continue;
                logger.debug("paytype = " + extmycardreq.getPaytype());
                if (extmycardreq.getPaytype().trim().equals("Q2")) {
                    this.moveMemberReqToSucc(extmycardreq);
                    return;
                }
                String authCodeReq = extmycardreq.getAuthcode();
                boolean query = CustomUtil.isQuery((String)"mycardQ3");
                logger.info("query:" + query + "\torderid:" + extmycardreq.getOrderid());
                if (!query) {
                    this.doMoveQ3(extmycardreq);
                    continue;
                }
                List results = this.billingUtil.queryMycard(authCodeReq);
                String returnmsgno = ((String)results.get(0)).trim();
                if (returnmsgno.equals("1")) {
                    String tradeResult = (String)results.get(2);
                    if (tradeResult.trim().equals("3")) {
                        this.doMoveQ3(extmycardreq);
                        continue;
                    }
                    this.alertJS("\u67e5\u8be2\u6210\u529f \u4ea4\u6613\u5931\u8d25");
                    continue;
                }
                String errMsg = null;
                String errcode = (String)results.get(0);
                errMsg = BillingErrMsgParser.isQueryMsgContainsKey((String)errcode) ? BillingErrMsgParser.getQueryMsgMap((String)errcode) : "\u53d1\u751f\u9519\u8bef";
                this.alertJS("\u9519\u8bef\u7801\u4e3a\uff1a" + errcode + "\n\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + errMsg);
            }
        } else {
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
        }
    }

    private void checkAndConfigTrade(String authCodeReq, String usershow) {
        List checkResults = this.billingUtil.checkMycard(authCodeReq);
        logger.info("checkresults is null?" + (checkResults == null));
        for (String str : checkResults) {
            logger.info("checkstr-->" + str);
        }
        this.billingUtil.setCPMemberId(usershow);
        List verifyResults = this.billingUtil.verifyMycard(authCodeReq);
        for (String str : verifyResults) {
            logger.info("verifystr-->" + str);
        }
    }

    public void moveMemberReqToSucc(Extmycardreq extmycardreq) {
        String authCode = extmycardreq.getAuthcode();
        String otp = extmycardreq.getOtp();
        boolean query = CustomUtil.isQuery((String)"mycardQ2");
        logger.info("query:" + query + "\torderid:" + extmycardreq.getOrderid());
        if (!query) {
            this.doMoveQ2(extmycardreq);
        } else {
            try {
                MemberTradeQuerySingleResult result = MemberServiceUtil.queryMemberTradeSingleResult((String)authCode, (String)otp);
                String returnMsgNo = result.getReturnMsgNo().trim();
                if (returnMsgNo.equals("1")) {
                    String tradeResult = result.getTradeResult();
                    if (tradeResult != null && tradeResult.trim().equals("3")) {
                        this.doMoveQ2(extmycardreq);
                    } else {
                        this.alertJS("\u67e5\u8be2\u6210\u529f \u4ea4\u6613\u5931\u8d25");
                    }
                } else {
                    String returnMsg = "";
                    returnMsg = MemberReturnMsgsParser.getTradequerysingleResultMsg((String)returnMsgNo);
                    if (returnMsg == null || returnMsg.trim().isEmpty()) {
                        returnMsg = "\u672a\u77e5\u9519\u8bef";
                    }
                    this.alertJS(returnMsg);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void doMoveQ2(Extmycardreq extmycardreq) {
        extmycardreq.setRemark(this.noticeok_remark(extmycardreq.getRemark()));
        facade.updateExtmycardreq(extmycardreq);
        Extmycardok extmycardok = new Extmycardok();
        extmycardok.setBizorderstatus("Y");
        extmycardok.setOrderid(extmycardreq.getOrderid());
        Bizorder bizorderQry = new Bizorder();
        bizorderQry.setXunleipayid(extmycardreq.getOrderid());
        Bizorder bizorder = facade.findBizorder(bizorderQry);
        if (bizorder != null) {
            facade.moveMemberMyCardReqToSucc(extmycardok);
            PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extmycardreq.getOrderid());
            logger.info("orderId = " + extmycardreq.getOrderid());
        }
    }

    private void doMoveQ3(Extmycardreq extmycardreq) {
        extmycardreq.setRemark(this.noticeok_remark(extmycardreq.getRemark()));
        facade.updateExtmycardreq(extmycardreq);
        Extmycardok extmycardok = new Extmycardok();
        extmycardok.setOrderid(extmycardreq.getOrderid());
        extmycardok.setBizorderstatus("Y");
        Bizorder bizorderQry = new Bizorder();
        bizorderQry.setXunleipayid(extmycardreq.getOrderid());
        Bizorder bizorder = IFacade.INSTANCE.findBizorder(bizorderQry);
        if (bizorder != null) {
            facade.moveBillingExtmycardreqToSuccess(extmycardok);
            logger.info("=========orderId=================" + extmycardok.getOrderid());
            PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extmycardreq.getOrderid());
        } else {
            this.alertJS("\u4e0d\u5b58\u5728\u6b64\u8ba2\u5355\u53f7\u7684\u8ba2\u5355");
        }
    }

    public void setWaitToFail() {
        this.authenticateAdd();
        String noticefailIds = this.findParameter("noticefailBtn");
        logger.info("noticefailIds\uff1a" + noticefailIds);
        if (this.isNotEmpty(noticefailIds)) {
            String[] seqids;
            for (String seqid : seqids = noticefailIds.split("\\|")) {
                Extmycardreq extmycardreqQuery = new Extmycardreq();
                extmycardreqQuery.setSeqid(Long.valueOf(seqid).longValue());
                extmycardreqQuery.setExtmycardstatus("W");
                Extmycardreq extmycardreq = facade.findExtmycardreq(extmycardreqQuery);
                Bizorder bizorderForQuery = new Bizorder();
                bizorderForQuery.setXunleipayid(extmycardreq.getOrderid());
                Bizorder bizorder = IFacade.INSTANCE.findBizorder(bizorderForQuery);
                extmycardreq.setExtmycardstatus("N");
                extmycardreq.setRemark(this.noticefail_remark(extmycardreq.getRemark().trim()));
                bizorder.setOrderstatus("N");
                if (bizorder != null) {
                    facade.updateExtmycardreq(extmycardreq);
                    facade.updateBizorder(bizorder);
                    continue;
                }
                this.alertJS("\u4e0d\u5b58\u5728\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a" + extmycardreq.getOrderid() + "\u7684\u8bf7\u6c42\u8ba2\u5355");
            }
        } else {
            this.alertJS("\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getbillingTradeQuery() {
        this.authenticateRun();
        String authCode = this.findParameter("billing_authcode");
        Extmycardreq query = new Extmycardreq();
        query.setAuthcode(authCode);
        Extmycardreq data = facade.findExtmycardreq(query);
        if (data != null) {
            this.checkAndConfigTrade(authCode, data.getUsershow());
        }
        try {
            List queryResultList = this.billingUtil.queryMycard(authCode);
            String queryResult = ((String)queryResultList.get(0)).trim();
            if (queryResult.equals("1")) {
                String tradeResult = (String)queryResultList.get(2);
                if (tradeResult.equals("0")) {
                    this.alertJS("\u67e5\u8be2\u6210\u529f\uff0c\u4ea4\u6613\u5931\u8d25");
                } else {
                    this.alertJS("\u67e5\u8be2\u6210\u529f\uff0c\u4ea4\u6613\u6210\u529f");
                }
            } else {
                String queryMsg = "\u672a\u77e5\u9519\u8bef";
                if (BillingErrMsgParser.isQueryMsgContainsKey((String)queryResult)) {
                    queryMsg = BillingErrMsgParser.getQueryMsgMap((String)queryResult);
                }
                Extmycardreq extmycardreqQuery = new Extmycardreq();
                extmycardreqQuery.setAuthcode(authCode);
                Extmycardreq extmycardreq = facade.findExtmycardreq(extmycardreqQuery);
                extmycardreq.setErrcode(queryResult);
                extmycardreq.setErrmsg(queryMsg);
                facade.updateExtmycardreq(extmycardreq);
                this.alertJS("\u9519\u8bef\u7801\u4e3a\uff1a " + queryResult + ",\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a " + queryMsg);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return "";
    }

    public Map<String, String> getOrdertypeMap() {
        if (ordertypeMap == null) {
            List list = facade.getLibclassdByClassNo("mycardPayType");
            ordertypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                ordertypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return ordertypeMap;
    }

    public SelectItem[] getOrdertypeItem() {
        if (ordertypeItem == null) {
            List list = facade.getLibclassdByClassNo("mycardPayType");
            if (list == null) {
                ordertypeItem = new SelectItem[0];
            } else {
                ordertypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtmycardManagedBean.ordertypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return ordertypeItem;
    }

    public Map<String, String> getPaystatusMap() {
        if (paystatusMap == null) {
            List list = facade.getLibclassdByClassNo("PayStatus");
            paystatusMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paystatusMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paystatusMap;
    }

    public SelectItem[] getPaystatusItem() {
        if (paystatusItem == null) {
            List list = facade.getLibclassdByClassNo("PayStatus");
            if (list == null) {
                paystatusItem = new SelectItem[0];
            } else {
                paystatusItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtmycardManagedBean.paystatusItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return paystatusItem;
    }
}

