/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.thirdparty.client.ThirdpartyQueryClient;
import com.xunlei.channel.thirdparty.vo.QueryRequest;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.ExtJingdongPayOk;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.Properties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyJingdongpayok")
public class ExtjingdongpayokManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtjingdongpayokManagedBean.class);
    private static Map<String, String> payTypeMap;
    private static SelectItem[] payTypeItem;

    public Map<String, String> getPayTypeMap() {
        if (null == payTypeMap) {
            payTypeMap = new HashMap<String, String>();
            payTypeMap.put("JD", "\u4eac\u4e1c\u652f\u4ed8");
            payTypeMap.put("JS", "\u4eac\u4e1c\u626b\u7801");
            payTypeMap.put("J5", "\u4eac\u4e1cH5");
        }
        return payTypeMap;
    }

    public SelectItem[] getPayTypeItem() {
        if (payTypeItem == null) {
            payTypeItem = new SelectItem[3];
            ExtjingdongpayokManagedBean.payTypeItem[0] = new SelectItem((Object)"JD", "\u4eac\u4e1c\u652f\u4ed8");
            ExtjingdongpayokManagedBean.payTypeItem[1] = new SelectItem((Object)"JS", "\u4eac\u4e1c\u626b\u7801");
            ExtjingdongpayokManagedBean.payTypeItem[2] = new SelectItem((Object)"J5", "\u4eac\u4e1cH5");
        }
        return payTypeItem;
    }

    public String getQuery() {
        logger.debug("entering ExtjingdongpayokManagedBean getQuery()...");
        this.authenticateRun();
        ExtJingdongPayOk data = (ExtJingdongPayOk)this.findBean(ExtJingdongPayOk.class, "payproxy_extjingdongpayok");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getFromdate())) {
                data.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)data.getTodate())) {
                data.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid desc");
            Sheet sheet = facade.queryExtJingdongPayOk(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String checkOrderStatus() throws ParseException {
        this.authenticateRun();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String xunleiPayId = this.findParameter("query_xunleiPayId");
        if (StringUtils.isEmpty((String)xunleiPayId)) {
            this.alertJS("\u51fa\u73b0\u5f02\u5e38\uff0c\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a\u7a7a");
            return "";
        }
        ExtJingdongPayOk extJingdongPayOk = facade.findExtJingdongPayOkByXunleiPayId(xunleiPayId);
        Bizorderok bizorderok = new Bizorderok();
        bizorderok.setXunleipayid(xunleiPayId);
        bizorderok = facade.findBizorderok(bizorderok);
        QueryRequest request = new QueryRequest(xunleiPayId, extJingdongPayOk.getPayType(), (int)(extJingdongPayOk.getOrderAmt() * 100.0), extJingdongPayOk.getXunleiId(), extJingdongPayOk.getUserShow(), bizorderok.getBankno(), extJingdongPayOk.getBizOrderId(), "{\"merchantNum\":\"" + extJingdongPayOk.getMerchantNo() + "\"}", sdf.parse(extJingdongPayOk.getInputTime()), "", "");
        String propertiesName = "";
        if (extJingdongPayOk.getPayType().equals("JD")) {
            propertiesName = "jdpayweb";
        } else if (extJingdongPayOk.getPayType().equals("JS")) {
            propertiesName = "jdpaycode";
        } else if (extJingdongPayOk.getPayType().equals("J5")) {
            propertiesName = "jdpayh5";
        }
        Map<String, String> channelConfigMap = Properties.getPayTypeConfigMap(propertiesName);
        if (extJingdongPayOk.getPayType().equals("JS")) {
            channelConfigMap.put("merchant_no", extJingdongPayOk.getMerchantNo());
        }
        if (extJingdongPayOk.getPayType().equals("J5")) {
            channelConfigMap.put("merchant", extJingdongPayOk.getMerchantNo());
            channelConfigMap.put("tradeNum", extJingdongPayOk.getXunleiPayId());
            channelConfigMap.put("tradeType", "0");
        }
        QueryResponse response = ThirdpartyQueryClient.query3rdPartyOrder((QueryRequest)request, channelConfigMap);
        this.alertJS(response.getErrMsg());
        return "";
    }
}

