/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.thirdparty.client.ThirdpartyQueryClient;
import com.xunlei.channel.thirdparty.vo.QueryRequest;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.MiscUtility;
import com.xunlei.payproxy.vo.ExtJingdongPay;
import com.xunlei.payproxy.vo.ExtJingdongPayOk;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.Properties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyJingdongpay")
public class ExtjingdongpayManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtjingdongpayManagedBean.class);
    private static Map<String, String> payTypeMap;
    private static SelectItem[] payTypeItem;

    public Map<String, String> getPayTypeMap() {
        if (null == payTypeMap) {
            payTypeMap = new HashMap<String, String>();
            payTypeMap.put("JD", "\u4eac\u4e1c\u652f\u4ed8");
            payTypeMap.put("JS", "\u4eac\u4e1c\u626b\u7801");
            payTypeMap.put("J5", "\u4eac\u4e1cH5");
        }
        return payTypeMap;
    }

    public SelectItem[] getPayTypeItem() {
        if (payTypeItem == null) {
            payTypeItem = new SelectItem[3];
            ExtjingdongpayManagedBean.payTypeItem[0] = new SelectItem((Object)"JD", "\u4eac\u4e1c\u652f\u4ed8");
            ExtjingdongpayManagedBean.payTypeItem[1] = new SelectItem((Object)"JS", "\u4eac\u4e1c\u626b\u7801");
            ExtjingdongpayManagedBean.payTypeItem[2] = new SelectItem((Object)"J5", "\u4eac\u4e1cH5");
        }
        return payTypeItem;
    }

    public String getQuery() {
        logger.debug("entering ExtjingdongpayManagedBean getQuery() ...");
        this.authenticateRun();
        ExtJingdongPay data = (ExtJingdongPay)this.findBean(ExtJingdongPay.class, "payproxy_extjingdongpay");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getFromdate())) {
                data.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getTodate())) {
                data.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtJingdongPay(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String checkOrderStatus() throws ParseException {
        this.authenticateRun();
        String xunleiPayId = this.findParameter("query_xunleiPayId");
        if (StringUtils.isEmpty((String)xunleiPayId)) {
            this.alertJS("\u51fa\u73b0\u5f02\u5e38\uff0c\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a\u7a7a");
            return "";
        }
        ExtJingdongPayOk extJingdongPayOk = facade.findExtJingdongPayOkByXunleiPayId(xunleiPayId);
        if (null != extJingdongPayOk) {
            this.alertJS("\u8be5\u8ba2\u5355\u5df2\u6210\u529f");
            return "";
        }
        ExtJingdongPay extJingdongPay = facade.findExtJingdongPayByXunleiPayId(xunleiPayId);
        QueryResponse response = this.getQuery3rdPartyResult(extJingdongPay);
        this.alertJS(response.getErrMsg());
        return "";
    }

    public QueryResponse getQuery3rdPartyResult(ExtJingdongPay extJingdongPay) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QueryRequest request = new QueryRequest(extJingdongPay.getXunleiPayId(), extJingdongPay.getPayType(), (int)(extJingdongPay.getOrderAmt() * 100.0), extJingdongPay.getXunleiId(), extJingdongPay.getUserShow(), "", extJingdongPay.getBizOrderId(), "{\"merchantNum\":\"" + extJingdongPay.getMerchantNo() + "\"}", sdf.parse(extJingdongPay.getInputTime()), "", "");
        String propertiesName = "";
        if (extJingdongPay.getPayType().equals("JD")) {
            propertiesName = "jdpayweb";
        } else if (extJingdongPay.getPayType().equals("JS")) {
            propertiesName = "jdpaycode";
        } else if (extJingdongPay.getPayType().equals("J5")) {
            propertiesName = "jdpayh5";
        }
        Map<String, String> channelConfigMap = Properties.getPayTypeConfigMap(propertiesName);
        if (extJingdongPay.getPayType().equals("J5")) {
            channelConfigMap.put("merchant", extJingdongPay.getMerchantNo());
            channelConfigMap.put("tradeNum", extJingdongPay.getXunleiPayId());
            channelConfigMap.put("tradeType", "0");
        }
        QueryResponse response = ThirdpartyQueryClient.query3rdPartyOrder((QueryRequest)request, channelConfigMap);
        return response;
    }

    public String moveExtJingdongPayToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticeBtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                ExtJingdongPay extJingdongPayQuery = new ExtJingdongPay();
                extJingdongPayQuery.setSeqid(Long.valueOf(seqid).longValue());
                ExtJingdongPay extJingdongPay = facade.findExtJingdongPay(extJingdongPayQuery);
                if (extJingdongPay == null) continue;
                String xunleiPayId = extJingdongPay.getXunleiPayId();
                try {
                    logger.debug("\u5f00\u59cb\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c....");
                    boolean query = CustomUtil.isQuery((String)"jdpayweb");
                    logger.info("jdpayweb query:" + query + "\txunleipayid:" + xunleiPayId);
                    if (!query) {
                        this.doMove(extJingdongPay);
                    } else {
                        QueryResponse response = this.getQuery3rdPartyResult(extJingdongPay);
                        if (response.isQuerySuccess()) {
                            this.doMove(extJingdongPay);
                        } else {
                            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25\uff0c\u4fe1\u606f\u4e3a\uff1a" + response.getErrMsg());
                        }
                    }
                    logger.debug("\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c\u7ed3\u675f....");
                }
                catch (Exception e) {
                    this.alertJS("\u5b9a\u5236\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38,\u5b9a\u5236\u5931\u8d25!");
                    logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    private void doMove(ExtJingdongPay extJingdongPay) {
        String remark = this.noticeok_remark(extJingdongPay.getRemark());
        ExtJingdongPayOk extJingdongPayOk = new ExtJingdongPayOk();
        extJingdongPayOk.setBalanceDate(MiscUtility.dateofnow());
        extJingdongPayOk.setBizNo(extJingdongPay.getBizNo());
        extJingdongPayOk.setBizOrderId(extJingdongPay.getBizOrderId());
        extJingdongPayOk.setChannelOrderId(null);
        extJingdongPayOk.setExt1(null);
        extJingdongPayOk.setExt2(null);
        extJingdongPayOk.setInputTime(MiscUtility.timeofnow());
        extJingdongPayOk.setMerchantNo(extJingdongPay.getMerchantNo());
        extJingdongPayOk.setOrderAmt(extJingdongPay.getOrderAmt());
        extJingdongPayOk.setPayType(extJingdongPay.getPayType());
        extJingdongPayOk.setRemark(remark);
        extJingdongPayOk.setSuccessTime(MiscUtility.timeofnow());
        extJingdongPayOk.setUserShow(extJingdongPay.getUserShow());
        extJingdongPayOk.setXunleiId(extJingdongPay.getXunleiId());
        extJingdongPayOk.setXunleiPayId(extJingdongPay.getXunleiPayId());
        facade.moveExtJingdongPayToSuccess(extJingdongPayOk);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extJingdongPayOk.getXunleiPayId());
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }
}

