/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.alipaydut.AlipaydutVo;
import com.xunlei.channel.alipaydut.QueryForSign;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.util.TimeUtil;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extcontractok;
import com.xunlei.payproxy.vo.Extcontractreq;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtcontractreq")
public class ExtcontractreqManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtcontractreqManagedBean.class);

    public String getQuery() {
        logger.info("ExtcontractreqManagedBean-----getQuery-----run at : " + new Date());
        this.authenticateRun();
        Extcontractreq extcontractreq = (Extcontractreq)this.findBean(Extcontractreq.class, "payproxy_contractreq");
        if (extcontractreq != null) {
            logger.info("ExtcontractreqManagedBean-----getQuery-----extcontractreq is not null");
            if (StringTools.isEmpty((String)extcontractreq.getFromdate())) {
                extcontractreq.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)extcontractreq.getTodate())) {
                extcontractreq.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("reqtime desc");
            Sheet sheet = facade.queryExtcontractreq(extcontractreq, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public void moveExtcontractreqToSuccess() throws Exception {
        logger.info("ExtcontractreqManagedBean-----moveExtcontractreqToSuccess-----run at : " + new Date());
        this.authenticateEdit();
        String moveids = this.findParameter("noticesuccBtn");
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            logger.info("ExtcontractreqManagedBean-----moveExtcontractreqToSuccess-----moveids:" + moveids);
            for (String seqid : seqids = moveids.split("\\|")) {
                Extcontractreq extcontractreqQuery = new Extcontractreq();
                extcontractreqQuery.setSeqid(Long.valueOf(seqid).longValue());
                Extcontractreq extcontractreq = facade.findExtcontractreq(extcontractreqQuery);
                if (extcontractreq != null) {
                    logger.debug("seqid = " + seqid + ", externalsignno=" + extcontractreq.getExternalsignno() + ", xunleiid=" + extcontractreq.getXunleiid());
                    AlipaydutVo alipaydutVo = QueryForSign.getInstance().queryBySignNo_XunleiId(extcontractreq.getExternalsignno(), extcontractreq.getXunleiid());
                    logger.info("moveExtcontractreqToSuccess-----\u7b7e\u7ea6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + alipaydutVo.isSuccess() + ", status\uff1a" + alipaydutVo.getStatus() + ", externalsignno: " + alipaydutVo.getExternal_sign_no());
                    if (alipaydutVo.isSuccess() && alipaydutVo.getStatus().trim().equals("S")) {
                        logger.info("moveExtcontractreqToSuccess-----\u67e5\u8be2\u6210\u529f");
                        this.doMove(extcontractreq, alipaydutVo);
                        continue;
                    }
                    logger.info("moveExtcontractreqToSuccess-----\u7b7e\u7ea6\u67e5\u8be2\u5931\u8d25");
                    this.alertJS("\u7b7e\u7ea6ID\u4e3a\uff1a" + extcontractreq.getExternalsignno() + ",\u67e5\u8be2\u5931\u8d25\uff0c\u65e0\u6cd5\u5b9a\u5236\u6210\u529f");
                    return;
                }
                logger.info("seqid = " + seqid + " \u7684\u5217\u4e0d\u5b58\u5728\u4e8e\u8bf7\u6c42\u8868");
            }
        } else {
            logger.info("ExtcontractreqManagedBean-----moveExtcontractreqToSuccess-----\u6ca1\u6709\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5217");
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
        }
    }

    private void doMove(Extcontractreq extcontractreq, AlipaydutVo alipaydutVo) {
        logger.info("ExtcontractreqManagedBean-----moveExtcontractreqToSuccess----domove\u64cd\u4f5c");
        extcontractreq.setRemark(this.noticeok_remark(extcontractreq.getRemark()));
        logger.debug(Utility.toStringCommon((Object)extcontractreq));
        Extcontractok extcontractok = new Extcontractok();
        extcontractok.setExternalsignno(extcontractreq.getExternalsignno());
        extcontractok.setItemcode(extcontractreq.getItemcode());
        extcontractok.setXunleiid(extcontractreq.getXunleiid());
        extcontractok.setExt1(extcontractreq.getExt1());
        extcontractok.setProtocolcode(extcontractreq.getProtocolcode());
        extcontractok.setUsershow(extcontractreq.getUsershow());
        extcontractok.setReqtime(extcontractreq.getReqtime());
        extcontractok.setRemark(extcontractreq.getRemark());
        extcontractok.setBgurl(extcontractreq.getBgurl());
        extcontractok.setFgurl(extcontractreq.getFgurl());
        extcontractok.setModifyreqtime(TimeUtil.now());
        extcontractok.setModifyoktime(TimeUtil.now());
        extcontractok.setAlipayuserid(alipaydutVo.getAlipay_userid());
        extcontractok.setBalancedate(alipaydutVo.getSign_date());
        extcontractok.setExt2("");
        extcontractok.setNotifytime(TimeUtil.now());
        extcontractok.setMobile("");
        extcontractok.setUserloginid(alipaydutVo.getUser_logon_id());
        extcontractok.setSuccesstime(TimeUtil.now());
        extcontractok.setStatus("S");
        try {
            facade.insertExtcontractok(extcontractok);
            facade.deleteExtcontractreq(extcontractreq);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25");
            return;
        }
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }

    public String getContractreqQuery() {
        logger.info("ExtcontractreqManagedBean-----getContractreqQuery-----run at : " + new Date());
        this.authenticateRun();
        String externalsignno = this.findParameter("contractreq_externalsignno");
        String xunleiid = this.findParameter("contractreq_xunleiid");
        logger.info("ExtcontractreqManagedBean-----getContractreqQuery-----externalsignno= " + externalsignno + ", xunleiid=" + xunleiid);
        try {
            AlipaydutVo alipaydutVo = QueryForSign.getInstance().queryBySignNo_XunleiId(externalsignno, xunleiid);
            if (alipaydutVo == null) {
                logger.info("ExtcontractreqManagedBean-----getContractreqQuery-----\u83b7\u53d6\u7684\u67e5\u8be2\u7c7b\u4e3a\u7a7a");
                this.alertJS("\u67e5\u8be2\u5931\u8d25");
                return "";
            }
            logger.info("result code : " + alipaydutVo.isSuccess());
            if (alipaydutVo.isSuccess() && alipaydutVo.getStatus().trim().equals("S")) {
                logger.info(" xunleiid : " + alipaydutVo.getXunleiid() + ", externalsianno=" + alipaydutVo.getExternal_sign_no() + "\uff0cstatus=" + alipaydutVo.getStatus());
                this.alertJS("\u7528\u6237[" + xunleiid + "]\u7b7e\u7ea6\u6210\u529f,\u7b7e\u7ea6\u53f7\u4e3a\uff1a" + externalsignno);
            } else if (alipaydutVo.isSuccess() && alipaydutVo.getStatus().trim().equals("U")) {
                logger.info(" xunleiid : " + alipaydutVo.getXunleiid() + ", externalsianno=" + alipaydutVo.getExternal_sign_no() + "\uff0cstatus=" + alipaydutVo.getStatus());
                this.alertJS("\u7528\u6237[" + xunleiid + "]\u5df2\u7ecf\u89e3\u7ea6,\u7b7e\u7ea6\u53f7\u4e3a\uff1a" + externalsignno);
            } else {
                logger.info("\u7528\u6237\u672a\u6210\u529f\uff1aerrorcode: " + alipaydutVo.getErrcode());
                this.alertJS("\u7528\u6237\u7b7e\u7ea6\u672a\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4e00\u952e\u652f\u4ed8\u7b7e\u7ea6\u8bf7\u6c42\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return "";
    }
}

