/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.alipaydut.AlipaydutVo;
import com.xunlei.channel.alipaydut.QueryForSign;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.util.HttpGetAndPostSender;
import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.vo.Extcontractok;
import com.xunlei.payproxy.vo.Extuncontract;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtcontractok")
public class ExtcontractokManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtcontractokManagedBean.class);
    private static Map<String, String> statusMap;
    private static SelectItem[] statusItem;

    public String getQuery() {
        logger.info("ExtcontractokManagedBean-----getQuery-----run at : " + new Date());
        this.authenticateRun();
        Extcontractok extcontractok = (Extcontractok)this.findBean(Extcontractok.class, "payproxy_contractok");
        if (extcontractok != null) {
            logger.info("ExtcontractokManagedBean-----getQuery-----extcontractok is not null");
            if (StringTools.isEmpty((String)extcontractok.getFromdate())) {
                extcontractok.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)extcontractok.getTodate())) {
                extcontractok.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("reqtime desc");
            Sheet sheet = facade.queryExtcontractok(extcontractok, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String moveUncontract() {
        logger.info("ExtcontractokManagedBean-----moveUncontract-----run at : " + new Date());
        this.authenticateEdit();
        String moveids = this.findParameter("noticesuccBtn");
        try {
            if (this.isNotEmpty(moveids)) {
                String[] seqids;
                logger.info("ExtcontractokManagedBean-----moveUncontract-----moveids:" + moveids);
                for (String seqid : seqids = moveids.split("\\|")) {
                    Extcontractok queryExtcontractok = new Extcontractok();
                    queryExtcontractok.setSeqid(Long.parseLong(seqid));
                    Extcontractok extcontractok = facade.findExtcontractok(queryExtcontractok);
                    if (extcontractok != null) {
                        logger.info("moveUncontract-----\u89e3\u7ea6\u7684xunleiid\u4e3a\uff1a" + extcontractok.getXunleiid() + this.getOprationerInfo());
                        this.uncontractByXunleiId(extcontractok.getXunleiid());
                        Thread.sleep(3000L);
                        Extuncontract extuncontract = new Extuncontract();
                        extuncontract.setXunleiid(extcontractok.getXunleiid());
                        extuncontract = facade.findExtuncontract(extuncontract);
                        if (null == extuncontract) {
                            logger.info("according to xunleiid:" + extcontractok.getXunleiid() + ",can not find Extuncontract");
                            continue;
                        }
                        String remark = extuncontract.getRemark();
                        extuncontract.setRemark(remark + this.getOprationerInfo());
                        facade.updateExtuncontract(extuncontract);
                        continue;
                    }
                    this.alertJS("\u6240\u9009\u62e9\u5217\u7684seqid\u9519\u8bef");
                    logger.error("ExtcontractokManagedBean-----moveUncontract-----seqid=" + seqid + "\u4e0d\u5b58\u5728\u4e8e\u7b7e\u7ea6\u6210\u529f\u8868\u4e2d");
                }
            } else {
                logger.info("ExtcontractreqManagedBean-----moveExtcontractreqToSuccess-----\u6ca1\u6709\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5217");
                this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.alertJS("\u64cd\u4f5c\u5931\u8d25");
        }
        return "";
    }

    public String removeUncontract() {
        logger.info("ExtcontractokManagedBean-----removeUncontract-----run at : " + new Date());
        this.authenticateEdit();
        String moveids = this.findParameter("removeBtn");
        String externalsignno = this.findParameter("contractok_externalsignno");
        try {
            if (this.isNotEmpty(moveids)) {
                String[] seqids;
                logger.info("ExtcontractokManagedBean-----removeUncontract-----moveids:" + moveids);
                for (String seqid : seqids = moveids.split("\\|")) {
                    Extcontractok queryExtcontractok = new Extcontractok();
                    queryExtcontractok.setSeqid(Long.parseLong(seqid));
                    Extcontractok extcontractok = facade.findExtcontractok(queryExtcontractok);
                    if (extcontractok != null) {
                        String xunleiId = extcontractok.getXunleiid();
                        logger.info("removeUncontract-----\u89e3\u7ea6\u7684xunleiid\u4e3a\uff1a" + xunleiId + this.getOprationerInfo());
                        AlipaydutVo alipaydutVo = QueryForSign.getInstance().queryBySignNo_XunleiId(externalsignno, extcontractok.getXunleiid());
                        if (alipaydutVo == null) {
                            logger.info("ExtcontractreqManagedBean-----getContractokQuery-----\u83b7\u53d6\u7684\u67e5\u8be2\u7c7b\u4e3a\u7a7a");
                            this.alertJS("\u67e5\u4e0d\u6570\u636e,\u5220\u9664\u5931\u8d25");
                            return "";
                        }
                        if (alipaydutVo.isSuccess() && alipaydutVo.getStatus().trim().equals("S")) {
                            logger.info(" xunleiid : " + alipaydutVo.getXunleiid() + ", externalsianno=" + alipaydutVo.getExternal_sign_no() + "\uff0cstatus=" + alipaydutVo.getStatus());
                            this.alertJS("\u5df2\u7b7e\u7ea6\u7528\u6237\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
                            continue;
                        }
                        logger.info(" xunleiid : " + alipaydutVo.getXunleiid() + ", externalsianno=" + alipaydutVo.getExternal_sign_no() + "\uff0cstatus=" + alipaydutVo.getStatus());
                        facade.deleteExtcontractok(extcontractok);
                        this.alertJS("\u5220\u9664\u5df2\u89e3\u7ea6\u6570\u636e,\u6210\u529f");
                        continue;
                    }
                    this.alertJS("\u6240\u9009\u62e9\u5217\u7684seqid\u9519\u8bef");
                    logger.error("ExtcontractokManagedBean-----moveUncontract-----seqid=" + seqid + "\u4e0d\u5b58\u5728\u4e8e\u7b7e\u7ea6\u6210\u529f\u8868\u4e2d");
                }
            } else {
                logger.info("ExtcontractreqManagedBean-----moveExtcontractreqToSuccess-----\u6ca1\u6709\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u5217");
                this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.alertJS("\u64cd\u4f5c\u5931\u8d25");
        }
        return "";
    }

    private String getOprationerInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("|uncontract by user:").append(this.currentUserLogo()).append(",ip:").append(this.currentUserLogIP());
        return sb.toString();
    }

    public void uncontractByXunleiId(String xunleiid) {
        logger.info("uncontractByXunleiId run at :" + new Date());
        try {
            ResourceBundle rb = ResourceBundle.getBundle("dutquery");
            String queryUrl = rb.getString("queryUrl");
            String bizno = rb.getString("bizno");
            String bizkey = rb.getString("bizkey");
            String type = "U";
            StringBuffer signMsg = new StringBuffer();
            signMsg.append("bizNo=").append(bizno).append("&");
            signMsg.append("type=").append(type).append("&");
            signMsg.append("xunleiId=").append(xunleiid);
            String sign = Md5Encrypt.md5((String)(signMsg.toString() + bizkey));
            StringBuffer query = new StringBuffer(queryUrl);
            query.append(signMsg.toString()).append("&signMsg=").append(sign);
            logger.info("uncontractUrl-->" + query.toString());
            HttpGetAndPostSender.sendGet((String)query.toString());
            this.alertJS("\u8fc5\u96f7ID[" + xunleiid + "]\u7684\u89e3\u7ea6\u8bf7\u6c42\u5df2\u7ecf\u53d1\u9001");
        }
        catch (Exception e) {
            logger.error("uncontractByXunleiId-----\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
    }

    public String getContractokQuery() {
        logger.info("ExtcontractokManagedBean-----getContractokQuery-----run at : " + new Date());
        this.authenticateRun();
        String externalsignno = this.findParameter("contractok_externalsignno");
        String xunleiid = this.findParameter("contractok_xunleiid");
        logger.info("ExtcontractokManagedBean-----getContractokQuery-----externalsignno= " + externalsignno + ", xunleiid=" + xunleiid);
        try {
            AlipaydutVo alipaydutVo = QueryForSign.getInstance().queryBySignNo_XunleiId(externalsignno, xunleiid);
            if (alipaydutVo == null) {
                logger.info("ExtcontractreqManagedBean-----getContractokQuery-----\u83b7\u53d6\u7684\u67e5\u8be2\u7c7b\u4e3a\u7a7a");
                this.alertJS("\u67e5\u8be2\u5931\u8d25");
                return "";
            }
            logger.info("result code : " + alipaydutVo.isSuccess());
            if (alipaydutVo.isSuccess() && alipaydutVo.getStatus().trim().equals("S")) {
                logger.info(" xunleiid : " + alipaydutVo.getXunleiid() + ", externalsianno=" + alipaydutVo.getExternal_sign_no() + "\uff0cstatus=" + alipaydutVo.getStatus());
                this.alertJS("\u7528\u6237[" + xunleiid + "]\u7b7e\u7ea6\u6210\u529f,\u7b7e\u7ea6\u53f7\u4e3a\uff1a" + externalsignno);
            } else if (alipaydutVo.isSuccess() && alipaydutVo.getStatus().trim().equals("U")) {
                logger.info(" xunleiid : " + alipaydutVo.getXunleiid() + ", externalsianno=" + alipaydutVo.getExternal_sign_no() + "\uff0cstatus=" + alipaydutVo.getStatus());
                this.alertJS("\u7528\u6237[" + xunleiid + "]\u5df2\u7ecf\u89e3\u7ea6,\u7b7e\u7ea6\u53f7\u4e3a\uff1a" + externalsignno);
            } else {
                logger.info("\u7528\u6237\u672a\u6210\u529f\uff1aerrorcode: " + alipaydutVo.getErrcode());
                this.alertJS("\u7528\u6237\u7b7e\u7ea6\u672a\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4e00\u952e\u652f\u4ed8\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return "";
    }

    public Map<String, String> getStatusMap() {
        if (statusMap == null) {
            List list = facade.getLibclassdByClassNo("contractstatus");
            statusMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                statusMap.put(data.getItemno(), data.getItemname());
            }
        }
        return statusMap;
    }

    public SelectItem[] getStatusItem() {
        if (statusItem == null) {
            List list = facade.getLibclassdByClassNo("contractstatus");
            if (list == null) {
                statusItem = new SelectItem[0];
            } else {
                statusItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtcontractokManagedBean.statusItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return statusItem;
    }
}

