/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.thirdparty.client.ThirdpartyQueryClient;
import com.xunlei.channel.thirdparty.vo.QueryRequest;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Extbestpaypay;
import com.xunlei.payproxy.vo.Extbestpaypayok;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.Properties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyBestpaypay")
public class ExtbestpaypayManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtbestpaypayManagedBean.class);
    private static Map<String, String> payTypeMap;
    private static SelectItem[] payTypeItem;
    private static String PAY_TYPE_YM;
    private static String PAY_TYPE_YN;

    public Map<String, String> getPayTypeMap() {
        if (null == payTypeMap) {
            payTypeMap = new HashMap<String, String>();
            payTypeMap.put(PAY_TYPE_YN, "\u7ffc\u652f\u4ed8\u70b9\u64ad");
            payTypeMap.put(PAY_TYPE_YM, "\u7ffc\u652f\u4ed8\u5305\u6708");
        }
        return payTypeMap;
    }

    public SelectItem[] getPayTypeItem() {
        if (payTypeItem == null) {
            payTypeItem = new SelectItem[2];
            ExtbestpaypayManagedBean.payTypeItem[0] = new SelectItem((Object)PAY_TYPE_YN, "\u7ffc\u652f\u4ed8\u70b9\u64ad");
            ExtbestpaypayManagedBean.payTypeItem[1] = new SelectItem((Object)PAY_TYPE_YM, "\u7ffc\u652f\u4ed8\u5305\u6708");
        }
        return payTypeItem;
    }

    public String getQuery() {
        logger.debug("entering ExtbestpaypayManagedBean getQuery() ...");
        this.authenticateRun();
        Extbestpaypay data = (Extbestpaypay)this.findBean(Extbestpaypay.class, "payproxy_extbestpaypay");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getFromdate())) {
                data.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getTodate())) {
                data.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtbestpaypay(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String checkOrderStatus() throws ParseException {
        this.authenticateRun();
        String xunleiPayId = this.findParameter("query_xunleiPayId");
        if (StringUtils.isEmpty((String)xunleiPayId)) {
            this.alertJS("\u51fa\u73b0\u5f02\u5e38\uff0c\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a\u7a7a");
            return "";
        }
        Extbestpaypayok extbestpaypayok = new Extbestpaypayok();
        extbestpaypayok.setXunleiPayId(xunleiPayId);
        extbestpaypayok = facade.findExtbestpaypayok(extbestpaypayok);
        if (null != extbestpaypayok) {
            this.alertJS("\u8be5\u8ba2\u5355\u5df2\u5728\u6210\u529f\u8ba2\u5355\u8868\u4e2d");
            return "";
        }
        Extbestpaypay extbestpaypay = new Extbestpaypay();
        extbestpaypay.setXunleiPayId(xunleiPayId);
        extbestpaypay = facade.findExtbestpaypay(extbestpaypay);
        if (extbestpaypay.getPayType().equals(PAY_TYPE_YM)) {
            this.alertJS("\u7ffc\u652f\u4ed8\u5305\u6708\u8ba2\u5355\u4e0d\u652f\u6301\u67e5\u8be2");
            return "";
        }
        QueryResponse response = this.getQuery3rdPartyResult(extbestpaypay);
        if (StringUtils.isEmpty((String)response.getErrMsg())) {
            this.alertJS("\u8be5\u8ba2\u5355\u652f\u4ed8\u6210\u529f");
        } else {
            this.alertJS(response.getErrMsg());
        }
        return "";
    }

    public QueryResponse getQuery3rdPartyResult(Extbestpaypay extbestpaypay) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Bizorder bizorder = new Bizorder();
        bizorder.setXunleipayid(extbestpaypay.getXunleiPayId());
        bizorder = IFacade.INSTANCE.findBizorder(bizorder);
        QueryRequest request = new QueryRequest(extbestpaypay.getXunleiPayId(), extbestpaypay.getPayType(), (int)(extbestpaypay.getOrderAmt() * 100.0), extbestpaypay.getXunleiId(), extbestpaypay.getUserShow(), "", bizorder.getBizorderid(), "", sdf.parse(extbestpaypay.getInputTime()), "", "");
        Map<String, String> channelConfigMap = Properties.getPayTypeConfigMap("bestpay_once");
        QueryResponse response = ThirdpartyQueryClient.query3rdPartyOrder((QueryRequest)request, channelConfigMap);
        return response;
    }

    public String moveExtbestpaypayToSuccess() {
        this.authenticateEdit();
        String selectIds = this.findParameter("noticeBtn");
        if (!this.isNotEmpty(selectIds)) {
            logger.debug("selectIds is null");
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c");
        } else {
            String[] seqIds;
            logger.debug("moveExtbestpaypayToSuccess, selectIds : " + selectIds);
            String[] arr$ = seqIds = selectIds.split("\\|");
            int len$ = seqIds.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String seqId = arr$[i$];
                Extbestpaypay queryData = new Extbestpaypay();
                queryData.setSeqid(Long.valueOf(seqId).longValue());
                queryData = facade.findExtbestpaypay(queryData);
                if (queryData != null) {
                    String xunleiPayId = queryData.getXunleiPayId();
                    try {
                        logger.debug("\u5f00\u59cb\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c....");
                        boolean query = CustomUtil.isQuery((String)"bestpay");
                        logger.info("jdpayweb query:" + query + "\txunleipayid:" + xunleiPayId);
                        if (!query) {
                            this.alertJS("\u8be5bestpay\u4eba\u5de5\u5b9a\u5236\u529f\u80fd\u5df2\u5173\u95ed");
                        } else {
                            QueryResponse response = this.getQuery3rdPartyResult(queryData);
                            if (response.isQuerySuccess()) {
                                JSONObject resultObj = JSON.parseObject((String)response.getExtraJson());
                                String orderReqNo = resultObj.getString("ourTransNo");
                                String orderDate = resultObj.getString("orderDate");
                                if (!StringUtils.isEmpty((String)orderDate)) {
                                    orderDate = orderDate.substring(0, 8);
                                }
                                this.doMove(queryData.getXunleiPayId(), queryData.getPayType(), orderReqNo, orderDate);
                                this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f");
                            } else {
                                this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25\uff0c\u4fe1\u606f\u4e3a\uff1a" + response.getErrMsg());
                            }
                        }
                        logger.debug("\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c\u7ed3\u675f....");
                    }
                    catch (Exception e) {
                        this.alertJS("\u5b9a\u5236\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38,\u5b9a\u5236\u5931\u8d25!");
                        logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    continue;
                }
                logger.debug("could not find order whose seqid is " + seqId);
                this.alertJS("\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355");
            }
        }
        return "";
    }

    private void doMove(String xunleiPayId, String payType, String channelOrderId, String channelOrderDate) {
        Extbestpaypayok extbestpaypayok = new Extbestpaypayok();
        extbestpaypayok.setXunleiPayId(xunleiPayId);
        extbestpaypayok.setChannelOrderId(channelOrderId);
        extbestpaypayok.setChannelOrderDate(channelOrderDate);
        if (!payType.equals(PAY_TYPE_YN)) {
            logger.debug("\u9519\u8bef\u7684\u652f\u4ed8\u7c7b\u578b,\u8ba2\u5355\u53f7{},\u652f\u4ed8\u7c7b\u578b{}" + xunleiPayId, (Object)payType);
            this.alertJS("\u9519\u8bef\u7684\u652f\u4ed8\u7c7b\u578b,\u8ba2\u5355\u53f7" + xunleiPayId + ",\u652f\u4ed8\u7c7b\u578b" + payType);
            return;
        }
        facade.moveExtbestpaypayOnceToSuccess(extbestpaypayok);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extbestpaypayok.getXunleiPayId());
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }

    static {
        PAY_TYPE_YM = "YM";
        PAY_TYPE_YN = "YN";
    }
}

