/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.ccbdudect.query.MonitorCCBDudectHandler;
import com.xunlei.cmb.check.CmbCheck;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.directpay.query.CCBQuery;
import com.xunlei.icbc.check.IcbcCheck;
import com.xunlei.icbc.prop.ConfigProperties;
import com.xunlei.icbc.prop.PropertiesUtil;
import com.xunlei.pay.center.icbc.vo.IcbcRetrieveVo;
import com.xunlei.pay.proxy.center.abc.query.facade.IFacade;
import com.xunlei.payproxy.vo.Extbankok;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtbankpayok")
public class ExtbankpayokManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExtbankpayokManagedBean.class);
    private String orderBankStateDesc = "\u8bf7\u70b9\u51fb\u6bcf\u884c\u67e5\u8be2\u6309\u94ae\u67e5\u8be2\u8be5\u884c\u8ba2\u5355\u7684\u94f6\u884c\u7aef\u72b6\u6001";
    private IcbcCheck icbcCheck = new IcbcCheck();
    private static Map<String, String> paytypeMap;
    private DateFormat df_Ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat df_Ymd = new SimpleDateFormat("yyyyMMdd");

    public Map<String, String> getPaytypeMap() {
        if (paytypeMap == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            paytypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paytypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paytypeMap;
    }

    public String getQuery() {
        this.authenticateRun();
        Extbankok extbankok = (Extbankok)this.findBean(Extbankok.class, "payproxy_extbankok");
        if (extbankok != null) {
            if (StringTools.isEmpty((String)extbankok.getFromdate())) {
                extbankok.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)extbankok.getTodate())) {
                extbankok.setTodate(DatetimeUtil.today());
                extbankok.setBankNo("-1");
                extbankok.setPayType("-1");
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("inputtime desc");
            Sheet sheet = facade.queryExtbankok(extbankok, fliper);
            if (sheet.getRowcount() > 0) {
                Sheet sumsheet = facade.queryExtbankokSum(extbankok);
                List extbankokslist = (List)sumsheet.getDatas();
                System.out.println("extbankokslist-------------->size=" + extbankokslist.size() + ",list=" + extbankokslist.get(0));
                sheet.getDatas().add(extbankokslist.get(0));
            }
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String checkBankOrderStatus() {
        String seqId = this.findParameter("bank_seqId");
        String orderId = this.findParameter("bank_orderId");
        String orderDate = this.findParameter("bank_orderDate");
        String orderAmt = this.findParameter("bank_orderAmt");
        String orderStatus = this.findParameter("bank_orderStatus");
        logger.info("seqId:" + seqId + ",orderId : " + orderId + ",orderDate : " + orderDate + ",orderAmt" + orderAmt);
        Date date = null;
        try {
            date = this.df_Ymdhms.parse(orderDate);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        String formatOrderDate = new SimpleDateFormat("yyyyMMdd").format(date);
        logger.debug("orderId: " + orderId + "formatOrderDate:" + formatOrderDate);
        long id = Long.parseLong(seqId);
        logger.debug("id is " + id);
        Extbankok extbankreq = facade.findExtbankokById(id);
        String tranDesc = "";
        Map rtnResult = new HashMap();
        logger.debug(extbankreq.getBankNo() + "," + extbankreq.getPayType());
        if ("ICBC".equals(extbankreq.getBankNo()) && !"X1".equals(extbankreq.getPayType())) {
            logger.info("\u8fdb\u5165ICBC\u7684if");
            String tranCode = "";
            try {
                tranCode = this.icbcCheck.isIcbcB2cPayStatusSuccess(orderId, formatOrderDate, Double.valueOf(orderAmt).doubleValue());
                logger.debug("tranCode:" + tranCode);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            tranDesc = PropertiesUtil.getProperty((Properties)ConfigProperties.IcbcB2CQueryProp, (String)tranCode);
            if (!tranCode.equals("tranStat_1")) {
                logger.error("orderId : " + orderId + ",tranDesc : " + tranDesc);
                Date dateReChec = null;
                try {
                    dateReChec = this.df_Ymdhms.parse(extbankreq.getInputTime());
                }
                catch (ParseException e1) {
                    logger.error("ParseException inputtime :\u3000{}", (Throwable)e1);
                }
                Calendar c = Calendar.getInstance();
                c.setTime(dateReChec);
                int hour = c.get(11);
                int min = c.get(12);
                if (hour >= 23 && min > 50) {
                    c.add(5, 1);
                    String tmp_orderDate = this.df_Ymd.format(c.getTime());
                    String inputtime = this.df_Ymdhms.format(c.getTime());
                    try {
                        tranCode = this.icbcCheck.isIcbcB2cPayStatusSuccess(orderId, tmp_orderDate, Double.valueOf(orderAmt).doubleValue());
                        tranDesc = PropertiesUtil.getProperty((Properties)ConfigProperties.IcbcB2CQueryProp, (String)tranCode);
                    }
                    catch (NumberFormatException e) {
                        logger.error("orderAmt NumberFormatException : {}", (Throwable)e);
                    }
                    catch (IOException e) {
                        logger.error("method isIcbcB2cPayStatusSuccess IOException : {}", (Throwable)e);
                    }
                    if (!tranCode.equals("tranStat_1")) {
                        tranDesc = PropertiesUtil.getProperty((Properties)ConfigProperties.IcbcB2CQueryProp, (String)tranCode);
                        logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc + ",inputtime : " + inputtime);
                    }
                }
            }
        } else if ("ICBC".equals(extbankreq.getBankNo()) && "X1".equals(extbankreq.getPayType())) {
            String tranCode = "";
            try {
                IcbcRetrieveVo icbcretrievevo = new IcbcRetrieveVo(orderId);
                rtnResult = com.xunlei.pay.center.icbc.retrieve.facade.IFacade.INSTANCE.retrieveIcbcDudect(icbcretrievevo);
                logger.debug("rtnResult:" + rtnResult);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            String code = "\u65e0";
            String retMsg = "\u65e0";
            String status = (String)rtnResult.get("status");
            String extRetMsg = "";
            if (this.isNotEmpty((String)rtnResult.get("code"))) {
                code = (String)rtnResult.get("code");
            }
            if (this.isNotEmpty((String)rtnResult.get("retMsg"))) {
                retMsg = (String)rtnResult.get("retMsg");
            }
            logger.info("code : " + code + ", retMsg :" + retMsg + ", status :" + status);
            extRetMsg = this.isNotEmpty(status) && "S".equals(status) ? "\u67e5\u8be2\u6210\u529f" : (this.isNotEmpty(status) && "N".equals(status) ? ("0".equals(code) ? "\u63d0\u4ea4\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406" : ("1".equals(code) ? "\u6388\u6743\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406" : ("2".equals(code) ? "\u7b49\u5f85\u6388\u6743" : ("3".equals(code) ? "\u7b49\u5f85\u4e8c\u6b21\u6388\u6743" : ("4".equals(code) ? "\u7b49\u5f85\u94f6\u884c\u7b54\u590d" : ("5".equals(code) ? "\u4e3b\u673a\u8fd4\u56de\u5f85\u5904\u7406" : ("6".equals(code) ? "\u88ab\u94f6\u884c\u62d2\u7edd" : ("7".equals(code) ? "\u5904\u7406\u6210\u529f" : ("8".equals(code) ? "\u6307\u4ee4\u88ab\u62d2\u7edd\u6388\u6743" : ("9".equals(code) ? "\u94f6\u884c\u6b63\u5728\u5904\u7406" : ("10".equals(code) ? "\u9884\u7ea6\u6307\u4ee4" : ("11".equals(code) ? "\u9884\u7ea6\u53d6\u6d88" : "")))))))))))) : "\u67e5\u8be2\u8fc7\u7a0b\u5931\u8d25");
            tranDesc = code.equals("\u65e0") && retMsg.equals("\u65e0") && status.equals("S") ? "\u67e5\u8be2\u6210\u529f\uff0c\u5df2\u6e05\u7b97" : ",\u8fd4\u56de\u7801:" + code + ",\u8fd4\u56de\u4fe1\u606f:" + retMsg + "," + extRetMsg;
            logger.info("\u8fdb\u5165ICBC\u548cXLYT\u7684if,orderId:" + orderId + ", tranDesc :" + tranDesc);
        } else if ("CMB".equals(extbankreq.getBankNo())) {
            CmbCheck.CmbCheckRet cmbData = CmbCheck.getInstance().querySingleOrder(formatOrderDate, extbankreq.getOrderId(), extbankreq.getOrderAmt());
            tranDesc = CmbCheck.getInstance().getResource().getString("tranStat_" + cmbData.getCheckStatus());
            if (cmbData.getCheckStatus() != 0) {
                logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc);
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                int hour = c.get(11);
                int min = c.get(12);
                if (hour >= 23 && min > 55) {
                    c.add(5, 1);
                    String inputtime = this.df_Ymdhms.format(c.getTime());
                    cmbData = CmbCheck.getInstance().querySingleOrder(this.Ymdhms2Ymd(inputtime), extbankreq.getOrderId(), extbankreq.getOrderAmt());
                    if (cmbData.getCheckStatus() != 0) {
                        tranDesc = CmbCheck.getInstance().getResource().getString("tranStat_" + cmbData.getCheckStatus());
                        logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc + ",inputtime : " + inputtime);
                    }
                }
            }
        } else if ("ABC".equals(extbankreq.getBankNo())) {
            System.out.println("\u901a\u8fc7orderid\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff0c\u94f6\u884c\u7c7b\u578b\u4e3aABC(\u519c\u884c)\uff0c\u652f\u4ed8\u7c7b\u578b\u4e3a\uff1a" + extbankreq.getPayType());
            tranDesc = this.getABCOrderStatusTranDesc(orderId, orderAmt);
        } else if (extbankreq.getBankNo().equals("CCB") && "X1".equals(extbankreq.getPayType())) {
            if ("U".equals(orderStatus)) {
                orderStatus = "";
            }
            rtnResult = new MonitorCCBDudectHandler().query(orderId, orderAmt, orderStatus, orderDate.substring(0, 10));
            logger.debug("rtnResult:" + rtnResult);
            if ("Y".equals(rtnResult.get("timeOut"))) {
                logger.info("orderId:" + orderId + " query timeout");
                tranDesc = "\u67e5\u8be2\u8d85\u65f6";
            } else if ("N".equals(rtnResult.get("checkSuccess"))) {
                String errMsg = (String)rtnResult.get("msg");
                logger.info("orderId:" + orderId + " query failed:" + errMsg);
                tranDesc = StringTools.isEmpty((String)errMsg) ? "\u67e5\u8be2\u5931\u8d25" : "\u67e5\u8be2\u5931\u8d25\uff1a" + errMsg;
            } else if ("Y".equals(rtnResult.get("checkSuccess"))) {
                logger.info("orderId:" + orderId + " query successed");
                tranDesc = "\u67e5\u8be2\u6210\u529f\uff0c\u8ba2\u5355\u5df2\u6210\u529f\u652f\u4ed8";
            }
        } else if (extbankreq.getBankNo().equals("CCB") && !"X1".equals(extbankreq.getPayType())) {
            logger.info("orderid[" + orderId + "],bankno: " + extbankreq.getBankNo() + ", paytype: " + extbankreq.getPayType());
            rtnResult = CCBQuery.defaultQuerySingleByOrderid((String)orderId, (double)extbankreq.getOrderAmt());
            logger.info("orderid[" + orderId + ", queryResult: " + rtnResult);
            String timeout = (String)rtnResult.get("timeOut");
            String queryCode = (String)rtnResult.get("checkSuccess");
            if (timeout.equals("N") && queryCode.equals("Y")) {
                tranDesc = "\u67e5\u8be2\u6210\u529f";
            } else if (timeout.equals("Y")) {
                logger.info("orderid[" + orderId + "]\u67e5\u8be2\u8d85\u65f6");
                tranDesc = "\u67e5\u8be2\u8d85\u65f6,\u8bf7\u7a0d\u540e\u518d\u8bd5";
            } else {
                logger.info("orderid[" + orderId + "],\u67e5\u8be2\u7ed3\u679c\u672a\u6210\u529f\uff1a" + (String)rtnResult.get("msg"));
                tranDesc = " \u67e5\u8be2\u5931\u8d25\uff1a" + (String)rtnResult.get("msg");
            }
        }
        this.orderBankStateDesc = orderId + ":" + tranDesc;
        logger.debug("orderBankStateDesc:" + this.orderBankStateDesc);
        this.alertJS(orderId + ":" + tranDesc);
        return null;
    }

    public String getABCOrderStatusTranDesc(String orderId, String orderAmt) {
        IFacade facadeABC = IFacade.INSTANCE;
        String tranDesc = "";
        HashMap resultMap = null;
        resultMap = facadeABC.getOrderInfo(orderId, true);
        if (resultMap == null) {
            System.out.println("------------\u5931\u8d25---------->\u4ece\u94f6\u884c\u83b7\u53d6\u7684map\u4e3anull");
            resultMap = new HashMap();
        } else if (((String)resultMap.get("ret")).equals("1")) {
            System.out.println("\u67e5\u8be2\u7528\u6237\u519c\u884c\u652f\u4ed8\u4fe1\u606f\u6210\u529f");
            String returnOrderIdString = (String)resultMap.get("orderNo");
            if (!returnOrderIdString.equals(orderId)) {
                System.out.println("\u519c\u884c\u8fd4\u56de\u4fe1\u606f\u7684\u8ba2\u5355\u53f7\u4e0d\u7b26");
                tranDesc = "\u519c\u884c\u8fd4\u56de\u4fe1\u606f\u7684\u8ba2\u5355\u53f7\u4e0d\u7b26";
                this.alertJS(orderId + ":" + tranDesc);
                return tranDesc;
            }
            if (Double.parseDouble(orderAmt) != Double.parseDouble((String)resultMap.get("orderAmount"))) {
                System.out.println("\u519c\u884c\u8fd4\u56de\u4fe1\u606f\u7684\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26");
                tranDesc = "\u519c\u884c\u8fd4\u56de\u4fe1\u606f\u7684\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26";
                this.alertJS(orderId + ":" + tranDesc);
                return tranDesc;
            }
            String returnStatusCode = (String)resultMap.get("orderStatus");
            tranDesc = returnStatusCode.equals("00") ? "\u8ba2\u5355\u5df2\u53d6\u6d88" : (returnStatusCode.equals("01") ? "\u8ba2\u5355\u5df2\u5efa\u7acb\uff0c\u7b49\u5f85\u652f\u4ed8" : (returnStatusCode.equals("02") ? "\u6d88\u8d39\u8005\u5df2\u652f\u4ed8\uff0c\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c" : (returnStatusCode.equals("03") ? "\u8ba2\u5355\u5df2\u652f\u4ed8\uff08\u652f\u4ed8\u6210\u529f\uff09" : (returnStatusCode.equals("04") ? "\u8ba2\u5355\u5df2\u7ed3\u7b97\uff08\u652f\u4ed8\u6210\u529f\uff09" : (returnStatusCode.equals("05") ? "\u8ba2\u5355\u5df2\u9000\u6b3e" : (returnStatusCode.equals("99") ? "\u8ba2\u5355\u652f\u4ed8\u5931\u8d25" : "\u8ba2\u5355\u8fd4\u56de\u7684\u8fd4\u56de\u7801\u9519\u8bef\uff1a" + returnStatusCode))))));
        } else if (((String)resultMap.get("ret")).equals("0")) {
            System.out.println("\u67e5\u8be2\u7528\u6237\u519c\u884c\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
            tranDesc = (String)resultMap.get("errorMsg");
        } else {
            System.out.println("\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u9519\u8bef");
            tranDesc = "\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u9519\u8bef";
        }
        return tranDesc;
    }

    public String getOrderBankStateDesc() {
        return this.orderBankStateDesc;
    }

    public void setOrderBankStateDesc(String orderBankStateDesc) {
        this.orderBankStateDesc = orderBankStateDesc;
    }

    public String Ymdhms2Ymd(String time_Ymdhms) {
        if (time_Ymdhms.isEmpty() || time_Ymdhms == null) {
            return "";
        }
        String time_Ymd = "";
        try {
            time_Ymd = this.df_Ymd.format(this.df_Ymdhms.parse(time_Ymdhms).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            logger.error("Ymdhms2Ymd with Exception:{}", (Throwable)e);
        }
        return time_Ymd;
    }
}

