/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.ccbdudect.query.MonitorCCBDudectHandler;
import com.xunlei.cmb.check.CmbCheck;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.directpay.query.CCBQuery;
import com.xunlei.icbc.check.IcbcCheck;
import com.xunlei.icbc.check.IcbcCheckRet;
import com.xunlei.icbc.prop.ConfigProperties;
import com.xunlei.icbc.prop.PropertiesUtil;
import com.xunlei.pay.center.icbc.vo.IcbcRetrieveVo;
import com.xunlei.pay.proxy.center.abc.query.facade.IFacade;
import com.xunlei.payproxy.constant.BankpayConstant;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Extbankok;
import com.xunlei.payproxy.vo.Extbankreq;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtbankpay")
public class ExtbankpayManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExtbankpayManagedBean.class);
    private String orderBankStateDesc = "\u8bf7\u70b9\u51fb\u6bcf\u884c\u67e5\u8be2\u6309\u94ae\u67e5\u8be2\u8be5\u884c\u8ba2\u5355\u7684\u94f6\u884c\u7aef\u72b6\u6001";
    private static Map<String, String> paytypeMap;
    private IcbcCheck icbcCheck = new IcbcCheck();
    private DateFormat df_Ymdhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat df_Ymd = new SimpleDateFormat("yyyyMMdd");

    public Map<String, String> getPaytypeMap() {
        if (paytypeMap == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            paytypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paytypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paytypeMap;
    }

    public String getQuery() {
        this.authenticateRun();
        Extbankreq extbankreq = (Extbankreq)this.findBean(Extbankreq.class, "payproxy_extbankreq");
        if (StringTools.isEmpty((String)extbankreq.getFromdate())) {
            extbankreq.setFromdate(DatetimeUtil.today());
        }
        if (StringTools.isEmpty((String)extbankreq.getTodate())) {
            extbankreq.setTodate(DatetimeUtil.today());
            extbankreq.setBankNo("-1");
            extbankreq.setPayType("-1");
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputTime desc");
        Sheet sheet = facade.queryExtbankreq(extbankreq, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public void moveExtbankreqToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticebtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                boolean query;
                Extbankreq extbankreqQry = new Extbankreq();
                extbankreqQry.setSeqid(Long.valueOf(seqid).longValue());
                logger.debug("extbankreqQry seqId: " + Long.valueOf(seqid));
                Extbankreq extbankreq = facade.findExtbankreq(extbankreqQry);
                if (extbankreq.getBankNo().equals("ICBC") && !extbankreq.getPayType().equals("X1")) {
                    query = CustomUtil.isQuery((String)"icbc");
                    logger.info("query:" + query + "\torderid:" + extbankreq.getOrderId());
                    if (!query) {
                        this.doMoveIcbc(extbankreq, "");
                        continue;
                    }
                    try {
                        IcbcCheckRet icbcCheckRet = this.getIcbcCheckRet(extbankreq, extbankreq.getInputTime());
                        String transOrderStat = icbcCheckRet.getOrderTranStat();
                        String tranDesc = PropertiesUtil.getProperty((Properties)ConfigProperties.IcbcB2CQueryProp, (String)transOrderStat);
                        if (!transOrderStat.equals("tranStat_1")) {
                            logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc);
                            Date date = this.df_Ymdhms.parse(extbankreq.getInputTime());
                            Calendar c = Calendar.getInstance();
                            c.setTime(date);
                            int hour = c.get(11);
                            int min = c.get(12);
                            if (hour >= 23 && min >= 44) {
                                c.add(5, 1);
                                String inputtime = this.df_Ymdhms.format(c.getTime());
                                icbcCheckRet = this.getIcbcCheckRet(extbankreq, inputtime);
                                transOrderStat = icbcCheckRet.getOrderTranStat();
                                if (!transOrderStat.equals("tranStat_1")) {
                                    tranDesc = PropertiesUtil.getProperty((Properties)ConfigProperties.IcbcB2CQueryProp, (String)transOrderStat);
                                    logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc + ",inputtime : " + inputtime);
                                }
                            }
                            this.alertJS(extbankreq.getXunleiPayId() + "\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f, transOrderStat = " + transOrderStat + " ,tranDesc = " + tranDesc);
                        }
                        if (!transOrderStat.equals("tranStat_1")) continue;
                        this.doMoveIcbc(extbankreq, icbcCheckRet.getOrderNotifyTime());
                        logger.error("orderId = " + extbankreq.getOrderId() + ",tranDesc = " + tranDesc);
                        this.alertJS("orderId = " + extbankreq.getOrderId() + " , transOrderStat = " + transOrderStat + ",tranDesc = " + tranDesc);
                    }
                    catch (Exception e) {
                        this.alertJS("\u67e5\u8be2\u51fa\u9519 \uff1a " + e.getMessage());
                        logger.error(e.getMessage());
                    }
                    continue;
                }
                if (extbankreq.getBankNo().equals("ICBC") && extbankreq.getPayType().equals("X1")) {
                    query = CustomUtil.isQuery((String)"icbc");
                    logger.info("query:" + query + "\torderid:" + extbankreq.getOrderId());
                    if (!query) {
                        this.doMoveIcbc(extbankreq, "");
                        continue;
                    }
                    try {
                        IcbcRetrieveVo icbcretrievevo = new IcbcRetrieveVo(extbankreq.getOrderId());
                        Map rtnResult = com.xunlei.pay.center.icbc.retrieve.facade.IFacade.INSTANCE.retrieveIcbcDudect(icbcretrievevo);
                        logger.debug("rtnResult:" + rtnResult);
                        String status = (String)rtnResult.get("status");
                        if (this.isNotEmpty(status) && "S".equals(status)) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            this.doMoveIcbc(extbankreq, sdf.format(new Date()));
                            this.alertJS("orderId = " + extbankreq.getOrderId() + "\u8865\u5355\u6210\u529f");
                            continue;
                        }
                        String code = "\u65e0";
                        String retMsg = "\u65e0";
                        if (this.isNotEmpty((String)rtnResult.get("code"))) {
                            code = (String)rtnResult.get("code");
                        }
                        if (this.isNotEmpty((String)rtnResult.get("retMsg"))) {
                            retMsg = (String)rtnResult.get("retMsg");
                        }
                        String extRetMsg = "";
                        logger.info("code : " + code + ", retMsg :" + retMsg + ", status :" + status);
                        extRetMsg = this.isNotEmpty(status) && "S".equals(status) ? "\u67e5\u8be2\u6210\u529f" : (this.isNotEmpty(status) && "N".equals(status) ? ("0".equals(code) ? "\u63d0\u4ea4\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406" : ("1".equals(code) ? "\u6388\u6743\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406" : ("2".equals(code) ? "\u7b49\u5f85\u6388\u6743" : ("3".equals(code) ? "\u7b49\u5f85\u4e8c\u6b21\u6388\u6743" : ("4".equals(code) ? "\u7b49\u5f85\u94f6\u884c\u7b54\u590d" : ("5".equals(code) ? "\u4e3b\u673a\u8fd4\u56de\u5f85\u5904\u7406" : ("6".equals(code) ? "\u88ab\u94f6\u884c\u62d2\u7edd" : ("8".equals(code) ? "\u6307\u4ee4\u88ab\u62d2\u7edd\u6388\u6743" : ("9".equals(code) ? "\u94f6\u884c\u6b63\u5728\u5904\u7406" : ("10".equals(code) ? "\u9884\u7ea6\u6307\u4ee4" : ("11".equals(code) ? "\u9884\u7ea6\u53d6\u6d88" : ""))))))))))) : "\u67e5\u8be2\u8fc7\u7a0b\u5931\u8d25");
                        this.alertJS(extbankreq.getXunleiPayId() + "\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f, transOrderStat = " + code + " ,tranDesc = " + extRetMsg);
                    }
                    catch (Exception e) {
                        this.alertJS("\u67e5\u8be2\u51fa\u9519 \uff1a " + e.getMessage());
                        logger.error(e.getMessage());
                    }
                    continue;
                }
                if (extbankreq.getBankNo().equals("CMB")) {
                    query = CustomUtil.isQuery((String)"cmb");
                    logger.info("query:" + query + "\torderid:" + extbankreq.getOrderId());
                    if (!query) {
                        this.doMoveCmb(extbankreq, "", "\u5b9a\u5236\u6210\u529f");
                        continue;
                    }
                    try {
                        CmbCheck.CmbCheckRet cmbData = CmbCheck.getInstance().querySingleOrder(this.Ymdhms2Ymd(extbankreq.getInputTime()), extbankreq.getOrderId(), extbankreq.getOrderAmt());
                        String tranDesc = CmbCheck.getInstance().getResource().getString("tranStat_" + cmbData.getCheckStatus());
                        if (cmbData.getCheckStatus() != 0) {
                            logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc);
                            Date date = null;
                            date = this.df_Ymdhms.parse(extbankreq.getInputTime());
                            Calendar c = Calendar.getInstance();
                            c.setTime(date);
                            int hour = c.get(11);
                            int min = c.get(12);
                            if (hour >= 23 && min > 55) {
                                c.add(5, 1);
                                String inputtime = this.df_Ymdhms.format(c.getTime());
                                cmbData = CmbCheck.getInstance().querySingleOrder(this.Ymdhms2Ymd(inputtime), extbankreq.getOrderId(), extbankreq.getOrderAmt());
                                if (cmbData.getCheckStatus() != 0) {
                                    tranDesc = CmbCheck.getInstance().getResource().getString("tranStat_" + cmbData.getCheckStatus());
                                    logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc + ",inputtime : " + inputtime);
                                }
                            }
                            this.alertJS(extbankreq.getOrderId() + ":" + tranDesc);
                            continue;
                        }
                        if (cmbData.getCheckStatus() != 0) continue;
                        this.doMoveCmb(extbankreq, cmbData.getDealTime(), tranDesc);
                    }
                    catch (Exception e) {
                        this.alertJS("\u67e5\u8be2\u51fa\u9519[" + e.getMessage() + "]");
                        logger.error(e.getMessage());
                    }
                    continue;
                }
                if (extbankreq.getBankNo().equals("ABC")) {
                    System.out.println("moveExtbankreqToSuccess------->bankNo\u4e3a\uff1a" + extbankreq.getBankNo());
                    query = CustomUtil.isQuery((String)"ABC");
                    logger.info("query:" + query + "\torderid:" + extbankreq.getOrderId());
                    if (!query) {
                        System.out.println("\u4e0d\u9700\u8981\u67e5\u8be2\u7b2c\u4e09\u65b9\u652f\u4ed8\u63a5\u53e3\u7684\u8ba2\u5355\u72b6\u6001\uff0c\u76f4\u63a5\u4eba\u5de5\u8bbe\u7f6e\u4e3a\u5b9a\u5236\u6210\u529f");
                        this.doMoveCmb(extbankreq, "", "\u5b9a\u5236\u6210\u529f");
                        continue;
                    }
                    IFacade facadeABC = IFacade.INSTANCE;
                    HashMap resultMap = null;
                    resultMap = facadeABC.getOrderInfo(extbankreq.getOrderId(), true);
                    if (resultMap == null) {
                        System.out.println("------------\u5931\u8d25---------->\u4ece\u94f6\u884c\u83b7\u53d6\u7684map\u4e3anull");
                        resultMap = new HashMap();
                    }
                    String ABCOrderStatusCode = (String)resultMap.get("ret");
                    String tranDesc = "";
                    System.out.println("\u53bb\u519c\u884c\u67e5\u8be2\u83b7\u53d6\u7684\u8fd4\u56de\u7801\u4e3a\uff1a" + ABCOrderStatusCode);
                    if (ABCOrderStatusCode.equals("1")) {
                        System.out.println("\u53bb\u519c\u884c\u67e5\u8be2\u6210\u529f\uff0c\u6b63\u786e\u83b7\u53d6\u8fd4\u56de\u4fe1\u606f");
                        System.out.println("movetosuccess--------->\u8fd4\u56de\u7801\u4e3a\uff1a" + (String)resultMap.get("orderStatus"));
                        if (((String)resultMap.get("orderStatus")).equals("03")) {
                            this.doMoveAbc(extbankreq, "\u8ba2\u5355\u5df2\u652f\u4ed8\uff08\u652f\u4ed8\u6210\u529f\uff09");
                            tranDesc = "\u8ba2\u5355\u5df2\u652f\u4ed8\uff08\u652f\u4ed8\u6210\u529f\uff09";
                        } else if (((String)resultMap.get("orderStatus")).equals("04")) {
                            this.doMoveAbc(extbankreq, "\u8ba2\u5355\u5df2\u7ed3\u7b97\uff08\u652f\u4ed8\u6210\u529f\uff09");
                            tranDesc = "\u8ba2\u5355\u5df2\u7ed3\u7b97\uff08\u652f\u4ed8\u6210\u529f\uff09";
                        } else {
                            String code = (String)resultMap.get("orderStatus");
                            tranDesc = code.equals("00") ? "\u8ba2\u5355\u5df2\u53d6\u6d88" : (code.equals("01") ? "\u8ba2\u5355\u5df2\u5efa\u7acb\uff0c\u7b49\u5f85\u652f\u4ed8" : (code.equals("02") ? "\u6d88\u8d39\u8005\u5df2\u652f\u4ed8\uff0c\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c" : (code.equals("05") ? "\u8ba2\u5355\u5df2\u9000\u6b3e" : (code.equals("99") ? "\u8ba2\u5355\u652f\u4ed8\u5931\u8d25" : "\u8ba2\u5355\u8fd4\u56de\u7684\u8fd4\u56de\u7801\u9519\u8bef\uff1a" + code))));
                        }
                        this.alertJS(extbankreq.getOrderId() + ":" + tranDesc);
                        continue;
                    }
                    if (ABCOrderStatusCode.equals("0")) {
                        System.out.println("\u53bb\u519c\u884c\u67e5\u8be2\u5931\u8d25");
                        this.alertJS(extbankreq.getOrderId() + ":" + (String)resultMap.get("errorMsg"));
                        continue;
                    }
                    System.out.println("\u65e0\u6cd5\u8fdb\u884c\u519c\u884c\u67e5\u8be2");
                    this.alertJS(extbankreq.getOrderId() + ":\u65e0\u6cd5\u8fdb\u884c\u519c\u884c\u67e5\u8be2");
                    continue;
                }
                if (extbankreq.getBankNo().equals("CCB") && !"X1".equals(extbankreq.getPayType())) {
                    logger.info("moveExtbankreqToSuccess------->bankNo\u4e3a\uff1a" + extbankreq.getBankNo() + ",paytpe: " + extbankreq.getPayType());
                    query = CustomUtil.isQuery((String)"CCBDirect");
                    logger.info("query:" + query + "\torderid:" + extbankreq.getOrderId());
                    if (!query) {
                        System.out.println("\u4e0d\u9700\u8981\u67e5\u8be2\u7b2c\u4e09\u65b9\u652f\u4ed8\u63a5\u53e3\u7684\u8ba2\u5355\u72b6\u6001\uff0c\u76f4\u63a5\u4eba\u5de5\u8bbe\u7f6e\u4e3a\u5b9a\u5236\u6210\u529f");
                        this.doMoveCCBDirect(extbankreq, 0.0, "\u5b9a\u5236\u6210\u529f");
                        continue;
                    }
                    logger.info("\u5efa\u884c\u76f4\u63a5\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236");
                    String orderid = extbankreq.getOrderId();
                    Map queryResultMap = CCBQuery.defaultQuerySingleByOrderid((String)orderid, (double)extbankreq.getOrderAmt());
                    logger.info("orderid[" + orderid + "],\u5efa\u884c\u76f4\u8fde\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a" + queryResultMap);
                    String queryCode = (String)queryResultMap.get("checkSuccess");
                    String timeout = (String)queryResultMap.get("timeOut");
                    if (timeout.equals("N") && queryCode.equals("Y")) {
                        double payment = Double.parseDouble((String)queryResultMap.get("amount"));
                        this.doMoveCCBDirect(extbankreq, payment, "\u5b9a\u5236\u6210\u529f");
                        continue;
                    }
                    if (timeout.equals("Y")) {
                        logger.info("orderid[" + orderid + "]\u67e5\u8be2\u8d85\u65f6");
                        this.alertJS("[" + orderid + "]\u67e5\u8be2\u8d85\u65f6,\u4eba\u5de5\u5b9a\u5236\u5931\u8d25");
                        continue;
                    }
                    logger.info("orderid[" + orderid + "],\u67e5\u8be2\u7ed3\u679c\u672a\u6210\u529f\uff1a" + (String)queryResultMap.get("msg"));
                    this.alertJS("[" + orderid + "]: \u67e5\u8be2\u5931\u8d25\uff1a" + (String)queryResultMap.get("msg"));
                    continue;
                }
                if (!extbankreq.getBankNo().equals("CCB") || !"X1".equals(extbankreq.getPayType())) continue;
                logger.info("moveExtbankreqToSuccess------->bankNo\u4e3a\uff1a" + extbankreq.getBankNo());
                query = CustomUtil.isQuery((String)"CCBDudect");
                logger.info("query:" + query + "\torderid:" + extbankreq.getOrderId());
                if (!query) {
                    System.out.println("\u4e0d\u9700\u8981\u67e5\u8be2\u7b2c\u4e09\u65b9\u652f\u4ed8\u63a5\u53e3\u7684\u8ba2\u5355\u72b6\u6001\uff0c\u76f4\u63a5\u4eba\u5de5\u8bbe\u7f6e\u4e3a\u5b9a\u5236\u6210\u529f");
                    this.doMoveCCBDudect(extbankreq, 0.0, "\u5b9a\u5236\u6210\u529f");
                    continue;
                }
                String orderStatus = extbankreq.getExtbankStatus();
                String orderId = extbankreq.getOrderId();
                String orderAmt = extbankreq.getOrderAmt() + "";
                String orderDate = extbankreq.getInputTime().substring(0, 10);
                HashMap rtnResult = new HashMap();
                if ("U".equals(orderStatus)) {
                    orderStatus = "";
                }
                rtnResult = new MonitorCCBDudectHandler().query(orderId, orderAmt, orderStatus, orderDate);
                logger.debug("orderId:" + orderId + "\u4eba\u5de5\u5b9a\u5236,rtnResult:" + rtnResult);
                if ("Y".equals(rtnResult.get("timeOut"))) {
                    logger.info("orderId:" + orderId + " query timeout");
                    this.alertJS(extbankreq.getOrderId() + ":\u67e5\u8be2\u8d85\u65f6\uff0c\u4eba\u5de5\u5b9a\u5236\u5931\u8d25");
                    continue;
                }
                if ("N".equals(rtnResult.get("checkSuccess"))) {
                    String errMsg = (String)rtnResult.get("msg");
                    logger.info("orderId:" + orderId + " query failed:" + errMsg);
                    if (StringTools.isEmpty((String)errMsg)) {
                        errMsg = "\u67e5\u8be2\u5931\u8d25";
                    }
                    this.alertJS(extbankreq.getOrderId() + ":\u67e5\u8be2\u5931\u8d25\uff0c\u4eba\u5de5\u5b9a\u5236\u5931\u8d25");
                    continue;
                }
                if (!"Y".equals(rtnResult.get("checkSuccess"))) continue;
                logger.info("orderId:" + orderId + " query successed");
                this.doMoveCCBDudect(extbankreq, 0.0, "\u5b9a\u5236\u6210\u529f");
            }
        }
    }

    public String getABCOrderStatusCode(String orderId) {
        IFacade facadeABC = IFacade.INSTANCE;
        HashMap resultMap = null;
        resultMap = facadeABC.getOrderInfo(orderId, true);
        if (resultMap == null) {
            System.out.println("------------\u5931\u8d25---------->\u4ece\u94f6\u884c\u83b7\u53d6\u7684map\u4e3anull");
            resultMap = new HashMap();
            return "";
        }
        return (String)resultMap.get("ret");
    }

    public String getABCOrderStatusTranDesc(String orderId, String orderAmt) {
        System.out.println("\u9a8c\u8bc1\u519c\u884c\u8fd4\u56de\u4fe1\u606f------->orderid=" + orderId + "\uff0corderamt=" + orderAmt);
        IFacade facadeABC = IFacade.INSTANCE;
        String tranDesc = "";
        HashMap resultMap = null;
        resultMap = facadeABC.getOrderInfo(orderId, true);
        if (resultMap == null) {
            System.out.println("------------\u5931\u8d25---------->\u4ece\u94f6\u884c\u83b7\u53d6\u7684map\u4e3anull");
            resultMap = new HashMap();
        } else if (((String)resultMap.get("ret")).equals("1")) {
            System.out.println("\u67e5\u8be2\u7528\u6237\u519c\u884c\u652f\u4ed8\u4fe1\u606f\u6210\u529f");
            System.out.println("\u8fd4\u56de\u7684\u4fe1\u606f\uff0cmap-------->" + ((Object)resultMap).toString());
            String returnOrderIdString = (String)resultMap.get("orderNo");
            if (!returnOrderIdString.equals(orderId)) {
                System.out.println("\u519c\u884c\u8fd4\u56de\u4fe1\u606f\u7684\u8ba2\u5355\u53f7\u4e0d\u7b26");
                tranDesc = "\u519c\u884c\u8fd4\u56de\u4fe1\u606f\u7684\u8ba2\u5355\u53f7\u4e0d\u7b26";
                this.alertJS(orderId + ":" + tranDesc);
                return tranDesc;
            }
            System.out.println("Double.parseDouble(orderAmt)----->" + Double.parseDouble(orderAmt));
            System.out.println("Double.parseDouble(resultMap.get(orderAmount))----->" + Double.parseDouble((String)resultMap.get("orderAmount")));
            if (Double.parseDouble(orderAmt) != Double.parseDouble((String)resultMap.get("orderAmount"))) {
                System.out.println("\u519c\u884c\u8fd4\u56de\u4fe1\u606f\u7684\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26");
                tranDesc = "\u519c\u884c\u8fd4\u56de\u4fe1\u606f\u7684\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26";
                this.alertJS(orderId + ":" + tranDesc);
                return tranDesc;
            }
            String returnStatusCode = (String)resultMap.get("orderStatus");
            tranDesc = returnStatusCode.equals("00") ? "\u8ba2\u5355\u5df2\u53d6\u6d88" : (returnStatusCode.equals("01") ? "\u8ba2\u5355\u5df2\u5efa\u7acb\uff0c\u7b49\u5f85\u652f\u4ed8" : (returnStatusCode.equals("02") ? "\u6d88\u8d39\u8005\u5df2\u652f\u4ed8\uff0c\u7b49\u5f85\u652f\u4ed8\u7ed3\u679c" : (returnStatusCode.equals("03") ? "\u8ba2\u5355\u5df2\u652f\u4ed8\uff08\u652f\u4ed8\u6210\u529f\uff09" : (returnStatusCode.equals("04") ? "\u8ba2\u5355\u5df2\u7ed3\u7b97\uff08\u652f\u4ed8\u6210\u529f\uff09" : (returnStatusCode.equals("05") ? "\u8ba2\u5355\u5df2\u9000\u6b3e" : (returnStatusCode.equals("99") ? "\u8ba2\u5355\u652f\u4ed8\u5931\u8d25" : "\u8ba2\u5355\u8fd4\u56de\u7684\u8fd4\u56de\u7801\u9519\u8bef\uff1a" + returnStatusCode))))));
        } else if (((String)resultMap.get("ret")).equals("0")) {
            System.out.println("\u67e5\u8be2\u7528\u6237\u519c\u884c\u652f\u4ed8\u4fe1\u606f\u5931\u8d25");
            tranDesc = (String)resultMap.get("errorMsg");
            System.out.println("\u8fd4\u56de\u7684\u4fe1\u606f\uff0cmap-------->" + ((Object)resultMap).toString());
        } else {
            System.out.println("\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u9519\u8bef");
            tranDesc = "\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u9519\u8bef";
        }
        return tranDesc;
    }

    public void moveExtbankreqToFailure() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticeToFailurebtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                Extbankreq extbankreqQry = new Extbankreq();
                extbankreqQry.setSeqid(Long.valueOf(seqid).longValue());
                logger.debug("extbankreqQry seqId: " + Long.valueOf(seqid));
                extbankreqQry.setExtbankStatus(BankpayConstant.PAY_STATUS_W);
                Extbankreq extbankreq = facade.findExtbankreq(extbankreqQry);
                if (null != extbankreq) {
                    extbankreq.setExtbankStatus(BankpayConstant.PAY_STATUS_N);
                    extbankreq.setRemark(this.noticefail_remark(extbankreq.getRemark()));
                    facade.updateExtbankreq(extbankreq);
                }
                this.alertJS("\u5b9a\u5236\u5931\u8d25\u64cd\u4f5c\u5b8c\u6210");
            }
        }
    }

    public String checkBankOrderStatus() {
        String orderId = this.findParameter("bank_orderId");
        String orderDate = this.findParameter("bank_orderDate");
        String orderAmt = this.findParameter("bank_orderAmt");
        String orderStatus = this.findParameter("bank_orderStatus");
        System.out.println("\u9a8c\u8bc1\u94f6\u884c\u76f4\u8fde\u8ba2\u5355\u72b6\u6001\uff0c\u4f20\u5165\u7684\u503c------->orderid=" + orderAmt + "\uff0corderdate=" + orderDate + "\uff0corderamt=" + orderAmt);
        Date date = null;
        try {
            date = this.df_Ymdhms.parse(orderDate);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        String formatOrderDate = this.df_Ymd.format(date);
        logger.debug("formatOrderDate:" + formatOrderDate);
        System.out.println("formatOrderDate:" + formatOrderDate);
        Extbankreq extbankreqQry = new Extbankreq();
        extbankreqQry.setOrderId(orderId);
        Extbankreq extbankreq = facade.findExtbankreq(extbankreqQry);
        String tranDesc = "";
        Map rtnResult = new HashMap();
        if (extbankreq.getBankNo().equals("ICBC") && !"X1".equals(extbankreq.getPayType())) {
            System.out.println("\u901a\u8fc7orderid\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff0c\u94f6\u884c\u7c7b\u578b\u4e3aICBC\uff0c\u652f\u4ed8\u7c7b\u578b\u4e0d\u4e3aX1\uff0c\u7c7b\u578b\u4e3a\uff1a" + extbankreq.getPayType());
            logger.info("\u8fdb\u5165ICBC\u7684if");
            String tranCode = "";
            try {
                tranCode = this.icbcCheck.isIcbcB2cPayStatusSuccess(orderId, formatOrderDate, Double.valueOf(orderAmt).doubleValue());
                System.out.println("icbcCheck.isIcbcB2cPayStatusSuccess---------->trancode=" + tranCode);
                logger.debug("tranCode:" + tranCode);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                System.err.println("\u9a8c\u8bc1\u5de5\u884c\u662f\u5426\u652f\u4ed8\u6210\u529f\uff0c\u51fa\u73b0\u5f02\u5e38");
            }
            tranDesc = PropertiesUtil.getProperty((Properties)ConfigProperties.IcbcB2CQueryProp, (String)tranCode);
            System.out.println("\u7531\u9a8c\u8bc1\u7684\u8fd4\u56de\u7801\u83b7\u53d6\u7684\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a" + tranDesc);
            if (!tranCode.equals("tranStat_1")) {
                logger.error("orderId : " + orderId + ",tranDesc : " + tranDesc);
                System.out.println("orderId : " + orderId + ",tranDesc : " + tranDesc);
                Date dateReChec = null;
                try {
                    dateReChec = this.df_Ymdhms.parse(extbankreq.getInputTime());
                }
                catch (ParseException e1) {
                    logger.error("ParseException inputtime :\u3000{}", (Throwable)e1);
                    System.err.println("ParseException inputtime :\u3000{}" + e1);
                }
                Calendar c = Calendar.getInstance();
                c.setTime(dateReChec);
                int hour = c.get(11);
                int min = c.get(12);
                if (hour > 23 && min > 55) {
                    System.out.println("\u5982\u679c\u7b26\u54080\u70b9\u91cd\u67e5\u6761\u4ef6,\u91cd\u67e5");
                    c.add(5, 1);
                    String tmp_orderDate = this.df_Ymd.format(c.getTime());
                    String inputtime = this.df_Ymdhms.format(c.getTime());
                    try {
                        tranCode = this.icbcCheck.isIcbcB2cPayStatusSuccess(orderId, tmp_orderDate, Double.valueOf(orderAmt).doubleValue());
                        System.out.println("\u96f6\u70b9\u91cd\u67e5\u83b7\u53d6\u7684\u8fd4\u56de\u7801\u4e3a\uff1a" + tranCode);
                    }
                    catch (NumberFormatException e) {
                        logger.error("orderAmt NumberFormatException : {}", (Throwable)e);
                        System.err.println("orderAmt NumberFormatException : {}" + e);
                    }
                    catch (IOException e) {
                        logger.error("method isIcbcB2cPayStatusSuccess IOException : {}", (Throwable)e);
                        System.err.println("method isIcbcB2cPayStatusSuccess IOException : {}" + e);
                    }
                    if (!tranCode.equals("tranStat_1")) {
                        tranDesc = PropertiesUtil.getProperty((Properties)ConfigProperties.IcbcB2CQueryProp, (String)tranCode);
                        logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc + ",inputtime : " + inputtime);
                    }
                }
            }
        } else if (extbankreq.getBankNo().equals("ICBC") && "X1".equals(extbankreq.getPayType())) {
            System.out.println("\u901a\u8fc7orderid\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff0c\u94f6\u884c\u7c7b\u578b\u4e3aICBC(\u5de5\u884c)\uff0c\u652f\u4ed8\u7c7b\u578b\u4e3aX1(\u94f6\u901a\u652f\u4ed8)");
            try {
                IcbcRetrieveVo icbcretrievevo = new IcbcRetrieveVo(orderId);
                rtnResult = com.xunlei.pay.center.icbc.retrieve.facade.IFacade.INSTANCE.retrieveIcbcDudect(icbcretrievevo);
                logger.debug("rtnResult:" + rtnResult);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            String code = "\u65e0";
            String retMsg = "\u65e0";
            String status = (String)rtnResult.get("status");
            String extRetMsg = "";
            if (this.isNotEmpty((String)rtnResult.get("code"))) {
                code = (String)rtnResult.get("code");
            }
            if (this.isNotEmpty((String)rtnResult.get("retMsg"))) {
                retMsg = (String)rtnResult.get("retMsg");
            }
            logger.info("code : " + code + ", retMsg :" + retMsg + ", status :" + status);
            extRetMsg = this.isNotEmpty(status) && "S".equals(status) ? "\u67e5\u8be2\u6210\u529f" : (this.isNotEmpty(status) && "N".equals(status) ? ("0".equals(code) ? "\u63d0\u4ea4\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406" : ("1".equals(code) ? "\u6388\u6743\u6210\u529f,\u7b49\u5f85\u94f6\u884c\u5904\u7406" : ("2".equals(code) ? "\u7b49\u5f85\u6388\u6743" : ("3".equals(code) ? "\u7b49\u5f85\u4e8c\u6b21\u6388\u6743" : ("4".equals(code) ? "\u7b49\u5f85\u94f6\u884c\u7b54\u590d" : ("5".equals(code) ? "\u4e3b\u673a\u8fd4\u56de\u5f85\u5904\u7406" : ("6".equals(code) ? "\u88ab\u94f6\u884c\u62d2\u7edd" : ("8".equals(code) ? "\u6307\u4ee4\u88ab\u62d2\u7edd\u6388\u6743" : ("9".equals(code) ? "\u94f6\u884c\u6b63\u5728\u5904\u7406" : ("10".equals(code) ? "\u9884\u7ea6\u6307\u4ee4" : ("11".equals(code) ? "\u9884\u7ea6\u53d6\u6d88" : ""))))))))))) : "\u67e5\u8be2\u8fc7\u7a0b\u5931\u8d25");
            tranDesc = ",\u8fd4\u56de\u7801:" + code + ",\u8fd4\u56de\u4fe1\u606f:" + retMsg + "," + extRetMsg;
            logger.info("\u8fdb\u5165ICBC\u548cXLYT\u7684if,orderId:" + orderId + ", tranDesc :" + tranDesc);
        } else if (extbankreq.getBankNo().equals("CMB")) {
            System.out.println("\u901a\u8fc7orderid\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff0c\u94f6\u884c\u7c7b\u578b\u4e3aCMB(\u62db\u884c)\uff0c\u652f\u4ed8\u7c7b\u578b\u4e3a\uff1a" + extbankreq.getPayType());
            CmbCheck.CmbCheckRet cmbData = CmbCheck.getInstance().querySingleOrder(formatOrderDate, extbankreq.getOrderId(), extbankreq.getOrderAmt());
            tranDesc = CmbCheck.getInstance().getResource().getString("tranStat_" + cmbData.getCheckStatus());
            if (cmbData.getCheckStatus() != 0) {
                logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc);
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                int hour = c.get(11);
                int min = c.get(12);
                if (hour > 23 && min > 55) {
                    c.add(5, 1);
                    String inputtime = this.df_Ymdhms.format(c.getTime());
                    cmbData = CmbCheck.getInstance().querySingleOrder(this.Ymdhms2Ymd(inputtime), extbankreq.getOrderId(), extbankreq.getOrderAmt());
                    if (cmbData.getCheckStatus() != 0) {
                        tranDesc = CmbCheck.getInstance().getResource().getString("tranStat_" + cmbData.getCheckStatus());
                        logger.error("orderId : " + extbankreq.getOrderId() + ",tranDesc : " + tranDesc + ",inputtime : " + inputtime);
                    }
                }
            }
        } else if (extbankreq.getBankNo().equals("ABC")) {
            System.out.println("\u901a\u8fc7orderid\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff0c\u94f6\u884c\u7c7b\u578b\u4e3aABC(\u519c\u884c)\uff0c\u652f\u4ed8\u7c7b\u578b\u4e3a\uff1a" + extbankreq.getPayType());
            tranDesc = this.getABCOrderStatusTranDesc(orderId, orderAmt);
        } else if (extbankreq.getBankNo().equals("CCB") && "X1".equals(extbankreq.getPayType())) {
            if ("U".equals(orderStatus)) {
                orderStatus = "";
            }
            rtnResult = new MonitorCCBDudectHandler().query(orderId, orderAmt, orderStatus, orderDate.substring(0, 10));
            logger.debug("rtnResult:" + rtnResult);
            if ("Y".equals(rtnResult.get("timeOut"))) {
                logger.info("orderId:" + orderId + " query timeout");
                tranDesc = "\u67e5\u8be2\u8d85\u65f6";
            } else if ("N".equals(rtnResult.get("checkSuccess"))) {
                String errMsg = (String)rtnResult.get("msg");
                logger.info("orderId:" + orderId + " query failed:" + errMsg);
                if (StringTools.isEmpty((String)errMsg)) {
                    errMsg = "\u67e5\u8be2\u5931\u8d25";
                }
                tranDesc = errMsg;
            } else if ("Y".equals(rtnResult.get("checkSuccess"))) {
                logger.info("orderId:" + orderId + " query successed");
                tranDesc = "\u67e5\u8be2\u6210\u529f\uff0c\u8ba2\u5355\u5df2\u6210\u529f\u652f\u4ed8";
            }
        } else if (extbankreq.getBankNo().equals("CCB") && !"X1".equals(extbankreq.getPayType())) {
            logger.info("orderid[" + orderId + "],bankno: " + extbankreq.getBankNo() + ", paytype: " + extbankreq.getPayType());
            rtnResult = CCBQuery.defaultQuerySingleByOrderid((String)orderId, (double)extbankreq.getOrderAmt());
            String timeout = (String)rtnResult.get("timeOut");
            String queryCode = (String)rtnResult.get("checkSuccess");
            if (timeout.equals("N") && queryCode.equals("Y")) {
                tranDesc = "\u67e5\u8be2\u6210\u529f";
            } else if (timeout.equals("Y")) {
                logger.info("orderid[" + orderId + "]\u67e5\u8be2\u8d85\u65f6");
                tranDesc = "\u67e5\u8be2\u8d85\u65f6,\u8bf7\u7a0d\u540e\u518d\u8bd5";
            } else {
                logger.info("orderid[" + orderId + "],\u67e5\u8be2\u7ed3\u679c\u672a\u6210\u529f\uff1a" + (String)rtnResult.get("msg"));
                tranDesc = "\u67e5\u8be2\u5931\u8d25\uff1a" + (String)rtnResult.get("msg");
            }
        }
        this.orderBankStateDesc = orderId + ":" + tranDesc;
        logger.debug("orderBankStateDesc:" + this.orderBankStateDesc);
        System.out.println("orderBankStateDesc:" + this.orderBankStateDesc);
        this.alertJS(orderId + ":" + tranDesc);
        return null;
    }

    public IcbcCheckRet getIcbcCheckRet(Extbankreq bankreq, String inputtime) throws IOException {
        String orderId = bankreq.getOrderId();
        String orderDate = this.Ymdhms2Ymd(inputtime);
        Double orderAmt = bankreq.getOrderAmt();
        IcbcCheckRet icbcCheckRet = this.icbcCheck.getIcbcB2cPayStatus(orderId, orderDate, orderAmt.doubleValue());
        logger.info("orderId = " + orderId + ",orderDate = " + orderDate + ",orderStatus = " + icbcCheckRet.getOrderTranStat());
        return icbcCheckRet;
    }

    public String Ymdhms2Ymd(String time_Ymdhms) {
        if (time_Ymdhms.isEmpty() || time_Ymdhms == null) {
            return "";
        }
        String time_Ymd = "";
        try {
            time_Ymd = this.df_Ymd.format(this.df_Ymdhms.parse(time_Ymdhms).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            logger.error("Ymdhms2Ymd with Exception:{}", (Throwable)e);
        }
        return time_Ymd;
    }

    public String getOrderBankStateDesc() {
        return this.orderBankStateDesc;
    }

    public void setOrderBankStateDesc(String orderBankStateDesc) {
        this.orderBankStateDesc = orderBankStateDesc;
    }

    private void doMoveIcbc(Extbankreq extbankreq, String dealTime) {
        extbankreq.setRemark(this.noticeok_remark(extbankreq.getRemark()));
        facade.updateExtbankreq(extbankreq);
        Extbankok extbankok = new Extbankok();
        extbankok.setOrderId(extbankreq.getOrderId());
        extbankok.setOrderAmt(extbankreq.getOrderAmt());
        extbankok.setTradeNo(extbankreq.getTradeNo());
        extbankok.setDealTime(dealTime);
        extbankok.setDealTime(Utility.otherdateofnow());
        extbankok.setBizOrderStatus("Y");
        facade.moveExtbankreqToSuccess(extbankok);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extbankok.getOrderId());
        this.alertJS("\u5b9a\u5236\u6210\u529f");
    }

    private void doMoveCmb(Extbankreq extbankreq, String dealTime, String tranDesc) {
        extbankreq.setRemark(this.noticeok_remark(extbankreq.getRemark()));
        facade.updateExtbankreq(extbankreq);
        Extbankok extbankok = new Extbankok();
        extbankok.setOrderId(extbankreq.getOrderId());
        extbankok.setOrderAmt(extbankreq.getOrderAmt());
        extbankok.setTradeNo(extbankreq.getTradeNo());
        extbankok.setDealTime(dealTime);
        extbankok.setBizOrderStatus("Y");
        facade.moveExtbankreqToSuccess(extbankok);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extbankok.getOrderId());
        logger.error("orderId = " + extbankreq.getOrderId() + ",tranDesc = " + tranDesc);
        this.alertJS(extbankreq.getOrderId() + ":" + tranDesc);
    }

    private void doMoveAbc(Extbankreq extbankreq, String tranDesc) {
        extbankreq.setRemark(this.noticeok_remark(extbankreq.getRemark()));
        facade.updateExtbankreq(extbankreq);
        Extbankok extbankok = new Extbankok();
        extbankok.setOrderId(extbankreq.getOrderId());
        extbankok.setOrderAmt(extbankreq.getOrderAmt());
        extbankok.setTradeNo(extbankreq.getTradeNo());
        extbankok.setDealTime(Utility.otherdateofnow());
        extbankok.setBizOrderStatus("Y");
        facade.moveExtbankreqToSuccess(extbankok);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extbankok.getOrderId());
        logger.error("orderId = " + extbankreq.getOrderId() + ",tranDesc = " + tranDesc);
        this.alertJS(extbankreq.getOrderId() + ":" + tranDesc);
    }

    private void doMoveCCBDirect(Extbankreq extbankreq, double payment, String tranDesc) {
        logger.info("doMoveCCBDirect-----start, payment: " + payment + ", tranDesc: " + tranDesc);
        extbankreq.setRemark(this.noticeok_remark(extbankreq.getRemark()));
        facade.updateExtbankreq(extbankreq);
        Extbankok extbankok = new Extbankok();
        extbankok.setOrderId(extbankreq.getOrderId());
        extbankok.setBizOrderStatus("Y");
        if (payment <= 0.0) {
            extbankok.setOrderAmt(extbankreq.getOrderAmt());
        } else {
            extbankok.setOrderAmt(payment);
        }
        extbankok.setExt1(extbankreq.getExt1());
        extbankok.setExt2(extbankreq.getExt2());
        extbankok.setTradeNo(extbankreq.getTradeNo());
        extbankok.setDealTime(extbankreq.getDealTime());
        extbankok.setRemark(extbankreq.getRemark());
        extbankok.setBizOrderStatus("Y");
        facade.moveExtbankreqToSuccess(extbankok);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extbankok.getOrderId());
        logger.error("orderId = " + extbankreq.getOrderId() + ",tranDesc = " + tranDesc);
        this.alertJS(extbankreq.getOrderId() + ":" + tranDesc);
    }

    private void doMoveCCBDudect(Extbankreq extbankreq, double payment, String tranDesc) {
        extbankreq.setRemark(this.noticeok_remark(extbankreq.getRemark()));
        facade.updateExtbankreq(extbankreq);
        Extbankok extbankok = new Extbankok();
        extbankok.setOrderId(extbankreq.getOrderId());
        extbankok.setBizOrderStatus("Y");
        if (payment <= 0.0) {
            extbankok.setOrderAmt(extbankreq.getOrderAmt());
        } else {
            extbankok.setOrderAmt(payment);
        }
        extbankok.setExt1(extbankreq.getExt1());
        extbankok.setExt2(extbankreq.getExt2());
        extbankok.setTradeNo(extbankreq.getTradeNo());
        extbankok.setDealTime(extbankreq.getDealTime());
        extbankok.setRemark(extbankreq.getRemark());
        extbankok.setBizOrderStatus("Y");
        facade.moveExtbankreqToSuccess(extbankok);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extbankok.getOrderId());
        logger.error("orderId = " + extbankreq.getOrderId() + ",tranDesc = " + tranDesc);
        this.alertJS(extbankreq.getOrderId() + ":" + tranDesc);
    }
}

