/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.thirdparty.client.ThirdpartyQueryClient;
import com.xunlei.channel.thirdparty.vo.QueryRequest;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.vo.ExtArsoftPay;
import com.xunlei.payproxy.vo.ExtArsoftPayOk;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.Properties;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyArsoftpay")
public class ExtarsoftpayManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtarsoftpayManagedBean.class);
    private static Map<String, String> payTypeMap;
    private static SelectItem[] payTypeItem;

    public Map<String, String> getPayTypeMap() {
        if (null == payTypeMap) {
            payTypeMap = new HashMap<String, String>();
            payTypeMap.put("AT", "\u4f18\u6613\u4ed8\u79fb\u52a8\u70b9\u64ad");
            payTypeMap.put("AS", "\u4f18\u6613\u4ed8\u79fb\u52a8\u5305\u6708");
            payTypeMap.put("AR", "\u4f18\u6613\u4ed8\u7535\u4fe1\u70b9\u64ad");
            payTypeMap.put("AQ", "\u4f18\u6613\u4ed8\u7535\u4fe1\u5305\u6708");
        }
        return payTypeMap;
    }

    public SelectItem[] getPayTypeItem() {
        if (payTypeItem == null) {
            payTypeItem = new SelectItem[4];
            ExtarsoftpayManagedBean.payTypeItem[0] = new SelectItem((Object)"AT", "\u4f18\u6613\u4ed8\u79fb\u52a8\u70b9\u64ad");
            ExtarsoftpayManagedBean.payTypeItem[1] = new SelectItem((Object)"AS", "\u4f18\u6613\u4ed8\u79fb\u52a8\u5305\u6708");
            ExtarsoftpayManagedBean.payTypeItem[2] = new SelectItem((Object)"AR", "\u4f18\u6613\u4ed8\u7535\u4fe1\u70b9\u64ad");
            ExtarsoftpayManagedBean.payTypeItem[3] = new SelectItem((Object)"AQ", "\u4f18\u6613\u4ed8\u7535\u4fe1\u5305\u6708");
        }
        return payTypeItem;
    }

    public String getQuery() {
        logger.debug("entering ExtarsoftpayManagedBean getQuery() ...");
        this.authenticateRun();
        ExtArsoftPay data = (ExtArsoftPay)this.findBean(ExtArsoftPay.class, "payproxy_extarsoftpay");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getFromdate())) {
                data.setFromdate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getTodate())) {
                data.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtArsoftPay(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String checkOrderStatus() throws ParseException {
        this.authenticateRun();
        String xunleiPayId = this.findParameter("query_xunleiPayId");
        if (StringUtils.isEmpty((String)xunleiPayId)) {
            this.alertJS("\u51fa\u73b0\u5f02\u5e38\uff0c\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a\u7a7a");
            return "";
        }
        ExtArsoftPayOk search = new ExtArsoftPayOk();
        search.setXunleiPayId(xunleiPayId);
        ExtArsoftPayOk extArsoftPayOk = facade.findExtArsoftPayOk(search);
        if (null != extArsoftPayOk) {
            this.alertJS("\u8be5\u8ba2\u5355\u5df2\u6210\u529f");
            return "";
        }
        ExtArsoftPay searchArsoftPay = new ExtArsoftPay();
        searchArsoftPay.setXunleiPayId(xunleiPayId);
        ExtArsoftPay extArsoftPay = facade.findExtArsoftPay(searchArsoftPay);
        QueryResponse response = this.getQuery3rdPartyResult(extArsoftPay);
        this.alertJS(response.getErrMsg());
        return "";
    }

    public QueryResponse getQuery3rdPartyResult(ExtArsoftPay extArsoftPay) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        QueryRequest request = new QueryRequest(extArsoftPay.getXunleiPayId(), extArsoftPay.getPayType(), (int)extArsoftPay.getOrderAmt() * 100, extArsoftPay.getXunleiId(), extArsoftPay.getUserShow(), "", "", "", sdf.parse(extArsoftPay.getInputTime()), "", "");
        Map<String, String> channelConfigMap = Properties.getPayTypeConfigMap("arsoft");
        QueryResponse response = ThirdpartyQueryClient.query3rdPartyOrder((QueryRequest)request, channelConfigMap);
        return response;
    }

    public String moveExtArsoftPayToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticeBtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                ExtArsoftPay extArsoftPayQuery = new ExtArsoftPay();
                extArsoftPayQuery.setSeqid(Long.valueOf(seqid).longValue());
                ExtArsoftPay extArsoftPay = facade.findExtArsoftPay(extArsoftPayQuery);
                if (extArsoftPay == null) continue;
                String xunleiPayId = extArsoftPay.getXunleiPayId();
                try {
                    logger.debug("\u5f00\u59cb\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c....");
                    boolean query = CustomUtil.isQuery((String)"arsoftpay");
                    logger.info("jdpayweb query:" + query + "\txunleipayid:" + xunleiPayId);
                    if (!query) {
                        this.doMove(extArsoftPay.getXunleiPayId());
                    } else {
                        QueryResponse response = this.getQuery3rdPartyResult(extArsoftPay);
                        if (response.isQuerySuccess()) {
                            this.doMove(extArsoftPay.getXunleiPayId());
                        } else {
                            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25\uff0c\u4fe1\u606f\u4e3a\uff1a" + response.getErrMsg());
                        }
                    }
                    logger.debug("\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c\u7ed3\u675f....");
                }
                catch (Exception e) {
                    this.alertJS("\u5b9a\u5236\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38,\u5b9a\u5236\u5931\u8d25!");
                    logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    private void doMove(String xunleiPayId) {
        facade.moveArsoftPayToOk(xunleiPayId);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)xunleiPayId);
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }
}

