/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.thirdparty.client.ThirdpartyQueryClient;
import com.xunlei.channel.thirdparty.vo.QueryRequest;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.ExtAlipayMonthBind;
import com.xunlei.payproxy.vo.ExtAlipayMonthOk;
import com.xunlei.payproxy.vo.ExtAlipayMonthReq;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.AlipayPartnerUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyAlipayMonthreq")
public class ExtalipaymonthreqManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtalipaymonthreqManagedBean.class);
    private static Map<String, String> orderStatusMap;
    private static String notice;
    private static String payType;
    private static String queryUrl;

    public String getQuery() {
        logger.debug("entering ExtalipaymonthreqManagedBean#getQuery...");
        this.authenticateRun();
        ExtAlipayMonthReq data = (ExtAlipayMonthReq)this.findBean(ExtAlipayMonthReq.class, "payproxy_extalipaymonthreq");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getBeginDate())) {
                data.setBeginDate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getEndDate())) {
                data.setEndDate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtAlipayMonthReq(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public Map<String, String> getOrderStatusMap() {
        if (orderStatusMap == null) {
            orderStatusMap = new HashMap<String, String>();
            orderStatusMap.put("W", "\u7b49\u5f85");
            orderStatusMap.put("N", "\u5931\u8d25");
            orderStatusMap.put("U", "\u53ef\u7591");
        }
        return orderStatusMap;
    }

    public void checkOrderStatus() {
        String xunleiPayId = this.findParameter("query_orderId");
        logger.debug("check order status xunleiPayId: {}", (Object)xunleiPayId);
        if (StringUtils.isEmpty((String)xunleiPayId)) {
            this.alertJS("\u67e5\u8be2\u7684\u8bf7\u6c42\u8ba2\u5355xunleiPayId\u4e3a\u7a7a!");
            return;
        }
        Bizorder bizorder = new Bizorder();
        bizorder.setXunleipayid(xunleiPayId);
        Bizorder found = facade.findBizorder(bizorder);
        if (found == null) {
            this.alertJS("\u67e5\u8be2\u7684\u8bf7\u6c42\u8ba2\u5355\u4e0d\u5b58\u5728Bizorder\u8868\u4e2d\uff01");
            return;
        }
        try {
            QueryRequest request = new QueryRequest(found.getXunleiid(), payType, (int)(found.getOrderamt() * 100.0));
            Map<String, String> config = AlipayPartnerUtil.createConfigByPartner(found.getOther2());
            QueryResponse response = ThirdpartyQueryClient.query3rdPartyOrder((QueryRequest)request, config);
            this.alertJS(notice + response.getErrMsg());
        }
        catch (Exception e) {
            logger.warn("", (Throwable)e);
            this.alertJS("\u53d1\u751f\u5f02\u5e38:" + e.toString());
        }
    }

    public String gensignedUrl(String bizNo, String xlnumId, String xunleiPayId, String bizKey) {
        StringBuffer signMsg = new StringBuffer();
        signMsg.append("bizNo=").append(bizNo).append("&");
        signMsg.append("xlnumId=").append(xlnumId).append("&");
        signMsg.append("xunleiPayId=").append(xunleiPayId);
        String sign = Md5Encrypt.md5((String)(signMsg.toString() + bizKey));
        StringBuffer queryStr = new StringBuffer(queryUrl);
        queryStr.append(signMsg.toString()).append("&signMsg=").append(sign);
        return queryStr.toString();
    }

    public static String analysisXML(Document document, String nodeName) throws DocumentException {
        Element root = document.getRootElement();
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(root);
        while (list != null) {
            Element element = null;
            Element firstElement = null;
            Iterator iter = list.iterator();
            if (iter.hasNext()) {
                firstElement = (Element)iter.next();
                iter.remove();
            }
            if (firstElement == null) continue;
            Iterator i = firstElement.elementIterator();
            while (i != null && i.hasNext()) {
                element = (Element)i.next();
                list.add(element);
                if (element == null || !element.getName().equals(nodeName)) continue;
                return element.getText();
            }
        }
        return null;
    }

    public String moveExtAlipayMonthReqToSuccess() {
        String[] seqIds;
        this.authenticateEdit();
        String selectIds = this.findParameter("noticeBtn");
        if (this.isEmpty(selectIds)) {
            logger.debug("selectIds is null \uff01");
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\uff01");
        }
        logger.debug("moveExtAlipayMonthReqToSuccess, selectIds : {}", (Object)selectIds);
        String[] stringArray = seqIds = selectIds.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        if (n2 < n) {
            String seqId = stringArray[n2];
            ExtAlipayMonthReq extAlipayMonthReq = new ExtAlipayMonthReq();
            extAlipayMonthReq.setSeqId(Long.valueOf(seqId).longValue());
            ExtAlipayMonthReq reqResult = facade.findExtAlipayMonthReq(extAlipayMonthReq);
            if (null == reqResult) {
                logger.error("according to seqId:{}, can not find ExtAlipayMonthReq", (Object)seqId);
                this.alertJS("\u64cd\u4f5c\u5931\u8d25,\u65e0\u6cd5\u627e\u5230\u8ba2\u5355!");
                return "";
            }
            String xunleiPayId = reqResult.getXunleiPayId();
            String bizNo = reqResult.getBizNo();
            String xlnumId = reqResult.getXunleiId();
            Copbizinfo copbizinfoForQuery = new Copbizinfo();
            copbizinfoForQuery.setBizno(bizNo);
            Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
            if (copbizinfo == null || copbizinfo.getBizstatus().equals("C")) {
                this.alertJS("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\uff01");
                return "";
            }
            String bizKey = copbizinfo.getBizkey();
            String url = this.gensignedUrl(bizNo, xlnumId, xunleiPayId, bizKey);
            logger.info("\u67e5\u8be2url-->{}", (Object)url);
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setParameter("http.connection.timeout", (Object)6000);
            client.getParams().setParameter("http.socket.timeout", (Object)6000);
            HttpGet get = new HttpGet(url);
            HttpResponse res = null;
            try {
                res = client.execute((HttpUriRequest)get);
            }
            catch (IOException e) {
                logger.error("\u67e5\u8be2\u8d85\u65f6\uff01{}", (Object)e.getMessage());
                this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff01");
                return "";
            }
            if (res == null) {
                logger.error("\u67e5\u8be2\u8d85\u65f6\uff01url: {}", (Object)url);
                this.alertJS("\u67e5\u8be2\u8d85\u65f6\uff01");
                return "";
            }
            if (res.getStatusLine().getStatusCode() != 200) {
                logger.error("\u67e5\u8be2\u5931\u8d25\uff01response code: {}", (Object)res.getStatusLine().getStatusCode());
                this.alertJS("\u67e5\u8be2\u5931\u8d25,\u670d\u52a1\u5668\u54cd\u5e94\u7801\u4e0d\u6b63\u786e\uff01code: " + res.getStatusLine().getStatusCode());
                return "";
            }
            try {
                String entity = EntityUtils.toString((HttpEntity)res.getEntity());
                logger.debug("response: {}", (Object)entity);
                Document doc = DocumentHelper.parseText((String)entity);
                Element rootElement = doc.getRootElement();
                String payresult = rootElement.element("payresult").getText();
                String orderStatus = rootElement.element("orderStatus").getText();
                if (StringUtils.isNotEmpty((String)payresult) && StringUtils.isNotEmpty((String)orderStatus) && "00".equals(payresult.trim()) && "TRADE_SUCCESS".equals(orderStatus.trim())) {
                    ExtAlipayMonthBind bindQuery = new ExtAlipayMonthBind();
                    bindQuery.setBizNo(bizNo);
                    bindQuery.setXunleiId(xlnumId);
                    ExtAlipayMonthBind bindResult = facade.findExtAlipayMonthBind(bindQuery);
                    if (bindResult == null || StringUtils.isEmpty((String)bindResult.getBindId())) {
                        logger.error("\u64cd\u4f5c\u5931\u8d25\uff0c\u6ca1\u6709\u7b7e\u7ea6\uff01");
                        this.alertJS("\u64cd\u4f5c\u5931\u8d25\uff0c\u6ca1\u6709\u7b7e\u7ea6\uff01");
                        return "";
                    }
                    ExtAlipayMonthOk extAlipayMonthOk = new ExtAlipayMonthOk();
                    extAlipayMonthOk.setOrderId(reqResult.getOrderId());
                    extAlipayMonthOk.setAmount(reqResult.getAmount());
                    extAlipayMonthOk.setXunleiId(xlnumId);
                    extAlipayMonthOk.setUserShow(reqResult.getUserShow());
                    extAlipayMonthOk.setXunleiPayId(xunleiPayId);
                    extAlipayMonthOk.setOrderTime(reqResult.getOrderTime());
                    extAlipayMonthOk.setSuccessTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                    extAlipayMonthOk.setBalanceDate("");
                    extAlipayMonthOk.setNotifyTime("");
                    extAlipayMonthOk.setTradeNo(reqResult.getTradeNo());
                    extAlipayMonthOk.setGoodNo(reqResult.getGoodNo());
                    extAlipayMonthOk.setBizNo(bizNo);
                    extAlipayMonthOk.setFareAmount(extAlipayMonthOk.getAmount() * 0.01);
                    extAlipayMonthOk.setFactAmount(extAlipayMonthOk.getAmount() - extAlipayMonthOk.getFareAmount());
                    extAlipayMonthOk.setExt1("");
                    extAlipayMonthOk.setExt2("");
                    extAlipayMonthOk.setRemark("");
                    extAlipayMonthOk.setBuyerLogonId("BD");
                    extAlipayMonthOk.setBuyerUserId(bindResult.getAlipayUserId());
                    extAlipayMonthOk.setOrderStatus("Y");
                    facade.moveExtAlipayMonthReqToSuccess(extAlipayMonthOk);
                    logger.info("move orderId:{}, success!", (Object)extAlipayMonthOk.getOrderId());
                    PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extAlipayMonthReq.getXunleiPayId());
                    this.alertJS("\u64cd\u4f5c\u6210\u529f!");
                    return "";
                }
                this.alertJS("\u8ba2\u5355\u652f\u4ed8\u672a\u6210\u529f\uff01");
                return "";
            }
            catch (DocumentException e) {
                logger.error("\u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! {}", (Object)e.getMessage());
                this.alertJS("\u67e5\u8be2\u5931\u8d25, \u89e3\u6790\u54cd\u5e94\u7ed3\u679c\u51fa\u9519, {}");
                return "";
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u5931\u8d25\uff01{}", (Object)e.getMessage());
                this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage());
                return "";
            }
        }
        return "";
    }

    static {
        notice = "\u8ba2\u5355\u5c1a\u5728bizorder\u8868\u4e2d\uff0c";
        payType = "AM";
        queryUrl = "http://proxy.pay.xunlei.com/alipayMonthQueryOrderServlet?";
    }
}

