/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.thirdparty.client.ThirdpartyQueryClient;
import com.xunlei.channel.thirdparty.vo.QueryRequest;
import com.xunlei.channel.thirdparty.vo.QueryResponse;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.ExtAlipayMonthOk;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.AlipayPartnerUtil;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyAlipayMonthok")
public class ExtalipaymonthokManagedBean
extends BaseManagedBean {
    private static String payType = "AM";
    private static final Logger logger = LoggerFactory.getLogger(ExtalipaymonthokManagedBean.class);
    private static Map<String, String> orderStatusMap;
    private static SelectItem[] orderStatusItem;
    private static String missOrderNotice;

    public String getQuery() {
        logger.debug("entering ExtalipaymonthokManagedBean#getQuery...");
        this.authenticateRun();
        ExtAlipayMonthOk data = (ExtAlipayMonthOk)this.findBean(ExtAlipayMonthOk.class, "payproxy_extalipaymonthok");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getBeginDate())) {
                data.setBeginDate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getEndDate())) {
                data.setEndDate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid desc");
            Sheet sheet = facade.queryExtAlipayMonthOk(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String checkOrderStatus() {
        this.authenticateRun();
        String xunleiPayId = this.findParameter("query_orderId");
        if (StringUtils.isEmpty((String)xunleiPayId)) {
            this.alertJS("\u51fa\u73b0\u5f02\u5e38\uff0c\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a\u7a7a");
            return "";
        }
        Bizorderok order = new Bizorderok();
        order.setXunleipayid(xunleiPayId);
        Bizorderok found = facade.findBizorderok(order);
        QueryResponse response = null;
        try {
            if (found != null) {
                QueryRequest request = new QueryRequest(xunleiPayId, payType, (int)(found.getOrderamt() * 100.0));
                Map<String, String> config = AlipayPartnerUtil.createConfigByPartner(found.getOther2());
                response = ThirdpartyQueryClient.query3rdPartyOrder((QueryRequest)request, config);
                this.alertJS(response.getErrMsg());
            } else {
                this.alertJS("\u8ba2\u5355\u4e0d\u5b58\u5728bizorderok\u8868\u4e2d");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.alertJS("\u53d1\u751f\u5f02\u5e38:" + e.toString());
        }
        return "";
    }

    public Map<String, String> getOrderStatusMap() {
        if (orderStatusMap == null) {
            orderStatusMap = new HashMap<String, String>();
            orderStatusMap.put("Y", "\u6210\u529f");
            orderStatusMap.put("N", "\u5931\u8d25");
        }
        return orderStatusMap;
    }

    public SelectItem[] getOrderStatusItem() {
        if (orderStatusItem == null) {
            orderStatusItem = new SelectItem[2];
            ExtalipaymonthokManagedBean.orderStatusItem[0] = new SelectItem((Object)"Y", "\u6210\u529f");
            ExtalipaymonthokManagedBean.orderStatusItem[1] = new SelectItem((Object)"N", "\u5931\u8d25");
        }
        return orderStatusItem;
    }

    static {
        missOrderNotice = "\u5728bizorok\u8868\u4e2d\u672a\u67e5\u5230\u6570\u636e\uff01";
    }
}

