/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.ExtAlipayMonthBind;
import com.xunlei.payproxy.vo.ExtAlipayMonthBindReq;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyAlipayMonthbindreq")
public class ExtalipaymonthbindreqManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtalipaymonthbindreqManagedBean.class);
    private String alipayMonthQuerySignUrl = new String("http://proxy.pay.xunlei.com/alipayMonthQuerySignServlet?");

    public String getQuery() {
        this.authenticateRun();
        ExtAlipayMonthBindReq data = (ExtAlipayMonthBindReq)this.findBean(ExtAlipayMonthBindReq.class, "payproxy_extalipaymonthbindreq");
        if (data != null) {
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtAlipayMonthBindReq(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public void checkOrderStatus() {
        String seqId = this.findParameter("query_externalSignNo");
        logger.debug("checkOrderStatus#seqId : {}", (Object)seqId);
        if (StringUtils.isEmpty((String)seqId)) {
            this.alertJS("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return;
        }
        ExtAlipayMonthBind query = new ExtAlipayMonthBind();
        query.setSeqId(Long.parseLong(seqId));
        ExtAlipayMonthBind result = facade.findExtAlipayMonthBind(query);
        if (null == result) {
            this.alertJS("\u67e5\u8be2\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
            return;
        }
        if (StringUtils.isNotEmpty((String)result.getBindId())) {
            this.alertJS("\u8be5\u8bb0\u5f55\u5df2\u7ecf\u7b7e\u7ea6\u6210\u529f\uff01");
            return;
        }
        String xlnumId = result.getXunleiId();
        String bizNo = result.getBizNo();
        Copbizinfo copbizinfoForQuery = new Copbizinfo();
        copbizinfoForQuery.setBizno(bizNo);
        Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
        if (copbizinfo == null || copbizinfo.getBizstatus().equals("C")) {
            this.alertJS("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\uff01");
            return;
        }
        String bizKey = copbizinfo.getBizkey();
        HashMap<String, String> parasMap = new HashMap<String, String>();
        parasMap.put("bizNo", bizNo);
        parasMap.put("xlnumId", xlnumId);
        String signMsg = this.sign(parasMap, bizKey);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.alipayMonthQuerySignUrl).append("bizNo=").append(bizNo).append("&").append("xlnumId=").append(xlnumId).append("&").append("signMsg=").append(signMsg);
        logger.info("query sign url: {}", (Object)urlBuilder.toString());
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getParams().setParameter("http.connection.timeout", (Object)6000);
        httpclient.getParams().setParameter("http.socket.timeout", (Object)6000);
        HttpGet httpGet = new HttpGet(urlBuilder.toString());
        HttpResponse res = null;
        try {
            res = httpclient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            logger.error("query sign failed, msg: {}", (Object)e.getMessage());
            this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01");
            return;
        }
        if (res == null) {
            logger.error("query sign timeout, url: {}", (Object)urlBuilder.toString());
            this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01");
            return;
        }
        if (res.getStatusLine().getStatusCode() != 200) {
            logger.error("query sign failed, statuscode is incorrected, status code: {}", (Object)res.getStatusLine().getStatusCode());
            this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01");
            return;
        }
        String resultText = "";
        Document doc = null;
        Element root = null;
        String payresult = "";
        String status = "";
        String errcode = "";
        try {
            resultText = EntityUtils.toString((HttpEntity)res.getEntity());
            logger.info("response text is : {}", (Object)resultText);
            doc = DocumentHelper.parseText((String)resultText);
            root = doc.getRootElement();
            payresult = root.element("payresult").getText();
            status = root.element("status").getText();
            errcode = root.element("errcode").getText();
        }
        catch (Exception e) {
            logger.error("query sign failed, parsing error, msg: {}", (Object)e.getMessage());
            this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01");
            return;
        }
        if (StringUtils.isNotEmpty((String)payresult) && "00".equals(payresult.trim()) && StringUtils.isNotEmpty((String)status) && "NORMAL".equals(status.trim())) {
            this.alertJS("\u7b7e\u7ea6\u6210\u529f\uff01");
            return;
        }
        if (StringUtils.isNotEmpty((String)payresult) && "10".equals(payresult.trim()) && StringUtils.isNotEmpty((String)errcode) && "1919".equals(errcode.trim())) {
            this.alertJS("\u7b7e\u7ea6\u4e0d\u5b58\u5728\uff01");
            return;
        }
        logger.error("query sign failed, payresult: {}, status: {}", (Object)payresult, (Object)status);
        this.alertJS("\u7b7e\u7ea6\u5931\u8d25\uff01");
    }

    private String sign(Map<String, String> map, String key) {
        StringBuilder builder = new StringBuilder();
        builder.append(ExtalipaymonthbindreqManagedBean.createLinkString(map)).append(key);
        return Md5Encrypt.md5((String)builder.toString(), (String)"GBK");
    }

    private static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (StringUtils.isEmpty((String)value)) continue;
            if (i == keys.size() - 1) {
                builder.append(key).append("=").append(value);
                continue;
            }
            builder.append(key).append("=").append(value).append("&");
        }
        return builder.toString();
    }

    public void moveExtAlipayMonthBindReqToBindOk() {
        String[] seqId;
        this.authenticateEdit();
        String seqIds = this.findParameter("noticeBtn");
        if (this.isEmpty(seqIds)) {
            logger.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01{}", (Object)seqIds);
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
        }
        logger.debug("seqIds: {}", (Object)seqIds);
        String[] stringArray = seqId = seqIds.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        if (n2 < n) {
            String id = stringArray[n2];
            ExtAlipayMonthBind query = new ExtAlipayMonthBind();
            query.setSeqId(Long.valueOf(id).longValue());
            ExtAlipayMonthBind result = facade.findExtAlipayMonthBind(query);
            if (null == result) {
                logger.error("\u8bf7\u6c42\u8bb0\u5f55\u4e0d\u5b58\u5728, id: {}", (Object)id);
                this.alertJS("\u8bf7\u6c42\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
                return;
            }
            if (StringUtils.isNotEmpty((String)result.getBindId())) {
                logger.error("\u5df2\u7ecf\u7b7e\u7ea6\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u4e0b\uff0cid: {}", (Object)id);
                this.alertJS("\u5df2\u7ecf\u7b7e\u7ea6\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u4e0b\uff01");
                return;
            }
            String xlnumId = result.getXunleiId();
            String bizNo = result.getBizNo();
            Copbizinfo copbizinfoForQuery = new Copbizinfo();
            copbizinfoForQuery.setBizno(bizNo);
            Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
            if (copbizinfo == null || copbizinfo.getBizstatus().equals("C")) {
                this.alertJS("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\uff01");
                return;
            }
            String bizKey = copbizinfo.getBizkey();
            String source = "CHANNEL";
            HashMap<String, String> parasMap = new HashMap<String, String>();
            parasMap.put("bizNo", bizNo);
            parasMap.put("xlnumId", xlnumId);
            parasMap.put("source", source);
            String signMsg = this.sign(parasMap, bizKey);
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(this.alipayMonthQuerySignUrl).append("bizNo=").append(bizNo).append("&").append("xlnumId=").append(xlnumId).append("&").append("source=").append(source).append("&").append("signMsg=").append(signMsg);
            logger.info("query sign url: {}", (Object)urlBuilder.toString());
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.connection.timeout", (Object)6000);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)6000);
            HttpGet httpGet = new HttpGet(urlBuilder.toString());
            HttpResponse res = null;
            try {
                res = httpclient.execute((HttpUriRequest)httpGet);
            }
            catch (Exception e) {
                logger.error("query sign failed, msg: {}", (Object)e.getMessage());
                this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01");
                return;
            }
            if (res == null) {
                logger.error("query sign timeout, url: {}", (Object)urlBuilder.toString());
                this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01");
                return;
            }
            if (res.getStatusLine().getStatusCode() != 200) {
                logger.error("query sign failed, statuscode is incorrected, status code: {}", (Object)res.getStatusLine().getStatusCode());
                this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01");
                return;
            }
            String resultText = "";
            Document doc = null;
            Element root = null;
            String payresult = "";
            String statusMsg = "";
            try {
                resultText = EntityUtils.toString((HttpEntity)res.getEntity());
                logger.info("response text is : {}", (Object)resultText);
                doc = DocumentHelper.parseText((String)resultText);
                root = doc.getRootElement();
                payresult = root.element("payresult").getText();
                statusMsg = root.element("status").getText();
            }
            catch (Exception e) {
                logger.error("query sign failed, parsing error, msg: {}", (Object)e.getMessage());
                this.alertJS("\u67e5\u8be2\u5931\u8d25\uff01");
                return;
            }
            if (StringUtils.isNotEmpty((String)payresult) && "00".equals(payresult.trim())) {
                HashMap<String, String> statusMap = new HashMap<String, String>();
                String[] statusArray = statusMsg.split("\\|");
                if (statusArray.length > 0) {
                    for (String s : statusArray) {
                        String[] temp = s.split("=");
                        statusMap.put(temp[0], temp[1]);
                    }
                }
                String externalSignNo = (String)statusMap.get("external_sign_no");
                String status = (String)statusMap.get("status");
                String validTime = (String)statusMap.get("valid_time");
                String invalidTime = (String)statusMap.get("invalid_time");
                String signTime = (String)statusMap.get("sign_time");
                String signModifyTime = (String)statusMap.get("sign_modify_time");
                String agreementNo = (String)statusMap.get("agreement_no");
                ExtAlipayMonthBind r = new ExtAlipayMonthBind();
                r.setExternalSignNo(externalSignNo);
                ExtAlipayMonthBind rs = facade.findExtAlipayMonthBind(r);
                if (rs == null) {
                    logger.error("bindreq record doesn't exist, externalSignNo: {}", (Object)externalSignNo);
                    this.alertJS("\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
                    return;
                }
                if (StringUtils.isNotEmpty((String)rs.getBindId())) {
                    logger.error("bindreq record already exist, externalSignNo: {}", (Object)externalSignNo);
                    this.alertJS("\u8bb0\u5f55\u5df2\u7ecf\u7b7e\u7ea6\u6210\u529f\uff0c\u8bf7\u518d\u6b21\u67e5\u8be2\uff01");
                    return;
                }
                if (StringUtils.isEmpty((String)status) || !"NORMAL".equals(status.trim())) {
                    logger.error("status incorrect !, status: {}", (Object)status);
                    this.alertJS("\u64cd\u4f5c\u5931\u8d25\uff0c\u7b7e\u7ea6\u72b6\u6001\u672a\u6210\u529f\uff01");
                    return;
                }
                rs.setBindId(agreementNo);
                rs.setSignModifyTime(signModifyTime);
                rs.setSignTime(signTime);
                rs.setInvalidTime(invalidTime);
                rs.setValidTime(validTime);
                rs.setStatus(status);
                rs.setSignStatus("SUCCESS");
                facade.updateExtAlipayMonthBind(rs);
                logger.info("moveExtAlipayMonthBindReqToBindOk successfully.");
                this.alertJS("\u7f6e\u4e3a\u6210\u529f\uff01");
                return;
            }
            logger.error("\u7f6e\u4e3a\u5931\u8d25\uff01");
            this.alertJS("\u7f6e\u4e3a\u5931\u8d25\uff01");
            return;
        }
    }
}

