/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.util.Md5Encrypt;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.ExtAlipayMonthBind;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyAlipayMonthbind")
public class ExtalipaymonthbindManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ExtalipaymonthbindManagedBean.class);
    private String ALIPAY_MONTH_UNSIGN_URL = new String("http://proxy.pay.xunlei.com/alipayMonthUnsignServlet?");
    private static Map<String, String> statusMap;
    private static SelectItem[] statusItem;

    public String getQuery() {
        this.authenticateRun();
        ExtAlipayMonthBind data = (ExtAlipayMonthBind)this.findBean(ExtAlipayMonthBind.class, "payproxy_extalipaymonthbind");
        if (data != null) {
            if (StringTools.isEmpty((String)data.getStartDate())) {
                data.setStartDate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isEmpty((String)data.getEndDate())) {
                data.setEndDate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqId desc");
            Sheet sheet = facade.queryExtAlipayMonthBind(data, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String moveExtAlipayMonthBindToQuitok() {
        this.authenticateEdit();
        String seqIds = this.findParameter("noticeBtn");
        if (this.isEmpty(seqIds)) {
            logger.error("\u89e3\u7ea6\u53c2\u6570noticeBtn\uff1a{}\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object)seqIds);
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217!");
        }
        logger.debug("\u89e3\u7ea6seqIds: {}", (Object)seqIds);
        String[] seqId = seqIds.split("\\|");
        int counter = 0;
        for (String id : seqId) {
            ExtAlipayMonthBind bindInfo = new ExtAlipayMonthBind();
            bindInfo.setSeqId(Long.valueOf(id).longValue());
            bindInfo = facade.findExtAlipayMonthBind(bindInfo);
            if (null == bindInfo) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684seqId: {} \u7b7e\u7ea6\u8bb0\u5f55", (Object)id);
                continue;
            }
            String xlnumId = bindInfo.getXunleiId();
            String bizNo = bindInfo.getBizNo();
            if (StringUtils.isEmpty((String)xlnumId)) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u89e3\u7ea6\u67e5\u8be2\u53c2\u6570xlnumId\uff1a{}\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object)xlnumId);
                continue;
            }
            if (StringUtils.isEmpty((String)bizNo)) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u89e3\u7ea6\u67e5\u8be2\u53c2\u6570bizNo\uff1a{}\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object)bizNo);
                continue;
            }
            Copbizinfo copbizinfoForQuery = new Copbizinfo();
            copbizinfoForQuery.setBizno(bizNo);
            Copbizinfo copbizinfo = facade.findCopbizinfo(copbizinfoForQuery);
            if (copbizinfo == null || copbizinfo.getBizstatus().equals("C")) {
                logger.error("\u4e1a\u52a1\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\uff01");
                continue;
            }
            String bizKey = copbizinfo.getBizkey();
            String url = this.gensignedUrl(bizNo, xlnumId, bizKey);
            logger.info("unsign url : {}", (Object)url);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            httpclient.getParams().setParameter("http.connection.timeout", (Object)6000);
            httpclient.getParams().setParameter("http.socket.timeout", (Object)6000);
            HttpGet httpGet = new HttpGet(url);
            HttpResponse res = null;
            try {
                res = httpclient.execute((HttpUriRequest)httpGet);
            }
            catch (Exception e) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u89e3\u7ea6\u8bf7\u6c42URL\uff1a{}", (Object)(url + e.getMessage()));
                continue;
            }
            if (res == null) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u670d\u52a1\u5668\u8d85\u65f6, \u89e3\u7ea6\u8bf7\u6c42URL\uff1a{}", (Object)url);
                continue;
            }
            if (res.getStatusLine().getStatusCode() != 200) {
                logger.error("\u89e3\u7ea6\u5931\u8d25, \u670d\u52a1\u5668\u9519\u8bef, status code\uff1a{}", (Object)res.getStatusLine().getStatusCode());
                continue;
            }
            String result = "";
            String resultCode = "";
            try {
                result = EntityUtils.toString((HttpEntity)res.getEntity());
                Document doc = DocumentHelper.parseText((String)result);
                Element rootElement = doc.getRootElement();
                resultCode = rootElement.element("result").getText();
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u652f\u4ed8\u5b9d\u5305\u6708\u4ee3\u6263\u54cd\u5e94\u7ed3\u679c\u51fa\u9519! xml: {}", (Object)result);
                continue;
            }
            if (!StringUtils.isEmpty((String)resultCode) && "00".equals(resultCode)) {
                ++counter;
                logger.info("\u89e3\u7ea6\u6210\u529f\uff0cid: {}", (Object)id);
                continue;
            }
            logger.error("\u89e3\u7ea6\u5931\u8d25! xml: {}", (Object)result);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u5171\u89e3\u7ea6: ").append(seqId.length).append(" \u4e2a\uff0c\u6210\u529f\uff1a").append(counter).append(" \u4e2a\uff01");
        this.alertJS(buffer.toString());
        return "";
    }

    public void checkOrderStatus() {
        String bindId = this.findParameter("query_bindId");
        logger.debug("check sign NO. is : {}", (Object)bindId);
        if (StringUtils.isEmpty((String)bindId)) {
            this.alertJS("\u67e5\u8be2\u7684\u7b7e\u7ea6\u53f7\u4e3a\u7a7a");
            return;
        }
    }

    public static String analysisXML(Document document, String nodeName) throws DocumentException {
        Element root = document.getRootElement();
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(root);
        while (list != null) {
            Element element = null;
            Element firstElement = null;
            Iterator iter = list.iterator();
            if (iter.hasNext()) {
                firstElement = (Element)iter.next();
                iter.remove();
            }
            if (firstElement == null) continue;
            Iterator i = firstElement.elementIterator();
            while (i != null && i.hasNext()) {
                element = (Element)i.next();
                list.add(element);
                if (element == null || !element.getName().equals(nodeName)) continue;
                return element.getText();
            }
        }
        return null;
    }

    public Map<String, String> getStatusMap() {
        if (statusMap == null) {
            statusMap = new HashMap<String, String>();
            statusMap.put("TEMP", "\u6682\u5b58");
            statusMap.put("NORMAL", "\u6b63\u5e38");
            statusMap.put("STOP", "\u6682\u505c");
        }
        return statusMap;
    }

    public SelectItem[] getStatusItem() {
        if (statusItem == null) {
            statusItem = new SelectItem[3];
            ExtalipaymonthbindManagedBean.statusItem[0] = new SelectItem((Object)"TEMP", "\u6682\u5b58");
            ExtalipaymonthbindManagedBean.statusItem[1] = new SelectItem((Object)"NORMAL", "\u6b63\u5e38");
            ExtalipaymonthbindManagedBean.statusItem[2] = new SelectItem((Object)"STOP", "\u6682\u505c");
        }
        return statusItem;
    }

    public String gensignedUrl(String bizNo, String xlnumId, String bizKey) {
        StringBuffer signMsg = new StringBuffer();
        signMsg.append("bizNo=").append(bizNo).append("&");
        signMsg.append("xlnumId=").append(xlnumId);
        String sign = Md5Encrypt.md5((String)(signMsg.toString() + bizKey), (String)"GBK");
        StringBuffer queryStr = new StringBuffer(this.ALIPAY_MONTH_UNSIGN_URL);
        queryStr.append(signMsg.toString()).append("&signMsg=").append(sign);
        return queryStr.toString();
    }
}

