/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.cardnewpay.check.CardNewPayCheck;
import com.xunlei.cardnewpay.check.CardNewPayRtn;
import com.xunlei.cardpay.check.CardPayCheck;
import com.xunlei.cardpay.check.CardPayRet;
import com.xunlei.channel.thirdparty.utils.HttpClient4Utils;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Extcardpay;
import com.xunlei.payproxy.vo.Extcardpayok;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtCardPay")
public class ExtCardpayManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(ExtCardpayManagedBean.class);
    private static IFacade payproxyFacade = IFacade.INSTANCE;
    private static Map<String, String> currTypeMap;
    private static SelectItem[] currTypeItem;
    private static List<String> agencyList;
    private static Map<String, String> cardMessage;

    public String getQuery() {
        this.authenticateRun();
        Extcardpay extcardpay = (Extcardpay)this.findBean(Extcardpay.class, "payproxy_extcardpay");
        if (extcardpay != null) {
            if (StringTools.isEmpty((String)extcardpay.getFromdate())) {
                extcardpay.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)extcardpay.getTodate())) {
                extcardpay.setTodate(DatetimeUtil.today());
            }
            extcardpay.setAgencys(this.getAgencyList());
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("inputtime desc");
            Sheet sheet = facade.queryExtcardpay(extcardpay, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public void setWaitToFail() {
        this.authenticateEdit();
        String moveIds = this.findParameter("noticefailBtn");
        if (this.isNotEmpty(moveIds)) {
            String[] seqIds;
            for (String seqId : seqIds = moveIds.split("\\|")) {
                Extcardpay extcardpayQuery = new Extcardpay();
                extcardpayQuery.setSeqid(Long.parseLong(seqId));
                Extcardpay extcardpay = facade.findExtcardpay(extcardpayQuery);
                if (extcardpay == null) continue;
                Bizorder bizorderQry = new Bizorder();
                bizorderQry.setXunleipayid(extcardpay.getXunleipayid());
                Bizorder bizorder = facade.findBizorder(bizorderQry);
                if (bizorder != null) {
                    if ("N".equals(extcardpay.getExtcardpaystatus())) {
                        this.alertJS("\u8ba2\u5355\u5df2\u7ecf\u5904\u4e8e\u5931\u8d25\u72b6\u6001,\u4e0d\u8981\u91cd\u590d\u5b9a\u5236!");
                        continue;
                    }
                    extcardpay.setExtcardpaystatus("N");
                    extcardpay.setRemark(this.noticefail_remark(extcardpay.getRemark().trim()) + "|\u7f6e\u4e3a\u5931\u8d25!");
                    facade.updateExtcardpay(extcardpay);
                    bizorder.setOrderstatus("N");
                    facade.updateBizorder(bizorder);
                    this.alertJS("\u7f6e\u4e3a\u5931\u8d25\u6210\u529f!");
                    continue;
                }
                this.alertJS("\u4e0d\u5b58\u5728\u8fc5\u96f7\u652f\u4ed8\u53f7\u4e3a" + extcardpay.getXunleipayid() + "\u7684\u8bf7\u6c42\u8ba2\u5355");
            }
        }
    }

    public String checkOrderStatus() throws UnsupportedEncodingException {
        String orderid = this.findParameter("card_orderid");
        String orderamt = this.findParameter("card_orderamt");
        String cardno = this.findParameter("card_cardno");
        logger.info("ExtCardpayManagedBean-----checkOrderStatus-----orderid=" + orderid + ", orderamt=" + orderamt + ", cardno=" + cardno);
        double amt = Double.valueOf(orderamt);
        CardNewPayRtn cardNewPayRtn = null;
        CardPayRet resultInfo = null;
        if (cardno.trim().equals("")) {
            logger.info("ExtCardpayManagedBean-----checkOrderStatus-----cardno\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8fc5\u96f7\u76f4\u5145");
            cardNewPayRtn = CardNewPayCheck.queryOrderByOrderid((String)orderid);
        } else {
            logger.info("ExtCardpayManagedBean-----checkOrderStatus-----cardno\u4e0d\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8fc5\u96f7\u70b9\u5361\u652f\u4ed8");
            resultInfo = CardPayCheck.queryPay((String)orderid);
        }
        if (resultInfo == null && cardNewPayRtn == null) {
            this.alertJS("\u8ba2\u5355" + orderid + "\u652f\u4ed8\u672a\u6210\u529f!");
        } else if (cardNewPayRtn != null && resultInfo != null) {
            this.alertJS("\u8ba2\u5355\u53f7\u4e3a" + orderid + "\u7684\u8ba2\u5355\u975e\u6cd5");
        } else if (resultInfo != null) {
            if ("Y".equals(resultInfo.getIsSuccess())) {
                logger.info("ExtCardpayManagedBean-----checkOrderStatus-----\u70b9\u5361\u652f\u4ed8, \u5e73\u53f0\u8bb0\u5f55\u91d1\u989d:" + amt + ",CardPay\u8fd4\u56de\u91d1\u989d:" + resultInfo.getOrderAmt());
                if (amt != resultInfo.getOrderAmt()) {
                    this.alertJS("\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26,\u5e73\u53f0\u8bb0\u5f55\u91d1\u989d:" + amt + ",CardPay\u8fd4\u56de\u91d1\u989d:" + resultInfo.getOrderAmt());
                } else {
                    this.alertJS("\u8ba2\u5355" + orderid + "\u652f\u4ed8\u6210\u529f!");
                }
            } else {
                this.alertJS(cardMessage.get(resultInfo.getErrcode().trim()));
            }
        } else if ("Y".equals(cardNewPayRtn.getIsSuccess())) {
            logger.info("ExtCardpayManagedBean-----checkOrderStatus-----\u8fc5\u96f7\u76f4\u5145\u652f\u4ed8, \u5e73\u53f0\u8bb0\u5f55\u91d1\u989d:" + amt + ",CardNewPay\u8fd4\u56de\u91d1\u989d:" + cardNewPayRtn.getOrderamt());
            if (amt != cardNewPayRtn.getOrderamt()) {
                this.alertJS("\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26,\u5e73\u53f0\u8bb0\u5f55\u91d1\u989d:" + amt + ",CardNewPay\u8fd4\u56de\u91d1\u989d:" + cardNewPayRtn.getOrderamt());
            } else {
                this.alertJS("\u8ba2\u5355" + orderid + "\u652f\u4ed8\u6210\u529f!");
            }
        } else {
            this.alertJS("\u8ba2\u5355" + orderid + "\u652f\u4ed8\u672a\u6210\u529f\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + URLDecoder.decode(cardNewPayRtn.getErrmsg(), "utf8"));
        }
        return "";
    }

    public SelectItem[] getCurrTypeItem() {
        if (currTypeItem == null) {
            List list = payproxyFacade.getLibclassdByClassNo("CurrType");
            if (list == null) {
                currTypeItem = new SelectItem[0];
            } else {
                currTypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ExtCardpayManagedBean.currTypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return currTypeItem;
    }

    public Map<String, String> getCurrTypeMap() {
        if (currTypeMap == null) {
            List list = payproxyFacade.getLibclassdByClassNo("CurrType");
            currTypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                currTypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return currTypeMap;
    }

    public List<String> getAgencyList() {
        if (agencyList == null) {
            List list = payproxyFacade.getLibclassdByClassNo("DPayAgency");
            agencyList = new ArrayList<String>();
            for (Libclassd data : list) {
                agencyList.add(data.getItemno());
            }
        }
        return agencyList;
    }

    public void moveCardpayToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticebtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                Extcardpay extcardpayForQuery = new Extcardpay();
                extcardpayForQuery.setSeqid(Long.valueOf(seqid).longValue());
                Extcardpay extcardpay = facade.findExtcardpay(extcardpayForQuery);
                if (extcardpay == null) continue;
                String orderid = extcardpay.getOrderid();
                double amt = extcardpay.getOrderamt();
                try {
                    logger.debug("\u5f00\u59cb\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c....");
                    boolean query = CustomUtil.isQuery((String)"cardpay");
                    logger.info("query:" + query + "\torderid:" + orderid);
                    if (!query) {
                        this.doMove(extcardpay, null);
                    } else {
                        CardPayRet resultInfo = CardPayCheck.queryPay((String)orderid);
                        if (null != resultInfo && "Y".equals(resultInfo.getIsSuccess())) {
                            if (amt == resultInfo.getOrderAmt()) {
                                this.doMove(extcardpay, resultInfo);
                            } else {
                                logger.info("\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26,\u5e73\u53f0\u8bb0\u5f55\u91d1\u989d:" + amt + ",CardPay\u8fd4\u56de\u91d1\u989d:" + resultInfo.getOrderAmt());
                                this.alertJS("\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26,\u5e73\u53f0\u8bb0\u5f55\u91d1\u989d:" + amt + ",CardPay\u8fd4\u56de\u91d1\u989d:" + resultInfo.getOrderAmt());
                            }
                        } else {
                            logger.info("resultInfo=" + resultInfo);
                            if (null != resultInfo) {
                                this.alertJS(cardMessage.get(resultInfo.getErrcode().trim()));
                            } else {
                                this.alertJS("\u6240\u67e5\u8be2\u7684\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f!");
                            }
                        }
                    }
                    logger.debug("\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c\u7ed3\u675f....");
                }
                catch (Exception e) {
                    this.alertJS("\u5b9a\u5236\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38,\u5b9a\u5236\u5931\u8d25!");
                    logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }

    private void doMove(Extcardpay extcardpay, CardPayRet cardpayRet) {
        if (null == cardpayRet) {
            cardpayRet = new CardPayRet();
            cardpayRet.setCardpayTime(Utility.timeofnow());
            cardpayRet.setCardpayId("");
            cardpayRet.setOrderId(extcardpay.getOrderid());
            cardpayRet.setFareamt(0.0);
            cardpayRet.setOrderAmt(extcardpay.getOrderamt());
            cardpayRet.setCardno(extcardpay.getCardno());
        }
        Extcardpayok extcardpayok = new Extcardpayok();
        extcardpayok.setCardpaytime(cardpayRet.getCardpayTime());
        extcardpayok.setBizorderstatus("Y");
        extcardpayok.setCardpayid(cardpayRet.getCardpayId());
        extcardpayok.setOrderid(cardpayRet.getOrderId());
        extcardpayok.setOrderamt(cardpayRet.getOrderAmt());
        extcardpayok.setCardno(cardpayRet.getCardno());
        extcardpayok.setFareamt(cardpayRet.getFareamt());
        facade.moveExtcardpayToSuccess(extcardpayok);
        Extcardpayok query = new Extcardpayok();
        query.setCardpayid(cardpayRet.getCardpayId());
        Extcardpayok ecpo = facade.findExtcardpayok(query);
        if (null != ecpo) {
            ecpo.setRemark(this.noticeok_remark(extcardpay.getRemark()));
            facade.updateExtcardpayok(ecpo);
        }
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)extcardpay.getOrderid());
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }

    public Map<String, String> getErrMessage() {
        return cardMessage;
    }

    public String checkStatusbtn() {
        String orderid = this.findParameter("card_orderid");
        String cardno = this.findParameter("card_cardno");
        logger.info("ExtCardpayManagedBean-----checkStatusbtn orderid" + orderid + " cardno=" + cardno);
        String info = this.getCardStatusInfo(cardno);
        logger.info("ExtCardpayManagedBean-----checkStatusbtn orderid" + orderid + "\n" + info);
        this.alertJS(info);
        return "";
    }

    private String getCardStatusInfo(String cardno) {
        String url = "http://svr.gamepay.xunlei.com/gamepaycenter/pay";
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer info = null;
        try {
            map.put("action", URLEncoder.encode("querycard", "UTF-8"));
            map.put("cardno", URLEncoder.encode(cardno, "UTF-8"));
            String response = HttpClient4Utils.doPost((String)url, map);
            response = response.replace("{", "");
            response = response.replace("}", "");
            response = response.replace("\"", "");
            String[] params = response.split(",");
            HashMap<String, String> mapParam = new HashMap<String, String>();
            for (int i = 0; i < params.length; ++i) {
                String[] str = params[i].split(":");
                mapParam.put(str[0], str[1]);
            }
            info = new StringBuffer();
            String code = (String)mapParam.get("code");
            if ("0".equals(code)) {
                info.append("\u67e5\u8be2\u6210\u529f");
                info.append("\n\u4e00\u5361\u901a\u9762\u989d:");
                info.append((String)mapParam.get("amount"));
                info.append("\n\u4e00\u5361\u901a\u6709\u6548\u671f:");
                info.append((String)mapParam.get("expiretime"));
                info.append("\n\u4e00\u5361\u901a\u72b6\u6001\u7801:");
                info.append((String)mapParam.get("statuscode"));
                info.append("\n\u4e00\u5361\u901a\u72b6\u6001:");
                info.append(this.getParams().get(mapParam.get("statuscode")));
            } else if ("1".equals(code)) {
                info.append("\u67e5\u8be2\u5931\u8d25");
                info.append("\n\u63d0\u793a\u4fe1\u606f:");
                info.append("\u53c2\u6570\u9519\u8bef");
            } else {
                info.append("\u67e5\u8be2\u5931\u8d25");
                info.append("\n\u63d0\u793a\u4fe1\u606f:");
                info.append("\u70b9\u5361\u72b6\u6001\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        logger.info("cardno:" + cardno + "\tinfo:" + info.toString());
        return info.toString();
    }

    private Map<String, String> getParams() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("V", "\u5f85\u5ba1\u6838");
        map.put("F", "\u51bb\u7ed3");
        map.put("A", "\u53ef\u7528");
        map.put("C", "\u5df2\u7528");
        map.put("E", "\u8fc7\u671f");
        map.put("D", "\u9500\u6bc1");
        return map;
    }

    static {
        cardMessage = new HashMap<String, String>();
        cardMessage.put("0101", "\u65e0\u64cd\u4f5c\u6743\u9650");
        cardMessage.put("0201", "\u7b7e\u540d\u4e0d\u6b63\u786e");
        cardMessage.put("0203", "\u53c2\u6570\u683c\u5f0f\u6216\u503c\u4e0d\u6b63\u786e");
        cardMessage.put("0401", "\u670d\u52a1\u7aef\u9519\u8bef");
        cardMessage.put("0402", "\u65e0\u64cd\u4f5c\u6743\u9650");
        cardMessage.put("0403", "\u67e5\u8be2\u7528\u6237\u5931\u8d25");
        cardMessage.put("0501", "\u8ba2\u5355\u53f7\u91cd\u590d");
        cardMessage.put("0502", "\u8fc5\u96f7\u8d26\u6237\u4e0d\u5b58\u5728");
        cardMessage.put("0503", "\u70b9\u5361\u5361\u53f7\u4e0d\u5b58\u5728");
        cardMessage.put("0504", "\u5bc6\u7801\u65e0\u6548\t\u5bc6\u7801\u9519\u8bef\u6216\u70b9\u5361\u72b6\u6001\u5904\u4e8e\uff1aF,C,D\u72b6\u6001");
        cardMessage.put("0505", "\u8fc5\u96f7\u70b9\u5361\u5df2\u8fc7\u6709\u6548\u671f");
        cardMessage.put("0506", "\u8ba2\u5355\u91d1\u989d\u4e0e\u70b9\u5361\u9762\u503c\u4e0d\u7b26");
        cardMessage.put("0507", "\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f");
        cardMessage.put("0508", "\u70b9\u5361\u5df2\u88ab\u51bb\u7ed3");
        cardMessage.put("0509", "\u70b9\u5361\u5df2\u88ab\u7a0b\u5e8f\u51bb\u7ed3");
        cardMessage.put("0510", "\u70b9\u5361\u5904\u4e8e\u5f85\u5ba1\u6838\u72b6\u6001");
        cardMessage.put("0511", "\u70b9\u5361\u5904\u4e8e\u8fc7\u671f\u72b6\u6001");
        cardMessage.put("0512", "\u70b9\u5361\u5904\u4e8e\u9500\u6bc1\u72b6\u6001");
        cardMessage.put("0513", "\u70b9\u5361\u5904\u4e8e\u5df2\u7528\u72b6\u6001");
    }
}

