/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.baiduwallet.BaiduWalletQuery;
import com.xunlei.channel.baiduwallet.BaiduWalletRtn;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.vo.ExtBaiduWallet;
import com.xunlei.payproxy.vo.ExtBaiduWalletOk;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExtbaiduwallet")
public class ExtBaiduWalletManagedBean
extends BaseManagedBean {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static Map<String, String> orderStatusMap;
    private static SelectItem[] orderStatusItem;
    private static SelectItem[] payTypeItem;
    private static SelectItem[] spNoItem;
    private static Map<String, String> payTypeMap;

    public String getQuery() {
        this.logger.debug("getQuery..");
        this.authenticateRun();
        ExtBaiduWallet extBaiduWallet = (ExtBaiduWallet)this.findBean(ExtBaiduWallet.class, "payproxy_Extbaiduwallet");
        if (extBaiduWallet != null) {
            if (StringTools.isEmpty((String)extBaiduWallet.getStartdate())) {
                extBaiduWallet.setStartdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)extBaiduWallet.getEnddate())) {
                extBaiduWallet.setEnddate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("seqid desc");
            Sheet sheet = facade.queryExtBaiduWallet(extBaiduWallet, fliper);
            if (sheet.getRowcount() > 0) {
                ExtBaiduWallet sum = facade.queryExtBaiduWalletSum(extBaiduWallet);
                sheet.getDatas().add(sum);
            }
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String moveExtBaiduWalletToSuccess() {
        this.authenticateEdit();
        String moveIds = this.findParameter("noticeBtn");
        if (this.isNotEmpty(moveIds)) {
            String[] seqids;
            this.logger.info("moveExtBaiduWalletToSuccess...ids:{}", (Object)moveIds);
            for (String seqid : seqids = moveIds.split("\\|")) {
                ExtBaiduWallet baiduWalletQuery = new ExtBaiduWallet();
                try {
                    baiduWalletQuery.setSeqid(Long.valueOf(seqid).longValue());
                }
                catch (NumberFormatException e1) {
                    this.logger.info("unable to parse long from:{}", (Object)seqid);
                    continue;
                }
                ExtBaiduWallet baiduWallet = facade.findExtBaiduWallet(baiduWalletQuery);
                if (baiduWallet != null) {
                    String spNo;
                    String orderId = baiduWallet.getOrderId();
                    BaiduWalletRtn rtn = BaiduWalletQuery.queryByOrderNo((String)orderId, (String)(spNo = baiduWallet.getSpNo()));
                    if (null == rtn) {
                        this.logger.info("something wrong when query order:{},spNo:{}", (Object)orderId, (Object)spNo);
                        continue;
                    }
                    if (!orderId.equals(rtn.getOrderNo())) {
                        this.logger.info("orderId mismatch...baiduWallet.orderId:{},rtn.orderId:{}", (Object)orderId, (Object)rtn.getOrderNo());
                        continue;
                    }
                    if (rtn.getPayStatus() == 1) {
                        this.logger.info("orderId:{} pay success!", (Object)orderId);
                        this.doMove(baiduWallet, rtn);
                        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
                        continue;
                    }
                    this.logger.info("cannot move to success for orderId:{} because of the unsuccess status", (Object)orderId);
                    this.alertJS("\u8ba2\u5355\u53f7\u4e3a\uff1a" + orderId + ",\u67e5\u8be2\u5931\u8d25\uff0c\u65e0\u6cd5\u5b9a\u5236\u6210\u529f");
                    return "";
                }
                this.logger.info("error,cannot find ExtBaiduWallet which seqid={}", (Object)seqid);
            }
        } else {
            this.logger.info("no seqid selected");
            this.alertJS("\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5217");
        }
        return "";
    }

    private void doMove(ExtBaiduWallet baiduWallet, BaiduWalletRtn rtn) {
        this.logger.debug("domove...orderId:{}", (Object)baiduWallet.getOrderId());
        ExtBaiduWalletOk baiduWalletOk = new ExtBaiduWalletOk();
        baiduWalletOk.setOrderId(rtn.getOrderNo());
        baiduWalletOk.setOrderAmt(rtn.getDoubleTotalAmount());
        baiduWalletOk.setFactAmt(rtn.getFactAmount());
        baiduWalletOk.setSuccessTime(this.generateSuccessTime(rtn.getPayTime()));
        baiduWalletOk.setBaiduOrderNo(rtn.getBfbOrderNo());
        baiduWalletOk.setBizOrderStatus("Y");
        baiduWalletOk.setBaiduPayType(rtn.getPayType());
        baiduWalletOk.setRemark(this.noticeok_remark(baiduWallet.getRemark()));
        baiduWalletOk.setSpNo(baiduWallet.getSpNo());
        facade.moveExtBaiduWalletToSuccess(baiduWalletOk);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)baiduWallet.getOrderId());
    }

    private String generateSuccessTime(String payTime) {
        if (null != payTime && payTime.length() == 14) {
            return payTime.substring(0, 4) + "-" + payTime.substring(4, 6) + "-" + payTime.substring(6, 8) + " " + payTime.substring(8, 10) + ":" + payTime.substring(10, 12) + ":" + payTime.substring(12);
        }
        return payTime;
    }

    public String checkOrderStatus() {
        this.authenticateRun();
        String orderId = this.findParameter("baidu_orderid");
        String spNo = this.findParameter("baidu_spno");
        this.logger.info("checkOrderStatus...orderId:{},spNo:{}", (Object)orderId, (Object)spNo);
        BaiduWalletRtn rtn = BaiduWalletQuery.queryByOrderNo((String)orderId, (String)spNo);
        if (null == rtn) {
            this.logger.info("something wrong when query order:{}", (Object)orderId);
            this.alertJS("\u67e5\u8be2\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5!");
            return "";
        }
        if (!"0".equals(rtn.getQueryStatus())) {
            this.alertJS(rtn.getErrorMsg());
            return "";
        }
        if (!orderId.equals(rtn.getOrderNo())) {
            this.logger.info("orderId mismatch...baiduWallet.orderId:{},rtn.orderId:{}", (Object)orderId, (Object)rtn.getOrderNo());
            this.alertJS("\u67e5\u8be2\u5230\u7684\u8ba2\u5355\u53f7\u4e0d\u5339\u914d!");
            return "";
        }
        if (rtn.getPayStatus() == 1) {
            this.alertJS("\u652f\u4ed8\u6210\u529f!");
        } else if (rtn.getPayStatus() == 2) {
            this.alertJS("\u7b49\u5f85\u652f\u4ed8!");
        } else {
            this.alertJS("\u53d1\u751f\u9519\u8bef\uff1a" + rtn.getErrorMsg());
        }
        return "";
    }

    public Map<String, String> getOrderStatusMap() {
        if (orderStatusMap == null) {
            orderStatusMap = new HashMap<String, String>();
            orderStatusMap.put("W", "\u7b49\u5f85");
            orderStatusMap.put("N", "\u5931\u8d25");
            orderStatusMap.put("U", "\u53ef\u7591");
        }
        return orderStatusMap;
    }

    public SelectItem[] getOrderStatusItem() {
        if (orderStatusItem == null) {
            orderStatusItem = new SelectItem[3];
            ExtBaiduWalletManagedBean.orderStatusItem[0] = new SelectItem((Object)"W", "\u7b49\u5f85");
            ExtBaiduWalletManagedBean.orderStatusItem[1] = new SelectItem((Object)"U", "\u53ef\u7591");
            ExtBaiduWalletManagedBean.orderStatusItem[2] = new SelectItem((Object)"N", "\u5931\u8d25");
        }
        return orderStatusItem;
    }

    public SelectItem[] getPayTypeItem() {
        if (payTypeItem == null) {
            payTypeItem = new SelectItem[2];
            ExtBaiduWalletManagedBean.payTypeItem[0] = new SelectItem((Object)"E4", "\u5feb\u6377\u652f\u4ed8");
            ExtBaiduWalletManagedBean.payTypeItem[1] = new SelectItem((Object)"E5", "\u4f59\u989d\u652f\u4ed8");
        }
        return payTypeItem;
    }

    public SelectItem[] getSpNoItem() {
        if (spNoItem == null) {
            spNoItem = new SelectItem[2];
            ExtBaiduWalletManagedBean.spNoItem[0] = new SelectItem((Object)"2600300001", "2600300001");
            ExtBaiduWalletManagedBean.spNoItem[1] = new SelectItem((Object)"2600300004", "2600300004");
        }
        return spNoItem;
    }

    public Map<String, String> getPayTypeMap() {
        if (payTypeMap == null) {
            payTypeMap = new HashMap<String, String>();
            payTypeMap.put("E4", "\u5feb\u6377\u652f\u4ed8");
            payTypeMap.put("E5", "\u4f59\u989d\u652f\u4ed8");
        }
        return payTypeMap;
    }
}

