/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.card.vo.Libclassd;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Ext99bill;
import com.xunlei.payproxy.vo.Ext99billok;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxyutil.ext99bill.Ext99BillHelper;
import com.xunlei.payproxyutil.result.ResultInfo;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyExt99bill")
public class Ext99billManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(Ext99billManagedBean.class);
    private static IFacade payproxyFacade = IFacade.INSTANCE;
    private static com.xunlei.card.facade.IFacade cardFacade = com.xunlei.card.facade.IFacade.INSTANCE;
    private static Map<String, String> currTypeMap;
    private static SelectItem[] currTypeItem;
    public static Map<String, String> bankMap;
    public static SelectItem[] bankItem;

    public String getQuery() {
        this.authenticateRun();
        Ext99bill ext99bill = (Ext99bill)this.findBean(Ext99bill.class, "payproxy_ext99bill");
        if (ext99bill != null) {
            if (StringTools.isEmpty((String)ext99bill.getFromdate())) {
                ext99bill.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)ext99bill.getTodate())) {
                ext99bill.setTodate(DatetimeUtil.today());
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("inputTime desc");
            Sheet sheet = facade.queryExt99bill(ext99bill, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public SelectItem[] getCurrTypeItem() {
        if (currTypeItem == null) {
            List list = payproxyFacade.getLibclassdByClassNo("CurrType");
            if (list == null) {
                currTypeItem = new SelectItem[0];
            } else {
                currTypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    Ext99billManagedBean.currTypeItem[i] = new SelectItem((Object)((com.xunlei.payproxy.vo.Libclassd)list.get(i)).getItemno(), ((com.xunlei.payproxy.vo.Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return currTypeItem;
    }

    public Map<String, String> getCurrTypeMap() {
        if (currTypeMap == null) {
            List list = payproxyFacade.getLibclassdByClassNo("CurrType");
            currTypeMap = new Hashtable<String, String>();
            for (com.xunlei.payproxy.vo.Libclassd data : list) {
                currTypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return currTypeMap;
    }

    public void move99billToSuccess() {
        this.authenticateAdd();
        String moveids = this.findParameter("noticebtn");
        logger.info("moveids:" + moveids);
        if (this.isNotEmpty(moveids)) {
            String[] seqids;
            for (String seqid : seqids = moveids.split("\\|")) {
                Ext99bill ext99billForQuery = new Ext99bill();
                ext99billForQuery.setSeqid(Long.valueOf(seqid).longValue());
                Ext99bill ext99bill = facade.findExt99bill(ext99billForQuery);
                if (ext99bill == null) continue;
                String orderid = ext99bill.getOrderid();
                String bankN = ext99bill.getBankno();
                double amt = ext99bill.getOrderamt();
                try {
                    logger.debug("\u5f00\u59cb\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c....");
                    boolean query = CustomUtil.isQuery((String)"99bill");
                    logger.info("query:" + query + "\torderid:" + orderid);
                    if (!query) {
                        this.doMove(ext99bill);
                    } else {
                        ResultInfo resultInfo = Ext99BillHelper.getQueryResult((String)orderid, (String)bankN, (double)amt);
                        if (resultInfo.getCode().trim().equals("00")) {
                            this.doMove(ext99bill);
                        } else {
                            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5931\u8d25\uff0c\u4fe1\u606f\u4e3a\uff1a" + resultInfo.getMessage());
                        }
                    }
                    logger.debug("\u4eba\u5de5\u5b9a\u5236\u64cd\u4f5c\u7ed3\u675f....");
                }
                catch (Exception e) {
                    this.alertJS("\u5b9a\u5236\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38,\u5b9a\u5236\u5931\u8d25!");
                    logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }
    }

    public String checkOrderStatus() {
        String orderid = this.findParameter("ext99bill_orderid");
        String bankN = this.findParameter("ext99bill_bankN");
        double amt = Double.valueOf(this.findParameter("ext99bill_amt"));
        try {
            ResultInfo resultInfo = Ext99BillHelper.getQueryResult((String)orderid, (String)bankN, (double)amt);
            logger.info("\u5feb\u94b1\u652f\u4ed8 \u8ba2\u5355\u72b6\u6001 Orderid:" + orderid + ",bankN:" + bankN + ",amt:" + amt + ",Rtncode:" + resultInfo.getCode());
            if (resultInfo.getCode().trim().equals("00")) {
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u6210\u529f");
            } else {
                logger.info("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u672a\u6210\u529f\uff1a" + resultInfo.getMessage());
                this.alertJS("\u8ba2\u5355[" + orderid + "]\u652f\u4ed8\u672a\u6210\u529f");
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
            this.alertJS("\u67e5\u8be2\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u5f02\u5e38");
        }
        return "";
    }

    public Map<String, String> getBankMap() {
        if (bankMap == null) {
            Libclassd libclassd = new Libclassd();
            libclassd.setItemvalue("1");
            libclassd.setClassno("BankNo");
            Sheet sheet = cardFacade.queryLibclassd(libclassd, new PagedFliper());
            List list = (List)sheet.getDatas();
            bankMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                if (!data.getItemvalue().equals("1")) continue;
                bankMap.put(data.getItemno(), data.getItemname());
            }
            bankMap.put("99BILL", "\u5feb\u94b1\u5176\u5b83\u94f6\u884c");
        }
        return bankMap;
    }

    public SelectItem[] getBankItem() {
        if (bankItem == null) {
            Libclassd libclassd = new Libclassd();
            libclassd.setItemvalue("1");
            libclassd.setClassno("BankNo");
            Sheet sheet = cardFacade.queryLibclassd(libclassd, new PagedFliper());
            List list = (List)sheet.getDatas();
            if (list == null) {
                bankItem = new SelectItem[0];
            } else {
                bankItem = new SelectItem[list.size() + 1];
                for (int i = 0; i < list.size(); ++i) {
                    Ext99billManagedBean.bankItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
                Ext99billManagedBean.bankItem[list.size()] = new SelectItem((Object)"99BILL", "\u5feb\u94b1\u5176\u5b83\u94f6\u884c");
            }
        }
        return bankItem;
    }

    private void doMove(Ext99bill ext99bill) {
        ext99bill.setRemark(this.noticeok_remark(ext99bill.getRemark()));
        logger.debug(Utility.toStringCommon((Object)ext99bill));
        facade.updateExt99bill(ext99bill);
        Ext99billok ext99billok = new Ext99billok();
        ext99billok.setOrderid(ext99bill.getOrderid());
        ext99billok.setOrderamt(ext99bill.getOrderamt());
        ext99billok.setFareamt(ext99bill.getFareamt());
        ext99billok.setDealtime(ext99bill.getDealtime());
        ext99billok.setBizorderstatus("Y");
        facade.moveExt99billToSuccess(ext99billok);
        PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)ext99bill.getOrderid());
        this.alertJS("\u4eba\u5de5\u5b9a\u5236\u6210\u529f\uff01");
    }
}

