/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.paycommon.configcache.ConfigCacheClientProxy;
import com.xunlei.channel.paycommon.configcache.vo.CacheKey;
import com.xunlei.channel.paycommon.configcache.vo.CacheValue;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.payproxy.vo.Config_info;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@FunRef(value="PayProxyConfig_info")
public class Config_infoManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(Config_infoManagedBean.class);

    public String getQuery() {
        logger.info("query Config_info");
        this.authenticateRun();
        Config_info data = (Config_info)this.findBean(Config_info.class, "payproxy_Config_info");
        Sheet sheet = null;
        PagedFliper fliper = null;
        if (data != null) {
            fliper = this.getFliper();
            fliper.setSortColumnIfEmpty(" id desc");
            sheet = facade.queryConfig_info(data, fliper);
            logger.debug("sheet size:" + sheet.getRowcount());
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String edit(Config_info newData) {
        this.authenticateEdit();
        logger.info("edit Config_info");
        Config_info data = (Config_info)this.findBean(Config_info.class, "payproxy_Config_info");
        if (data != null) {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("paycommon-configcache-context.xml");
            ConfigCacheClientProxy configCacheClientProxy = (ConfigCacheClientProxy)context.getBean("configCacheClientProxy");
            CacheKey cacheKey = new CacheKey(data.getGroup_id(), data.getProperty_key());
            configCacheClientProxy.delete(cacheKey);
            data.setId(newData.getId());
            data.setIn_use("N");
            data.setUpdate_time(DateUtils.getCurrentTime("yyyy-MM-dd HH:mm:ss"));
            data.setCreate_time(newData.getCreate_time());
            facade.updateConfig_info(data);
        } else {
            logger.warn("the cacheKey is null!");
        }
        return this.getQueryConfigInfolist();
    }

    public String add() {
        this.authenticateAdd();
        logger.info("add Config_info");
        Config_info data = (Config_info)this.findBean(Config_info.class, "payproxy_Config_info");
        Config_info newData = new Config_info();
        newData.setGroup_id(data.getGroup_id());
        newData.setProperty_key(data.getProperty_key());
        newData = facade.findConfig_info(newData);
        if (newData == null) {
            data.setCreate_time(DateUtils.getCurrentTime("yyyy-MM-dd HH:mm:ss"));
            data.setUpdate_time(DateUtils.getCurrentTime("yyyy-MM-dd HH:mm:ss"));
            data.setIn_use("N");
            facade.insertConfig_info(data);
            return this.getQueryConfigInfolist();
        }
        return this.edit(newData);
    }

    private String getQueryConfigInfolist() {
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty(" id desc");
        this.mergePagedDataModel(facade.queryConfig_info((Config_info)this.findBean(Config_info.class, "payproxy_Config_info"), fliper), new PagedFliper[]{fliper});
        return "";
    }

    public String release() {
        this.authenticateRun();
        String groupid = this.findParameter("release_groupid");
        String keyid = this.findParameter("release_keyid");
        Config_info data = new Config_info();
        data.setGroup_id(groupid);
        data.setProperty_key(keyid);
        data = facade.findConfig_info(data);
        logger.debug("get Config_info bean --------->" + data);
        try {
            if (data != null) {
                ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("paycommon-configcache-context.xml");
                ConfigCacheClientProxy configCacheClientProxy = (ConfigCacheClientProxy)context.getBean("configCacheClientProxy");
                CacheKey cacheKey = new CacheKey(data.getGroup_id(), data.getProperty_key());
                CacheValue cacheValue = new CacheValue(data.getProperty_value());
                configCacheClientProxy.put(cacheKey, cacheValue);
                cacheValue = configCacheClientProxy.get(cacheKey);
                logger.info("get Config_info bean --------->" + cacheValue);
                if (null != cacheValue && cacheValue.getPropertyValue().equals(data.getProperty_value()) && data.getIn_use() != "Y") {
                    data.setIn_use("Y");
                    facade.updateConfig_info(data);
                }
                this.alertJS("\u5df2\u53d1\u5e03\u5230\u7f13\u5b58\u4e2d\uff01");
            }
        }
        catch (Exception e) {
            logger.error("get unknown error --------->" + e.getMessage());
            this.alertJS("\u672a\u77e5\u9519\u8bef");
        }
        return this.getQueryConfigInfolist();
    }

    public String checkStatus() {
        this.authenticateRun();
        String groupid = this.findParameter("release_groupid");
        String keyid = this.findParameter("release_keyid");
        Config_info data = new Config_info();
        data.setGroup_id(groupid);
        data.setProperty_key(keyid);
        data = facade.findConfig_info(data);
        logger.debug("get Config_info bean --------->" + data);
        try {
            if (data != null) {
                ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("paycommon-configcache-context.xml");
                ConfigCacheClientProxy configCacheClientProxy = (ConfigCacheClientProxy)context.getBean("configCacheClientProxy");
                CacheKey cacheKey = new CacheKey(data.getGroup_id(), data.getProperty_key());
                CacheValue cacheValue = new CacheValue(data.getProperty_value());
                cacheValue = configCacheClientProxy.get(cacheKey);
                logger.info("get Config_info bean --------->" + cacheValue);
                if (cacheValue != null) {
                    if (cacheValue.getPropertyValue().equals(data.getProperty_value())) {
                        this.alertJS("\u5df2\u53d1\u5e03\u5230\u7f13\u5b58\u4e2d\uff01" + cacheValue);
                    } else {
                        this.alertJS("\u4e0e\u7f13\u5b58\u4e2d\u7684\u6570\u636e\u4e0d\u5339\u914d\uff01");
                    }
                } else {
                    this.alertJS("\u672a\u53d1\u5e03\u5230\u7f13\u5b58\u4e2d\uff01");
                }
            }
        }
        catch (Exception e) {
            logger.error("get unknown error --------->" + e.getMessage());
            this.alertJS("\u672a\u77e5\u9519\u8bef");
        }
        return this.getQueryConfigInfolist();
    }

    public String deleteSome() {
        this.authenticateDel();
        for (long seqid : this.findParamSeqids()) {
            Config_info data = facade.findConfig_infoById(seqid);
            if (data == null) continue;
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("paycommon-configcache-context.xml");
            ConfigCacheClientProxy configCacheClientProxy = (ConfigCacheClientProxy)context.getBean("configCacheClientProxy");
            CacheKey cacheKey = new CacheKey(data.getGroup_id(), data.getProperty_key());
            configCacheClientProxy.delete(cacheKey);
            logger.warn("delete cache --------->" + cacheKey);
            CacheValue cacheValue = configCacheClientProxy.get(cacheKey);
            if (cacheValue != null) continue;
            facade.deleteConfig_info(data);
        }
        return this.getQueryConfigInfolist();
    }
}

