/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.payproxy.vo.ConfigChannel;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import javax.faces.context.FacesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyConfigChannel")
public class ConfigChannelManagedBean
extends BaseManagedBean {
    private static final Logger logger = LoggerFactory.getLogger(ConfigChannelManagedBean.class);

    public String getQuery() {
        logger.debug("entering ConfigChannelManagedBean#getQuery...");
        this.authenticateRun();
        ConfigChannel data = (ConfigChannel)this.findBean(ConfigChannel.class, "payproxy_configchannel");
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("seqid desc");
        Sheet sheet = facade.queryConfigChannelList(null, fliper);
        logger.info("size(): {}", (Object)sheet.getDatas().size());
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }

    public void edit() {
        logger.info("edit ConfigChannel");
        this.authenticateEdit();
        ConfigChannel data = (ConfigChannel)this.findBean(ConfigChannel.class, "payproxy_configchannel");
        logger.info("add: {}", (Object)data.toString());
        if (data == null || data.getSeqid() <= 0L) {
            logger.error("record not exist!");
            this.alertJS("record not exist!");
            return;
        }
        ConfigChannel queryResult = facade.queryConfigChannel(data.getSeqid());
        if (queryResult == null) {
            logger.error("record not exist!");
            this.alertJS("record not exist!");
            return;
        }
        if (facade.findConfigChannelExists(data.getSourcePayType(), data.getSeqid())) {
            logger.error("\u6e90\u652f\u4ed8\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728!");
            this.alertJS("\u6e90\u652f\u4ed8\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728!");
            return;
        }
        String userName = "";
        Object userinfo = FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("userinfo");
        if (userinfo != null) {
            UserInfo user = (UserInfo)userinfo;
            userName = user.getUserlogno();
        }
        queryResult.setSourcePayType(data.getSourcePayType());
        queryResult.setDestinationPayType(data.getDestinationPayType());
        queryResult.setRemark(data.getRemark());
        queryResult.setModifyPerson(userName);
        queryResult.setModifyTime(DatetimeUtil.now());
        logger.info("edit: {}", (Object)queryResult);
        facade.updateConfigChannel(queryResult);
        this.getQuery();
    }

    public void add() {
        logger.info("add ConfigChannel");
        this.authenticateAdd();
        ConfigChannel data = (ConfigChannel)this.findBean(ConfigChannel.class, "payproxy_configchannel");
        logger.info("add: {}", (Object)data.toString());
        if (facade.findConfigChannelExists(data.getSourcePayType())) {
            logger.error("record already exist!");
            this.alertJS("record already exist!");
            return;
        }
        String userName = "";
        Object userinfo = FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("userinfo");
        if (userinfo != null) {
            UserInfo user = (UserInfo)userinfo;
            userName = user.getUserlogno();
        }
        data.setCreatePerson(userName);
        data.setCreateTime(DatetimeUtil.now());
        data.setIsDelete("N");
        logger.info("add: {}", (Object)data.toString());
        facade.addConfigChannel(data);
        this.getQuery();
    }

    public void del() {
        logger.info("add ConfigChannel");
        this.authenticateAdd();
        String seqId = this.findParameter("seqid");
        logger.info("seqId: {}", (Object)seqId);
        if (Long.parseLong(seqId) <= 0L) {
            logger.error("record not exist!");
            this.alertJS("record not exist!");
            return;
        }
        ConfigChannel result = facade.queryConfigChannel(Long.parseLong(seqId));
        if (result == null) {
            logger.error("record not exist!");
            this.alertJS("record not exist!");
            return;
        }
        result.setIsDelete("Y");
        facade.updateConfigChannel(result);
        this.getQuery();
    }
}

