/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.utils.DateUtils;
import com.xunlei.payproxy.web.utils.Properties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="CleanDataJob")
public class CleanDataJobManagedBean
extends BaseManagedBean {
    private static final Logger LOG = LoggerFactory.getLogger(CleanDataJobManagedBean.class);
    private static final IFacade facade = IFacade.INSTANCE;
    private UploadedFile upFile;

    public UploadedFile getUpFile() {
        return this.upFile;
    }

    public void setUpFile(UploadedFile upFile) {
        this.upFile = upFile;
    }

    public String doCleanJobMain() {
        this.authenticateRun();
        String activeType = this.findParameter("activeType");
        try {
            LOG.info("CleanDataJobManagedBean begin task!");
            if (null == activeType || "".equals(activeType)) {
                LOG.error("activeType is empty!");
                this.alertJS("\u7cfb\u7edf\u9519\u8bef");
                return "";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("activeType:{}", (Object)activeType);
            }
            if (!activeType.equals("kong")) {
                LOG.error("activeType:{},does supported!", (Object)activeType);
                this.alertJS("\u6682\u4e0d\u652f\u6301\u7684\u7c7b\u578b!");
                return "";
            }
            this.doKongCleanJob();
        }
        catch (Exception e) {
            LOG.error("doCleanJob throws Exception\uff1a" + e);
            this.alertJS("\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doKongCleanJob() throws Exception {
        if (this.upFile == null) {
            LOG.info("\u6ca1\u6709\u4e0a\u4f20\u6587\u4ef6");
            this.alertJS("\u8bf7\u9009\u62e9\u4e0a\u4f20\u7684\u6587\u4ef6");
            return;
        }
        String fileName = this.upFile.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a\uff1a" + fileName);
        }
        if (!fileName.toLowerCase().endsWith("txt")) {
            LOG.info("\u6587\u4ef6\u683c\u5f0f\u5fc5\u987b\u662ftxt\u683c\u5f0f");
            this.alertJS("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u662ftxt\u683c\u5f0f");
            return;
        }
        Properties prop = new Properties("cleanjopConfig");
        String kongUploadPath = prop.getPropertie("kongUploadPath");
        String kongCleanShell = prop.getPropertie("kongCleanShell");
        File upLoadFile = this.getUploadFile(kongUploadPath);
        InputStream in = null;
        BufferedReader read = null;
        try {
            Object[] shellParams = new String[]{"sh", kongCleanShell, "-tA", "-force", "-f" + upLoadFile.getName(), "-2fnot" + upLoadFile.getName()};
            LOG.info("executeCleankongShell shellParams:{}", (Object)Arrays.toString(shellParams));
            Process pro = Runtime.getRuntime().exec((String[])shellParams);
            pro.waitFor();
            in = pro.getInputStream();
            read = new BufferedReader(new InputStreamReader(in));
            String result = read.readLine();
            while (null != result) {
                LOG.info(result);
                result = read.readLine();
            }
            LOG.info("doKongCleanJob end!");
            this.alertJS("\u6e05\u7406\u5b8c\u6210!");
        }
        catch (Exception e) {
            LOG.error("executeCleankongShell throws Exception:", (Throwable)e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != read) {
                    read.close();
                }
            }
            catch (Exception e2) {
                LOG.error("executeCleankongShell close stream throws Exception:", (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getUploadFile(String uploadPath) throws Exception {
        String upLoadFileName = this.upFile.getName();
        String cleanDate = "";
        if (upLoadFileName.length() == 8) {
            try {
                new SimpleDateFormat("yyyyMMdd").parse(cleanDate);
                cleanDate = upLoadFileName;
            }
            catch (Exception e) {
                LOG.info("can not parse upLoadFileName:{},use today!", (Object)upLoadFileName);
            }
        }
        if ("".equals(cleanDate)) {
            cleanDate = DateUtils.getCurrentTime("yyyyMMdd");
        }
        String renameFileName = "cleanup" + cleanDate + ".txt";
        File outPutFile = new File(uploadPath + renameFileName);
        LOG.info("uploadPath:{},renameFileName:{}", new Object[]{outPutFile, renameFileName});
        InputStream reader = null;
        FileOutputStream writeer = null;
        try {
            reader = this.upFile.getInputStream();
            writeer = new FileOutputStream(outPutFile);
            long fSize = this.upFile.getSize();
            byte[] buffer = new byte[(int)fSize];
            reader.read(buffer, 0, (int)fSize);
            ((OutputStream)writeer).write(buffer, 0, (int)fSize);
            File file = outPutFile;
            return file;
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
                if (null != writeer) {
                    ((OutputStream)writeer).close();
                }
            }
            catch (Exception e) {
                LOG.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", (Throwable)e);
            }
        }
    }
}

